/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.ch.wwmm.opsin;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import uk.ac.cam.ch.wwmm.opsin.Atom;
import uk.ac.cam.ch.wwmm.opsin.Bond;
import uk.ac.cam.ch.wwmm.opsin.Fragment;

class CycleDetector {
    CycleDetector() {
    }

    static void assignWhetherAtomsAreInCycles(Fragment frag) {
        List<Atom> atomList = frag.getAtomList();
        for (Atom atom : atomList) {
            atom.setAtomIsInACycle(false);
            atom.setProperty(Atom.VISITED, null);
        }
        for (Atom a : atomList) {
            if (a.getProperty(Atom.VISITED) != null) continue;
            CycleDetector.traverseRings(a, null, 0);
        }
    }

    private static int traverseRings(Atom currentAtom, Atom previousAtom, int depth) {
        List<Atom> neighbours;
        Integer previouslyAssignedDepth = currentAtom.getProperty(Atom.VISITED);
        if (previouslyAssignedDepth != null) {
            return previouslyAssignedDepth;
        }
        currentAtom.setProperty(Atom.VISITED, depth);
        ArrayList<Atom> equivalentAtoms = new ArrayList<Atom>();
        equivalentAtoms.add(currentAtom);
        while (true) {
            Atom nextAtom;
            neighbours = currentAtom.getAtomNeighbours();
            neighbours.remove(previousAtom);
            if (neighbours.size() != 1 || (nextAtom = neighbours.get(0)).getProperty(Atom.VISITED) != null) break;
            previousAtom = currentAtom;
            currentAtom = nextAtom;
            equivalentAtoms.add(currentAtom);
            currentAtom.setProperty(Atom.VISITED, ++depth);
        }
        int result = depth + 1;
        for (Atom neighbour : neighbours) {
            int temp = CycleDetector.traverseRings(neighbour, currentAtom, depth + 1);
            result = Math.min(result, temp);
        }
        if (result < depth) {
            for (Atom a : equivalentAtoms) {
                a.setAtomIsInACycle(true);
            }
        } else if (result == depth) {
            currentAtom.setAtomIsInACycle(true);
        }
        return result;
    }

    static List<List<Atom>> getPathBetweenAtomsUsingBonds(Atom a1, Atom a2, Set<Bond> peripheryBonds) {
        ArrayList<List<Atom>> paths = new ArrayList<List<Atom>>();
        ArrayDeque<PathSearchState> stateStack = new ArrayDeque<PathSearchState>();
        stateStack.add(new PathSearchState(a1, new ArrayList<Atom>()));
        while (stateStack.size() > 0) {
            PathSearchState state = (PathSearchState)stateStack.removeLast();
            List<Atom> orderAtomsVisited = state.getOrderAtomsVisited();
            Atom nextAtom = state.getCurrentAtom();
            orderAtomsVisited.add(nextAtom);
            LinkedHashSet<Bond> neighbourBonds = new LinkedHashSet<Bond>(nextAtom.getBonds());
            neighbourBonds.retainAll(peripheryBonds);
            for (Bond neighbourBond : neighbourBonds) {
                Atom neighbour = neighbourBond.getOtherAtom(nextAtom);
                if (orderAtomsVisited.contains(neighbour)) continue;
                if (neighbour == a2) {
                    paths.add(new ArrayList<Atom>(orderAtomsVisited.subList(1, orderAtomsVisited.size())));
                    continue;
                }
                stateStack.add(new PathSearchState(neighbour, new ArrayList<Atom>(orderAtomsVisited)));
            }
        }
        return paths;
    }

    private static class PathSearchState {
        final Atom currentAtom;
        final List<Atom> orderAtomsVisited;

        public PathSearchState(Atom currentAtom, List<Atom> orderAtomsVisited) {
            this.currentAtom = currentAtom;
            this.orderAtomsVisited = orderAtomsVisited;
        }

        Atom getCurrentAtom() {
            return this.currentAtom;
        }

        List<Atom> getOrderAtomsVisited() {
            return this.orderAtomsVisited;
        }
    }
}

