/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.ch.wwmm.opsin;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Queue;
import uk.ac.cam.ch.wwmm.opsin.Atom;
import uk.ac.cam.ch.wwmm.opsin.Bond;
import uk.ac.cam.ch.wwmm.opsin.CipOrderingException;

class CipSequenceRules {
    private final Atom chiralAtom;

    CipSequenceRules(Atom chiralAtom) {
        this.chiralAtom = chiralAtom;
    }

    List<Atom> getNeighbouringAtomsInCipOrder() throws CipOrderingException {
        List<Atom> neighbours = this.chiralAtom.getAtomNeighbours();
        try {
            Collections.sort(neighbours, new SortByCipOrder(this.chiralAtom));
        }
        catch (CipOrderingRunTimeException e) {
            throw new CipOrderingException(e.getMessage());
        }
        return neighbours;
    }

    List<Atom> getNeighbouringAtomsInCipOrderIgnoringGivenNeighbour(Atom neighbourToIgnore) throws CipOrderingException {
        List<Atom> neighbours = this.chiralAtom.getAtomNeighbours();
        if (!neighbours.remove(neighbourToIgnore)) {
            throw new IllegalArgumentException("OPSIN bug: Atom" + neighbourToIgnore.getID() + " was not a neighbour of the given stereogenic atom");
        }
        try {
            Collections.sort(neighbours, new SortByCipOrder(this.chiralAtom));
        }
        catch (CipOrderingRunTimeException e) {
            throw new CipOrderingException(e.getMessage());
        }
        return neighbours;
    }

    private class SortByCipOrder
    implements Comparator<Atom> {
        private final Atom chiralAtom;
        private final AtomListCipComparator atomListCipComparator = new AtomListCipComparator();
        private final ListOfAtomListsCipComparator listOfAtomListsCipComparator = new ListOfAtomListsCipComparator();
        private final CipComparator cipComparator = new CipComparator();
        private int rule = 0;

        SortByCipOrder(Atom chiralAtom) {
            this.chiralAtom = chiralAtom;
        }

        @Override
        public int compare(Atom a, Atom b) {
            this.rule = 0;
            while (this.rule <= 2) {
                ArrayList<Atom> atomsVisted = new ArrayList<Atom>();
                atomsVisted.add(this.chiralAtom);
                AtomWithHistory aWithHistory = new AtomWithHistory(a, atomsVisted, null);
                AtomWithHistory bWithHistory = new AtomWithHistory(b, new ArrayList<Atom>(atomsVisted), null);
                int compare = this.compareByCipRules(aWithHistory, bWithHistory);
                if (compare != 0) {
                    return compare;
                }
                ArrayList<AtomWithHistory> nextAtoms1 = new ArrayList<AtomWithHistory>();
                nextAtoms1.add(aWithHistory);
                ArrayList<AtomWithHistory> nextAtoms2 = new ArrayList<AtomWithHistory>();
                nextAtoms2.add(bWithHistory);
                CipState startingState = new CipState(nextAtoms1, nextAtoms2);
                ArrayDeque<CipState> cipStateQueue = new ArrayDeque<CipState>();
                cipStateQueue.add(startingState);
                while (!cipStateQueue.isEmpty()) {
                    CipState currentState = (CipState)cipStateQueue.removeFirst();
                    compare = this.compareAtNextLevel(currentState, cipStateQueue);
                    if (compare == 0) continue;
                    return compare;
                }
                ++this.rule;
            }
            throw new CipOrderingRunTimeException("Failed to assign CIP stereochemistry, this indicates a bug in OPSIN or a limitation in OPSIN's implementation of the sequence rules");
        }

        private int compareAtNextLevel(CipState cipState, Queue<CipState> queue) {
            List<List<AtomWithHistory>> neighbours2;
            List<List<AtomWithHistory>> neighbours1 = this.getNextLevelNeighbours(cipState.nextAtoms1);
            int compare = this.compareNeighboursByCipPriorityRules(neighbours1, neighbours2 = this.getNextLevelNeighbours(cipState.nextAtoms2));
            if (compare != 0) {
                return compare;
            }
            List<List<AtomWithHistory>> prioritisedNeighbours1 = this.formListsWithSamePriority(neighbours1);
            List<List<AtomWithHistory>> prioritisedNeighbours2 = this.formListsWithSamePriority(neighbours2);
            for (int i = prioritisedNeighbours1.size() - 1; i >= 0; --i) {
                queue.add(new CipState(prioritisedNeighbours1.get(i), prioritisedNeighbours2.get(i)));
            }
            return 0;
        }

        private int compareNeighboursByCipPriorityRules(List<List<AtomWithHistory>> neighbours1, List<List<AtomWithHistory>> neighbours2) {
            int difference = this.listOfAtomListsCipComparator.compare(neighbours1, neighbours2);
            if (difference > 0) {
                return 1;
            }
            if (difference < 0) {
                return -1;
            }
            return 0;
        }

        private List<List<AtomWithHistory>> getNextLevelNeighbours(List<AtomWithHistory> nextAtoms) {
            ArrayList<List<AtomWithHistory>> neighbourLists = new ArrayList<List<AtomWithHistory>>();
            for (AtomWithHistory nextAtom : nextAtoms) {
                neighbourLists.add(this.getNextAtomsWithAppropriateGhostAtoms(nextAtom));
            }
            Collections.sort(neighbourLists, this.atomListCipComparator);
            return neighbourLists;
        }

        /*
         * WARNING - void declaration
         */
        private List<List<AtomWithHistory>> formListsWithSamePriority(List<List<AtomWithHistory>> neighbourLists) {
            int i;
            int intialNeighbourListCount = neighbourLists.size();
            if (intialNeighbourListCount > 1) {
                ArrayList<List> listsToRemove = new ArrayList<List>();
                for (i = 0; i < intialNeighbourListCount; ++i) {
                    List<AtomWithHistory> list;
                    ArrayList<List<AtomWithHistory>> neighbourListsToCombine = new ArrayList<List<AtomWithHistory>>();
                    List<AtomWithHistory> primaryAtomList = neighbourLists.get(i);
                    for (int j = i + 1; j < intialNeighbourListCount && this.atomListCipComparator.compare(primaryAtomList, list = neighbourLists.get(j)) == 0; ++j) {
                        neighbourListsToCombine.add(list);
                        ++i;
                    }
                    for (List list2 : neighbourListsToCombine) {
                        listsToRemove.add(list2);
                        primaryAtomList.addAll(list2);
                    }
                }
                neighbourLists.removeAll(listsToRemove);
            }
            ArrayList<List<AtomWithHistory>> updatedNeighbourLists = new ArrayList<List<AtomWithHistory>>();
            int lstsLen = neighbourLists.size();
            for (i = 0; i < lstsLen; ++i) {
                void var8_15;
                List<AtomWithHistory> neighbourList = neighbourLists.get(i);
                Collections.sort(neighbourList, this.cipComparator);
                AtomWithHistory lastAtom = null;
                ArrayList arrayList = new ArrayList();
                int lstLen = neighbourList.size();
                for (int j = 0; j < lstLen; ++j) {
                    AtomWithHistory a = neighbourList.get(j);
                    if (lastAtom != null && this.compareByCipRules(lastAtom, a) != 0) {
                        updatedNeighbourLists.add((List<AtomWithHistory>)var8_15);
                        ArrayList arrayList2 = new ArrayList();
                    }
                    var8_15.add(a);
                    lastAtom = a;
                }
                if (var8_15.isEmpty()) continue;
                updatedNeighbourLists.add((List<AtomWithHistory>)var8_15);
            }
            return updatedNeighbourLists;
        }

        private List<AtomWithHistory> getNextAtomsWithAppropriateGhostAtoms(AtomWithHistory atomWithHistory) {
            Atom atom = atomWithHistory.atom;
            List<Atom> visitedAtoms = atomWithHistory.visitedAtoms;
            Atom previousAtom = visitedAtoms.get(visitedAtoms.size() - 1);
            ArrayList<Atom> visitedAtomsIncludingCurrentAtom = new ArrayList<Atom>(visitedAtoms);
            visitedAtomsIncludingCurrentAtom.add(atom);
            ArrayList<AtomWithHistory> neighboursWithHistory = new ArrayList<AtomWithHistory>();
            for (Bond b : atom.getBonds()) {
                Atom atomBondConnectsTo = b.getOtherAtom(atom);
                if (!atomBondConnectsTo.equals(this.chiralAtom)) {
                    for (int j = b.getOrder(); j > 1; --j) {
                        Atom ghost = new Atom(atomBondConnectsTo.getElement());
                        if (this.rule > 0) {
                            int indexOfOriginalAtom = visitedAtoms.indexOf(atomBondConnectsTo);
                            if (indexOfOriginalAtom != -1) {
                                neighboursWithHistory.add(new AtomWithHistory(ghost, visitedAtomsIncludingCurrentAtom, indexOfOriginalAtom));
                                continue;
                            }
                            neighboursWithHistory.add(new AtomWithHistory(ghost, visitedAtomsIncludingCurrentAtom, visitedAtoms.size() + 1));
                            continue;
                        }
                        neighboursWithHistory.add(new AtomWithHistory(ghost, visitedAtomsIncludingCurrentAtom, null));
                    }
                }
                if (atomBondConnectsTo.equals(previousAtom)) continue;
                if (visitedAtoms.contains(atomBondConnectsTo)) {
                    Atom ghost = new Atom(atomBondConnectsTo.getElement());
                    if (this.rule > 0) {
                        neighboursWithHistory.add(new AtomWithHistory(ghost, visitedAtomsIncludingCurrentAtom, visitedAtoms.indexOf(atomBondConnectsTo)));
                        continue;
                    }
                    neighboursWithHistory.add(new AtomWithHistory(ghost, visitedAtomsIncludingCurrentAtom, null));
                    continue;
                }
                neighboursWithHistory.add(new AtomWithHistory(atomBondConnectsTo, visitedAtomsIncludingCurrentAtom, null));
            }
            Collections.sort(neighboursWithHistory, this.cipComparator);
            return neighboursWithHistory;
        }

        private int compareByCipRules(AtomWithHistory a, AtomWithHistory b) {
            int atomicNumber1 = a.atom.getElement().ATOMIC_NUM;
            int atomicNumber2 = b.atom.getElement().ATOMIC_NUM;
            if (atomicNumber1 > atomicNumber2) {
                return 1;
            }
            if (atomicNumber1 < atomicNumber2) {
                return -1;
            }
            if (this.rule > 0) {
                Integer indexFromRoot1 = a.indexOfOriginalFromRoot;
                Integer indexFromRoot2 = b.indexOfOriginalFromRoot;
                if (indexFromRoot1 != null && indexFromRoot2 == null) {
                    return 1;
                }
                if (indexFromRoot1 == null && indexFromRoot2 != null) {
                    return -1;
                }
                if (indexFromRoot1 != null && indexFromRoot2 != null) {
                    if (indexFromRoot1 < indexFromRoot2) {
                        return 1;
                    }
                    if (indexFromRoot1 > indexFromRoot2) {
                        return -1;
                    }
                }
                if (this.rule > 1) {
                    Integer atomicMass1 = a.atom.getIsotope();
                    Integer atomicMass2 = b.atom.getIsotope();
                    if (atomicMass1 != null && atomicMass2 == null) {
                        return 1;
                    }
                    if (atomicMass1 == null && atomicMass2 != null) {
                        return -1;
                    }
                    if (atomicMass1 != null && atomicMass2 != null) {
                        if (atomicMass1 > atomicMass2) {
                            return 1;
                        }
                        if (atomicMass1 < atomicMass2) {
                            return -1;
                        }
                    }
                }
            }
            return 0;
        }

        private class ListOfAtomListsCipComparator
        implements Comparator<List<List<AtomWithHistory>>> {
            private ListOfAtomListsCipComparator() {
            }

            @Override
            public int compare(List<List<AtomWithHistory>> a, List<List<AtomWithHistory>> b) {
                int aSize = a.size();
                int bSize = b.size();
                int differenceInSize = aSize - bSize;
                int maxCommonSize = aSize > bSize ? bSize : aSize;
                for (int i = 1; i <= maxCommonSize; ++i) {
                    List<AtomWithHistory> aprime = a.get(aSize - i);
                    List<AtomWithHistory> bprime = b.get(bSize - i);
                    int aprimeSize = aprime.size();
                    int bprimeSize = bprime.size();
                    int differenceInSizeprime = aprimeSize - bprimeSize;
                    int maxCommonSizeprime = aprimeSize > bprimeSize ? bprimeSize : aprimeSize;
                    for (int j = 1; j <= maxCommonSizeprime; ++j) {
                        int difference = SortByCipOrder.this.compareByCipRules(aprime.get(aprimeSize - j), bprime.get(bprimeSize - j));
                        if (difference > 0) {
                            return 1;
                        }
                        if (difference >= 0) continue;
                        return -1;
                    }
                    if (differenceInSizeprime > 0) {
                        return 1;
                    }
                    if (differenceInSizeprime >= 0) continue;
                    return -1;
                }
                if (differenceInSize > 0) {
                    return 1;
                }
                if (differenceInSize < 0) {
                    return -1;
                }
                return 0;
            }
        }

        private class AtomListCipComparator
        implements Comparator<List<AtomWithHistory>> {
            private AtomListCipComparator() {
            }

            @Override
            public int compare(List<AtomWithHistory> a, List<AtomWithHistory> b) {
                int aSize = a.size();
                int bSize = b.size();
                int differenceInSize = aSize - bSize;
                int maxCommonSize = aSize > bSize ? bSize : aSize;
                for (int i = 1; i <= maxCommonSize; ++i) {
                    int difference = SortByCipOrder.this.compareByCipRules(a.get(aSize - i), b.get(bSize - i));
                    if (difference > 0) {
                        return 1;
                    }
                    if (difference >= 0) continue;
                    return -1;
                }
                if (differenceInSize > 0) {
                    return 1;
                }
                if (differenceInSize < 0) {
                    return -1;
                }
                return 0;
            }
        }

        private class CipComparator
        implements Comparator<AtomWithHistory> {
            private CipComparator() {
            }

            @Override
            public int compare(AtomWithHistory a, AtomWithHistory b) {
                return SortByCipOrder.this.compareByCipRules(a, b);
            }
        }
    }

    private static class AtomWithHistory {
        final Atom atom;
        final List<Atom> visitedAtoms;
        final Integer indexOfOriginalFromRoot;

        AtomWithHistory(Atom atom, List<Atom> visitedAtoms, Integer indexOfOriginalFromRoot) {
            this.atom = atom;
            this.visitedAtoms = visitedAtoms;
            this.indexOfOriginalFromRoot = indexOfOriginalFromRoot;
        }
    }

    private static class CipState {
        final List<AtomWithHistory> nextAtoms1;
        final List<AtomWithHistory> nextAtoms2;

        CipState(List<AtomWithHistory> nextAtoms1, List<AtomWithHistory> nextAtoms2) {
            this.nextAtoms1 = nextAtoms1;
            this.nextAtoms2 = nextAtoms2;
        }
    }

    private static class CipOrderingRunTimeException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        CipOrderingRunTimeException(String message) {
            super(message);
        }
    }
}

