/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.ch.wwmm.opsin;

import dk.brics.automaton.Automaton;
import dk.brics.automaton.RegExp;
import dk.brics.automaton.RunAutomaton;
import dk.brics.automaton.SpecialOperations;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import uk.ac.cam.ch.wwmm.opsin.ResourceGetter;

class AutomatonInitialiser {
    private static final Logger LOG = LogManager.getLogger(AutomatonInitialiser.class);
    private final ResourceGetter resourceGetter;

    AutomatonInitialiser(String resourcePath) {
        this.resourceGetter = new ResourceGetter(resourcePath);
    }

    RunAutomaton loadAutomaton(String automatonName, String regex, boolean tableize, boolean reverseAutomaton) {
        if (reverseAutomaton) {
            automatonName = automatonName + "_reversed_";
        }
        try {
            if (this.isAutomatonCached(automatonName, regex)) {
                return this.loadCachedAutomaton(automatonName);
            }
        }
        catch (IOException e) {
            LOG.warn("Error loading cached automaton: " + automatonName, (Throwable)e);
        }
        RunAutomaton automaton = AutomatonInitialiser.createAutomaton(regex, tableize, reverseAutomaton);
        this.cacheAutomaton(automatonName, automaton, regex);
        return automaton;
    }

    private boolean isAutomatonCached(String automatonName, String regex) {
        String currentRegexHash = this.getRegexHash(regex);
        String cachedRegexHash = this.getCachedRegexHash(automatonName);
        return currentRegexHash.equals(cachedRegexHash);
    }

    private String getRegexHash(String regex) {
        return Integer.toString(regex.hashCode());
    }

    private String getCachedRegexHash(String automatonName) {
        return this.resourceGetter.getFileContentsAsString(automatonName + "RegexHash.txt");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private RunAutomaton loadCachedAutomaton(String automatonName) throws IOException {
        try (InputStream automatonInput = this.resourceGetter.getInputstreamFromFileName(automatonName + "SerialisedAutomaton.aut");){
            RunAutomaton runAutomaton = RunAutomaton.load(new BufferedInputStream(automatonInput));
            return runAutomaton;
        }
        catch (Exception e) {
            IOException ioe = new IOException("Error loading automaton");
            ioe.initCause(e);
            throw ioe;
        }
    }

    private static RunAutomaton createAutomaton(String regex, boolean tableize, boolean reverseAutomaton) {
        Automaton a = new RegExp(regex).toAutomaton();
        if (reverseAutomaton) {
            SpecialOperations.reverse(a);
        }
        return new RunAutomaton(a, tableize);
    }

    private void cacheAutomaton(String automatonName, RunAutomaton automaton, String regex) {
        try (OutputStream regexHashOutputStream = this.resourceGetter.getOutputStream(automatonName + "RegexHash.txt");){
            regexHashOutputStream.write(this.getRegexHash(regex).getBytes(StandardCharsets.UTF_8));
            try (OutputStream automatonOutputStream = this.resourceGetter.getOutputStream(automatonName + "SerialisedAutomaton.aut");){
                automaton.store(automatonOutputStream);
            }
        }
        catch (IOException e) {
            LOG.warn("Error serialising automaton: " + automatonName, (Throwable)e);
        }
    }
}

