/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.ch.wwmm.opsin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import uk.ac.cam.ch.wwmm.opsin.AtomParity;
import uk.ac.cam.ch.wwmm.opsin.Bond;
import uk.ac.cam.ch.wwmm.opsin.ChemEl;
import uk.ac.cam.ch.wwmm.opsin.Fragment;
import uk.ac.cam.ch.wwmm.opsin.OpsinTools;
import uk.ac.cam.ch.wwmm.opsin.PropertyKey;
import uk.ac.cam.ch.wwmm.opsin.StereoGroup;
import uk.ac.cam.ch.wwmm.opsin.StereoGroupType;
import uk.ac.cam.ch.wwmm.opsin.StructureBuildingException;
import uk.ac.cam.ch.wwmm.opsin.ValencyChecker;

class Atom {
    private final int id;
    private ChemEl chemEl;
    private final List<String> locants = new ArrayList<String>(2);
    private int charge = 0;
    private Integer isotope = null;
    private AtomParity atomParity = null;
    private final List<Bond> bonds = new ArrayList<Bond>(4);
    private final Map<PropertyKey, Object> properties = new HashMap<PropertyKey, Object>();
    static final PropertyKey<Set<Atom>> AMBIGUOUS_ELEMENT_ASSIGNMENT = new PropertyKey("ambiguousElementAssignment");
    static final PropertyKey<Integer> ATOM_CLASS = new PropertyKey("atomClass");
    static final PropertyKey<String> HOMOLOGY_GROUP = new PropertyKey("homologyGroup");
    static final PropertyKey<List<Atom>> POSITION_VARIATION_BOND = new PropertyKey("positionVariationBond");
    static final PropertyKey<Integer> SMILES_HYDROGEN_COUNT = new PropertyKey("smilesHydrogenCount");
    static final PropertyKey<Integer> OXIDATION_NUMBER = new PropertyKey("oxidationNumber");
    static final PropertyKey<Boolean> ISALDEHYDE = new PropertyKey("isAldehyde");
    static final PropertyKey<Boolean> ISANOMERIC = new PropertyKey("isAnomeric");
    static final PropertyKey<Integer> VISITED = new PropertyKey("visited");
    private static final StereoGroup UNKNOWN_STEREOGROUP = new StereoGroup(StereoGroupType.Unk);
    private Fragment frag;
    private boolean spareValency = false;
    private int outValency = 0;
    private Integer lambdaConventionValency;
    private Integer minimumValency;
    private boolean implicitHydrogenAllowed = true;
    private int protonsExplicitlyAddedOrRemoved = 0;
    private String type;
    private boolean atomIsInACycle = false;

    Atom(int id, ChemEl chemlEl, Fragment frag) {
        if (frag == null) {
            throw new IllegalArgumentException("Atom is not in a fragment!");
        }
        if (chemlEl == null) {
            throw new IllegalArgumentException("Atom does not have an element!");
        }
        this.frag = frag;
        this.id = id;
        this.chemEl = chemlEl;
        this.type = frag.getType();
    }

    Atom(ChemEl chemlEl) {
        this.chemEl = chemlEl;
        this.id = 0;
    }

    int determineValency(boolean considerOutValency) {
        Integer defaultValency;
        Integer calculatedMinValency;
        if (this.lambdaConventionValency != null) {
            return this.lambdaConventionValency + this.protonsExplicitlyAddedOrRemoved;
        }
        int currentValency = this.getIncomingValency();
        if (considerOutValency) {
            currentValency += this.outValency;
        }
        Integer n = calculatedMinValency = this.minimumValency == null ? null : Integer.valueOf(this.minimumValency + this.protonsExplicitlyAddedOrRemoved);
        if (!(this.charge != 0 && this.protonsExplicitlyAddedOrRemoved == 0 || (defaultValency = ValencyChecker.getDefaultValency(this.chemEl)) == null || currentValency > (defaultValency = Integer.valueOf(defaultValency + this.protonsExplicitlyAddedOrRemoved)) || calculatedMinValency != null && defaultValency < calculatedMinValency)) {
            return defaultValency;
        }
        Integer[] possibleValencies = ValencyChecker.getPossibleValencies(this.chemEl, this.charge);
        if (possibleValencies != null) {
            if (calculatedMinValency != null && calculatedMinValency >= currentValency) {
                return calculatedMinValency;
            }
            for (Integer possibleValency : possibleValencies) {
                if (calculatedMinValency != null && possibleValency < calculatedMinValency || currentValency > possibleValency) continue;
                return possibleValency;
            }
        }
        if (calculatedMinValency != null && calculatedMinValency >= currentValency) {
            return calculatedMinValency;
        }
        return currentValency;
    }

    void addLocant(String locant) {
        this.locants.add(locant);
        this.frag.addMappingToAtomLocantMap(locant, this);
    }

    void replaceLocants(String locant) {
        this.clearLocants();
        this.addLocant(locant);
    }

    void removeLocant(String locantToRemove) {
        int locantArraySize = this.locants.size();
        for (int i = locantArraySize - 1; i >= 0; --i) {
            if (!this.locants.get(i).equals(locantToRemove)) continue;
            this.locants.remove(i);
            this.frag.removeMappingFromAtomLocantMap(locantToRemove);
        }
    }

    void clearLocants() {
        int l = this.locants.size();
        for (int i = 0; i < l; ++i) {
            this.frag.removeMappingFromAtomLocantMap(this.locants.get(i));
        }
        this.locants.clear();
    }

    void removeElementSymbolLocants() {
        for (int i = this.locants.size() - 1; i >= 0; --i) {
            String locant = this.locants.get(i);
            if (!OpsinTools.MATCH_ELEMENT_SYMBOL_LOCANT.matcher(locant).matches()) continue;
            this.frag.removeMappingFromAtomLocantMap(locant);
            this.locants.remove(i);
        }
    }

    void removeLocantsOtherThanElementSymbolLocants() {
        for (int i = this.locants.size() - 1; i >= 0; --i) {
            String locant = this.locants.get(i);
            if (OpsinTools.MATCH_ELEMENT_SYMBOL_LOCANT.matcher(locant).matches()) continue;
            this.frag.removeMappingFromAtomLocantMap(locant);
            this.locants.remove(i);
        }
    }

    boolean hasLocant(String locant) {
        if (this.locants.contains(locant)) {
            return true;
        }
        Matcher m = OpsinTools.MATCH_AMINOACID_STYLE_LOCANT.matcher(locant);
        if (m.matches() && this.chemEl.toString().equals(m.group(1))) {
            if (!m.group(2).equals("") && !this.hasLocant(m.group(1) + m.group(2))) {
                return false;
            }
            if (OpsinTools.depthFirstSearchForNonSuffixAtomWithLocant(this, m.group(3)) != null) {
                return true;
            }
        }
        return false;
    }

    String getFirstLocant() {
        return this.locants.size() > 0 ? this.locants.get(0) : null;
    }

    List<String> getLocants() {
        return Collections.unmodifiableList(this.locants);
    }

    List<String> getElementSymbolLocants() {
        ArrayList<String> elementSymbolLocants = new ArrayList<String>(1);
        int l = this.locants.size();
        for (int i = 0; i < l; ++i) {
            String locant = this.locants.get(i);
            if (!OpsinTools.MATCH_ELEMENT_SYMBOL_LOCANT.matcher(locant).matches()) continue;
            elementSymbolLocants.add(locant);
        }
        return elementSymbolLocants;
    }

    void setFrag(Fragment f) {
        this.frag = f;
    }

    Fragment getFrag() {
        return this.frag;
    }

    int getID() {
        return this.id;
    }

    ChemEl getElement() {
        return this.chemEl;
    }

    void setElement(ChemEl chemEl) {
        this.chemEl = chemEl;
    }

    int getCharge() {
        return this.charge;
    }

    void addChargeAndProtons(int charge, int protons) {
        this.charge += charge;
        this.protonsExplicitlyAddedOrRemoved += protons;
    }

    void setCharge(int c) {
        this.charge = c;
    }

    void neutraliseCharge() {
        this.charge = 0;
        this.protonsExplicitlyAddedOrRemoved = 0;
    }

    Integer getIsotope() {
        return this.isotope;
    }

    void setIsotope(Integer isotope) {
        if (isotope != null && isotope < this.chemEl.ATOMIC_NUM) {
            throw new RuntimeException("Isotopic mass cannot be less than the element's number of protons: " + this.chemEl.toString() + " " + isotope + " < " + this.chemEl.ATOMIC_NUM);
        }
        this.isotope = isotope;
    }

    void addBond(Bond b) {
        if (this.bonds.contains(b)) {
            throw new IllegalArgumentException("Atom already has given bond (This is not allowed as this would give two bonds between the same atoms!)");
        }
        this.bonds.add(b);
    }

    boolean removeBond(Bond b) {
        return this.bonds.remove(b);
    }

    int getIncomingValency() {
        int v = 0;
        int len = this.bonds.size();
        for (int i = 0; i < len; ++i) {
            v += this.bonds.get(i).getOrder();
        }
        return v;
    }

    int getProtonsExplicitlyAddedOrRemoved() {
        return this.protonsExplicitlyAddedOrRemoved;
    }

    void setProtonsExplicitlyAddedOrRemoved(int protonsExplicitlyAddedOrRemoved) {
        this.protonsExplicitlyAddedOrRemoved = protonsExplicitlyAddedOrRemoved;
    }

    boolean hasSpareValency() {
        return this.spareValency;
    }

    void setSpareValency(boolean sv) {
        this.spareValency = sv;
    }

    int getOutValency() {
        return this.outValency;
    }

    void addOutValency(int outV) {
        this.outValency += outV;
    }

    List<Bond> getBonds() {
        return Collections.unmodifiableList(this.bonds);
    }

    int getBondCount() {
        return this.bonds.size();
    }

    List<Atom> getAtomNeighbours() {
        int bondCount = this.bonds.size();
        ArrayList<Atom> results = new ArrayList<Atom>(bondCount);
        for (int i = 0; i < bondCount; ++i) {
            results.add(this.bonds.get(i).getOtherAtom(this));
        }
        return results;
    }

    Integer getLambdaConventionValency() {
        return this.lambdaConventionValency;
    }

    void setLambdaConventionValency(Integer valency) {
        this.lambdaConventionValency = valency;
    }

    String getType() {
        return this.type;
    }

    void setType(String type) {
        this.type = type;
    }

    boolean getAtomIsInACycle() {
        return this.atomIsInACycle;
    }

    void setAtomIsInACycle(boolean atomIsInACycle) {
        this.atomIsInACycle = atomIsInACycle;
    }

    AtomParity getAtomParity() {
        return this.atomParity;
    }

    void setAtomParity(AtomParity atomParity) {
        this.atomParity = atomParity;
    }

    void setAtomParity(Atom[] atomRefs4, int parity) {
        this.atomParity = new AtomParity(atomRefs4, parity);
    }

    Integer getMinimumValency() {
        return this.minimumValency;
    }

    void setMinimumValency(Integer minimumValency) {
        this.minimumValency = minimumValency;
    }

    boolean getImplicitHydrogenAllowed() {
        return this.implicitHydrogenAllowed;
    }

    void setImplicitHydrogenAllowed(boolean implicitHydrogenAllowed) {
        this.implicitHydrogenAllowed = implicitHydrogenAllowed;
    }

    <T> T getProperty(PropertyKey<T> propertyKey) {
        return (T)this.properties.get(propertyKey);
    }

    <T> void setProperty(PropertyKey<T> propertyKey, T value) {
        this.properties.put(propertyKey, value);
    }

    void ensureSVIsConsistantWithValency(boolean takeIntoAccountExternalBonds) throws StructureBuildingException {
        if (this.spareValency) {
            Integer maxValency;
            if (this.lambdaConventionValency != null) {
                maxValency = this.lambdaConventionValency + this.protonsExplicitlyAddedOrRemoved;
            } else {
                Integer hwValency = ValencyChecker.getHWValency(this.chemEl);
                if (hwValency == null) {
                    throw new StructureBuildingException((Object)((Object)this.chemEl) + " is not expected to be aromatic!");
                }
                maxValency = hwValency + this.protonsExplicitlyAddedOrRemoved;
            }
            int maxSpareValency = takeIntoAccountExternalBonds ? maxValency - this.getIncomingValency() - this.outValency : maxValency - this.frag.getIntraFragmentIncomingValency(this);
            if (maxSpareValency < 1) {
                this.setSpareValency(false);
            }
        }
    }

    Bond getFirstBond() {
        if (this.bonds.size() > 0) {
            return this.bonds.get(0);
        }
        return null;
    }

    Bond getBondToAtom(Atom a) {
        int l = this.bonds.size();
        for (int i = 0; i < l; ++i) {
            Bond b = this.bonds.get(i);
            if (b.getOtherAtom(this) != a) continue;
            return b;
        }
        return null;
    }

    Bond getBondToAtomOrThrow(Atom a) throws StructureBuildingException {
        Bond b = this.getBondToAtom(a);
        if (b == null) {
            throw new StructureBuildingException("Couldn't find specified bond");
        }
        return b;
    }

    void setStereoGroup(StereoGroup stroGrp) {
        if (this.atomParity != null) {
            this.atomParity.setStereoGroup(stroGrp);
        }
    }

    StereoGroup getStereoGroup() {
        return this.atomParity != null ? this.atomParity.getStereoGroup() : UNKNOWN_STEREOGROUP;
    }
}

