# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['ScheduledQueryArgs', 'ScheduledQuery']

@pulumi.input_type
class ScheduledQueryArgs:
    def __init__(__self__, *,
                 error_report_configuration: pulumi.Input['ScheduledQueryErrorReportConfigurationArgs'],
                 notification_configuration: pulumi.Input['ScheduledQueryNotificationConfigurationArgs'],
                 query_string: pulumi.Input[str],
                 schedule_configuration: pulumi.Input['ScheduledQueryScheduleConfigurationArgs'],
                 scheduled_query_execution_role_arn: pulumi.Input[str],
                 client_token: Optional[pulumi.Input[str]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 scheduled_query_name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['ScheduledQueryTagArgs']]]] = None,
                 target_configuration: Optional[pulumi.Input['ScheduledQueryTargetConfigurationArgs']] = None):
        """
        The set of arguments for constructing a ScheduledQuery resource.
        """
        pulumi.set(__self__, "error_report_configuration", error_report_configuration)
        pulumi.set(__self__, "notification_configuration", notification_configuration)
        pulumi.set(__self__, "query_string", query_string)
        pulumi.set(__self__, "schedule_configuration", schedule_configuration)
        pulumi.set(__self__, "scheduled_query_execution_role_arn", scheduled_query_execution_role_arn)
        if client_token is not None:
            pulumi.set(__self__, "client_token", client_token)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if scheduled_query_name is not None:
            pulumi.set(__self__, "scheduled_query_name", scheduled_query_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if target_configuration is not None:
            pulumi.set(__self__, "target_configuration", target_configuration)

    @property
    @pulumi.getter(name="errorReportConfiguration")
    def error_report_configuration(self) -> pulumi.Input['ScheduledQueryErrorReportConfigurationArgs']:
        return pulumi.get(self, "error_report_configuration")

    @error_report_configuration.setter
    def error_report_configuration(self, value: pulumi.Input['ScheduledQueryErrorReportConfigurationArgs']):
        pulumi.set(self, "error_report_configuration", value)

    @property
    @pulumi.getter(name="notificationConfiguration")
    def notification_configuration(self) -> pulumi.Input['ScheduledQueryNotificationConfigurationArgs']:
        return pulumi.get(self, "notification_configuration")

    @notification_configuration.setter
    def notification_configuration(self, value: pulumi.Input['ScheduledQueryNotificationConfigurationArgs']):
        pulumi.set(self, "notification_configuration", value)

    @property
    @pulumi.getter(name="queryString")
    def query_string(self) -> pulumi.Input[str]:
        return pulumi.get(self, "query_string")

    @query_string.setter
    def query_string(self, value: pulumi.Input[str]):
        pulumi.set(self, "query_string", value)

    @property
    @pulumi.getter(name="scheduleConfiguration")
    def schedule_configuration(self) -> pulumi.Input['ScheduledQueryScheduleConfigurationArgs']:
        return pulumi.get(self, "schedule_configuration")

    @schedule_configuration.setter
    def schedule_configuration(self, value: pulumi.Input['ScheduledQueryScheduleConfigurationArgs']):
        pulumi.set(self, "schedule_configuration", value)

    @property
    @pulumi.getter(name="scheduledQueryExecutionRoleArn")
    def scheduled_query_execution_role_arn(self) -> pulumi.Input[str]:
        return pulumi.get(self, "scheduled_query_execution_role_arn")

    @scheduled_query_execution_role_arn.setter
    def scheduled_query_execution_role_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "scheduled_query_execution_role_arn", value)

    @property
    @pulumi.getter(name="clientToken")
    def client_token(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "client_token")

    @client_token.setter
    def client_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_token", value)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter(name="scheduledQueryName")
    def scheduled_query_name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "scheduled_query_name")

    @scheduled_query_name.setter
    def scheduled_query_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scheduled_query_name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ScheduledQueryTagArgs']]]]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ScheduledQueryTagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="targetConfiguration")
    def target_configuration(self) -> Optional[pulumi.Input['ScheduledQueryTargetConfigurationArgs']]:
        return pulumi.get(self, "target_configuration")

    @target_configuration.setter
    def target_configuration(self, value: Optional[pulumi.Input['ScheduledQueryTargetConfigurationArgs']]):
        pulumi.set(self, "target_configuration", value)


class ScheduledQuery(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 client_token: Optional[pulumi.Input[str]] = None,
                 error_report_configuration: Optional[pulumi.Input[pulumi.InputType['ScheduledQueryErrorReportConfigurationArgs']]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 notification_configuration: Optional[pulumi.Input[pulumi.InputType['ScheduledQueryNotificationConfigurationArgs']]] = None,
                 query_string: Optional[pulumi.Input[str]] = None,
                 schedule_configuration: Optional[pulumi.Input[pulumi.InputType['ScheduledQueryScheduleConfigurationArgs']]] = None,
                 scheduled_query_execution_role_arn: Optional[pulumi.Input[str]] = None,
                 scheduled_query_name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ScheduledQueryTagArgs']]]]] = None,
                 target_configuration: Optional[pulumi.Input[pulumi.InputType['ScheduledQueryTargetConfigurationArgs']]] = None,
                 __props__=None):
        """
        The AWS::Timestream::ScheduledQuery resource creates a Timestream Scheduled Query.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ScheduledQueryArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The AWS::Timestream::ScheduledQuery resource creates a Timestream Scheduled Query.

        :param str resource_name: The name of the resource.
        :param ScheduledQueryArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ScheduledQueryArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 client_token: Optional[pulumi.Input[str]] = None,
                 error_report_configuration: Optional[pulumi.Input[pulumi.InputType['ScheduledQueryErrorReportConfigurationArgs']]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 notification_configuration: Optional[pulumi.Input[pulumi.InputType['ScheduledQueryNotificationConfigurationArgs']]] = None,
                 query_string: Optional[pulumi.Input[str]] = None,
                 schedule_configuration: Optional[pulumi.Input[pulumi.InputType['ScheduledQueryScheduleConfigurationArgs']]] = None,
                 scheduled_query_execution_role_arn: Optional[pulumi.Input[str]] = None,
                 scheduled_query_name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ScheduledQueryTagArgs']]]]] = None,
                 target_configuration: Optional[pulumi.Input[pulumi.InputType['ScheduledQueryTargetConfigurationArgs']]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ScheduledQueryArgs.__new__(ScheduledQueryArgs)

            __props__.__dict__["client_token"] = client_token
            if error_report_configuration is None and not opts.urn:
                raise TypeError("Missing required property 'error_report_configuration'")
            __props__.__dict__["error_report_configuration"] = error_report_configuration
            __props__.__dict__["kms_key_id"] = kms_key_id
            if notification_configuration is None and not opts.urn:
                raise TypeError("Missing required property 'notification_configuration'")
            __props__.__dict__["notification_configuration"] = notification_configuration
            if query_string is None and not opts.urn:
                raise TypeError("Missing required property 'query_string'")
            __props__.__dict__["query_string"] = query_string
            if schedule_configuration is None and not opts.urn:
                raise TypeError("Missing required property 'schedule_configuration'")
            __props__.__dict__["schedule_configuration"] = schedule_configuration
            if scheduled_query_execution_role_arn is None and not opts.urn:
                raise TypeError("Missing required property 'scheduled_query_execution_role_arn'")
            __props__.__dict__["scheduled_query_execution_role_arn"] = scheduled_query_execution_role_arn
            __props__.__dict__["scheduled_query_name"] = scheduled_query_name
            __props__.__dict__["tags"] = tags
            __props__.__dict__["target_configuration"] = target_configuration
            __props__.__dict__["arn"] = None
            __props__.__dict__["s_q_error_report_configuration"] = None
            __props__.__dict__["s_q_kms_key_id"] = None
            __props__.__dict__["s_q_name"] = None
            __props__.__dict__["s_q_notification_configuration"] = None
            __props__.__dict__["s_q_query_string"] = None
            __props__.__dict__["s_q_schedule_configuration"] = None
            __props__.__dict__["s_q_scheduled_query_execution_role_arn"] = None
            __props__.__dict__["s_q_target_configuration"] = None
        super(ScheduledQuery, __self__).__init__(
            'aws-native:timestream:ScheduledQuery',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'ScheduledQuery':
        """
        Get an existing ScheduledQuery resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = ScheduledQueryArgs.__new__(ScheduledQueryArgs)

        __props__.__dict__["arn"] = None
        __props__.__dict__["client_token"] = None
        __props__.__dict__["error_report_configuration"] = None
        __props__.__dict__["kms_key_id"] = None
        __props__.__dict__["notification_configuration"] = None
        __props__.__dict__["query_string"] = None
        __props__.__dict__["s_q_error_report_configuration"] = None
        __props__.__dict__["s_q_kms_key_id"] = None
        __props__.__dict__["s_q_name"] = None
        __props__.__dict__["s_q_notification_configuration"] = None
        __props__.__dict__["s_q_query_string"] = None
        __props__.__dict__["s_q_schedule_configuration"] = None
        __props__.__dict__["s_q_scheduled_query_execution_role_arn"] = None
        __props__.__dict__["s_q_target_configuration"] = None
        __props__.__dict__["schedule_configuration"] = None
        __props__.__dict__["scheduled_query_execution_role_arn"] = None
        __props__.__dict__["scheduled_query_name"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["target_configuration"] = None
        return ScheduledQuery(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="clientToken")
    def client_token(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "client_token")

    @property
    @pulumi.getter(name="errorReportConfiguration")
    def error_report_configuration(self) -> pulumi.Output['outputs.ScheduledQueryErrorReportConfiguration']:
        return pulumi.get(self, "error_report_configuration")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter(name="notificationConfiguration")
    def notification_configuration(self) -> pulumi.Output['outputs.ScheduledQueryNotificationConfiguration']:
        return pulumi.get(self, "notification_configuration")

    @property
    @pulumi.getter(name="queryString")
    def query_string(self) -> pulumi.Output[str]:
        return pulumi.get(self, "query_string")

    @property
    @pulumi.getter(name="sQErrorReportConfiguration")
    def s_q_error_report_configuration(self) -> pulumi.Output[str]:
        """
        Configuration for where error reports will be placed, how they will be named, and how they will be encrypted.
        """
        return pulumi.get(self, "s_q_error_report_configuration")

    @property
    @pulumi.getter(name="sQKmsKeyId")
    def s_q_kms_key_id(self) -> pulumi.Output[str]:
        """
        The KMS key for the scheduled query. If the KMS key is not specified, the database will be encrypted with a Timestream owned KMS key located in the Timestream account.
        """
        return pulumi.get(self, "s_q_kms_key_id")

    @property
    @pulumi.getter(name="sQName")
    def s_q_name(self) -> pulumi.Output[str]:
        """
        The name for the scheduled query.
        """
        return pulumi.get(self, "s_q_name")

    @property
    @pulumi.getter(name="sQNotificationConfiguration")
    def s_q_notification_configuration(self) -> pulumi.Output[str]:
        """
        Configuration for notification upon scheduled query execution.
        """
        return pulumi.get(self, "s_q_notification_configuration")

    @property
    @pulumi.getter(name="sQQueryString")
    def s_q_query_string(self) -> pulumi.Output[str]:
        """
        The query scheduled to be executed.
        """
        return pulumi.get(self, "s_q_query_string")

    @property
    @pulumi.getter(name="sQScheduleConfiguration")
    def s_q_schedule_configuration(self) -> pulumi.Output[str]:
        """
        Configuration that indicates when the scheduled query is executed.
        """
        return pulumi.get(self, "s_q_schedule_configuration")

    @property
    @pulumi.getter(name="sQScheduledQueryExecutionRoleArn")
    def s_q_scheduled_query_execution_role_arn(self) -> pulumi.Output[str]:
        """
        Role that AWS Timestream will assume to execute scheduled query.
        """
        return pulumi.get(self, "s_q_scheduled_query_execution_role_arn")

    @property
    @pulumi.getter(name="sQTargetConfiguration")
    def s_q_target_configuration(self) -> pulumi.Output[str]:
        """
        Target data source to export query results from.
        """
        return pulumi.get(self, "s_q_target_configuration")

    @property
    @pulumi.getter(name="scheduleConfiguration")
    def schedule_configuration(self) -> pulumi.Output['outputs.ScheduledQueryScheduleConfiguration']:
        return pulumi.get(self, "schedule_configuration")

    @property
    @pulumi.getter(name="scheduledQueryExecutionRoleArn")
    def scheduled_query_execution_role_arn(self) -> pulumi.Output[str]:
        return pulumi.get(self, "scheduled_query_execution_role_arn")

    @property
    @pulumi.getter(name="scheduledQueryName")
    def scheduled_query_name(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "scheduled_query_name")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['outputs.ScheduledQueryTag']]]:
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="targetConfiguration")
    def target_configuration(self) -> pulumi.Output[Optional['outputs.ScheduledQueryTargetConfiguration']]:
        return pulumi.get(self, "target_configuration")

