# Generated by Django 3.1.8 on 2021-10-19 13:31

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import uuid


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='HubOauthToken',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('uuid', models.UUIDField(default=uuid.uuid4, editable=False, verbose_name='User UUID')),
                ('access_token', models.TextField(blank=True, null=True, verbose_name='Access Token')),
                ('refresh_token', models.TextField(blank=True, null=True, verbose_name='Refresh Token')),
                ('expires_in', models.CharField(blank=True, max_length=255, null=True, verbose_name='Expires In')),
                ('expires_in_dt', models.DateTimeField(blank=True, max_length=255, null=True, verbose_name='Expires In DT')),
            ],
            options={
                'verbose_name': 'Hub Oauth Token',
                'verbose_name_plural': 'Hub Oauth Tokens',
                'db_table': 'hub_oauth_token',
            },
        ),
        migrations.CreateModel(
            name='UserCompany',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('uuid', models.UUIDField(blank=True, null=True, verbose_name='Hub Company UUID')),
                ('name', models.CharField(blank=True, max_length=255, null=True, verbose_name='Hub Company Name')),
            ],
            options={
                'verbose_name': 'User Company',
                'verbose_name_plural': 'User Companys',
                'db_table': 'hub_companies',
            },
        ),
        migrations.CreateModel(
            name='HubUser',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('token', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='user', to='django_hub_sdk.huboauthtoken', verbose_name='Tokens')),
                ('user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='tokens', to=settings.AUTH_USER_MODEL, verbose_name='Users')),
            ],
            options={
                'verbose_name': 'Hub User',
                'verbose_name_plural': 'Hub Users',
                'db_table': 'hub_users',
            },
        ),
    ]
