# coding: utf-8

"""
    XTRF Home Portal API

    XTRF Home Portal API enables you to perform operations on Projects, Quotes, Customers, Vendors etc. as a XTRF Home Portal user. <br>The documentation is generated from OpenAPI specification 3.0 available <a href=\"/home-api/openapi.json\">here</a> <br>   The API client/consumer code may be easily generated in 60+ programming languages using an open source code generator available at the time of writing this documentation at <a href='https://editor.swagger.io/'>https://editor.swagger.io/</a> Thank you for using XTRF Application Programming interface (XTRF API). By using the API you agree to the terms below. If you disagree with any of these terms, XTRF does not grant you a license to use the XTRF API. XTRF reserves the right to update and change these terms from time to time without a prior notice of API users. You can always find the most recent version of these terms here:   # noqa: E501

    OpenAPI spec version: 2.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class ViewWithIdDTO(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'view_id': 'int',
        'columns': 'list[ColumnDTO]',
        'order': 'OrderDTO',
        'settings': 'SettingsDTO',
        'permissions': 'PermissionsDTO'
    }

    attribute_map = {
        'view_id': 'viewId',
        'columns': 'columns',
        'order': 'order',
        'settings': 'settings',
        'permissions': 'permissions'
    }

    def __init__(self, view_id=None, columns=None, order=None, settings=None, permissions=None):  # noqa: E501
        """ViewWithIdDTO - a model defined in Swagger"""  # noqa: E501
        self._view_id = None
        self._columns = None
        self._order = None
        self._settings = None
        self._permissions = None
        self.discriminator = None
        if view_id is not None:
            self.view_id = view_id
        if columns is not None:
            self.columns = columns
        if order is not None:
            self.order = order
        if settings is not None:
            self.settings = settings
        if permissions is not None:
            self.permissions = permissions

    @property
    def view_id(self):
        """Gets the view_id of this ViewWithIdDTO.  # noqa: E501


        :return: The view_id of this ViewWithIdDTO.  # noqa: E501
        :rtype: int
        """
        return self._view_id

    @view_id.setter
    def view_id(self, view_id):
        """Sets the view_id of this ViewWithIdDTO.


        :param view_id: The view_id of this ViewWithIdDTO.  # noqa: E501
        :type: int
        """

        self._view_id = view_id

    @property
    def columns(self):
        """Gets the columns of this ViewWithIdDTO.  # noqa: E501


        :return: The columns of this ViewWithIdDTO.  # noqa: E501
        :rtype: list[ColumnDTO]
        """
        return self._columns

    @columns.setter
    def columns(self, columns):
        """Sets the columns of this ViewWithIdDTO.


        :param columns: The columns of this ViewWithIdDTO.  # noqa: E501
        :type: list[ColumnDTO]
        """

        self._columns = columns

    @property
    def order(self):
        """Gets the order of this ViewWithIdDTO.  # noqa: E501


        :return: The order of this ViewWithIdDTO.  # noqa: E501
        :rtype: OrderDTO
        """
        return self._order

    @order.setter
    def order(self, order):
        """Sets the order of this ViewWithIdDTO.


        :param order: The order of this ViewWithIdDTO.  # noqa: E501
        :type: OrderDTO
        """

        self._order = order

    @property
    def settings(self):
        """Gets the settings of this ViewWithIdDTO.  # noqa: E501


        :return: The settings of this ViewWithIdDTO.  # noqa: E501
        :rtype: SettingsDTO
        """
        return self._settings

    @settings.setter
    def settings(self, settings):
        """Sets the settings of this ViewWithIdDTO.


        :param settings: The settings of this ViewWithIdDTO.  # noqa: E501
        :type: SettingsDTO
        """

        self._settings = settings

    @property
    def permissions(self):
        """Gets the permissions of this ViewWithIdDTO.  # noqa: E501


        :return: The permissions of this ViewWithIdDTO.  # noqa: E501
        :rtype: PermissionsDTO
        """
        return self._permissions

    @permissions.setter
    def permissions(self, permissions):
        """Sets the permissions of this ViewWithIdDTO.


        :param permissions: The permissions of this ViewWithIdDTO.  # noqa: E501
        :type: PermissionsDTO
        """

        self._permissions = permissions

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(ViewWithIdDTO, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ViewWithIdDTO):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
