# coding: utf-8

"""
    XTRF Home Portal API

    XTRF Home Portal API enables you to perform operations on Projects, Quotes, Customers, Vendors etc. as a XTRF Home Portal user. <br>The documentation is generated from OpenAPI specification 3.0 available <a href=\"/home-api/openapi.json\">here</a> <br>   The API client/consumer code may be easily generated in 60+ programming languages using an open source code generator available at the time of writing this documentation at <a href='https://editor.swagger.io/'>https://editor.swagger.io/</a> Thank you for using XTRF Application Programming interface (XTRF API). By using the API you agree to the terms below. If you disagree with any of these terms, XTRF does not grant you a license to use the XTRF API. XTRF reserves the right to update and change these terms from time to time without a prior notice of API users. You can always find the most recent version of these terms here:   # noqa: E501

    OpenAPI spec version: 2.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class ProjectLanguagesDTO(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'source_language_id': 'int',
        'target_language_ids': 'list[int]',
        'specialization_id': 'int',
        'language_combinations': 'list[LanguageCombinationDTO]'
    }

    attribute_map = {
        'source_language_id': 'sourceLanguageId',
        'target_language_ids': 'targetLanguageIds',
        'specialization_id': 'specializationId',
        'language_combinations': 'languageCombinations'
    }

    def __init__(self, source_language_id=None, target_language_ids=None, specialization_id=None, language_combinations=None):  # noqa: E501
        """ProjectLanguagesDTO - a model defined in Swagger"""  # noqa: E501
        self._source_language_id = None
        self._target_language_ids = None
        self._specialization_id = None
        self._language_combinations = None
        self.discriminator = None
        if source_language_id is not None:
            self.source_language_id = source_language_id
        if target_language_ids is not None:
            self.target_language_ids = target_language_ids
        if specialization_id is not None:
            self.specialization_id = specialization_id
        if language_combinations is not None:
            self.language_combinations = language_combinations

    @property
    def source_language_id(self):
        """Gets the source_language_id of this ProjectLanguagesDTO.  # noqa: E501


        :return: The source_language_id of this ProjectLanguagesDTO.  # noqa: E501
        :rtype: int
        """
        return self._source_language_id

    @source_language_id.setter
    def source_language_id(self, source_language_id):
        """Sets the source_language_id of this ProjectLanguagesDTO.


        :param source_language_id: The source_language_id of this ProjectLanguagesDTO.  # noqa: E501
        :type: int
        """

        self._source_language_id = source_language_id

    @property
    def target_language_ids(self):
        """Gets the target_language_ids of this ProjectLanguagesDTO.  # noqa: E501


        :return: The target_language_ids of this ProjectLanguagesDTO.  # noqa: E501
        :rtype: list[int]
        """
        return self._target_language_ids

    @target_language_ids.setter
    def target_language_ids(self, target_language_ids):
        """Sets the target_language_ids of this ProjectLanguagesDTO.


        :param target_language_ids: The target_language_ids of this ProjectLanguagesDTO.  # noqa: E501
        :type: list[int]
        """

        self._target_language_ids = target_language_ids

    @property
    def specialization_id(self):
        """Gets the specialization_id of this ProjectLanguagesDTO.  # noqa: E501


        :return: The specialization_id of this ProjectLanguagesDTO.  # noqa: E501
        :rtype: int
        """
        return self._specialization_id

    @specialization_id.setter
    def specialization_id(self, specialization_id):
        """Sets the specialization_id of this ProjectLanguagesDTO.


        :param specialization_id: The specialization_id of this ProjectLanguagesDTO.  # noqa: E501
        :type: int
        """

        self._specialization_id = specialization_id

    @property
    def language_combinations(self):
        """Gets the language_combinations of this ProjectLanguagesDTO.  # noqa: E501


        :return: The language_combinations of this ProjectLanguagesDTO.  # noqa: E501
        :rtype: list[LanguageCombinationDTO]
        """
        return self._language_combinations

    @language_combinations.setter
    def language_combinations(self, language_combinations):
        """Sets the language_combinations of this ProjectLanguagesDTO.


        :param language_combinations: The language_combinations of this ProjectLanguagesDTO.  # noqa: E501
        :type: list[LanguageCombinationDTO]
        """

        self._language_combinations = language_combinations

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(ProjectLanguagesDTO, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ProjectLanguagesDTO):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
