# coding: utf-8

"""
    XTRF Home Portal API

    XTRF Home Portal API enables you to perform operations on Projects, Quotes, Customers, Vendors etc. as a XTRF Home Portal user. <br>The documentation is generated from OpenAPI specification 3.0 available <a href=\"/home-api/openapi.json\">here</a> <br>   The API client/consumer code may be easily generated in 60+ programming languages using an open source code generator available at the time of writing this documentation at <a href='https://editor.swagger.io/'>https://editor.swagger.io/</a> Thank you for using XTRF Application Programming interface (XTRF API). By using the API you agree to the terms below. If you disagree with any of these terms, XTRF does not grant you a license to use the XTRF API. XTRF reserves the right to update and change these terms from time to time without a prior notice of API users. You can always find the most recent version of these terms here:   # noqa: E501

    OpenAPI spec version: 2.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class LanguageDTO(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'id': 'int',
        'name': 'str',
        'active': 'bool',
        'preferred': 'bool',
        'symbol': 'str',
        'iso6391': 'str',
        'iso6392': 'str',
        'default': 'bool'
    }

    attribute_map = {
        'id': 'id',
        'name': 'name',
        'active': 'active',
        'preferred': 'preferred',
        'symbol': 'symbol',
        'iso6391': 'iso6391',
        'iso6392': 'iso6392',
        'default': 'default'
    }

    def __init__(self, id=None, name=None, active=None, preferred=None, symbol=None, iso6391=None, iso6392=None, default=None):  # noqa: E501
        """LanguageDTO - a model defined in Swagger"""  # noqa: E501
        self._id = None
        self._name = None
        self._active = None
        self._preferred = None
        self._symbol = None
        self._iso6391 = None
        self._iso6392 = None
        self._default = None
        self.discriminator = None
        if id is not None:
            self.id = id
        if name is not None:
            self.name = name
        if active is not None:
            self.active = active
        if preferred is not None:
            self.preferred = preferred
        if symbol is not None:
            self.symbol = symbol
        if iso6391 is not None:
            self.iso6391 = iso6391
        if iso6392 is not None:
            self.iso6392 = iso6392
        if default is not None:
            self.default = default

    @property
    def id(self):
        """Gets the id of this LanguageDTO.  # noqa: E501

        internal identifier  # noqa: E501

        :return: The id of this LanguageDTO.  # noqa: E501
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this LanguageDTO.

        internal identifier  # noqa: E501

        :param id: The id of this LanguageDTO.  # noqa: E501
        :type: int
        """

        self._id = id

    @property
    def name(self):
        """Gets the name of this LanguageDTO.  # noqa: E501

        localised name (formatted in the current user's locale)  # noqa: E501

        :return: The name of this LanguageDTO.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this LanguageDTO.

        localised name (formatted in the current user's locale)  # noqa: E501

        :param name: The name of this LanguageDTO.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def active(self):
        """Gets the active of this LanguageDTO.  # noqa: E501

        should this value be available on the XTRF selection lists  # noqa: E501

        :return: The active of this LanguageDTO.  # noqa: E501
        :rtype: bool
        """
        return self._active

    @active.setter
    def active(self, active):
        """Sets the active of this LanguageDTO.

        should this value be available on the XTRF selection lists  # noqa: E501

        :param active: The active of this LanguageDTO.  # noqa: E501
        :type: bool
        """

        self._active = active

    @property
    def preferred(self):
        """Gets the preferred of this LanguageDTO.  # noqa: E501

        should this value be available on the top of XTRF selection lists, in the Preferred section  # noqa: E501

        :return: The preferred of this LanguageDTO.  # noqa: E501
        :rtype: bool
        """
        return self._preferred

    @preferred.setter
    def preferred(self, preferred):
        """Sets the preferred of this LanguageDTO.

        should this value be available on the top of XTRF selection lists, in the Preferred section  # noqa: E501

        :param preferred: The preferred of this LanguageDTO.  # noqa: E501
        :type: bool
        """

        self._preferred = preferred

    @property
    def symbol(self):
        """Gets the symbol of this LanguageDTO.  # noqa: E501

        specific symbol or abbreviation  # noqa: E501

        :return: The symbol of this LanguageDTO.  # noqa: E501
        :rtype: str
        """
        return self._symbol

    @symbol.setter
    def symbol(self, symbol):
        """Sets the symbol of this LanguageDTO.

        specific symbol or abbreviation  # noqa: E501

        :param symbol: The symbol of this LanguageDTO.  # noqa: E501
        :type: str
        """

        self._symbol = symbol

    @property
    def iso6391(self):
        """Gets the iso6391 of this LanguageDTO.  # noqa: E501

        <a href=\"http://en.wikipedia.org/wiki/List_of_ISO_639-1_codes\">ISO 639-1 code</a>  # noqa: E501

        :return: The iso6391 of this LanguageDTO.  # noqa: E501
        :rtype: str
        """
        return self._iso6391

    @iso6391.setter
    def iso6391(self, iso6391):
        """Sets the iso6391 of this LanguageDTO.

        <a href=\"http://en.wikipedia.org/wiki/List_of_ISO_639-1_codes\">ISO 639-1 code</a>  # noqa: E501

        :param iso6391: The iso6391 of this LanguageDTO.  # noqa: E501
        :type: str
        """

        self._iso6391 = iso6391

    @property
    def iso6392(self):
        """Gets the iso6392 of this LanguageDTO.  # noqa: E501

        <a href=\"http://en.wikipedia.org/wiki/List_of_ISO_639-2_codes\">ISO 639-2 code</a>  # noqa: E501

        :return: The iso6392 of this LanguageDTO.  # noqa: E501
        :rtype: str
        """
        return self._iso6392

    @iso6392.setter
    def iso6392(self, iso6392):
        """Sets the iso6392 of this LanguageDTO.

        <a href=\"http://en.wikipedia.org/wiki/List_of_ISO_639-2_codes\">ISO 639-2 code</a>  # noqa: E501

        :param iso6392: The iso6392 of this LanguageDTO.  # noqa: E501
        :type: str
        """

        self._iso6392 = iso6392

    @property
    def default(self):
        """Gets the default of this LanguageDTO.  # noqa: E501

        should this value be set by default in XTRF selection lists  # noqa: E501

        :return: The default of this LanguageDTO.  # noqa: E501
        :rtype: bool
        """
        return self._default

    @default.setter
    def default(self, default):
        """Sets the default of this LanguageDTO.

        should this value be set by default in XTRF selection lists  # noqa: E501

        :param default: The default of this LanguageDTO.  # noqa: E501
        :type: bool
        """

        self._default = default

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(LanguageDTO, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, LanguageDTO):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
