# coding: utf-8

"""
    XTRF Home Portal API

    XTRF Home Portal API enables you to perform operations on Projects, Quotes, Customers, Vendors etc. as a XTRF Home Portal user. <br>The documentation is generated from OpenAPI specification 3.0 available <a href=\"/home-api/openapi.json\">here</a> <br>   The API client/consumer code may be easily generated in 60+ programming languages using an open source code generator available at the time of writing this documentation at <a href='https://editor.swagger.io/'>https://editor.swagger.io/</a> Thank you for using XTRF Application Programming interface (XTRF API). By using the API you agree to the terms below. If you disagree with any of these terms, XTRF does not grant you a license to use the XTRF API. XTRF reserves the right to update and change these terms from time to time without a prior notice of API users. You can always find the most recent version of these terms here:   # noqa: E501

    OpenAPI spec version: 2.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class ClassicProjectCreateDTO(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'customer_id': 'int',
        'service_id': 'int',
        'specialization_id': 'int',
        'source_language_id': 'int',
        'target_languages_ids': 'list[int]',
        'name': 'str',
        'categories_ids': 'list[int]',
        'input_files': 'list[TaskFileDTO]',
        'dates': 'ProjectDatesDTO',
        'instructions': 'InstructionsDTO',
        'people': 'ClassicPeopleDTO'
    }

    attribute_map = {
        'customer_id': 'customerId',
        'service_id': 'serviceId',
        'specialization_id': 'specializationId',
        'source_language_id': 'sourceLanguageId',
        'target_languages_ids': 'targetLanguagesIds',
        'name': 'name',
        'categories_ids': 'categoriesIds',
        'input_files': 'inputFiles',
        'dates': 'dates',
        'instructions': 'instructions',
        'people': 'people'
    }

    def __init__(self, customer_id=None, service_id=None, specialization_id=None, source_language_id=None, target_languages_ids=None, name=None, categories_ids=None, input_files=None, dates=None, instructions=None, people=None):  # noqa: E501
        """ClassicProjectCreateDTO - a model defined in Swagger"""  # noqa: E501
        self._customer_id = None
        self._service_id = None
        self._specialization_id = None
        self._source_language_id = None
        self._target_languages_ids = None
        self._name = None
        self._categories_ids = None
        self._input_files = None
        self._dates = None
        self._instructions = None
        self._people = None
        self.discriminator = None
        self.customer_id = customer_id
        self.service_id = service_id
        self.specialization_id = specialization_id
        if source_language_id is not None:
            self.source_language_id = source_language_id
        if target_languages_ids is not None:
            self.target_languages_ids = target_languages_ids
        if name is not None:
            self.name = name
        if categories_ids is not None:
            self.categories_ids = categories_ids
        if input_files is not None:
            self.input_files = input_files
        if dates is not None:
            self.dates = dates
        if instructions is not None:
            self.instructions = instructions
        if people is not None:
            self.people = people

    @property
    def customer_id(self):
        """Gets the customer_id of this ClassicProjectCreateDTO.  # noqa: E501


        :return: The customer_id of this ClassicProjectCreateDTO.  # noqa: E501
        :rtype: int
        """
        return self._customer_id

    @customer_id.setter
    def customer_id(self, customer_id):
        """Sets the customer_id of this ClassicProjectCreateDTO.


        :param customer_id: The customer_id of this ClassicProjectCreateDTO.  # noqa: E501
        :type: int
        """
        if customer_id is None:
            raise ValueError("Invalid value for `customer_id`, must not be `None`")  # noqa: E501

        self._customer_id = customer_id

    @property
    def service_id(self):
        """Gets the service_id of this ClassicProjectCreateDTO.  # noqa: E501


        :return: The service_id of this ClassicProjectCreateDTO.  # noqa: E501
        :rtype: int
        """
        return self._service_id

    @service_id.setter
    def service_id(self, service_id):
        """Sets the service_id of this ClassicProjectCreateDTO.


        :param service_id: The service_id of this ClassicProjectCreateDTO.  # noqa: E501
        :type: int
        """
        if service_id is None:
            raise ValueError("Invalid value for `service_id`, must not be `None`")  # noqa: E501

        self._service_id = service_id

    @property
    def specialization_id(self):
        """Gets the specialization_id of this ClassicProjectCreateDTO.  # noqa: E501


        :return: The specialization_id of this ClassicProjectCreateDTO.  # noqa: E501
        :rtype: int
        """
        return self._specialization_id

    @specialization_id.setter
    def specialization_id(self, specialization_id):
        """Sets the specialization_id of this ClassicProjectCreateDTO.


        :param specialization_id: The specialization_id of this ClassicProjectCreateDTO.  # noqa: E501
        :type: int
        """
        if specialization_id is None:
            raise ValueError("Invalid value for `specialization_id`, must not be `None`")  # noqa: E501

        self._specialization_id = specialization_id

    @property
    def source_language_id(self):
        """Gets the source_language_id of this ClassicProjectCreateDTO.  # noqa: E501


        :return: The source_language_id of this ClassicProjectCreateDTO.  # noqa: E501
        :rtype: int
        """
        return self._source_language_id

    @source_language_id.setter
    def source_language_id(self, source_language_id):
        """Sets the source_language_id of this ClassicProjectCreateDTO.


        :param source_language_id: The source_language_id of this ClassicProjectCreateDTO.  # noqa: E501
        :type: int
        """

        self._source_language_id = source_language_id

    @property
    def target_languages_ids(self):
        """Gets the target_languages_ids of this ClassicProjectCreateDTO.  # noqa: E501


        :return: The target_languages_ids of this ClassicProjectCreateDTO.  # noqa: E501
        :rtype: list[int]
        """
        return self._target_languages_ids

    @target_languages_ids.setter
    def target_languages_ids(self, target_languages_ids):
        """Sets the target_languages_ids of this ClassicProjectCreateDTO.


        :param target_languages_ids: The target_languages_ids of this ClassicProjectCreateDTO.  # noqa: E501
        :type: list[int]
        """

        self._target_languages_ids = target_languages_ids

    @property
    def name(self):
        """Gets the name of this ClassicProjectCreateDTO.  # noqa: E501


        :return: The name of this ClassicProjectCreateDTO.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this ClassicProjectCreateDTO.


        :param name: The name of this ClassicProjectCreateDTO.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def categories_ids(self):
        """Gets the categories_ids of this ClassicProjectCreateDTO.  # noqa: E501

        list of language categories  # noqa: E501

        :return: The categories_ids of this ClassicProjectCreateDTO.  # noqa: E501
        :rtype: list[int]
        """
        return self._categories_ids

    @categories_ids.setter
    def categories_ids(self, categories_ids):
        """Sets the categories_ids of this ClassicProjectCreateDTO.

        list of language categories  # noqa: E501

        :param categories_ids: The categories_ids of this ClassicProjectCreateDTO.  # noqa: E501
        :type: list[int]
        """

        self._categories_ids = categories_ids

    @property
    def input_files(self):
        """Gets the input_files of this ClassicProjectCreateDTO.  # noqa: E501

        input files  # noqa: E501

        :return: The input_files of this ClassicProjectCreateDTO.  # noqa: E501
        :rtype: list[TaskFileDTO]
        """
        return self._input_files

    @input_files.setter
    def input_files(self, input_files):
        """Sets the input_files of this ClassicProjectCreateDTO.

        input files  # noqa: E501

        :param input_files: The input_files of this ClassicProjectCreateDTO.  # noqa: E501
        :type: list[TaskFileDTO]
        """

        self._input_files = input_files

    @property
    def dates(self):
        """Gets the dates of this ClassicProjectCreateDTO.  # noqa: E501


        :return: The dates of this ClassicProjectCreateDTO.  # noqa: E501
        :rtype: ProjectDatesDTO
        """
        return self._dates

    @dates.setter
    def dates(self, dates):
        """Sets the dates of this ClassicProjectCreateDTO.


        :param dates: The dates of this ClassicProjectCreateDTO.  # noqa: E501
        :type: ProjectDatesDTO
        """

        self._dates = dates

    @property
    def instructions(self):
        """Gets the instructions of this ClassicProjectCreateDTO.  # noqa: E501


        :return: The instructions of this ClassicProjectCreateDTO.  # noqa: E501
        :rtype: InstructionsDTO
        """
        return self._instructions

    @instructions.setter
    def instructions(self, instructions):
        """Sets the instructions of this ClassicProjectCreateDTO.


        :param instructions: The instructions of this ClassicProjectCreateDTO.  # noqa: E501
        :type: InstructionsDTO
        """

        self._instructions = instructions

    @property
    def people(self):
        """Gets the people of this ClassicProjectCreateDTO.  # noqa: E501


        :return: The people of this ClassicProjectCreateDTO.  # noqa: E501
        :rtype: ClassicPeopleDTO
        """
        return self._people

    @people.setter
    def people(self, people):
        """Sets the people of this ClassicProjectCreateDTO.


        :param people: The people of this ClassicProjectCreateDTO.  # noqa: E501
        :type: ClassicPeopleDTO
        """

        self._people = people

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(ClassicProjectCreateDTO, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ClassicProjectCreateDTO):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
