# coding: utf-8

"""
    XTRF Home Portal API

    XTRF Home Portal API enables you to perform operations on Projects, Quotes, Customers, Vendors etc. as a XTRF Home Portal user. <br>The documentation is generated from OpenAPI specification 3.0 available <a href=\"/home-api/openapi.json\">here</a> <br>   The API client/consumer code may be easily generated in 60+ programming languages using an open source code generator available at the time of writing this documentation at <a href='https://editor.swagger.io/'>https://editor.swagger.io/</a> Thank you for using XTRF Application Programming interface (XTRF API). By using the API you agree to the terms below. If you disagree with any of these terms, XTRF does not grant you a license to use the XTRF API. XTRF reserves the right to update and change these terms from time to time without a prior notice of API users. You can always find the most recent version of these terms here:   # noqa: E501

    OpenAPI spec version: 2.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from xtrf_api.api_client import ApiClient


class VendorsApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def delete3(self, person_id, **kwargs):  # noqa: E501
        """Removes a person.  # noqa: E501

        Removes a person.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete3(person_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int person_id: person's internal identifier (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete3_with_http_info(person_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete3_with_http_info(person_id, **kwargs)  # noqa: E501
            return data

    def delete3_with_http_info(self, person_id, **kwargs):  # noqa: E501
        """Removes a person.  # noqa: E501

        Removes a person.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete3_with_http_info(person_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int person_id: person's internal identifier (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['person_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete3" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'person_id' is set
        if ('person_id' not in params or
                params['person_id'] is None):
            raise ValueError("Missing the required parameter `person_id` when calling `delete3`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'person_id' in params:
            path_params['personId'] = params['person_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.xtrf-v1+json;charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/providers/persons/{personId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete3_0(self, price_list_id, **kwargs):  # noqa: E501
        """Removes a provider price list.  # noqa: E501

        Removes a provider price list.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete3_0(price_list_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int price_list_id: provider price list's internal identifier (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete3_0_with_http_info(price_list_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete3_0_with_http_info(price_list_id, **kwargs)  # noqa: E501
            return data

    def delete3_0_with_http_info(self, price_list_id, **kwargs):  # noqa: E501
        """Removes a provider price list.  # noqa: E501

        Removes a provider price list.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete3_0_with_http_info(price_list_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int price_list_id: provider price list's internal identifier (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['price_list_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete3_0" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'price_list_id' is set
        if ('price_list_id' not in params or
                params['price_list_id'] is None):
            raise ValueError("Missing the required parameter `price_list_id` when calling `delete3_0`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'price_list_id' in params:
            path_params['priceListId'] = params['price_list_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/providers/priceLists/{priceListId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete4(self, provider_id, **kwargs):  # noqa: E501
        """Removes a provider.  # noqa: E501

        Removes a provider.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete4(provider_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int provider_id: provider's internal identifier (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete4_with_http_info(provider_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete4_with_http_info(provider_id, **kwargs)  # noqa: E501
            return data

    def delete4_with_http_info(self, provider_id, **kwargs):  # noqa: E501
        """Removes a provider.  # noqa: E501

        Removes a provider.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete4_with_http_info(provider_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int provider_id: provider's internal identifier (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['provider_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete4" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'provider_id' is set
        if ('provider_id' not in params or
                params['provider_id'] is None):
            raise ValueError("Missing the required parameter `provider_id` when calling `delete4`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'provider_id' in params:
            path_params['providerId'] = params['provider_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/providers/{providerId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_address1(self, provider_id, **kwargs):  # noqa: E501
        """Returns address of a given provider.  # noqa: E501

        Returns address of a given provider.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_address1(provider_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int provider_id: provider's internal identifier (required)
        :return: AddressDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_address1_with_http_info(provider_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_address1_with_http_info(provider_id, **kwargs)  # noqa: E501
            return data

    def get_address1_with_http_info(self, provider_id, **kwargs):  # noqa: E501
        """Returns address of a given provider.  # noqa: E501

        Returns address of a given provider.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_address1_with_http_info(provider_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int provider_id: provider's internal identifier (required)
        :return: AddressDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['provider_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_address1" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'provider_id' is set
        if ('provider_id' not in params or
                params['provider_id'] is None):
            raise ValueError("Missing the required parameter `provider_id` when calling `get_address1`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'provider_id' in params:
            path_params['providerId'] = params['provider_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.xtrf-v1+json;charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/providers/{providerId}/address', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AddressDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_all_ids4(self, **kwargs):  # noqa: E501
        """Returns persons' internal identifiers.  # noqa: E501

        Returns persons' internal identifiers.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_ids4(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int updated_since: only persons modified since this timestamp
        :return: list[int]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_all_ids4_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_all_ids4_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_all_ids4_with_http_info(self, **kwargs):  # noqa: E501
        """Returns persons' internal identifiers.  # noqa: E501

        Returns persons' internal identifiers.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_ids4_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int updated_since: only persons modified since this timestamp
        :return: list[int]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['updated_since']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_all_ids4" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'updated_since' in params:
            query_params.append(('updatedSince', params['updated_since']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.xtrf-v1+json;charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/providers/persons/ids', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[int]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_all_ids5(self, **kwargs):  # noqa: E501
        """Returns providers' internal identifiers.  # noqa: E501

        Returns providers' internal identifiers.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_ids5(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int updated_since: only providers modified since this timestamp
        :return: list[int]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_all_ids5_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_all_ids5_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_all_ids5_with_http_info(self, **kwargs):  # noqa: E501
        """Returns providers' internal identifiers.  # noqa: E501

        Returns providers' internal identifiers.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_ids5_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int updated_since: only providers modified since this timestamp
        :return: list[int]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['updated_since']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_all_ids5" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'updated_since' in params:
            query_params.append(('updatedSince', params['updated_since']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.xtrf-v1+json;charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/providers/ids', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[int]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_by_id4(self, person_id, **kwargs):  # noqa: E501
        """Returns person details.  # noqa: E501

        Returns person details.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_by_id4(person_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int person_id: person's internal identifier (required)
        :return: ProviderPersonDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_by_id4_with_http_info(person_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_by_id4_with_http_info(person_id, **kwargs)  # noqa: E501
            return data

    def get_by_id4_with_http_info(self, person_id, **kwargs):  # noqa: E501
        """Returns person details.  # noqa: E501

        Returns person details.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_by_id4_with_http_info(person_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int person_id: person's internal identifier (required)
        :return: ProviderPersonDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['person_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_by_id4" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'person_id' is set
        if ('person_id' not in params or
                params['person_id'] is None):
            raise ValueError("Missing the required parameter `person_id` when calling `get_by_id4`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'person_id' in params:
            path_params['personId'] = params['person_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.xtrf-v1+json;charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/providers/persons/{personId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ProviderPersonDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_by_id5(self, provider_id, **kwargs):  # noqa: E501
        """Returns provider details.  # noqa: E501

        Returns provider details.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_by_id5(provider_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int provider_id: provider's internal identifier (required)
        :param str embed: list of adittional fields which should be embedded in the response (ie. persons)
        :return: ProviderDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_by_id5_with_http_info(provider_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_by_id5_with_http_info(provider_id, **kwargs)  # noqa: E501
            return data

    def get_by_id5_with_http_info(self, provider_id, **kwargs):  # noqa: E501
        """Returns provider details.  # noqa: E501

        Returns provider details.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_by_id5_with_http_info(provider_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int provider_id: provider's internal identifier (required)
        :param str embed: list of adittional fields which should be embedded in the response (ie. persons)
        :return: ProviderDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['provider_id', 'embed']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_by_id5" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'provider_id' is set
        if ('provider_id' not in params or
                params['provider_id'] is None):
            raise ValueError("Missing the required parameter `provider_id` when calling `get_by_id5`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'provider_id' in params:
            path_params['providerId'] = params['provider_id']  # noqa: E501

        query_params = []
        if 'embed' in params:
            query_params.append(('embed', params['embed']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.xtrf-v1+json;charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/providers/{providerId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ProviderDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_competencies(self, provider_id, **kwargs):  # noqa: E501
        """Returns competencies of a given provider.  # noqa: E501

        Returns competencies of a given provider.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_competencies(provider_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int provider_id: provider's internal identifier (required)
        :return: CompetenciesDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_competencies_with_http_info(provider_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_competencies_with_http_info(provider_id, **kwargs)  # noqa: E501
            return data

    def get_competencies_with_http_info(self, provider_id, **kwargs):  # noqa: E501
        """Returns competencies of a given provider.  # noqa: E501

        Returns competencies of a given provider.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_competencies_with_http_info(provider_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int provider_id: provider's internal identifier (required)
        :return: CompetenciesDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['provider_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_competencies" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'provider_id' is set
        if ('provider_id' not in params or
                params['provider_id'] is None):
            raise ValueError("Missing the required parameter `provider_id` when calling `get_competencies`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'provider_id' in params:
            path_params['providerId'] = params['provider_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.xtrf-v1+json;charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/providers/{providerId}/competencies', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CompetenciesDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_contact2(self, person_id, **kwargs):  # noqa: E501
        """Returns contact of a given person.  # noqa: E501

        Returns contact of a given person.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_contact2(person_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int person_id: person's internal identifier (required)
        :return: PersonContactDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_contact2_with_http_info(person_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_contact2_with_http_info(person_id, **kwargs)  # noqa: E501
            return data

    def get_contact2_with_http_info(self, person_id, **kwargs):  # noqa: E501
        """Returns contact of a given person.  # noqa: E501

        Returns contact of a given person.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_contact2_with_http_info(person_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int person_id: person's internal identifier (required)
        :return: PersonContactDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['person_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_contact2" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'person_id' is set
        if ('person_id' not in params or
                params['person_id'] is None):
            raise ValueError("Missing the required parameter `person_id` when calling `get_contact2`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'person_id' in params:
            path_params['personId'] = params['person_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.xtrf-v1+json;charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/providers/persons/{personId}/contact', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PersonContactDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_contact3(self, provider_id, **kwargs):  # noqa: E501
        """Returns contact of a given provider.  # noqa: E501

        Returns contact of a given provider.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_contact3(provider_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int provider_id: provider's internal identifier (required)
        :return: ContactDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_contact3_with_http_info(provider_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_contact3_with_http_info(provider_id, **kwargs)  # noqa: E501
            return data

    def get_contact3_with_http_info(self, provider_id, **kwargs):  # noqa: E501
        """Returns contact of a given provider.  # noqa: E501

        Returns contact of a given provider.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_contact3_with_http_info(provider_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int provider_id: provider's internal identifier (required)
        :return: ContactDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['provider_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_contact3" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'provider_id' is set
        if ('provider_id' not in params or
                params['provider_id'] is None):
            raise ValueError("Missing the required parameter `provider_id` when calling `get_contact3`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'provider_id' in params:
            path_params['providerId'] = params['provider_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.xtrf-v1+json;charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/providers/{providerId}/contact', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ContactDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_correspondence_address1(self, provider_id, **kwargs):  # noqa: E501
        """Returns correspondence address of a given provider.  # noqa: E501

        Returns correspondence address of a given provider.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_correspondence_address1(provider_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int provider_id: provider's internal identifier (required)
        :return: AddressDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_correspondence_address1_with_http_info(provider_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_correspondence_address1_with_http_info(provider_id, **kwargs)  # noqa: E501
            return data

    def get_correspondence_address1_with_http_info(self, provider_id, **kwargs):  # noqa: E501
        """Returns correspondence address of a given provider.  # noqa: E501

        Returns correspondence address of a given provider.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_correspondence_address1_with_http_info(provider_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int provider_id: provider's internal identifier (required)
        :return: AddressDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['provider_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_correspondence_address1" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'provider_id' is set
        if ('provider_id' not in params or
                params['provider_id'] is None):
            raise ValueError("Missing the required parameter `provider_id` when calling `get_correspondence_address1`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'provider_id' in params:
            path_params['providerId'] = params['provider_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.xtrf-v1+json;charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/providers/{providerId}/correspondenceAddress', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AddressDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_custom_fields2(self, person_id, **kwargs):  # noqa: E501
        """Returns custom fields of a given person.  # noqa: E501

        Returns custom fields of a given person.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_custom_fields2(person_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int person_id: person's internal identifier (required)
        :return: CustomFieldsDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_custom_fields2_with_http_info(person_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_custom_fields2_with_http_info(person_id, **kwargs)  # noqa: E501
            return data

    def get_custom_fields2_with_http_info(self, person_id, **kwargs):  # noqa: E501
        """Returns custom fields of a given person.  # noqa: E501

        Returns custom fields of a given person.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_custom_fields2_with_http_info(person_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int person_id: person's internal identifier (required)
        :return: CustomFieldsDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['person_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_custom_fields2" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'person_id' is set
        if ('person_id' not in params or
                params['person_id'] is None):
            raise ValueError("Missing the required parameter `person_id` when calling `get_custom_fields2`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'person_id' in params:
            path_params['personId'] = params['person_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.xtrf-v1+json;charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/providers/persons/{personId}/customFields', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CustomFieldsDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_custom_fields3(self, provider_id, **kwargs):  # noqa: E501
        """Returns custom fields of a given provider.  # noqa: E501

        Returns custom fields of a given provider.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_custom_fields3(provider_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int provider_id: provider's internal identifier (required)
        :return: CustomFieldsDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_custom_fields3_with_http_info(provider_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_custom_fields3_with_http_info(provider_id, **kwargs)  # noqa: E501
            return data

    def get_custom_fields3_with_http_info(self, provider_id, **kwargs):  # noqa: E501
        """Returns custom fields of a given provider.  # noqa: E501

        Returns custom fields of a given provider.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_custom_fields3_with_http_info(provider_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int provider_id: provider's internal identifier (required)
        :return: CustomFieldsDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['provider_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_custom_fields3" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'provider_id' is set
        if ('provider_id' not in params or
                params['provider_id'] is None):
            raise ValueError("Missing the required parameter `provider_id` when calling `get_custom_fields3`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'provider_id' in params:
            path_params['providerId'] = params['provider_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.xtrf-v1+json;charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/providers/{providerId}/customFields', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CustomFieldsDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def send_invitations(self, person_id, **kwargs):  # noqa: E501
        """Sends invitation to Vendor Portal.  # noqa: E501

        Sends invitation to Vendor Portal.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.send_invitations(person_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int person_id: person's internal identifier (required)
        :return: InvitationStatisticsDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.send_invitations_with_http_info(person_id, **kwargs)  # noqa: E501
        else:
            (data) = self.send_invitations_with_http_info(person_id, **kwargs)  # noqa: E501
            return data

    def send_invitations_with_http_info(self, person_id, **kwargs):  # noqa: E501
        """Sends invitation to Vendor Portal.  # noqa: E501

        Sends invitation to Vendor Portal.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.send_invitations_with_http_info(person_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int person_id: person's internal identifier (required)
        :return: InvitationStatisticsDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['person_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method send_invitations" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'person_id' is set
        if ('person_id' not in params or
                params['person_id'] is None):
            raise ValueError("Missing the required parameter `person_id` when calling `send_invitations`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'person_id' in params:
            path_params['personId'] = params['person_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.xtrf-v1+json;charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/providers/persons/{personId}/notification/invitation', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InvitationStatisticsDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def send_invitations1(self, provider_id, **kwargs):  # noqa: E501
        """Sends invitations to Vendor Portal.  # noqa: E501

        Sends invitations to Vendor Portal.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.send_invitations1(provider_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int provider_id: provider's internal identifier (required)
        :return: InvitationStatisticsDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.send_invitations1_with_http_info(provider_id, **kwargs)  # noqa: E501
        else:
            (data) = self.send_invitations1_with_http_info(provider_id, **kwargs)  # noqa: E501
            return data

    def send_invitations1_with_http_info(self, provider_id, **kwargs):  # noqa: E501
        """Sends invitations to Vendor Portal.  # noqa: E501

        Sends invitations to Vendor Portal.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.send_invitations1_with_http_info(provider_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int provider_id: provider's internal identifier (required)
        :return: InvitationStatisticsDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['provider_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method send_invitations1" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'provider_id' is set
        if ('provider_id' not in params or
                params['provider_id'] is None):
            raise ValueError("Missing the required parameter `provider_id` when calling `send_invitations1`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'provider_id' in params:
            path_params['providerId'] = params['provider_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.xtrf-v1+json;charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/providers/{providerId}/notification/invitation', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InvitationStatisticsDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
