# coding: utf-8

"""
    XTRF Home Portal API

    XTRF Home Portal API enables you to perform operations on Projects, Quotes, Customers, Vendors etc. as a XTRF Home Portal user. <br>The documentation is generated from OpenAPI specification 3.0 available <a href=\"/home-api/openapi.json\">here</a> <br>   The API client/consumer code may be easily generated in 60+ programming languages using an open source code generator available at the time of writing this documentation at <a href='https://editor.swagger.io/'>https://editor.swagger.io/</a> Thank you for using XTRF Application Programming interface (XTRF API). By using the API you agree to the terms below. If you disagree with any of these terms, XTRF does not grant you a license to use the XTRF API. XTRF reserves the right to update and change these terms from time to time without a prior notice of API users. You can always find the most recent version of these terms here:   # noqa: E501

    OpenAPI spec version: 2.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from xtrf_api.api_client import ApiClient


class TasksClassicApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def add_file(self, body, task_id, **kwargs):  # noqa: E501
        """Adds files to a given task.  # noqa: E501

        Adds files to a given task.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_file(body, task_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param FileDTO body: (required)
        :param str task_id: task's internal identifier (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_file_with_http_info(body, task_id, **kwargs)  # noqa: E501
        else:
            (data) = self.add_file_with_http_info(body, task_id, **kwargs)  # noqa: E501
            return data

    def add_file_with_http_info(self, body, task_id, **kwargs):  # noqa: E501
        """Adds files to a given task.  # noqa: E501

        Adds files to a given task.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_file_with_http_info(body, task_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param FileDTO body: (required)
        :param str task_id: task's internal identifier (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'task_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_file" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `add_file`")  # noqa: E501
        # verify the required parameter 'task_id' is set
        if ('task_id' not in params or
                params['task_id'] is None):
            raise ValueError("Missing the required parameter `task_id` when calling `add_file`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'task_id' in params:
            path_params['taskId'] = params['task_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/tasks/{taskId}/files/input', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete5(self, task_id, **kwargs):  # noqa: E501
        """Removes a task.  # noqa: E501

        Removes a task.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete5(task_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str task_id: task's internal identifier (required)
        :param bool remove_files_from_disc: remove files from disc
        :param bool remove_external_projects: remove external projects (ie. from CAT Tool)
        :param bool force_jobs_removal: force jobs removal (ie. started or ready)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete5_with_http_info(task_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete5_with_http_info(task_id, **kwargs)  # noqa: E501
            return data

    def delete5_with_http_info(self, task_id, **kwargs):  # noqa: E501
        """Removes a task.  # noqa: E501

        Removes a task.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete5_with_http_info(task_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str task_id: task's internal identifier (required)
        :param bool remove_files_from_disc: remove files from disc
        :param bool remove_external_projects: remove external projects (ie. from CAT Tool)
        :param bool force_jobs_removal: force jobs removal (ie. started or ready)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['task_id', 'remove_files_from_disc', 'remove_external_projects', 'force_jobs_removal']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete5" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'task_id' is set
        if ('task_id' not in params or
                params['task_id'] is None):
            raise ValueError("Missing the required parameter `task_id` when calling `delete5`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'task_id' in params:
            path_params['taskId'] = params['task_id']  # noqa: E501

        query_params = []
        if 'remove_files_from_disc' in params:
            query_params.append(('removeFilesFromDisc', params['remove_files_from_disc']))  # noqa: E501
        if 'remove_external_projects' in params:
            query_params.append(('removeExternalProjects', params['remove_external_projects']))  # noqa: E501
        if 'force_jobs_removal' in params:
            query_params.append(('forceJobsRemoval', params['force_jobs_removal']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/tasks/{taskId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_contacts1(self, task_id, **kwargs):  # noqa: E501
        """Returns contacts of a given task.  # noqa: E501

        Returns contacts of a given task.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_contacts1(task_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str task_id: task's internal identifier (required)
        :return: ContactsDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_contacts1_with_http_info(task_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_contacts1_with_http_info(task_id, **kwargs)  # noqa: E501
            return data

    def get_contacts1_with_http_info(self, task_id, **kwargs):  # noqa: E501
        """Returns contacts of a given task.  # noqa: E501

        Returns contacts of a given task.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_contacts1_with_http_info(task_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str task_id: task's internal identifier (required)
        :return: ContactsDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['task_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_contacts1" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'task_id' is set
        if ('task_id' not in params or
                params['task_id'] is None):
            raise ValueError("Missing the required parameter `task_id` when calling `get_contacts1`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'task_id' in params:
            path_params['taskId'] = params['task_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.xtrf-v1+json;charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/tasks/{taskId}/contacts', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ContactsDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_custom_fields7(self, task_id, **kwargs):  # noqa: E501
        """Returns custom fields of a given task.  # noqa: E501

        Returns custom fields of a given task.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_custom_fields7(task_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str task_id: task's internal identifier (required)
        :return: CustomFieldsDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_custom_fields7_with_http_info(task_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_custom_fields7_with_http_info(task_id, **kwargs)  # noqa: E501
            return data

    def get_custom_fields7_with_http_info(self, task_id, **kwargs):  # noqa: E501
        """Returns custom fields of a given task.  # noqa: E501

        Returns custom fields of a given task.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_custom_fields7_with_http_info(task_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str task_id: task's internal identifier (required)
        :return: CustomFieldsDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['task_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_custom_fields7" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'task_id' is set
        if ('task_id' not in params or
                params['task_id'] is None):
            raise ValueError("Missing the required parameter `task_id` when calling `get_custom_fields7`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'task_id' in params:
            path_params['taskId'] = params['task_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.xtrf-v1+json;charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/tasks/{taskId}/customFields', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CustomFieldsDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_dates3(self, task_id, **kwargs):  # noqa: E501
        """Returns dates of a given task.  # noqa: E501

        Returns dates of a given task.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_dates3(task_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str task_id: task's internal identifier (required)
        :return: ProjectDatesDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_dates3_with_http_info(task_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_dates3_with_http_info(task_id, **kwargs)  # noqa: E501
            return data

    def get_dates3_with_http_info(self, task_id, **kwargs):  # noqa: E501
        """Returns dates of a given task.  # noqa: E501

        Returns dates of a given task.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_dates3_with_http_info(task_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str task_id: task's internal identifier (required)
        :return: ProjectDatesDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['task_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_dates3" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'task_id' is set
        if ('task_id' not in params or
                params['task_id'] is None):
            raise ValueError("Missing the required parameter `task_id` when calling `get_dates3`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'task_id' in params:
            path_params['taskId'] = params['task_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.xtrf-v1+json;charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/tasks/{taskId}/dates', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ProjectDatesDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_instructions2(self, task_id, **kwargs):  # noqa: E501
        """Returns instructions of a given task.  # noqa: E501

        Returns instructions of a given task.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_instructions2(task_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str task_id: task's internal identifier (required)
        :return: InstructionsDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_instructions2_with_http_info(task_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_instructions2_with_http_info(task_id, **kwargs)  # noqa: E501
            return data

    def get_instructions2_with_http_info(self, task_id, **kwargs):  # noqa: E501
        """Returns instructions of a given task.  # noqa: E501

        Returns instructions of a given task.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_instructions2_with_http_info(task_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str task_id: task's internal identifier (required)
        :return: InstructionsDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['task_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_instructions2" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'task_id' is set
        if ('task_id' not in params or
                params['task_id'] is None):
            raise ValueError("Missing the required parameter `task_id` when calling `get_instructions2`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'task_id' in params:
            path_params['taskId'] = params['task_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.xtrf-v1+json;charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/tasks/{taskId}/instructions', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InstructionsDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_progress(self, task_id, **kwargs):  # noqa: E501
        """Returns progress of a given task.  # noqa: E501

        Returns progress of a given task. Progress contains information about task's status (ie. opened or ready) and current phase (ie. translation). Workflow phase is defined as the first one which contains not ready jobs (ie. opened or started). When no such job exists then workflow phase is not included.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_progress(task_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str task_id: task's internal identifier (required)
        :return: TaskProgressDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_progress_with_http_info(task_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_progress_with_http_info(task_id, **kwargs)  # noqa: E501
            return data

    def get_progress_with_http_info(self, task_id, **kwargs):  # noqa: E501
        """Returns progress of a given task.  # noqa: E501

        Returns progress of a given task. Progress contains information about task's status (ie. opened or ready) and current phase (ie. translation). Workflow phase is defined as the first one which contains not ready jobs (ie. opened or started). When no such job exists then workflow phase is not included.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_progress_with_http_info(task_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str task_id: task's internal identifier (required)
        :return: TaskProgressDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['task_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_progress" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'task_id' is set
        if ('task_id' not in params or
                params['task_id'] is None):
            raise ValueError("Missing the required parameter `task_id` when calling `get_progress`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'task_id' in params:
            path_params['taskId'] = params['task_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.xtrf-v1+json;charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/tasks/{taskId}/progress', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TaskProgressDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def start1(self, task_id, **kwargs):  # noqa: E501
        """Starts a task.  # noqa: E501

        Starts a task.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.start1(task_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str task_id: task's internal identifier (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.start1_with_http_info(task_id, **kwargs)  # noqa: E501
        else:
            (data) = self.start1_with_http_info(task_id, **kwargs)  # noqa: E501
            return data

    def start1_with_http_info(self, task_id, **kwargs):  # noqa: E501
        """Starts a task.  # noqa: E501

        Starts a task.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.start1_with_http_info(task_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str task_id: task's internal identifier (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['task_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method start1" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'task_id' is set
        if ('task_id' not in params or
                params['task_id'] is None):
            raise ValueError("Missing the required parameter `task_id` when calling `start1`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'task_id' in params:
            path_params['taskId'] = params['task_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/tasks/{taskId}/start', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_client_task_po_number(self, body, task_id, **kwargs):  # noqa: E501
        """Updates Client Task PO Number of a given task.  # noqa: E501

        Updates Client Task PO Number of a given task.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_client_task_po_number(body, task_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param StringDTO body: Updated Client Task PO Number of a given task. (required)
        :param str task_id: task's internal identifier (required)
        :return: StringDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_client_task_po_number_with_http_info(body, task_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_client_task_po_number_with_http_info(body, task_id, **kwargs)  # noqa: E501
            return data

    def update_client_task_po_number_with_http_info(self, body, task_id, **kwargs):  # noqa: E501
        """Updates Client Task PO Number of a given task.  # noqa: E501

        Updates Client Task PO Number of a given task.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_client_task_po_number_with_http_info(body, task_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param StringDTO body: Updated Client Task PO Number of a given task. (required)
        :param str task_id: task's internal identifier (required)
        :return: StringDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'task_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_client_task_po_number" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_client_task_po_number`")  # noqa: E501
        # verify the required parameter 'task_id' is set
        if ('task_id' not in params or
                params['task_id'] is None):
            raise ValueError("Missing the required parameter `task_id` when calling `update_client_task_po_number`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'task_id' in params:
            path_params['taskId'] = params['task_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.xtrf-v1+json;charset=UTF-8'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/tasks/{taskId}/clientTaskPONumber', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='StringDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_contacts(self, body, task_id, **kwargs):  # noqa: E501
        """Updates contacts of a given task.  # noqa: E501

        Updates contacts of a given task.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_contacts(body, task_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ContactsDTO body: Updated contacts of given task. (required)
        :param str task_id: task's internal identifier (required)
        :return: ContactsDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_contacts_with_http_info(body, task_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_contacts_with_http_info(body, task_id, **kwargs)  # noqa: E501
            return data

    def update_contacts_with_http_info(self, body, task_id, **kwargs):  # noqa: E501
        """Updates contacts of a given task.  # noqa: E501

        Updates contacts of a given task.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_contacts_with_http_info(body, task_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ContactsDTO body: Updated contacts of given task. (required)
        :param str task_id: task's internal identifier (required)
        :return: ContactsDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'task_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_contacts" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_contacts`")  # noqa: E501
        # verify the required parameter 'task_id' is set
        if ('task_id' not in params or
                params['task_id'] is None):
            raise ValueError("Missing the required parameter `task_id` when calling `update_contacts`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'task_id' in params:
            path_params['taskId'] = params['task_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.xtrf-v1+json;charset=UTF-8'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/tasks/{taskId}/contacts', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ContactsDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_custom_fields(self, body, task_id, **kwargs):  # noqa: E501
        """Updates custom fields of a given task.  # noqa: E501

        Updates custom fields of a given task.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_custom_fields(body, task_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[CustomFieldDTO] body: Updated custom fields (required)
        :param str task_id: task's internal identifier (required)
        :return: CustomFieldsDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_custom_fields_with_http_info(body, task_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_custom_fields_with_http_info(body, task_id, **kwargs)  # noqa: E501
            return data

    def update_custom_fields_with_http_info(self, body, task_id, **kwargs):  # noqa: E501
        """Updates custom fields of a given task.  # noqa: E501

        Updates custom fields of a given task.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_custom_fields_with_http_info(body, task_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[CustomFieldDTO] body: Updated custom fields (required)
        :param str task_id: task's internal identifier (required)
        :return: CustomFieldsDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'task_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_custom_fields" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_custom_fields`")  # noqa: E501
        # verify the required parameter 'task_id' is set
        if ('task_id' not in params or
                params['task_id'] is None):
            raise ValueError("Missing the required parameter `task_id` when calling `update_custom_fields`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'task_id' in params:
            path_params['taskId'] = params['task_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.xtrf-v1+json;charset=UTF-8'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/tasks/{taskId}/customFields', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CustomFieldsDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_dates(self, body, task_id, **kwargs):  # noqa: E501
        """Updates dates of a given task.  # noqa: E501

        Updates dates of a given task.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_dates(body, task_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ProjectDatesDTO body: Updated dates of a given task. (required)
        :param str task_id: task's internal identifier (required)
        :return: ProjectDatesDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_dates_with_http_info(body, task_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_dates_with_http_info(body, task_id, **kwargs)  # noqa: E501
            return data

    def update_dates_with_http_info(self, body, task_id, **kwargs):  # noqa: E501
        """Updates dates of a given task.  # noqa: E501

        Updates dates of a given task.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_dates_with_http_info(body, task_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ProjectDatesDTO body: Updated dates of a given task. (required)
        :param str task_id: task's internal identifier (required)
        :return: ProjectDatesDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'task_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_dates" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_dates`")  # noqa: E501
        # verify the required parameter 'task_id' is set
        if ('task_id' not in params or
                params['task_id'] is None):
            raise ValueError("Missing the required parameter `task_id` when calling `update_dates`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'task_id' in params:
            path_params['taskId'] = params['task_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.xtrf-v1+json;charset=UTF-8'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/tasks/{taskId}/dates', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ProjectDatesDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_instructions(self, body, task_id, **kwargs):  # noqa: E501
        """Updates instructions of a given task.  # noqa: E501

        Updates instructions of a given task.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_instructions(body, task_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param InstructionsDTO body: Updated instructions of a given task. (required)
        :param str task_id: task's internal identifier (required)
        :return: InstructionsDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_instructions_with_http_info(body, task_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_instructions_with_http_info(body, task_id, **kwargs)  # noqa: E501
            return data

    def update_instructions_with_http_info(self, body, task_id, **kwargs):  # noqa: E501
        """Updates instructions of a given task.  # noqa: E501

        Updates instructions of a given task.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_instructions_with_http_info(body, task_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param InstructionsDTO body: Updated instructions of a given task. (required)
        :param str task_id: task's internal identifier (required)
        :return: InstructionsDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'task_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_instructions" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_instructions`")  # noqa: E501
        # verify the required parameter 'task_id' is set
        if ('task_id' not in params or
                params['task_id'] is None):
            raise ValueError("Missing the required parameter `task_id` when calling `update_instructions`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'task_id' in params:
            path_params['taskId'] = params['task_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.xtrf-v1+json;charset=UTF-8'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/tasks/{taskId}/instructions', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InstructionsDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_name(self, body, task_id, **kwargs):  # noqa: E501
        """Updates name of a given task.  # noqa: E501

        Updates name of a given task.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_name(body, task_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param StringDTO body: (required)
        :param str task_id: task's internal identifier (required)
        :return: StringDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_name_with_http_info(body, task_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_name_with_http_info(body, task_id, **kwargs)  # noqa: E501
            return data

    def update_name_with_http_info(self, body, task_id, **kwargs):  # noqa: E501
        """Updates name of a given task.  # noqa: E501

        Updates name of a given task.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_name_with_http_info(body, task_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param StringDTO body: (required)
        :param str task_id: task's internal identifier (required)
        :return: StringDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'task_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_name" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_name`")  # noqa: E501
        # verify the required parameter 'task_id' is set
        if ('task_id' not in params or
                params['task_id'] is None):
            raise ValueError("Missing the required parameter `task_id` when calling `update_name`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'task_id' in params:
            path_params['taskId'] = params['task_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.xtrf-v1+json;charset=UTF-8'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/tasks/{taskId}/name', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='StringDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
