# coding: utf-8

"""
    XTRF Home Portal API

    XTRF Home Portal API enables you to perform operations on Projects, Quotes, Customers, Vendors etc. as a XTRF Home Portal user. <br>The documentation is generated from OpenAPI specification 3.0 available <a href=\"/home-api/openapi.json\">here</a> <br>   The API client/consumer code may be easily generated in 60+ programming languages using an open source code generator available at the time of writing this documentation at <a href='https://editor.swagger.io/'>https://editor.swagger.io/</a> Thank you for using XTRF Application Programming interface (XTRF API). By using the API you agree to the terms below. If you disagree with any of these terms, XTRF does not grant you a license to use the XTRF API. XTRF reserves the right to update and change these terms from time to time without a prior notice of API users. You can always find the most recent version of these terms here:   # noqa: E501

    OpenAPI spec version: 2.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from xtrf_api.api_client import ApiClient


class CurrencyExchangeRatesApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_exchange_rate(self, body, iso_code, **kwargs):  # noqa: E501
        """Adding currency exchange rates.  # noqa: E501

        Adding currency exchange rates via API  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_exchange_rate(body, iso_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CurrencyHistoryDTO body: Adding new currency exchange rates (required)
        :param str iso_code: iso code, https://www.xe.com/iso4217.php (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_exchange_rate_with_http_info(body, iso_code, **kwargs)  # noqa: E501
        else:
            (data) = self.create_exchange_rate_with_http_info(body, iso_code, **kwargs)  # noqa: E501
            return data

    def create_exchange_rate_with_http_info(self, body, iso_code, **kwargs):  # noqa: E501
        """Adding currency exchange rates.  # noqa: E501

        Adding currency exchange rates via API  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_exchange_rate_with_http_info(body, iso_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CurrencyHistoryDTO body: Adding new currency exchange rates (required)
        :param str iso_code: iso code, https://www.xe.com/iso4217.php (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'iso_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_exchange_rate" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_exchange_rate`")  # noqa: E501
        # verify the required parameter 'iso_code' is set
        if ('iso_code' not in params or
                params['iso_code'] is None):
            raise ValueError("Missing the required parameter `iso_code` when calling `create_exchange_rate`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'iso_code' in params:
            path_params['isoCode'] = params['iso_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/dictionaries/currency/{isoCode}/exchangeRate', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_by_iso_code(self, iso_code, **kwargs):  # noqa: E501
        """Returns currency exchange rates.  # noqa: E501

        Returns currency exchange rates.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_by_iso_code(iso_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str iso_code: iso code, https://www.xe.com/iso4217.php (required)
        :return: CurrencyHistoryDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_by_iso_code_with_http_info(iso_code, **kwargs)  # noqa: E501
        else:
            (data) = self.get_by_iso_code_with_http_info(iso_code, **kwargs)  # noqa: E501
            return data

    def get_by_iso_code_with_http_info(self, iso_code, **kwargs):  # noqa: E501
        """Returns currency exchange rates.  # noqa: E501

        Returns currency exchange rates.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_by_iso_code_with_http_info(iso_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str iso_code: iso code, https://www.xe.com/iso4217.php (required)
        :return: CurrencyHistoryDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['iso_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_by_iso_code" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'iso_code' is set
        if ('iso_code' not in params or
                params['iso_code'] is None):
            raise ValueError("Missing the required parameter `iso_code` when calling `get_by_iso_code`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'iso_code' in params:
            path_params['isoCode'] = params['iso_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.xtrf-v1+json;charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/dictionaries/currency/{isoCode}/exchangeRate', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CurrencyHistoryDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
