import { Duration, RemovalPolicy } from 'aws-cdk-lib';
import * as lambda from 'aws-cdk-lib/aws-lambda';
import { Construct } from 'constructs';
/**
 * Properties to initialize an instance of `MicroAppsChildDeployer`.
 */
export interface MicroAppsChildDeployerProps {
    /**
     * ARN of the parent Deployer Lambda Function
     */
    readonly parentDeployerLambdaARN: string;
    /**
     * ARN of the IAM Role for the Edge to Origin Lambda Function
     */
    readonly edgeToOriginRoleARN: string;
    /**
     * RemovalPolicy override for child resources
     *
     * Note: if set to DESTROY the S3 buckes will have `autoDeleteObjects` set to `true`
     *
     * @default - per resource default
     */
    readonly removalPolicy?: RemovalPolicy;
    /**
     * Application environment, passed as `NODE_ENV`
     * to the Router and Deployer Lambda functions
     */
    readonly appEnv: string;
    /**
     * Optional asset name root
     *
     * @example microapps
     * @default - resource names auto assigned
     */
    readonly assetNameRoot?: string;
    /**
     * Optional asset name suffix
     *
     * @example -dev-pr-12
     * @default none
     */
    readonly assetNameSuffix?: string;
    /**
     * Deployer timeout
     *
     * For larger applications this needs to be set up to 2-5 minutes for the S3 copy
     *
     * @default 2 minutes
     */
    readonly deployerTimeout?: Duration;
}
/**
 * Represents a MicroApps Child Deployer
 */
export interface IMicroAppsChildDeployer {
    /**
     * Lambda function for the Deployer
     */
    readonly deployerFunc: lambda.IFunction;
}
/**
 * Create a new MicroApps Child Deployer construct.
 */
export declare class MicroAppsChildDeployer extends Construct implements IMicroAppsChildDeployer {
    private _deployerFunc;
    get deployerFunc(): lambda.IFunction;
    constructor(scope: Construct, id: string, props?: MicroAppsChildDeployerProps);
}
//# sourceMappingURL=MicroAppsChildDeployer.d.ts.map