# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from . import _utilities, _tables
from . import outputs
from ._inputs import *

__all__ = ['OutputsTcpServer']


class OutputsTcpServer(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acl: Optional[pulumi.Input[pulumi.InputType['OutputsTcpServerAclArgs']]] = None,
                 disabled: Optional[pulumi.Input[bool]] = None,
                 method: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 ssl_alt_name_to_check: Optional[pulumi.Input[str]] = None,
                 ssl_cert_path: Optional[pulumi.Input[str]] = None,
                 ssl_cipher: Optional[pulumi.Input[str]] = None,
                 ssl_common_name_to_check: Optional[pulumi.Input[str]] = None,
                 ssl_password: Optional[pulumi.Input[str]] = None,
                 ssl_root_ca_path: Optional[pulumi.Input[str]] = None,
                 ssl_verify_server_cert: Optional[pulumi.Input[bool]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        ## # Resource: OutputsTcpServer

        Access data forwarding configurations.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_splunk as splunk

        tcp_server = splunk.OutputsTcpServer("tcpServer", ssl_alt_name_to_check="old-host")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['OutputsTcpServerAclArgs']] acl: The app/user context that is the namespace for the resource
        :param pulumi.Input[bool] disabled: If true, disables the group.
        :param pulumi.Input[str] method: Valid values: (clone | balance | autobalance)
               The data distribution method used when two or more servers exist in the same forwarder group.
        :param pulumi.Input[str] name: <host>:<port> of the Splunk receiver. <host> can be either an ip address or server name. <port> is the that port that the Splunk receiver is listening on.
        :param pulumi.Input[str] ssl_alt_name_to_check: The alternate name to match in the remote server's SSL certificate.
        :param pulumi.Input[str] ssl_cert_path: Path to the client certificate. If specified, connection uses SSL.
        :param pulumi.Input[str] ssl_cipher: SSL Cipher in the form ALL:!aNULL:!eNULL:!LOW:!EXP:RC4+RSA:+HIGH:+MEDIUM
        :param pulumi.Input[str] ssl_common_name_to_check: Check the common name of the server's certificate against this name.
               If there is no match, assume that Splunk Enterprise is not authenticated against this server. You must specify this setting if sslVerifyServerCert is true.
        :param pulumi.Input[str] ssl_password: The password associated with the CAcert.
               The default Splunk Enterprise CAcert uses the password "password."
        :param pulumi.Input[str] ssl_root_ca_path: The path to the root certificate authority file.
        :param pulumi.Input[bool] ssl_verify_server_cert: If true, make sure that the server you are connecting to is a valid one (authenticated). Both the common name and the alternate name of the server are then checked for a match.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['acl'] = acl
            __props__['disabled'] = disabled
            __props__['method'] = method
            __props__['name'] = name
            __props__['ssl_alt_name_to_check'] = ssl_alt_name_to_check
            __props__['ssl_cert_path'] = ssl_cert_path
            __props__['ssl_cipher'] = ssl_cipher
            __props__['ssl_common_name_to_check'] = ssl_common_name_to_check
            __props__['ssl_password'] = ssl_password
            __props__['ssl_root_ca_path'] = ssl_root_ca_path
            __props__['ssl_verify_server_cert'] = ssl_verify_server_cert
        super(OutputsTcpServer, __self__).__init__(
            'splunk:index/outputsTcpServer:OutputsTcpServer',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            acl: Optional[pulumi.Input[pulumi.InputType['OutputsTcpServerAclArgs']]] = None,
            disabled: Optional[pulumi.Input[bool]] = None,
            method: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            ssl_alt_name_to_check: Optional[pulumi.Input[str]] = None,
            ssl_cert_path: Optional[pulumi.Input[str]] = None,
            ssl_cipher: Optional[pulumi.Input[str]] = None,
            ssl_common_name_to_check: Optional[pulumi.Input[str]] = None,
            ssl_password: Optional[pulumi.Input[str]] = None,
            ssl_root_ca_path: Optional[pulumi.Input[str]] = None,
            ssl_verify_server_cert: Optional[pulumi.Input[bool]] = None) -> 'OutputsTcpServer':
        """
        Get an existing OutputsTcpServer resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['OutputsTcpServerAclArgs']] acl: The app/user context that is the namespace for the resource
        :param pulumi.Input[bool] disabled: If true, disables the group.
        :param pulumi.Input[str] method: Valid values: (clone | balance | autobalance)
               The data distribution method used when two or more servers exist in the same forwarder group.
        :param pulumi.Input[str] name: <host>:<port> of the Splunk receiver. <host> can be either an ip address or server name. <port> is the that port that the Splunk receiver is listening on.
        :param pulumi.Input[str] ssl_alt_name_to_check: The alternate name to match in the remote server's SSL certificate.
        :param pulumi.Input[str] ssl_cert_path: Path to the client certificate. If specified, connection uses SSL.
        :param pulumi.Input[str] ssl_cipher: SSL Cipher in the form ALL:!aNULL:!eNULL:!LOW:!EXP:RC4+RSA:+HIGH:+MEDIUM
        :param pulumi.Input[str] ssl_common_name_to_check: Check the common name of the server's certificate against this name.
               If there is no match, assume that Splunk Enterprise is not authenticated against this server. You must specify this setting if sslVerifyServerCert is true.
        :param pulumi.Input[str] ssl_password: The password associated with the CAcert.
               The default Splunk Enterprise CAcert uses the password "password."
        :param pulumi.Input[str] ssl_root_ca_path: The path to the root certificate authority file.
        :param pulumi.Input[bool] ssl_verify_server_cert: If true, make sure that the server you are connecting to is a valid one (authenticated). Both the common name and the alternate name of the server are then checked for a match.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["acl"] = acl
        __props__["disabled"] = disabled
        __props__["method"] = method
        __props__["name"] = name
        __props__["ssl_alt_name_to_check"] = ssl_alt_name_to_check
        __props__["ssl_cert_path"] = ssl_cert_path
        __props__["ssl_cipher"] = ssl_cipher
        __props__["ssl_common_name_to_check"] = ssl_common_name_to_check
        __props__["ssl_password"] = ssl_password
        __props__["ssl_root_ca_path"] = ssl_root_ca_path
        __props__["ssl_verify_server_cert"] = ssl_verify_server_cert
        return OutputsTcpServer(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def acl(self) -> pulumi.Output['outputs.OutputsTcpServerAcl']:
        """
        The app/user context that is the namespace for the resource
        """
        return pulumi.get(self, "acl")

    @property
    @pulumi.getter
    def disabled(self) -> pulumi.Output[bool]:
        """
        If true, disables the group.
        """
        return pulumi.get(self, "disabled")

    @property
    @pulumi.getter
    def method(self) -> pulumi.Output[str]:
        """
        Valid values: (clone | balance | autobalance)
        The data distribution method used when two or more servers exist in the same forwarder group.
        """
        return pulumi.get(self, "method")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        <host>:<port> of the Splunk receiver. <host> can be either an ip address or server name. <port> is the that port that the Splunk receiver is listening on.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="sslAltNameToCheck")
    def ssl_alt_name_to_check(self) -> pulumi.Output[str]:
        """
        The alternate name to match in the remote server's SSL certificate.
        """
        return pulumi.get(self, "ssl_alt_name_to_check")

    @property
    @pulumi.getter(name="sslCertPath")
    def ssl_cert_path(self) -> pulumi.Output[str]:
        """
        Path to the client certificate. If specified, connection uses SSL.
        """
        return pulumi.get(self, "ssl_cert_path")

    @property
    @pulumi.getter(name="sslCipher")
    def ssl_cipher(self) -> pulumi.Output[str]:
        """
        SSL Cipher in the form ALL:!aNULL:!eNULL:!LOW:!EXP:RC4+RSA:+HIGH:+MEDIUM
        """
        return pulumi.get(self, "ssl_cipher")

    @property
    @pulumi.getter(name="sslCommonNameToCheck")
    def ssl_common_name_to_check(self) -> pulumi.Output[str]:
        """
        Check the common name of the server's certificate against this name.
        If there is no match, assume that Splunk Enterprise is not authenticated against this server. You must specify this setting if sslVerifyServerCert is true.
        """
        return pulumi.get(self, "ssl_common_name_to_check")

    @property
    @pulumi.getter(name="sslPassword")
    def ssl_password(self) -> pulumi.Output[str]:
        """
        The password associated with the CAcert.
        The default Splunk Enterprise CAcert uses the password "password."
        """
        return pulumi.get(self, "ssl_password")

    @property
    @pulumi.getter(name="sslRootCaPath")
    def ssl_root_ca_path(self) -> pulumi.Output[str]:
        """
        The path to the root certificate authority file.
        """
        return pulumi.get(self, "ssl_root_ca_path")

    @property
    @pulumi.getter(name="sslVerifyServerCert")
    def ssl_verify_server_cert(self) -> pulumi.Output[bool]:
        """
        If true, make sure that the server you are connecting to is a valid one (authenticated). Both the common name and the alternate name of the server are then checked for a match.
        """
        return pulumi.get(self, "ssl_verify_server_cert")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

