# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from . import _utilities, _tables
from . import outputs
from ._inputs import *

__all__ = ['OutputsTcpDefault']


class OutputsTcpDefault(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acl: Optional[pulumi.Input[pulumi.InputType['OutputsTcpDefaultAclArgs']]] = None,
                 default_group: Optional[pulumi.Input[str]] = None,
                 disabled: Optional[pulumi.Input[bool]] = None,
                 drop_events_on_queue_full: Optional[pulumi.Input[int]] = None,
                 heartbeat_frequency: Optional[pulumi.Input[int]] = None,
                 index_and_forward: Optional[pulumi.Input[bool]] = None,
                 max_queue_size: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 send_cooked_data: Optional[pulumi.Input[bool]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        ## # Resource: OutputsTcpDefault

        Manage to global tcpout properties.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_splunk as splunk

        tcp_default = splunk.OutputsTcpDefault("tcpDefault",
            default_group="test-indexers",
            disabled=False,
            drop_events_on_queue_full=60,
            index_and_forward=True,
            max_queue_size="100KB",
            send_cooked_data=True)
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['OutputsTcpDefaultAclArgs']] acl: The app/user context that is the namespace for the resource
        :param pulumi.Input[str] default_group: Comma-separated list of one or more target group names, specified later in [tcpout:<target_group>] stanzas of outputs.conf.spec file.
               The forwarder sends all data to the specified groups. If you do not want to forward data automatically, do not set this attribute. Can be overridden by an inputs.conf _TCP_ROUTING setting, which in turn can be overridden by a props.conf/transforms.conf modifier.
        :param pulumi.Input[bool] disabled: Disables default tcpout settings
        :param pulumi.Input[int] drop_events_on_queue_full: If set to a positive number, wait the specified number of seconds before throwing out all new events until the output queue has space. Defaults to -1 (do not drop events).
               <br>CAUTION: Do not set this value to a positive integer if you are monitoring files.
               Setting this to -1 or 0 causes the output queue to block when it gets full, which causes further blocking up the processing chain. If any target group queue is blocked, no more data reaches any other target group.
               Using auto load-balancing is the best way to minimize this condition, because, in that case, multiple receivers must be down (or jammed up) before queue blocking can occur.
        :param pulumi.Input[int] heartbeat_frequency: How often (in seconds) to send a heartbeat packet to the receiving server.
               Heartbeats are only sent if sendCookedData=true. Defaults to 30 seconds.
        :param pulumi.Input[bool] index_and_forward: Specifies whether to index all data locally, in addition to forwarding it. Defaults to false.
               This is known as an "index-and-forward" configuration. This attribute is only available for heavy forwarders. It is available only at the top level [tcpout] stanza in outputs.conf. It cannot be overridden in a target group.
        :param pulumi.Input[str] max_queue_size: Specify an integer or integer[KB|MB|GB].
               <br>Sets the maximum size of the forwarder output queue. It also sets the maximum size of the wait queue to 3x this value, if you have enabled indexer acknowledgment (useACK=true).
               Although the wait queue and the output queues are both configured by this attribute, they are separate queues. The setting determines the maximum size of the queue in-memory (RAM) buffer.
               For heavy forwarders sending parsed data, maxQueueSize is the maximum number of events. Since events are typically much shorter than data blocks, the memory consumed by the queue on a parsing forwarder is likely to be much smaller than on a non-parsing forwarder, if you use this version of the setting.
               If specified as a lone integer (for example, maxQueueSize=100), maxQueueSize indicates the maximum number of queued events (for parsed data) or blocks of data (for unparsed data). A block of data is approximately 64KB. For non-parsing forwarders, such as universal forwarders, that send unparsed data, maxQueueSize is the maximum number of data blocks.
               If specified as an integer followed by KB, MB, or GB (for example, maxQueueSize=100MB), maxQueueSize indicates the maximum RAM allocated to the queue buffer. Defaults to 500KB (which means a maximum size of 500KB for the output queue and 1500KB for the wait queue, if any).
        :param pulumi.Input[str] name: Configuration to be edited. The only valid value is "tcpout".
        :param pulumi.Input[bool] send_cooked_data: If true, events are cooked (processed by Splunk software). If false, events are raw and untouched prior to sending. Defaults to true.
               Set to false if you are sending to a third-party system.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['acl'] = acl
            __props__['default_group'] = default_group
            __props__['disabled'] = disabled
            __props__['drop_events_on_queue_full'] = drop_events_on_queue_full
            __props__['heartbeat_frequency'] = heartbeat_frequency
            __props__['index_and_forward'] = index_and_forward
            __props__['max_queue_size'] = max_queue_size
            __props__['name'] = name
            __props__['send_cooked_data'] = send_cooked_data
        super(OutputsTcpDefault, __self__).__init__(
            'splunk:index/outputsTcpDefault:OutputsTcpDefault',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            acl: Optional[pulumi.Input[pulumi.InputType['OutputsTcpDefaultAclArgs']]] = None,
            default_group: Optional[pulumi.Input[str]] = None,
            disabled: Optional[pulumi.Input[bool]] = None,
            drop_events_on_queue_full: Optional[pulumi.Input[int]] = None,
            heartbeat_frequency: Optional[pulumi.Input[int]] = None,
            index_and_forward: Optional[pulumi.Input[bool]] = None,
            max_queue_size: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            send_cooked_data: Optional[pulumi.Input[bool]] = None) -> 'OutputsTcpDefault':
        """
        Get an existing OutputsTcpDefault resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['OutputsTcpDefaultAclArgs']] acl: The app/user context that is the namespace for the resource
        :param pulumi.Input[str] default_group: Comma-separated list of one or more target group names, specified later in [tcpout:<target_group>] stanzas of outputs.conf.spec file.
               The forwarder sends all data to the specified groups. If you do not want to forward data automatically, do not set this attribute. Can be overridden by an inputs.conf _TCP_ROUTING setting, which in turn can be overridden by a props.conf/transforms.conf modifier.
        :param pulumi.Input[bool] disabled: Disables default tcpout settings
        :param pulumi.Input[int] drop_events_on_queue_full: If set to a positive number, wait the specified number of seconds before throwing out all new events until the output queue has space. Defaults to -1 (do not drop events).
               <br>CAUTION: Do not set this value to a positive integer if you are monitoring files.
               Setting this to -1 or 0 causes the output queue to block when it gets full, which causes further blocking up the processing chain. If any target group queue is blocked, no more data reaches any other target group.
               Using auto load-balancing is the best way to minimize this condition, because, in that case, multiple receivers must be down (or jammed up) before queue blocking can occur.
        :param pulumi.Input[int] heartbeat_frequency: How often (in seconds) to send a heartbeat packet to the receiving server.
               Heartbeats are only sent if sendCookedData=true. Defaults to 30 seconds.
        :param pulumi.Input[bool] index_and_forward: Specifies whether to index all data locally, in addition to forwarding it. Defaults to false.
               This is known as an "index-and-forward" configuration. This attribute is only available for heavy forwarders. It is available only at the top level [tcpout] stanza in outputs.conf. It cannot be overridden in a target group.
        :param pulumi.Input[str] max_queue_size: Specify an integer or integer[KB|MB|GB].
               <br>Sets the maximum size of the forwarder output queue. It also sets the maximum size of the wait queue to 3x this value, if you have enabled indexer acknowledgment (useACK=true).
               Although the wait queue and the output queues are both configured by this attribute, they are separate queues. The setting determines the maximum size of the queue in-memory (RAM) buffer.
               For heavy forwarders sending parsed data, maxQueueSize is the maximum number of events. Since events are typically much shorter than data blocks, the memory consumed by the queue on a parsing forwarder is likely to be much smaller than on a non-parsing forwarder, if you use this version of the setting.
               If specified as a lone integer (for example, maxQueueSize=100), maxQueueSize indicates the maximum number of queued events (for parsed data) or blocks of data (for unparsed data). A block of data is approximately 64KB. For non-parsing forwarders, such as universal forwarders, that send unparsed data, maxQueueSize is the maximum number of data blocks.
               If specified as an integer followed by KB, MB, or GB (for example, maxQueueSize=100MB), maxQueueSize indicates the maximum RAM allocated to the queue buffer. Defaults to 500KB (which means a maximum size of 500KB for the output queue and 1500KB for the wait queue, if any).
        :param pulumi.Input[str] name: Configuration to be edited. The only valid value is "tcpout".
        :param pulumi.Input[bool] send_cooked_data: If true, events are cooked (processed by Splunk software). If false, events are raw and untouched prior to sending. Defaults to true.
               Set to false if you are sending to a third-party system.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["acl"] = acl
        __props__["default_group"] = default_group
        __props__["disabled"] = disabled
        __props__["drop_events_on_queue_full"] = drop_events_on_queue_full
        __props__["heartbeat_frequency"] = heartbeat_frequency
        __props__["index_and_forward"] = index_and_forward
        __props__["max_queue_size"] = max_queue_size
        __props__["name"] = name
        __props__["send_cooked_data"] = send_cooked_data
        return OutputsTcpDefault(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def acl(self) -> pulumi.Output['outputs.OutputsTcpDefaultAcl']:
        """
        The app/user context that is the namespace for the resource
        """
        return pulumi.get(self, "acl")

    @property
    @pulumi.getter(name="defaultGroup")
    def default_group(self) -> pulumi.Output[str]:
        """
        Comma-separated list of one or more target group names, specified later in [tcpout:<target_group>] stanzas of outputs.conf.spec file.
        The forwarder sends all data to the specified groups. If you do not want to forward data automatically, do not set this attribute. Can be overridden by an inputs.conf _TCP_ROUTING setting, which in turn can be overridden by a props.conf/transforms.conf modifier.
        """
        return pulumi.get(self, "default_group")

    @property
    @pulumi.getter
    def disabled(self) -> pulumi.Output[bool]:
        """
        Disables default tcpout settings
        """
        return pulumi.get(self, "disabled")

    @property
    @pulumi.getter(name="dropEventsOnQueueFull")
    def drop_events_on_queue_full(self) -> pulumi.Output[int]:
        """
        If set to a positive number, wait the specified number of seconds before throwing out all new events until the output queue has space. Defaults to -1 (do not drop events).
        <br>CAUTION: Do not set this value to a positive integer if you are monitoring files.
        Setting this to -1 or 0 causes the output queue to block when it gets full, which causes further blocking up the processing chain. If any target group queue is blocked, no more data reaches any other target group.
        Using auto load-balancing is the best way to minimize this condition, because, in that case, multiple receivers must be down (or jammed up) before queue blocking can occur.
        """
        return pulumi.get(self, "drop_events_on_queue_full")

    @property
    @pulumi.getter(name="heartbeatFrequency")
    def heartbeat_frequency(self) -> pulumi.Output[int]:
        """
        How often (in seconds) to send a heartbeat packet to the receiving server.
        Heartbeats are only sent if sendCookedData=true. Defaults to 30 seconds.
        """
        return pulumi.get(self, "heartbeat_frequency")

    @property
    @pulumi.getter(name="indexAndForward")
    def index_and_forward(self) -> pulumi.Output[bool]:
        """
        Specifies whether to index all data locally, in addition to forwarding it. Defaults to false.
        This is known as an "index-and-forward" configuration. This attribute is only available for heavy forwarders. It is available only at the top level [tcpout] stanza in outputs.conf. It cannot be overridden in a target group.
        """
        return pulumi.get(self, "index_and_forward")

    @property
    @pulumi.getter(name="maxQueueSize")
    def max_queue_size(self) -> pulumi.Output[str]:
        """
        Specify an integer or integer[KB|MB|GB].
        <br>Sets the maximum size of the forwarder output queue. It also sets the maximum size of the wait queue to 3x this value, if you have enabled indexer acknowledgment (useACK=true).
        Although the wait queue and the output queues are both configured by this attribute, they are separate queues. The setting determines the maximum size of the queue in-memory (RAM) buffer.
        For heavy forwarders sending parsed data, maxQueueSize is the maximum number of events. Since events are typically much shorter than data blocks, the memory consumed by the queue on a parsing forwarder is likely to be much smaller than on a non-parsing forwarder, if you use this version of the setting.
        If specified as a lone integer (for example, maxQueueSize=100), maxQueueSize indicates the maximum number of queued events (for parsed data) or blocks of data (for unparsed data). A block of data is approximately 64KB. For non-parsing forwarders, such as universal forwarders, that send unparsed data, maxQueueSize is the maximum number of data blocks.
        If specified as an integer followed by KB, MB, or GB (for example, maxQueueSize=100MB), maxQueueSize indicates the maximum RAM allocated to the queue buffer. Defaults to 500KB (which means a maximum size of 500KB for the output queue and 1500KB for the wait queue, if any).
        """
        return pulumi.get(self, "max_queue_size")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Configuration to be edited. The only valid value is "tcpout".
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="sendCookedData")
    def send_cooked_data(self) -> pulumi.Output[bool]:
        """
        If true, events are cooked (processed by Splunk software). If false, events are raw and untouched prior to sending. Defaults to true.
        Set to false if you are sending to a third-party system.
        """
        return pulumi.get(self, "send_cooked_data")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

