# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from . import _utilities, _tables
from . import outputs
from ._inputs import *

__all__ = ['InputsTcpCooked']


class InputsTcpCooked(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acl: Optional[pulumi.Input[pulumi.InputType['InputsTcpCookedAclArgs']]] = None,
                 connection_host: Optional[pulumi.Input[str]] = None,
                 disabled: Optional[pulumi.Input[bool]] = None,
                 host: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 restrict_to_host: Optional[pulumi.Input[str]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        ## # Resource: InputsTcpCooked

        Create or update cooked TCP input information and create new containers for managing cooked data.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_splunk as splunk

        tcp_cooked = splunk.InputsTcpCooked("tcpCooked",
            connection_host="dns",
            disabled=False,
            restrict_to_host="splunk")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['InputsTcpCookedAclArgs']] acl: The app/user context that is the namespace for the resource
        :param pulumi.Input[str] connection_host: Valid values: (ip | dns | none)
               Set the host for the remote server that is sending data.
               ip sets the host to the IP address of the remote server sending data.
               dns sets the host to the reverse DNS entry for the IP address of the remote server sending data.
               none leaves the host as specified in inputs.conf, which is typically the Splunk system hostname.
               Default value is dns.
        :param pulumi.Input[bool] disabled: Indicates if input is disabled.
        :param pulumi.Input[str] host: Host from which the indexer gets data.
        :param pulumi.Input[str] name: The port number of this input.
        :param pulumi.Input[str] restrict_to_host: Restrict incoming connections on this port to the host specified here.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['acl'] = acl
            __props__['connection_host'] = connection_host
            __props__['disabled'] = disabled
            __props__['host'] = host
            __props__['name'] = name
            __props__['restrict_to_host'] = restrict_to_host
        super(InputsTcpCooked, __self__).__init__(
            'splunk:index/inputsTcpCooked:InputsTcpCooked',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            acl: Optional[pulumi.Input[pulumi.InputType['InputsTcpCookedAclArgs']]] = None,
            connection_host: Optional[pulumi.Input[str]] = None,
            disabled: Optional[pulumi.Input[bool]] = None,
            host: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            restrict_to_host: Optional[pulumi.Input[str]] = None) -> 'InputsTcpCooked':
        """
        Get an existing InputsTcpCooked resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['InputsTcpCookedAclArgs']] acl: The app/user context that is the namespace for the resource
        :param pulumi.Input[str] connection_host: Valid values: (ip | dns | none)
               Set the host for the remote server that is sending data.
               ip sets the host to the IP address of the remote server sending data.
               dns sets the host to the reverse DNS entry for the IP address of the remote server sending data.
               none leaves the host as specified in inputs.conf, which is typically the Splunk system hostname.
               Default value is dns.
        :param pulumi.Input[bool] disabled: Indicates if input is disabled.
        :param pulumi.Input[str] host: Host from which the indexer gets data.
        :param pulumi.Input[str] name: The port number of this input.
        :param pulumi.Input[str] restrict_to_host: Restrict incoming connections on this port to the host specified here.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["acl"] = acl
        __props__["connection_host"] = connection_host
        __props__["disabled"] = disabled
        __props__["host"] = host
        __props__["name"] = name
        __props__["restrict_to_host"] = restrict_to_host
        return InputsTcpCooked(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def acl(self) -> pulumi.Output['outputs.InputsTcpCookedAcl']:
        """
        The app/user context that is the namespace for the resource
        """
        return pulumi.get(self, "acl")

    @property
    @pulumi.getter(name="connectionHost")
    def connection_host(self) -> pulumi.Output[str]:
        """
        Valid values: (ip | dns | none)
        Set the host for the remote server that is sending data.
        ip sets the host to the IP address of the remote server sending data.
        dns sets the host to the reverse DNS entry for the IP address of the remote server sending data.
        none leaves the host as specified in inputs.conf, which is typically the Splunk system hostname.
        Default value is dns.
        """
        return pulumi.get(self, "connection_host")

    @property
    @pulumi.getter
    def disabled(self) -> pulumi.Output[bool]:
        """
        Indicates if input is disabled.
        """
        return pulumi.get(self, "disabled")

    @property
    @pulumi.getter
    def host(self) -> pulumi.Output[str]:
        """
        Host from which the indexer gets data.
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The port number of this input.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="restrictToHost")
    def restrict_to_host(self) -> pulumi.Output[str]:
        """
        Restrict incoming connections on this port to the host specified here.
        """
        return pulumi.get(self, "restrict_to_host")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

