# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from . import _utilities, _tables
from . import outputs
from ._inputs import *

__all__ = ['InputsMonitor']


class InputsMonitor(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acl: Optional[pulumi.Input[pulumi.InputType['InputsMonitorAclArgs']]] = None,
                 blacklist: Optional[pulumi.Input[str]] = None,
                 crc_salt: Optional[pulumi.Input[str]] = None,
                 disabled: Optional[pulumi.Input[bool]] = None,
                 follow_tail: Optional[pulumi.Input[bool]] = None,
                 host: Optional[pulumi.Input[str]] = None,
                 host_regex: Optional[pulumi.Input[str]] = None,
                 host_segment: Optional[pulumi.Input[int]] = None,
                 ignore_older_than: Optional[pulumi.Input[str]] = None,
                 index: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 recursive: Optional[pulumi.Input[bool]] = None,
                 rename_source: Optional[pulumi.Input[str]] = None,
                 sourcetype: Optional[pulumi.Input[str]] = None,
                 time_before_close: Optional[pulumi.Input[int]] = None,
                 whitelist: Optional[pulumi.Input[str]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        ## # Resource: InputsMonitor

        Create or update a new file or directory monitor input.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_splunk as splunk

        monitor = splunk.InputsMonitor("monitor",
            recursive=True,
            sourcetype="text")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['InputsMonitorAclArgs']] acl: The app/user context that is the namespace for the resource
        :param pulumi.Input[str] blacklist: Specify a regular expression for a file path. The file path that matches this regular expression is not indexed.
        :param pulumi.Input[str] crc_salt: A string that modifies the file tracking identity for files in this input. The magic value <SOURCE> invokes special behavior.
        :param pulumi.Input[bool] disabled: Indicates if input monitoring is disabled.
        :param pulumi.Input[bool] follow_tail: If set to true, files that are seen for the first time is read from the end.
        :param pulumi.Input[str] host: The value to populate in the host field for events from this data input.
        :param pulumi.Input[str] host_regex: Specify a regular expression for a file path. If the path for a file matches this regular expression, the captured value is used to populate the host field for events from this data input. The regular expression must have one capture group.
        :param pulumi.Input[int] host_segment: Use the specified slash-separate segment of the filepath as the host field value.
        :param pulumi.Input[str] ignore_older_than: Specify a time value. If the modification time of a file being monitored falls outside of this rolling time window, the file is no longer being monitored.
        :param pulumi.Input[str] index: Which index events from this input should be stored in. Defaults to default.
        :param pulumi.Input[str] name: The file or directory path to monitor on the system.
        :param pulumi.Input[bool] recursive: Setting this to false prevents monitoring of any subdirectories encountered within this data input.
        :param pulumi.Input[str] rename_source: The value to populate in the source field for events from this data input. The same source should not be used for multiple data inputs.
        :param pulumi.Input[str] sourcetype: The value to populate in the sourcetype field for incoming events.
        :param pulumi.Input[int] time_before_close: When Splunk software reaches the end of a file that is being read, the file is kept open for a minimum of the number of seconds specified in this value. After this period has elapsed, the file is checked again for more data.
        :param pulumi.Input[str] whitelist: Specify a regular expression for a file path. Only file paths that match this regular expression are indexed.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['acl'] = acl
            __props__['blacklist'] = blacklist
            __props__['crc_salt'] = crc_salt
            __props__['disabled'] = disabled
            __props__['follow_tail'] = follow_tail
            __props__['host'] = host
            __props__['host_regex'] = host_regex
            __props__['host_segment'] = host_segment
            __props__['ignore_older_than'] = ignore_older_than
            __props__['index'] = index
            __props__['name'] = name
            __props__['recursive'] = recursive
            __props__['rename_source'] = rename_source
            __props__['sourcetype'] = sourcetype
            __props__['time_before_close'] = time_before_close
            __props__['whitelist'] = whitelist
        super(InputsMonitor, __self__).__init__(
            'splunk:index/inputsMonitor:InputsMonitor',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            acl: Optional[pulumi.Input[pulumi.InputType['InputsMonitorAclArgs']]] = None,
            blacklist: Optional[pulumi.Input[str]] = None,
            crc_salt: Optional[pulumi.Input[str]] = None,
            disabled: Optional[pulumi.Input[bool]] = None,
            follow_tail: Optional[pulumi.Input[bool]] = None,
            host: Optional[pulumi.Input[str]] = None,
            host_regex: Optional[pulumi.Input[str]] = None,
            host_segment: Optional[pulumi.Input[int]] = None,
            ignore_older_than: Optional[pulumi.Input[str]] = None,
            index: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            recursive: Optional[pulumi.Input[bool]] = None,
            rename_source: Optional[pulumi.Input[str]] = None,
            sourcetype: Optional[pulumi.Input[str]] = None,
            time_before_close: Optional[pulumi.Input[int]] = None,
            whitelist: Optional[pulumi.Input[str]] = None) -> 'InputsMonitor':
        """
        Get an existing InputsMonitor resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['InputsMonitorAclArgs']] acl: The app/user context that is the namespace for the resource
        :param pulumi.Input[str] blacklist: Specify a regular expression for a file path. The file path that matches this regular expression is not indexed.
        :param pulumi.Input[str] crc_salt: A string that modifies the file tracking identity for files in this input. The magic value <SOURCE> invokes special behavior.
        :param pulumi.Input[bool] disabled: Indicates if input monitoring is disabled.
        :param pulumi.Input[bool] follow_tail: If set to true, files that are seen for the first time is read from the end.
        :param pulumi.Input[str] host: The value to populate in the host field for events from this data input.
        :param pulumi.Input[str] host_regex: Specify a regular expression for a file path. If the path for a file matches this regular expression, the captured value is used to populate the host field for events from this data input. The regular expression must have one capture group.
        :param pulumi.Input[int] host_segment: Use the specified slash-separate segment of the filepath as the host field value.
        :param pulumi.Input[str] ignore_older_than: Specify a time value. If the modification time of a file being monitored falls outside of this rolling time window, the file is no longer being monitored.
        :param pulumi.Input[str] index: Which index events from this input should be stored in. Defaults to default.
        :param pulumi.Input[str] name: The file or directory path to monitor on the system.
        :param pulumi.Input[bool] recursive: Setting this to false prevents monitoring of any subdirectories encountered within this data input.
        :param pulumi.Input[str] rename_source: The value to populate in the source field for events from this data input. The same source should not be used for multiple data inputs.
        :param pulumi.Input[str] sourcetype: The value to populate in the sourcetype field for incoming events.
        :param pulumi.Input[int] time_before_close: When Splunk software reaches the end of a file that is being read, the file is kept open for a minimum of the number of seconds specified in this value. After this period has elapsed, the file is checked again for more data.
        :param pulumi.Input[str] whitelist: Specify a regular expression for a file path. Only file paths that match this regular expression are indexed.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["acl"] = acl
        __props__["blacklist"] = blacklist
        __props__["crc_salt"] = crc_salt
        __props__["disabled"] = disabled
        __props__["follow_tail"] = follow_tail
        __props__["host"] = host
        __props__["host_regex"] = host_regex
        __props__["host_segment"] = host_segment
        __props__["ignore_older_than"] = ignore_older_than
        __props__["index"] = index
        __props__["name"] = name
        __props__["recursive"] = recursive
        __props__["rename_source"] = rename_source
        __props__["sourcetype"] = sourcetype
        __props__["time_before_close"] = time_before_close
        __props__["whitelist"] = whitelist
        return InputsMonitor(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def acl(self) -> pulumi.Output['outputs.InputsMonitorAcl']:
        """
        The app/user context that is the namespace for the resource
        """
        return pulumi.get(self, "acl")

    @property
    @pulumi.getter
    def blacklist(self) -> pulumi.Output[str]:
        """
        Specify a regular expression for a file path. The file path that matches this regular expression is not indexed.
        """
        return pulumi.get(self, "blacklist")

    @property
    @pulumi.getter(name="crcSalt")
    def crc_salt(self) -> pulumi.Output[str]:
        """
        A string that modifies the file tracking identity for files in this input. The magic value <SOURCE> invokes special behavior.
        """
        return pulumi.get(self, "crc_salt")

    @property
    @pulumi.getter
    def disabled(self) -> pulumi.Output[bool]:
        """
        Indicates if input monitoring is disabled.
        """
        return pulumi.get(self, "disabled")

    @property
    @pulumi.getter(name="followTail")
    def follow_tail(self) -> pulumi.Output[bool]:
        """
        If set to true, files that are seen for the first time is read from the end.
        """
        return pulumi.get(self, "follow_tail")

    @property
    @pulumi.getter
    def host(self) -> pulumi.Output[str]:
        """
        The value to populate in the host field for events from this data input.
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter(name="hostRegex")
    def host_regex(self) -> pulumi.Output[str]:
        """
        Specify a regular expression for a file path. If the path for a file matches this regular expression, the captured value is used to populate the host field for events from this data input. The regular expression must have one capture group.
        """
        return pulumi.get(self, "host_regex")

    @property
    @pulumi.getter(name="hostSegment")
    def host_segment(self) -> pulumi.Output[int]:
        """
        Use the specified slash-separate segment of the filepath as the host field value.
        """
        return pulumi.get(self, "host_segment")

    @property
    @pulumi.getter(name="ignoreOlderThan")
    def ignore_older_than(self) -> pulumi.Output[str]:
        """
        Specify a time value. If the modification time of a file being monitored falls outside of this rolling time window, the file is no longer being monitored.
        """
        return pulumi.get(self, "ignore_older_than")

    @property
    @pulumi.getter
    def index(self) -> pulumi.Output[str]:
        """
        Which index events from this input should be stored in. Defaults to default.
        """
        return pulumi.get(self, "index")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The file or directory path to monitor on the system.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def recursive(self) -> pulumi.Output[bool]:
        """
        Setting this to false prevents monitoring of any subdirectories encountered within this data input.
        """
        return pulumi.get(self, "recursive")

    @property
    @pulumi.getter(name="renameSource")
    def rename_source(self) -> pulumi.Output[str]:
        """
        The value to populate in the source field for events from this data input. The same source should not be used for multiple data inputs.
        """
        return pulumi.get(self, "rename_source")

    @property
    @pulumi.getter
    def sourcetype(self) -> pulumi.Output[str]:
        """
        The value to populate in the sourcetype field for incoming events.
        """
        return pulumi.get(self, "sourcetype")

    @property
    @pulumi.getter(name="timeBeforeClose")
    def time_before_close(self) -> pulumi.Output[int]:
        """
        When Splunk software reaches the end of a file that is being read, the file is kept open for a minimum of the number of seconds specified in this value. After this period has elapsed, the file is checked again for more data.
        """
        return pulumi.get(self, "time_before_close")

    @property
    @pulumi.getter
    def whitelist(self) -> pulumi.Output[str]:
        """
        Specify a regular expression for a file path. Only file paths that match this regular expression are indexed.
        """
        return pulumi.get(self, "whitelist")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

