# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from . import _utilities, _tables

__all__ = ['GlobalHttpEventCollector']


class GlobalHttpEventCollector(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dedicated_io_threads: Optional[pulumi.Input[int]] = None,
                 disabled: Optional[pulumi.Input[bool]] = None,
                 enable_ssl: Optional[pulumi.Input[bool]] = None,
                 max_sockets: Optional[pulumi.Input[int]] = None,
                 max_threads: Optional[pulumi.Input[int]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 use_deployment_server: Optional[pulumi.Input[int]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        ## # Resource: GlobalHttpEventCollector

        Update Global HTTP Event Collector input configuration.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_splunk as splunk

        http = splunk.GlobalHttpEventCollector("http",
            disabled=False,
            enable_ssl=True,
            port=8088)
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] dedicated_io_threads: Number of threads used by HTTP Input server.
        :param pulumi.Input[bool] disabled: Input disabled indicator.
        :param pulumi.Input[bool] enable_ssl: Enable SSL protocol for HTTP data input. `true` = SSL enabled, `false` = SSL disabled.
        :param pulumi.Input[int] max_sockets: Maximum number of simultaneous HTTP connections accepted. Adjusting this value may cause server performance issues and is not generally recommended. Possible values for this setting vary by OS.
        :param pulumi.Input[int] max_threads: Maximum number of threads that can be used by active HTTP transactions. Adjusting this value may cause server performance issues and is not generally recommended. Possible values for this setting vary by OS.
        :param pulumi.Input[int] port: HTTP data input IP port.
        :param pulumi.Input[int] use_deployment_server: Indicates whether the event collector input writes its configuration to a deployment server repository. When this setting is set to 1 (enabled), the input writes its configuration to the directory specified as repositoryLocation in serverclass.conf.
               Copy the full contents of the splunk_httpinput app directory to this directory for the configuration to work. When enabled, only the tokens defined in the splunk_httpinput app in this repository are viewable and editable on the API and the Data Inputs page in Splunk Web. When disabled, the input writes its configuration to $SPLUNK_HOME/etc/apps by default. Defaults to 0 (disabled).
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['dedicated_io_threads'] = dedicated_io_threads
            __props__['disabled'] = disabled
            __props__['enable_ssl'] = enable_ssl
            __props__['max_sockets'] = max_sockets
            __props__['max_threads'] = max_threads
            __props__['port'] = port
            __props__['use_deployment_server'] = use_deployment_server
        super(GlobalHttpEventCollector, __self__).__init__(
            'splunk:index/globalHttpEventCollector:GlobalHttpEventCollector',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            dedicated_io_threads: Optional[pulumi.Input[int]] = None,
            disabled: Optional[pulumi.Input[bool]] = None,
            enable_ssl: Optional[pulumi.Input[bool]] = None,
            max_sockets: Optional[pulumi.Input[int]] = None,
            max_threads: Optional[pulumi.Input[int]] = None,
            port: Optional[pulumi.Input[int]] = None,
            use_deployment_server: Optional[pulumi.Input[int]] = None) -> 'GlobalHttpEventCollector':
        """
        Get an existing GlobalHttpEventCollector resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] dedicated_io_threads: Number of threads used by HTTP Input server.
        :param pulumi.Input[bool] disabled: Input disabled indicator.
        :param pulumi.Input[bool] enable_ssl: Enable SSL protocol for HTTP data input. `true` = SSL enabled, `false` = SSL disabled.
        :param pulumi.Input[int] max_sockets: Maximum number of simultaneous HTTP connections accepted. Adjusting this value may cause server performance issues and is not generally recommended. Possible values for this setting vary by OS.
        :param pulumi.Input[int] max_threads: Maximum number of threads that can be used by active HTTP transactions. Adjusting this value may cause server performance issues and is not generally recommended. Possible values for this setting vary by OS.
        :param pulumi.Input[int] port: HTTP data input IP port.
        :param pulumi.Input[int] use_deployment_server: Indicates whether the event collector input writes its configuration to a deployment server repository. When this setting is set to 1 (enabled), the input writes its configuration to the directory specified as repositoryLocation in serverclass.conf.
               Copy the full contents of the splunk_httpinput app directory to this directory for the configuration to work. When enabled, only the tokens defined in the splunk_httpinput app in this repository are viewable and editable on the API and the Data Inputs page in Splunk Web. When disabled, the input writes its configuration to $SPLUNK_HOME/etc/apps by default. Defaults to 0 (disabled).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["dedicated_io_threads"] = dedicated_io_threads
        __props__["disabled"] = disabled
        __props__["enable_ssl"] = enable_ssl
        __props__["max_sockets"] = max_sockets
        __props__["max_threads"] = max_threads
        __props__["port"] = port
        __props__["use_deployment_server"] = use_deployment_server
        return GlobalHttpEventCollector(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="dedicatedIoThreads")
    def dedicated_io_threads(self) -> pulumi.Output[int]:
        """
        Number of threads used by HTTP Input server.
        """
        return pulumi.get(self, "dedicated_io_threads")

    @property
    @pulumi.getter
    def disabled(self) -> pulumi.Output[bool]:
        """
        Input disabled indicator.
        """
        return pulumi.get(self, "disabled")

    @property
    @pulumi.getter(name="enableSsl")
    def enable_ssl(self) -> pulumi.Output[bool]:
        """
        Enable SSL protocol for HTTP data input. `true` = SSL enabled, `false` = SSL disabled.
        """
        return pulumi.get(self, "enable_ssl")

    @property
    @pulumi.getter(name="maxSockets")
    def max_sockets(self) -> pulumi.Output[int]:
        """
        Maximum number of simultaneous HTTP connections accepted. Adjusting this value may cause server performance issues and is not generally recommended. Possible values for this setting vary by OS.
        """
        return pulumi.get(self, "max_sockets")

    @property
    @pulumi.getter(name="maxThreads")
    def max_threads(self) -> pulumi.Output[int]:
        """
        Maximum number of threads that can be used by active HTTP transactions. Adjusting this value may cause server performance issues and is not generally recommended. Possible values for this setting vary by OS.
        """
        return pulumi.get(self, "max_threads")

    @property
    @pulumi.getter
    def port(self) -> pulumi.Output[int]:
        """
        HTTP data input IP port.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="useDeploymentServer")
    def use_deployment_server(self) -> pulumi.Output[int]:
        """
        Indicates whether the event collector input writes its configuration to a deployment server repository. When this setting is set to 1 (enabled), the input writes its configuration to the directory specified as repositoryLocation in serverclass.conf.
        Copy the full contents of the splunk_httpinput app directory to this directory for the configuration to work. When enabled, only the tokens defined in the splunk_httpinput app in this repository are viewable and editable on the API and the Data Inputs page in Splunk Web. When disabled, the input writes its configuration to $SPLUNK_HOME/etc/apps by default. Defaults to 0 (disabled).
        """
        return pulumi.get(self, "use_deployment_server")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

