import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ServiceEmailsOnPushConfig extends cdktf.TerraformMetaArguments {
    /**
    * Branches to send notifications for. Valid options are `all`, `default`, `protected`, `default_and_protected`. Notifications are always fired for tag pushes.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/service_emails_on_push#branches_to_be_notified ServiceEmailsOnPush#branches_to_be_notified}
    */
    readonly branchesToBeNotified?: string;
    /**
    * Disable code diffs.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/service_emails_on_push#disable_diffs ServiceEmailsOnPush#disable_diffs}
    */
    readonly disableDiffs?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/service_emails_on_push#id ServiceEmailsOnPush#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * ID or full-path of the project you want to activate integration on.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/service_emails_on_push#project ServiceEmailsOnPush#project}
    */
    readonly project: string;
    /**
    * Enable notifications for push events.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/service_emails_on_push#push_events ServiceEmailsOnPush#push_events}
    */
    readonly pushEvents?: boolean | cdktf.IResolvable;
    /**
    * Emails separated by whitespace.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/service_emails_on_push#recipients ServiceEmailsOnPush#recipients}
    */
    readonly recipients: string;
    /**
    * Send from committer.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/service_emails_on_push#send_from_committer_email ServiceEmailsOnPush#send_from_committer_email}
    */
    readonly sendFromCommitterEmail?: boolean | cdktf.IResolvable;
    /**
    * Enable notifications for tag push events.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/service_emails_on_push#tag_push_events ServiceEmailsOnPush#tag_push_events}
    */
    readonly tagPushEvents?: boolean | cdktf.IResolvable;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/gitlab/r/service_emails_on_push gitlab_service_emails_on_push}
*/
export declare class ServiceEmailsOnPush extends cdktf.TerraformResource {
    static readonly tfResourceType = "gitlab_service_emails_on_push";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/gitlab/r/service_emails_on_push gitlab_service_emails_on_push} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ServiceEmailsOnPushConfig
    */
    constructor(scope: Construct, id: string, config: ServiceEmailsOnPushConfig);
    get active(): cdktf.IResolvable;
    private _branchesToBeNotified?;
    get branchesToBeNotified(): string;
    set branchesToBeNotified(value: string);
    resetBranchesToBeNotified(): void;
    get branchesToBeNotifiedInput(): string | undefined;
    get createdAt(): string;
    private _disableDiffs?;
    get disableDiffs(): boolean | cdktf.IResolvable;
    set disableDiffs(value: boolean | cdktf.IResolvable);
    resetDisableDiffs(): void;
    get disableDiffsInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    get projectInput(): string | undefined;
    private _pushEvents?;
    get pushEvents(): boolean | cdktf.IResolvable;
    set pushEvents(value: boolean | cdktf.IResolvable);
    resetPushEvents(): void;
    get pushEventsInput(): boolean | cdktf.IResolvable | undefined;
    private _recipients?;
    get recipients(): string;
    set recipients(value: string);
    get recipientsInput(): string | undefined;
    private _sendFromCommitterEmail?;
    get sendFromCommitterEmail(): boolean | cdktf.IResolvable;
    set sendFromCommitterEmail(value: boolean | cdktf.IResolvable);
    resetSendFromCommitterEmail(): void;
    get sendFromCommitterEmailInput(): boolean | cdktf.IResolvable | undefined;
    get slug(): string;
    private _tagPushEvents?;
    get tagPushEvents(): boolean | cdktf.IResolvable;
    set tagPushEvents(value: boolean | cdktf.IResolvable);
    resetTagPushEvents(): void;
    get tagPushEventsInput(): boolean | cdktf.IResolvable | undefined;
    get title(): string;
    get updatedAt(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
