"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Project = exports.ProjectPushRulesOutputReference = exports.projectPushRulesToTerraform = exports.ProjectContainerExpirationPolicyOutputReference = exports.projectContainerExpirationPolicyToTerraform = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
function projectContainerExpirationPolicyToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        cadence: cdktf.stringToTerraform(struct.cadence),
        enabled: cdktf.booleanToTerraform(struct.enabled),
        keep_n: cdktf.numberToTerraform(struct.keepN),
        name_regex_delete: cdktf.stringToTerraform(struct.nameRegexDelete),
        name_regex_keep: cdktf.stringToTerraform(struct.nameRegexKeep),
        older_than: cdktf.stringToTerraform(struct.olderThan),
    };
}
exports.projectContainerExpirationPolicyToTerraform = projectContainerExpirationPolicyToTerraform;
class ProjectContainerExpirationPolicyOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._cadence !== undefined) {
            hasAnyValues = true;
            internalValueResult.cadence = this._cadence;
        }
        if (this._enabled !== undefined) {
            hasAnyValues = true;
            internalValueResult.enabled = this._enabled;
        }
        if (this._keepN !== undefined) {
            hasAnyValues = true;
            internalValueResult.keepN = this._keepN;
        }
        if (this._nameRegexDelete !== undefined) {
            hasAnyValues = true;
            internalValueResult.nameRegexDelete = this._nameRegexDelete;
        }
        if (this._nameRegexKeep !== undefined) {
            hasAnyValues = true;
            internalValueResult.nameRegexKeep = this._nameRegexKeep;
        }
        if (this._olderThan !== undefined) {
            hasAnyValues = true;
            internalValueResult.olderThan = this._olderThan;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._cadence = undefined;
            this._enabled = undefined;
            this._keepN = undefined;
            this._nameRegexDelete = undefined;
            this._nameRegexKeep = undefined;
            this._olderThan = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._cadence = value.cadence;
            this._enabled = value.enabled;
            this._keepN = value.keepN;
            this._nameRegexDelete = value.nameRegexDelete;
            this._nameRegexKeep = value.nameRegexKeep;
            this._olderThan = value.olderThan;
        }
    }
    get cadence() {
        return this.getStringAttribute('cadence');
    }
    set cadence(value) {
        this._cadence = value;
    }
    resetCadence() {
        this._cadence = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cadenceInput() {
        return this._cadence;
    }
    get enabled() {
        return this.getBooleanAttribute('enabled');
    }
    set enabled(value) {
        this._enabled = value;
    }
    resetEnabled() {
        this._enabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get enabledInput() {
        return this._enabled;
    }
    get keepN() {
        return this.getNumberAttribute('keep_n');
    }
    set keepN(value) {
        this._keepN = value;
    }
    resetKeepN() {
        this._keepN = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get keepNInput() {
        return this._keepN;
    }
    get nameRegexDelete() {
        return this.getStringAttribute('name_regex_delete');
    }
    set nameRegexDelete(value) {
        this._nameRegexDelete = value;
    }
    resetNameRegexDelete() {
        this._nameRegexDelete = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get nameRegexDeleteInput() {
        return this._nameRegexDelete;
    }
    get nameRegexKeep() {
        return this.getStringAttribute('name_regex_keep');
    }
    set nameRegexKeep(value) {
        this._nameRegexKeep = value;
    }
    resetNameRegexKeep() {
        this._nameRegexKeep = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get nameRegexKeepInput() {
        return this._nameRegexKeep;
    }
    // next_run_at - computed: true, optional: false, required: false
    get nextRunAt() {
        return this.getStringAttribute('next_run_at');
    }
    get olderThan() {
        return this.getStringAttribute('older_than');
    }
    set olderThan(value) {
        this._olderThan = value;
    }
    resetOlderThan() {
        this._olderThan = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get olderThanInput() {
        return this._olderThan;
    }
}
exports.ProjectContainerExpirationPolicyOutputReference = ProjectContainerExpirationPolicyOutputReference;
_a = JSII_RTTI_SYMBOL_1;
ProjectContainerExpirationPolicyOutputReference[_a] = { fqn: "@cdktf/provider-gitlab.project.ProjectContainerExpirationPolicyOutputReference", version: "4.0.1" };
function projectPushRulesToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        author_email_regex: cdktf.stringToTerraform(struct.authorEmailRegex),
        branch_name_regex: cdktf.stringToTerraform(struct.branchNameRegex),
        commit_committer_check: cdktf.booleanToTerraform(struct.commitCommitterCheck),
        commit_message_negative_regex: cdktf.stringToTerraform(struct.commitMessageNegativeRegex),
        commit_message_regex: cdktf.stringToTerraform(struct.commitMessageRegex),
        deny_delete_tag: cdktf.booleanToTerraform(struct.denyDeleteTag),
        file_name_regex: cdktf.stringToTerraform(struct.fileNameRegex),
        max_file_size: cdktf.numberToTerraform(struct.maxFileSize),
        member_check: cdktf.booleanToTerraform(struct.memberCheck),
        prevent_secrets: cdktf.booleanToTerraform(struct.preventSecrets),
        reject_unsigned_commits: cdktf.booleanToTerraform(struct.rejectUnsignedCommits),
    };
}
exports.projectPushRulesToTerraform = projectPushRulesToTerraform;
class ProjectPushRulesOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._authorEmailRegex !== undefined) {
            hasAnyValues = true;
            internalValueResult.authorEmailRegex = this._authorEmailRegex;
        }
        if (this._branchNameRegex !== undefined) {
            hasAnyValues = true;
            internalValueResult.branchNameRegex = this._branchNameRegex;
        }
        if (this._commitCommitterCheck !== undefined) {
            hasAnyValues = true;
            internalValueResult.commitCommitterCheck = this._commitCommitterCheck;
        }
        if (this._commitMessageNegativeRegex !== undefined) {
            hasAnyValues = true;
            internalValueResult.commitMessageNegativeRegex = this._commitMessageNegativeRegex;
        }
        if (this._commitMessageRegex !== undefined) {
            hasAnyValues = true;
            internalValueResult.commitMessageRegex = this._commitMessageRegex;
        }
        if (this._denyDeleteTag !== undefined) {
            hasAnyValues = true;
            internalValueResult.denyDeleteTag = this._denyDeleteTag;
        }
        if (this._fileNameRegex !== undefined) {
            hasAnyValues = true;
            internalValueResult.fileNameRegex = this._fileNameRegex;
        }
        if (this._maxFileSize !== undefined) {
            hasAnyValues = true;
            internalValueResult.maxFileSize = this._maxFileSize;
        }
        if (this._memberCheck !== undefined) {
            hasAnyValues = true;
            internalValueResult.memberCheck = this._memberCheck;
        }
        if (this._preventSecrets !== undefined) {
            hasAnyValues = true;
            internalValueResult.preventSecrets = this._preventSecrets;
        }
        if (this._rejectUnsignedCommits !== undefined) {
            hasAnyValues = true;
            internalValueResult.rejectUnsignedCommits = this._rejectUnsignedCommits;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._authorEmailRegex = undefined;
            this._branchNameRegex = undefined;
            this._commitCommitterCheck = undefined;
            this._commitMessageNegativeRegex = undefined;
            this._commitMessageRegex = undefined;
            this._denyDeleteTag = undefined;
            this._fileNameRegex = undefined;
            this._maxFileSize = undefined;
            this._memberCheck = undefined;
            this._preventSecrets = undefined;
            this._rejectUnsignedCommits = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._authorEmailRegex = value.authorEmailRegex;
            this._branchNameRegex = value.branchNameRegex;
            this._commitCommitterCheck = value.commitCommitterCheck;
            this._commitMessageNegativeRegex = value.commitMessageNegativeRegex;
            this._commitMessageRegex = value.commitMessageRegex;
            this._denyDeleteTag = value.denyDeleteTag;
            this._fileNameRegex = value.fileNameRegex;
            this._maxFileSize = value.maxFileSize;
            this._memberCheck = value.memberCheck;
            this._preventSecrets = value.preventSecrets;
            this._rejectUnsignedCommits = value.rejectUnsignedCommits;
        }
    }
    get authorEmailRegex() {
        return this.getStringAttribute('author_email_regex');
    }
    set authorEmailRegex(value) {
        this._authorEmailRegex = value;
    }
    resetAuthorEmailRegex() {
        this._authorEmailRegex = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get authorEmailRegexInput() {
        return this._authorEmailRegex;
    }
    get branchNameRegex() {
        return this.getStringAttribute('branch_name_regex');
    }
    set branchNameRegex(value) {
        this._branchNameRegex = value;
    }
    resetBranchNameRegex() {
        this._branchNameRegex = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get branchNameRegexInput() {
        return this._branchNameRegex;
    }
    get commitCommitterCheck() {
        return this.getBooleanAttribute('commit_committer_check');
    }
    set commitCommitterCheck(value) {
        this._commitCommitterCheck = value;
    }
    resetCommitCommitterCheck() {
        this._commitCommitterCheck = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get commitCommitterCheckInput() {
        return this._commitCommitterCheck;
    }
    get commitMessageNegativeRegex() {
        return this.getStringAttribute('commit_message_negative_regex');
    }
    set commitMessageNegativeRegex(value) {
        this._commitMessageNegativeRegex = value;
    }
    resetCommitMessageNegativeRegex() {
        this._commitMessageNegativeRegex = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get commitMessageNegativeRegexInput() {
        return this._commitMessageNegativeRegex;
    }
    get commitMessageRegex() {
        return this.getStringAttribute('commit_message_regex');
    }
    set commitMessageRegex(value) {
        this._commitMessageRegex = value;
    }
    resetCommitMessageRegex() {
        this._commitMessageRegex = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get commitMessageRegexInput() {
        return this._commitMessageRegex;
    }
    get denyDeleteTag() {
        return this.getBooleanAttribute('deny_delete_tag');
    }
    set denyDeleteTag(value) {
        this._denyDeleteTag = value;
    }
    resetDenyDeleteTag() {
        this._denyDeleteTag = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get denyDeleteTagInput() {
        return this._denyDeleteTag;
    }
    get fileNameRegex() {
        return this.getStringAttribute('file_name_regex');
    }
    set fileNameRegex(value) {
        this._fileNameRegex = value;
    }
    resetFileNameRegex() {
        this._fileNameRegex = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get fileNameRegexInput() {
        return this._fileNameRegex;
    }
    get maxFileSize() {
        return this.getNumberAttribute('max_file_size');
    }
    set maxFileSize(value) {
        this._maxFileSize = value;
    }
    resetMaxFileSize() {
        this._maxFileSize = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get maxFileSizeInput() {
        return this._maxFileSize;
    }
    get memberCheck() {
        return this.getBooleanAttribute('member_check');
    }
    set memberCheck(value) {
        this._memberCheck = value;
    }
    resetMemberCheck() {
        this._memberCheck = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get memberCheckInput() {
        return this._memberCheck;
    }
    get preventSecrets() {
        return this.getBooleanAttribute('prevent_secrets');
    }
    set preventSecrets(value) {
        this._preventSecrets = value;
    }
    resetPreventSecrets() {
        this._preventSecrets = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get preventSecretsInput() {
        return this._preventSecrets;
    }
    get rejectUnsignedCommits() {
        return this.getBooleanAttribute('reject_unsigned_commits');
    }
    set rejectUnsignedCommits(value) {
        this._rejectUnsignedCommits = value;
    }
    resetRejectUnsignedCommits() {
        this._rejectUnsignedCommits = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get rejectUnsignedCommitsInput() {
        return this._rejectUnsignedCommits;
    }
}
exports.ProjectPushRulesOutputReference = ProjectPushRulesOutputReference;
_b = JSII_RTTI_SYMBOL_1;
ProjectPushRulesOutputReference[_b] = { fqn: "@cdktf/provider-gitlab.project.ProjectPushRulesOutputReference", version: "4.0.1" };
/**
* Represents a {@link https://www.terraform.io/docs/providers/gitlab/r/project gitlab_project}
*/
class Project extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/gitlab/r/project gitlab_project} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ProjectConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'gitlab_project',
            terraformGeneratorMetadata: {
                providerName: 'gitlab',
                providerVersion: '3.20.0',
                providerVersionConstraint: '~> 3.14'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle,
            provisioners: config.provisioners,
            connection: config.connection,
            forEach: config.forEach
        });
        // container_expiration_policy - computed: false, optional: true, required: false
        this._containerExpirationPolicy = new ProjectContainerExpirationPolicyOutputReference(this, "container_expiration_policy");
        // push_rules - computed: false, optional: true, required: false
        this._pushRules = new ProjectPushRulesOutputReference(this, "push_rules");
        this._allowMergeOnSkippedPipeline = config.allowMergeOnSkippedPipeline;
        this._analyticsAccessLevel = config.analyticsAccessLevel;
        this._approvalsBeforeMerge = config.approvalsBeforeMerge;
        this._archiveOnDestroy = config.archiveOnDestroy;
        this._archived = config.archived;
        this._autoCancelPendingPipelines = config.autoCancelPendingPipelines;
        this._autoDevopsDeployStrategy = config.autoDevopsDeployStrategy;
        this._autoDevopsEnabled = config.autoDevopsEnabled;
        this._autocloseReferencedIssues = config.autocloseReferencedIssues;
        this._buildCoverageRegex = config.buildCoverageRegex;
        this._buildGitStrategy = config.buildGitStrategy;
        this._buildTimeout = config.buildTimeout;
        this._buildsAccessLevel = config.buildsAccessLevel;
        this._ciConfigPath = config.ciConfigPath;
        this._ciDefaultGitDepth = config.ciDefaultGitDepth;
        this._ciForwardDeploymentEnabled = config.ciForwardDeploymentEnabled;
        this._containerRegistryAccessLevel = config.containerRegistryAccessLevel;
        this._containerRegistryEnabled = config.containerRegistryEnabled;
        this._defaultBranch = config.defaultBranch;
        this._description = config.description;
        this._emailsDisabled = config.emailsDisabled;
        this._externalAuthorizationClassificationLabel = config.externalAuthorizationClassificationLabel;
        this._forkingAccessLevel = config.forkingAccessLevel;
        this._groupWithProjectTemplatesId = config.groupWithProjectTemplatesId;
        this._id = config.id;
        this._importUrl = config.importUrl;
        this._initializeWithReadme = config.initializeWithReadme;
        this._issuesAccessLevel = config.issuesAccessLevel;
        this._issuesEnabled = config.issuesEnabled;
        this._issuesTemplate = config.issuesTemplate;
        this._lfsEnabled = config.lfsEnabled;
        this._mergeCommitTemplate = config.mergeCommitTemplate;
        this._mergeMethod = config.mergeMethod;
        this._mergePipelinesEnabled = config.mergePipelinesEnabled;
        this._mergeRequestsAccessLevel = config.mergeRequestsAccessLevel;
        this._mergeRequestsEnabled = config.mergeRequestsEnabled;
        this._mergeRequestsTemplate = config.mergeRequestsTemplate;
        this._mergeTrainsEnabled = config.mergeTrainsEnabled;
        this._mirror = config.mirror;
        this._mirrorOverwritesDivergedBranches = config.mirrorOverwritesDivergedBranches;
        this._mirrorTriggerBuilds = config.mirrorTriggerBuilds;
        this._name = config.name;
        this._namespaceId = config.namespaceId;
        this._onlyAllowMergeIfAllDiscussionsAreResolved = config.onlyAllowMergeIfAllDiscussionsAreResolved;
        this._onlyAllowMergeIfPipelineSucceeds = config.onlyAllowMergeIfPipelineSucceeds;
        this._onlyMirrorProtectedBranches = config.onlyMirrorProtectedBranches;
        this._operationsAccessLevel = config.operationsAccessLevel;
        this._packagesEnabled = config.packagesEnabled;
        this._pagesAccessLevel = config.pagesAccessLevel;
        this._path = config.path;
        this._pipelinesEnabled = config.pipelinesEnabled;
        this._printingMergeRequestLinkEnabled = config.printingMergeRequestLinkEnabled;
        this._publicBuilds = config.publicBuilds;
        this._removeSourceBranchAfterMerge = config.removeSourceBranchAfterMerge;
        this._repositoryAccessLevel = config.repositoryAccessLevel;
        this._repositoryStorage = config.repositoryStorage;
        this._requestAccessEnabled = config.requestAccessEnabled;
        this._requirementsAccessLevel = config.requirementsAccessLevel;
        this._resolveOutdatedDiffDiscussions = config.resolveOutdatedDiffDiscussions;
        this._securityAndComplianceAccessLevel = config.securityAndComplianceAccessLevel;
        this._sharedRunnersEnabled = config.sharedRunnersEnabled;
        this._skipWaitForDefaultBranchProtection = config.skipWaitForDefaultBranchProtection;
        this._snippetsAccessLevel = config.snippetsAccessLevel;
        this._snippetsEnabled = config.snippetsEnabled;
        this._squashCommitTemplate = config.squashCommitTemplate;
        this._squashOption = config.squashOption;
        this._suggestionCommitMessage = config.suggestionCommitMessage;
        this._tags = config.tags;
        this._templateName = config.templateName;
        this._templateProjectId = config.templateProjectId;
        this._topics = config.topics;
        this._useCustomTemplate = config.useCustomTemplate;
        this._visibilityLevel = config.visibilityLevel;
        this._wikiAccessLevel = config.wikiAccessLevel;
        this._wikiEnabled = config.wikiEnabled;
        this._containerExpirationPolicy.internalValue = config.containerExpirationPolicy;
        this._pushRules.internalValue = config.pushRules;
    }
    get allowMergeOnSkippedPipeline() {
        return this.getBooleanAttribute('allow_merge_on_skipped_pipeline');
    }
    set allowMergeOnSkippedPipeline(value) {
        this._allowMergeOnSkippedPipeline = value;
    }
    resetAllowMergeOnSkippedPipeline() {
        this._allowMergeOnSkippedPipeline = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get allowMergeOnSkippedPipelineInput() {
        return this._allowMergeOnSkippedPipeline;
    }
    get analyticsAccessLevel() {
        return this.getStringAttribute('analytics_access_level');
    }
    set analyticsAccessLevel(value) {
        this._analyticsAccessLevel = value;
    }
    resetAnalyticsAccessLevel() {
        this._analyticsAccessLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get analyticsAccessLevelInput() {
        return this._analyticsAccessLevel;
    }
    get approvalsBeforeMerge() {
        return this.getNumberAttribute('approvals_before_merge');
    }
    set approvalsBeforeMerge(value) {
        this._approvalsBeforeMerge = value;
    }
    resetApprovalsBeforeMerge() {
        this._approvalsBeforeMerge = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get approvalsBeforeMergeInput() {
        return this._approvalsBeforeMerge;
    }
    get archiveOnDestroy() {
        return this.getBooleanAttribute('archive_on_destroy');
    }
    set archiveOnDestroy(value) {
        this._archiveOnDestroy = value;
    }
    resetArchiveOnDestroy() {
        this._archiveOnDestroy = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get archiveOnDestroyInput() {
        return this._archiveOnDestroy;
    }
    get archived() {
        return this.getBooleanAttribute('archived');
    }
    set archived(value) {
        this._archived = value;
    }
    resetArchived() {
        this._archived = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get archivedInput() {
        return this._archived;
    }
    get autoCancelPendingPipelines() {
        return this.getStringAttribute('auto_cancel_pending_pipelines');
    }
    set autoCancelPendingPipelines(value) {
        this._autoCancelPendingPipelines = value;
    }
    resetAutoCancelPendingPipelines() {
        this._autoCancelPendingPipelines = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get autoCancelPendingPipelinesInput() {
        return this._autoCancelPendingPipelines;
    }
    get autoDevopsDeployStrategy() {
        return this.getStringAttribute('auto_devops_deploy_strategy');
    }
    set autoDevopsDeployStrategy(value) {
        this._autoDevopsDeployStrategy = value;
    }
    resetAutoDevopsDeployStrategy() {
        this._autoDevopsDeployStrategy = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get autoDevopsDeployStrategyInput() {
        return this._autoDevopsDeployStrategy;
    }
    get autoDevopsEnabled() {
        return this.getBooleanAttribute('auto_devops_enabled');
    }
    set autoDevopsEnabled(value) {
        this._autoDevopsEnabled = value;
    }
    resetAutoDevopsEnabled() {
        this._autoDevopsEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get autoDevopsEnabledInput() {
        return this._autoDevopsEnabled;
    }
    get autocloseReferencedIssues() {
        return this.getBooleanAttribute('autoclose_referenced_issues');
    }
    set autocloseReferencedIssues(value) {
        this._autocloseReferencedIssues = value;
    }
    resetAutocloseReferencedIssues() {
        this._autocloseReferencedIssues = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get autocloseReferencedIssuesInput() {
        return this._autocloseReferencedIssues;
    }
    get buildCoverageRegex() {
        return this.getStringAttribute('build_coverage_regex');
    }
    set buildCoverageRegex(value) {
        this._buildCoverageRegex = value;
    }
    resetBuildCoverageRegex() {
        this._buildCoverageRegex = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get buildCoverageRegexInput() {
        return this._buildCoverageRegex;
    }
    get buildGitStrategy() {
        return this.getStringAttribute('build_git_strategy');
    }
    set buildGitStrategy(value) {
        this._buildGitStrategy = value;
    }
    resetBuildGitStrategy() {
        this._buildGitStrategy = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get buildGitStrategyInput() {
        return this._buildGitStrategy;
    }
    get buildTimeout() {
        return this.getNumberAttribute('build_timeout');
    }
    set buildTimeout(value) {
        this._buildTimeout = value;
    }
    resetBuildTimeout() {
        this._buildTimeout = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get buildTimeoutInput() {
        return this._buildTimeout;
    }
    get buildsAccessLevel() {
        return this.getStringAttribute('builds_access_level');
    }
    set buildsAccessLevel(value) {
        this._buildsAccessLevel = value;
    }
    resetBuildsAccessLevel() {
        this._buildsAccessLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get buildsAccessLevelInput() {
        return this._buildsAccessLevel;
    }
    get ciConfigPath() {
        return this.getStringAttribute('ci_config_path');
    }
    set ciConfigPath(value) {
        this._ciConfigPath = value;
    }
    resetCiConfigPath() {
        this._ciConfigPath = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get ciConfigPathInput() {
        return this._ciConfigPath;
    }
    get ciDefaultGitDepth() {
        return this.getNumberAttribute('ci_default_git_depth');
    }
    set ciDefaultGitDepth(value) {
        this._ciDefaultGitDepth = value;
    }
    resetCiDefaultGitDepth() {
        this._ciDefaultGitDepth = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get ciDefaultGitDepthInput() {
        return this._ciDefaultGitDepth;
    }
    get ciForwardDeploymentEnabled() {
        return this.getBooleanAttribute('ci_forward_deployment_enabled');
    }
    set ciForwardDeploymentEnabled(value) {
        this._ciForwardDeploymentEnabled = value;
    }
    resetCiForwardDeploymentEnabled() {
        this._ciForwardDeploymentEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get ciForwardDeploymentEnabledInput() {
        return this._ciForwardDeploymentEnabled;
    }
    get containerRegistryAccessLevel() {
        return this.getStringAttribute('container_registry_access_level');
    }
    set containerRegistryAccessLevel(value) {
        this._containerRegistryAccessLevel = value;
    }
    resetContainerRegistryAccessLevel() {
        this._containerRegistryAccessLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get containerRegistryAccessLevelInput() {
        return this._containerRegistryAccessLevel;
    }
    get containerRegistryEnabled() {
        return this.getBooleanAttribute('container_registry_enabled');
    }
    set containerRegistryEnabled(value) {
        this._containerRegistryEnabled = value;
    }
    resetContainerRegistryEnabled() {
        this._containerRegistryEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get containerRegistryEnabledInput() {
        return this._containerRegistryEnabled;
    }
    get defaultBranch() {
        return this.getStringAttribute('default_branch');
    }
    set defaultBranch(value) {
        this._defaultBranch = value;
    }
    resetDefaultBranch() {
        this._defaultBranch = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get defaultBranchInput() {
        return this._defaultBranch;
    }
    get description() {
        return this.getStringAttribute('description');
    }
    set description(value) {
        this._description = value;
    }
    resetDescription() {
        this._description = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get descriptionInput() {
        return this._description;
    }
    get emailsDisabled() {
        return this.getBooleanAttribute('emails_disabled');
    }
    set emailsDisabled(value) {
        this._emailsDisabled = value;
    }
    resetEmailsDisabled() {
        this._emailsDisabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get emailsDisabledInput() {
        return this._emailsDisabled;
    }
    get externalAuthorizationClassificationLabel() {
        return this.getStringAttribute('external_authorization_classification_label');
    }
    set externalAuthorizationClassificationLabel(value) {
        this._externalAuthorizationClassificationLabel = value;
    }
    resetExternalAuthorizationClassificationLabel() {
        this._externalAuthorizationClassificationLabel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get externalAuthorizationClassificationLabelInput() {
        return this._externalAuthorizationClassificationLabel;
    }
    get forkingAccessLevel() {
        return this.getStringAttribute('forking_access_level');
    }
    set forkingAccessLevel(value) {
        this._forkingAccessLevel = value;
    }
    resetForkingAccessLevel() {
        this._forkingAccessLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get forkingAccessLevelInput() {
        return this._forkingAccessLevel;
    }
    get groupWithProjectTemplatesId() {
        return this.getNumberAttribute('group_with_project_templates_id');
    }
    set groupWithProjectTemplatesId(value) {
        this._groupWithProjectTemplatesId = value;
    }
    resetGroupWithProjectTemplatesId() {
        this._groupWithProjectTemplatesId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get groupWithProjectTemplatesIdInput() {
        return this._groupWithProjectTemplatesId;
    }
    // http_url_to_repo - computed: true, optional: false, required: false
    get httpUrlToRepo() {
        return this.getStringAttribute('http_url_to_repo');
    }
    get id() {
        return this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    resetId() {
        this._id = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get idInput() {
        return this._id;
    }
    get importUrl() {
        return this.getStringAttribute('import_url');
    }
    set importUrl(value) {
        this._importUrl = value;
    }
    resetImportUrl() {
        this._importUrl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get importUrlInput() {
        return this._importUrl;
    }
    get initializeWithReadme() {
        return this.getBooleanAttribute('initialize_with_readme');
    }
    set initializeWithReadme(value) {
        this._initializeWithReadme = value;
    }
    resetInitializeWithReadme() {
        this._initializeWithReadme = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get initializeWithReadmeInput() {
        return this._initializeWithReadme;
    }
    get issuesAccessLevel() {
        return this.getStringAttribute('issues_access_level');
    }
    set issuesAccessLevel(value) {
        this._issuesAccessLevel = value;
    }
    resetIssuesAccessLevel() {
        this._issuesAccessLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get issuesAccessLevelInput() {
        return this._issuesAccessLevel;
    }
    get issuesEnabled() {
        return this.getBooleanAttribute('issues_enabled');
    }
    set issuesEnabled(value) {
        this._issuesEnabled = value;
    }
    resetIssuesEnabled() {
        this._issuesEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get issuesEnabledInput() {
        return this._issuesEnabled;
    }
    get issuesTemplate() {
        return this.getStringAttribute('issues_template');
    }
    set issuesTemplate(value) {
        this._issuesTemplate = value;
    }
    resetIssuesTemplate() {
        this._issuesTemplate = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get issuesTemplateInput() {
        return this._issuesTemplate;
    }
    get lfsEnabled() {
        return this.getBooleanAttribute('lfs_enabled');
    }
    set lfsEnabled(value) {
        this._lfsEnabled = value;
    }
    resetLfsEnabled() {
        this._lfsEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get lfsEnabledInput() {
        return this._lfsEnabled;
    }
    get mergeCommitTemplate() {
        return this.getStringAttribute('merge_commit_template');
    }
    set mergeCommitTemplate(value) {
        this._mergeCommitTemplate = value;
    }
    resetMergeCommitTemplate() {
        this._mergeCommitTemplate = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get mergeCommitTemplateInput() {
        return this._mergeCommitTemplate;
    }
    get mergeMethod() {
        return this.getStringAttribute('merge_method');
    }
    set mergeMethod(value) {
        this._mergeMethod = value;
    }
    resetMergeMethod() {
        this._mergeMethod = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get mergeMethodInput() {
        return this._mergeMethod;
    }
    get mergePipelinesEnabled() {
        return this.getBooleanAttribute('merge_pipelines_enabled');
    }
    set mergePipelinesEnabled(value) {
        this._mergePipelinesEnabled = value;
    }
    resetMergePipelinesEnabled() {
        this._mergePipelinesEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get mergePipelinesEnabledInput() {
        return this._mergePipelinesEnabled;
    }
    get mergeRequestsAccessLevel() {
        return this.getStringAttribute('merge_requests_access_level');
    }
    set mergeRequestsAccessLevel(value) {
        this._mergeRequestsAccessLevel = value;
    }
    resetMergeRequestsAccessLevel() {
        this._mergeRequestsAccessLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get mergeRequestsAccessLevelInput() {
        return this._mergeRequestsAccessLevel;
    }
    get mergeRequestsEnabled() {
        return this.getBooleanAttribute('merge_requests_enabled');
    }
    set mergeRequestsEnabled(value) {
        this._mergeRequestsEnabled = value;
    }
    resetMergeRequestsEnabled() {
        this._mergeRequestsEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get mergeRequestsEnabledInput() {
        return this._mergeRequestsEnabled;
    }
    get mergeRequestsTemplate() {
        return this.getStringAttribute('merge_requests_template');
    }
    set mergeRequestsTemplate(value) {
        this._mergeRequestsTemplate = value;
    }
    resetMergeRequestsTemplate() {
        this._mergeRequestsTemplate = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get mergeRequestsTemplateInput() {
        return this._mergeRequestsTemplate;
    }
    get mergeTrainsEnabled() {
        return this.getBooleanAttribute('merge_trains_enabled');
    }
    set mergeTrainsEnabled(value) {
        this._mergeTrainsEnabled = value;
    }
    resetMergeTrainsEnabled() {
        this._mergeTrainsEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get mergeTrainsEnabledInput() {
        return this._mergeTrainsEnabled;
    }
    get mirror() {
        return this.getBooleanAttribute('mirror');
    }
    set mirror(value) {
        this._mirror = value;
    }
    resetMirror() {
        this._mirror = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get mirrorInput() {
        return this._mirror;
    }
    get mirrorOverwritesDivergedBranches() {
        return this.getBooleanAttribute('mirror_overwrites_diverged_branches');
    }
    set mirrorOverwritesDivergedBranches(value) {
        this._mirrorOverwritesDivergedBranches = value;
    }
    resetMirrorOverwritesDivergedBranches() {
        this._mirrorOverwritesDivergedBranches = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get mirrorOverwritesDivergedBranchesInput() {
        return this._mirrorOverwritesDivergedBranches;
    }
    get mirrorTriggerBuilds() {
        return this.getBooleanAttribute('mirror_trigger_builds');
    }
    set mirrorTriggerBuilds(value) {
        this._mirrorTriggerBuilds = value;
    }
    resetMirrorTriggerBuilds() {
        this._mirrorTriggerBuilds = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get mirrorTriggerBuildsInput() {
        return this._mirrorTriggerBuilds;
    }
    get name() {
        return this.getStringAttribute('name');
    }
    set name(value) {
        this._name = value;
    }
    // Temporarily expose input value. Use with caution.
    get nameInput() {
        return this._name;
    }
    get namespaceId() {
        return this.getNumberAttribute('namespace_id');
    }
    set namespaceId(value) {
        this._namespaceId = value;
    }
    resetNamespaceId() {
        this._namespaceId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get namespaceIdInput() {
        return this._namespaceId;
    }
    get onlyAllowMergeIfAllDiscussionsAreResolved() {
        return this.getBooleanAttribute('only_allow_merge_if_all_discussions_are_resolved');
    }
    set onlyAllowMergeIfAllDiscussionsAreResolved(value) {
        this._onlyAllowMergeIfAllDiscussionsAreResolved = value;
    }
    resetOnlyAllowMergeIfAllDiscussionsAreResolved() {
        this._onlyAllowMergeIfAllDiscussionsAreResolved = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get onlyAllowMergeIfAllDiscussionsAreResolvedInput() {
        return this._onlyAllowMergeIfAllDiscussionsAreResolved;
    }
    get onlyAllowMergeIfPipelineSucceeds() {
        return this.getBooleanAttribute('only_allow_merge_if_pipeline_succeeds');
    }
    set onlyAllowMergeIfPipelineSucceeds(value) {
        this._onlyAllowMergeIfPipelineSucceeds = value;
    }
    resetOnlyAllowMergeIfPipelineSucceeds() {
        this._onlyAllowMergeIfPipelineSucceeds = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get onlyAllowMergeIfPipelineSucceedsInput() {
        return this._onlyAllowMergeIfPipelineSucceeds;
    }
    get onlyMirrorProtectedBranches() {
        return this.getBooleanAttribute('only_mirror_protected_branches');
    }
    set onlyMirrorProtectedBranches(value) {
        this._onlyMirrorProtectedBranches = value;
    }
    resetOnlyMirrorProtectedBranches() {
        this._onlyMirrorProtectedBranches = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get onlyMirrorProtectedBranchesInput() {
        return this._onlyMirrorProtectedBranches;
    }
    get operationsAccessLevel() {
        return this.getStringAttribute('operations_access_level');
    }
    set operationsAccessLevel(value) {
        this._operationsAccessLevel = value;
    }
    resetOperationsAccessLevel() {
        this._operationsAccessLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get operationsAccessLevelInput() {
        return this._operationsAccessLevel;
    }
    get packagesEnabled() {
        return this.getBooleanAttribute('packages_enabled');
    }
    set packagesEnabled(value) {
        this._packagesEnabled = value;
    }
    resetPackagesEnabled() {
        this._packagesEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get packagesEnabledInput() {
        return this._packagesEnabled;
    }
    get pagesAccessLevel() {
        return this.getStringAttribute('pages_access_level');
    }
    set pagesAccessLevel(value) {
        this._pagesAccessLevel = value;
    }
    resetPagesAccessLevel() {
        this._pagesAccessLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get pagesAccessLevelInput() {
        return this._pagesAccessLevel;
    }
    get path() {
        return this.getStringAttribute('path');
    }
    set path(value) {
        this._path = value;
    }
    resetPath() {
        this._path = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get pathInput() {
        return this._path;
    }
    // path_with_namespace - computed: true, optional: false, required: false
    get pathWithNamespace() {
        return this.getStringAttribute('path_with_namespace');
    }
    get pipelinesEnabled() {
        return this.getBooleanAttribute('pipelines_enabled');
    }
    set pipelinesEnabled(value) {
        this._pipelinesEnabled = value;
    }
    resetPipelinesEnabled() {
        this._pipelinesEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get pipelinesEnabledInput() {
        return this._pipelinesEnabled;
    }
    get printingMergeRequestLinkEnabled() {
        return this.getBooleanAttribute('printing_merge_request_link_enabled');
    }
    set printingMergeRequestLinkEnabled(value) {
        this._printingMergeRequestLinkEnabled = value;
    }
    resetPrintingMergeRequestLinkEnabled() {
        this._printingMergeRequestLinkEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get printingMergeRequestLinkEnabledInput() {
        return this._printingMergeRequestLinkEnabled;
    }
    get publicBuilds() {
        return this.getBooleanAttribute('public_builds');
    }
    set publicBuilds(value) {
        this._publicBuilds = value;
    }
    resetPublicBuilds() {
        this._publicBuilds = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get publicBuildsInput() {
        return this._publicBuilds;
    }
    get removeSourceBranchAfterMerge() {
        return this.getBooleanAttribute('remove_source_branch_after_merge');
    }
    set removeSourceBranchAfterMerge(value) {
        this._removeSourceBranchAfterMerge = value;
    }
    resetRemoveSourceBranchAfterMerge() {
        this._removeSourceBranchAfterMerge = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get removeSourceBranchAfterMergeInput() {
        return this._removeSourceBranchAfterMerge;
    }
    get repositoryAccessLevel() {
        return this.getStringAttribute('repository_access_level');
    }
    set repositoryAccessLevel(value) {
        this._repositoryAccessLevel = value;
    }
    resetRepositoryAccessLevel() {
        this._repositoryAccessLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get repositoryAccessLevelInput() {
        return this._repositoryAccessLevel;
    }
    get repositoryStorage() {
        return this.getStringAttribute('repository_storage');
    }
    set repositoryStorage(value) {
        this._repositoryStorage = value;
    }
    resetRepositoryStorage() {
        this._repositoryStorage = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get repositoryStorageInput() {
        return this._repositoryStorage;
    }
    get requestAccessEnabled() {
        return this.getBooleanAttribute('request_access_enabled');
    }
    set requestAccessEnabled(value) {
        this._requestAccessEnabled = value;
    }
    resetRequestAccessEnabled() {
        this._requestAccessEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get requestAccessEnabledInput() {
        return this._requestAccessEnabled;
    }
    get requirementsAccessLevel() {
        return this.getStringAttribute('requirements_access_level');
    }
    set requirementsAccessLevel(value) {
        this._requirementsAccessLevel = value;
    }
    resetRequirementsAccessLevel() {
        this._requirementsAccessLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get requirementsAccessLevelInput() {
        return this._requirementsAccessLevel;
    }
    get resolveOutdatedDiffDiscussions() {
        return this.getBooleanAttribute('resolve_outdated_diff_discussions');
    }
    set resolveOutdatedDiffDiscussions(value) {
        this._resolveOutdatedDiffDiscussions = value;
    }
    resetResolveOutdatedDiffDiscussions() {
        this._resolveOutdatedDiffDiscussions = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get resolveOutdatedDiffDiscussionsInput() {
        return this._resolveOutdatedDiffDiscussions;
    }
    // runners_token - computed: true, optional: false, required: false
    get runnersToken() {
        return this.getStringAttribute('runners_token');
    }
    get securityAndComplianceAccessLevel() {
        return this.getStringAttribute('security_and_compliance_access_level');
    }
    set securityAndComplianceAccessLevel(value) {
        this._securityAndComplianceAccessLevel = value;
    }
    resetSecurityAndComplianceAccessLevel() {
        this._securityAndComplianceAccessLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get securityAndComplianceAccessLevelInput() {
        return this._securityAndComplianceAccessLevel;
    }
    get sharedRunnersEnabled() {
        return this.getBooleanAttribute('shared_runners_enabled');
    }
    set sharedRunnersEnabled(value) {
        this._sharedRunnersEnabled = value;
    }
    resetSharedRunnersEnabled() {
        this._sharedRunnersEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sharedRunnersEnabledInput() {
        return this._sharedRunnersEnabled;
    }
    get skipWaitForDefaultBranchProtection() {
        return this.getBooleanAttribute('skip_wait_for_default_branch_protection');
    }
    set skipWaitForDefaultBranchProtection(value) {
        this._skipWaitForDefaultBranchProtection = value;
    }
    resetSkipWaitForDefaultBranchProtection() {
        this._skipWaitForDefaultBranchProtection = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get skipWaitForDefaultBranchProtectionInput() {
        return this._skipWaitForDefaultBranchProtection;
    }
    get snippetsAccessLevel() {
        return this.getStringAttribute('snippets_access_level');
    }
    set snippetsAccessLevel(value) {
        this._snippetsAccessLevel = value;
    }
    resetSnippetsAccessLevel() {
        this._snippetsAccessLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get snippetsAccessLevelInput() {
        return this._snippetsAccessLevel;
    }
    get snippetsEnabled() {
        return this.getBooleanAttribute('snippets_enabled');
    }
    set snippetsEnabled(value) {
        this._snippetsEnabled = value;
    }
    resetSnippetsEnabled() {
        this._snippetsEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get snippetsEnabledInput() {
        return this._snippetsEnabled;
    }
    get squashCommitTemplate() {
        return this.getStringAttribute('squash_commit_template');
    }
    set squashCommitTemplate(value) {
        this._squashCommitTemplate = value;
    }
    resetSquashCommitTemplate() {
        this._squashCommitTemplate = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get squashCommitTemplateInput() {
        return this._squashCommitTemplate;
    }
    get squashOption() {
        return this.getStringAttribute('squash_option');
    }
    set squashOption(value) {
        this._squashOption = value;
    }
    resetSquashOption() {
        this._squashOption = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get squashOptionInput() {
        return this._squashOption;
    }
    // ssh_url_to_repo - computed: true, optional: false, required: false
    get sshUrlToRepo() {
        return this.getStringAttribute('ssh_url_to_repo');
    }
    get suggestionCommitMessage() {
        return this.getStringAttribute('suggestion_commit_message');
    }
    set suggestionCommitMessage(value) {
        this._suggestionCommitMessage = value;
    }
    resetSuggestionCommitMessage() {
        this._suggestionCommitMessage = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get suggestionCommitMessageInput() {
        return this._suggestionCommitMessage;
    }
    get tags() {
        return cdktf.Fn.tolist(this.getListAttribute('tags'));
    }
    set tags(value) {
        this._tags = value;
    }
    resetTags() {
        this._tags = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tagsInput() {
        return this._tags;
    }
    get templateName() {
        return this.getStringAttribute('template_name');
    }
    set templateName(value) {
        this._templateName = value;
    }
    resetTemplateName() {
        this._templateName = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get templateNameInput() {
        return this._templateName;
    }
    get templateProjectId() {
        return this.getNumberAttribute('template_project_id');
    }
    set templateProjectId(value) {
        this._templateProjectId = value;
    }
    resetTemplateProjectId() {
        this._templateProjectId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get templateProjectIdInput() {
        return this._templateProjectId;
    }
    get topics() {
        return cdktf.Fn.tolist(this.getListAttribute('topics'));
    }
    set topics(value) {
        this._topics = value;
    }
    resetTopics() {
        this._topics = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get topicsInput() {
        return this._topics;
    }
    get useCustomTemplate() {
        return this.getBooleanAttribute('use_custom_template');
    }
    set useCustomTemplate(value) {
        this._useCustomTemplate = value;
    }
    resetUseCustomTemplate() {
        this._useCustomTemplate = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get useCustomTemplateInput() {
        return this._useCustomTemplate;
    }
    get visibilityLevel() {
        return this.getStringAttribute('visibility_level');
    }
    set visibilityLevel(value) {
        this._visibilityLevel = value;
    }
    resetVisibilityLevel() {
        this._visibilityLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get visibilityLevelInput() {
        return this._visibilityLevel;
    }
    // web_url - computed: true, optional: false, required: false
    get webUrl() {
        return this.getStringAttribute('web_url');
    }
    get wikiAccessLevel() {
        return this.getStringAttribute('wiki_access_level');
    }
    set wikiAccessLevel(value) {
        this._wikiAccessLevel = value;
    }
    resetWikiAccessLevel() {
        this._wikiAccessLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get wikiAccessLevelInput() {
        return this._wikiAccessLevel;
    }
    get wikiEnabled() {
        return this.getBooleanAttribute('wiki_enabled');
    }
    set wikiEnabled(value) {
        this._wikiEnabled = value;
    }
    resetWikiEnabled() {
        this._wikiEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get wikiEnabledInput() {
        return this._wikiEnabled;
    }
    get containerExpirationPolicy() {
        return this._containerExpirationPolicy;
    }
    putContainerExpirationPolicy(value) {
        this._containerExpirationPolicy.internalValue = value;
    }
    resetContainerExpirationPolicy() {
        this._containerExpirationPolicy.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get containerExpirationPolicyInput() {
        return this._containerExpirationPolicy.internalValue;
    }
    get pushRules() {
        return this._pushRules;
    }
    putPushRules(value) {
        this._pushRules.internalValue = value;
    }
    resetPushRules() {
        this._pushRules.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get pushRulesInput() {
        return this._pushRules.internalValue;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            allow_merge_on_skipped_pipeline: cdktf.booleanToTerraform(this._allowMergeOnSkippedPipeline),
            analytics_access_level: cdktf.stringToTerraform(this._analyticsAccessLevel),
            approvals_before_merge: cdktf.numberToTerraform(this._approvalsBeforeMerge),
            archive_on_destroy: cdktf.booleanToTerraform(this._archiveOnDestroy),
            archived: cdktf.booleanToTerraform(this._archived),
            auto_cancel_pending_pipelines: cdktf.stringToTerraform(this._autoCancelPendingPipelines),
            auto_devops_deploy_strategy: cdktf.stringToTerraform(this._autoDevopsDeployStrategy),
            auto_devops_enabled: cdktf.booleanToTerraform(this._autoDevopsEnabled),
            autoclose_referenced_issues: cdktf.booleanToTerraform(this._autocloseReferencedIssues),
            build_coverage_regex: cdktf.stringToTerraform(this._buildCoverageRegex),
            build_git_strategy: cdktf.stringToTerraform(this._buildGitStrategy),
            build_timeout: cdktf.numberToTerraform(this._buildTimeout),
            builds_access_level: cdktf.stringToTerraform(this._buildsAccessLevel),
            ci_config_path: cdktf.stringToTerraform(this._ciConfigPath),
            ci_default_git_depth: cdktf.numberToTerraform(this._ciDefaultGitDepth),
            ci_forward_deployment_enabled: cdktf.booleanToTerraform(this._ciForwardDeploymentEnabled),
            container_registry_access_level: cdktf.stringToTerraform(this._containerRegistryAccessLevel),
            container_registry_enabled: cdktf.booleanToTerraform(this._containerRegistryEnabled),
            default_branch: cdktf.stringToTerraform(this._defaultBranch),
            description: cdktf.stringToTerraform(this._description),
            emails_disabled: cdktf.booleanToTerraform(this._emailsDisabled),
            external_authorization_classification_label: cdktf.stringToTerraform(this._externalAuthorizationClassificationLabel),
            forking_access_level: cdktf.stringToTerraform(this._forkingAccessLevel),
            group_with_project_templates_id: cdktf.numberToTerraform(this._groupWithProjectTemplatesId),
            id: cdktf.stringToTerraform(this._id),
            import_url: cdktf.stringToTerraform(this._importUrl),
            initialize_with_readme: cdktf.booleanToTerraform(this._initializeWithReadme),
            issues_access_level: cdktf.stringToTerraform(this._issuesAccessLevel),
            issues_enabled: cdktf.booleanToTerraform(this._issuesEnabled),
            issues_template: cdktf.stringToTerraform(this._issuesTemplate),
            lfs_enabled: cdktf.booleanToTerraform(this._lfsEnabled),
            merge_commit_template: cdktf.stringToTerraform(this._mergeCommitTemplate),
            merge_method: cdktf.stringToTerraform(this._mergeMethod),
            merge_pipelines_enabled: cdktf.booleanToTerraform(this._mergePipelinesEnabled),
            merge_requests_access_level: cdktf.stringToTerraform(this._mergeRequestsAccessLevel),
            merge_requests_enabled: cdktf.booleanToTerraform(this._mergeRequestsEnabled),
            merge_requests_template: cdktf.stringToTerraform(this._mergeRequestsTemplate),
            merge_trains_enabled: cdktf.booleanToTerraform(this._mergeTrainsEnabled),
            mirror: cdktf.booleanToTerraform(this._mirror),
            mirror_overwrites_diverged_branches: cdktf.booleanToTerraform(this._mirrorOverwritesDivergedBranches),
            mirror_trigger_builds: cdktf.booleanToTerraform(this._mirrorTriggerBuilds),
            name: cdktf.stringToTerraform(this._name),
            namespace_id: cdktf.numberToTerraform(this._namespaceId),
            only_allow_merge_if_all_discussions_are_resolved: cdktf.booleanToTerraform(this._onlyAllowMergeIfAllDiscussionsAreResolved),
            only_allow_merge_if_pipeline_succeeds: cdktf.booleanToTerraform(this._onlyAllowMergeIfPipelineSucceeds),
            only_mirror_protected_branches: cdktf.booleanToTerraform(this._onlyMirrorProtectedBranches),
            operations_access_level: cdktf.stringToTerraform(this._operationsAccessLevel),
            packages_enabled: cdktf.booleanToTerraform(this._packagesEnabled),
            pages_access_level: cdktf.stringToTerraform(this._pagesAccessLevel),
            path: cdktf.stringToTerraform(this._path),
            pipelines_enabled: cdktf.booleanToTerraform(this._pipelinesEnabled),
            printing_merge_request_link_enabled: cdktf.booleanToTerraform(this._printingMergeRequestLinkEnabled),
            public_builds: cdktf.booleanToTerraform(this._publicBuilds),
            remove_source_branch_after_merge: cdktf.booleanToTerraform(this._removeSourceBranchAfterMerge),
            repository_access_level: cdktf.stringToTerraform(this._repositoryAccessLevel),
            repository_storage: cdktf.stringToTerraform(this._repositoryStorage),
            request_access_enabled: cdktf.booleanToTerraform(this._requestAccessEnabled),
            requirements_access_level: cdktf.stringToTerraform(this._requirementsAccessLevel),
            resolve_outdated_diff_discussions: cdktf.booleanToTerraform(this._resolveOutdatedDiffDiscussions),
            security_and_compliance_access_level: cdktf.stringToTerraform(this._securityAndComplianceAccessLevel),
            shared_runners_enabled: cdktf.booleanToTerraform(this._sharedRunnersEnabled),
            skip_wait_for_default_branch_protection: cdktf.booleanToTerraform(this._skipWaitForDefaultBranchProtection),
            snippets_access_level: cdktf.stringToTerraform(this._snippetsAccessLevel),
            snippets_enabled: cdktf.booleanToTerraform(this._snippetsEnabled),
            squash_commit_template: cdktf.stringToTerraform(this._squashCommitTemplate),
            squash_option: cdktf.stringToTerraform(this._squashOption),
            suggestion_commit_message: cdktf.stringToTerraform(this._suggestionCommitMessage),
            tags: cdktf.listMapper(cdktf.stringToTerraform, false)(this._tags),
            template_name: cdktf.stringToTerraform(this._templateName),
            template_project_id: cdktf.numberToTerraform(this._templateProjectId),
            topics: cdktf.listMapper(cdktf.stringToTerraform, false)(this._topics),
            use_custom_template: cdktf.booleanToTerraform(this._useCustomTemplate),
            visibility_level: cdktf.stringToTerraform(this._visibilityLevel),
            wiki_access_level: cdktf.stringToTerraform(this._wikiAccessLevel),
            wiki_enabled: cdktf.booleanToTerraform(this._wikiEnabled),
            container_expiration_policy: projectContainerExpirationPolicyToTerraform(this._containerExpirationPolicy.internalValue),
            push_rules: projectPushRulesToTerraform(this._pushRules.internalValue),
        };
    }
}
exports.Project = Project;
_c = JSII_RTTI_SYMBOL_1;
Project[_c] = { fqn: "@cdktf/provider-gitlab.project.Project", version: "4.0.1" };
// =================
// STATIC PROPERTIES
// =================
Project.tfResourceType = "gitlab_project";
//# sourceMappingURL=data:application/json;base64,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