import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ProjectLevelMrApprovalsConfig extends cdktf.TerraformMetaArguments {
    /**
    * By default, users are able to edit the approval rules in merge requests. If set to true,
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project_level_mr_approvals#disable_overriding_approvers_per_merge_request ProjectLevelMrApprovals#disable_overriding_approvers_per_merge_request}
    */
    readonly disableOverridingApproversPerMergeRequest?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project_level_mr_approvals#id ProjectLevelMrApprovals#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Set to `true` if you want to allow merge request authors to self-approve merge requests. Authors
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project_level_mr_approvals#merge_requests_author_approval ProjectLevelMrApprovals#merge_requests_author_approval}
    */
    readonly mergeRequestsAuthorApproval?: boolean | cdktf.IResolvable;
    /**
    * Set to `true` if you want to prevent approval of merge requests by merge request committers.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project_level_mr_approvals#merge_requests_disable_committers_approval ProjectLevelMrApprovals#merge_requests_disable_committers_approval}
    */
    readonly mergeRequestsDisableCommittersApproval?: boolean | cdktf.IResolvable;
    /**
    * The ID of the project to change MR approval configuration.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project_level_mr_approvals#project_id ProjectLevelMrApprovals#project_id}
    */
    readonly projectId: number;
    /**
    * Set to `true` if you want to require authentication when approving a merge request.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project_level_mr_approvals#require_password_to_approve ProjectLevelMrApprovals#require_password_to_approve}
    */
    readonly requirePasswordToApprove?: boolean | cdktf.IResolvable;
    /**
    * Set to `true` if you want to remove all approvals in a merge request when new commits are pushed to its source branch. Default is `true`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project_level_mr_approvals#reset_approvals_on_push ProjectLevelMrApprovals#reset_approvals_on_push}
    */
    readonly resetApprovalsOnPush?: boolean | cdktf.IResolvable;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/gitlab/r/project_level_mr_approvals gitlab_project_level_mr_approvals}
*/
export declare class ProjectLevelMrApprovals extends cdktf.TerraformResource {
    static readonly tfResourceType = "gitlab_project_level_mr_approvals";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/gitlab/r/project_level_mr_approvals gitlab_project_level_mr_approvals} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ProjectLevelMrApprovalsConfig
    */
    constructor(scope: Construct, id: string, config: ProjectLevelMrApprovalsConfig);
    private _disableOverridingApproversPerMergeRequest?;
    get disableOverridingApproversPerMergeRequest(): boolean | cdktf.IResolvable;
    set disableOverridingApproversPerMergeRequest(value: boolean | cdktf.IResolvable);
    resetDisableOverridingApproversPerMergeRequest(): void;
    get disableOverridingApproversPerMergeRequestInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _mergeRequestsAuthorApproval?;
    get mergeRequestsAuthorApproval(): boolean | cdktf.IResolvable;
    set mergeRequestsAuthorApproval(value: boolean | cdktf.IResolvable);
    resetMergeRequestsAuthorApproval(): void;
    get mergeRequestsAuthorApprovalInput(): boolean | cdktf.IResolvable | undefined;
    private _mergeRequestsDisableCommittersApproval?;
    get mergeRequestsDisableCommittersApproval(): boolean | cdktf.IResolvable;
    set mergeRequestsDisableCommittersApproval(value: boolean | cdktf.IResolvable);
    resetMergeRequestsDisableCommittersApproval(): void;
    get mergeRequestsDisableCommittersApprovalInput(): boolean | cdktf.IResolvable | undefined;
    private _projectId?;
    get projectId(): number;
    set projectId(value: number);
    get projectIdInput(): number | undefined;
    private _requirePasswordToApprove?;
    get requirePasswordToApprove(): boolean | cdktf.IResolvable;
    set requirePasswordToApprove(value: boolean | cdktf.IResolvable);
    resetRequirePasswordToApprove(): void;
    get requirePasswordToApproveInput(): boolean | cdktf.IResolvable | undefined;
    private _resetApprovalsOnPush?;
    get resetApprovalsOnPush(): boolean | cdktf.IResolvable;
    set resetApprovalsOnPush(value: boolean | cdktf.IResolvable);
    resetResetApprovalsOnPush(): void;
    get resetApprovalsOnPushInput(): boolean | cdktf.IResolvable | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
