import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGitlabGroupsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/groups#id DataGitlabGroups#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Order the groups' list by `id`, `name`, `path`, or `similarity`. (Requires administrator privileges)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/groups#order_by DataGitlabGroups#order_by}
    */
    readonly orderBy?: string;
    /**
    * Search groups by name or path.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/groups#search DataGitlabGroups#search}
    */
    readonly search?: string;
    /**
    * Sort groups' list in asc or desc order. (Requires administrator privileges)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/groups#sort DataGitlabGroups#sort}
    */
    readonly sort?: string;
}
export interface DataGitlabGroupsGroups {
}
export declare function dataGitlabGroupsGroupsToTerraform(struct?: DataGitlabGroupsGroups): any;
export declare class DataGitlabGroupsGroupsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGitlabGroupsGroups | undefined;
    set internalValue(value: DataGitlabGroupsGroups | undefined);
    get defaultBranchProtection(): number;
    get description(): string;
    get fullName(): string;
    get fullPath(): string;
    get groupId(): number;
    get lfsEnabled(): cdktf.IResolvable;
    get name(): string;
    get parentId(): number;
    get path(): string;
    get preventForkingOutsideGroup(): cdktf.IResolvable;
    get requestAccessEnabled(): cdktf.IResolvable;
    get runnersToken(): string;
    get visibilityLevel(): string;
    get webUrl(): string;
}
export declare class DataGitlabGroupsGroupsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGitlabGroupsGroupsOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/gitlab/d/groups gitlab_groups}
*/
export declare class DataGitlabGroups extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "gitlab_groups";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/gitlab/d/groups gitlab_groups} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGitlabGroupsConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataGitlabGroupsConfig);
    private _groups;
    get groups(): DataGitlabGroupsGroupsList;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _orderBy?;
    get orderBy(): string;
    set orderBy(value: string);
    resetOrderBy(): void;
    get orderByInput(): string | undefined;
    private _search?;
    get search(): string;
    set search(value: string);
    resetSearch(): void;
    get searchInput(): string | undefined;
    private _sort?;
    get sort(): string;
    set sort(value: string);
    resetSort(): void;
    get sortInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
