import os

from setuptools import setup
from os import path

this_directory = path.abspath(path.dirname(__file__))
with open(path.join(this_directory, "README.md"), encoding="utf-8") as f:
    long_description = f.read()


# cython detection
try:
    from Cython.Build import cythonize

    CYTHON = False
except ImportError:
    CYTHON = False

SOURCE_PATH = "./mobio"

ext_modules = []


# if CYTHON:
#     ext_modules = cythonize([SOURCE_PATH + "/**/*.py"], compiler_directives=dict(always_allow_keywords=True))


def package_files(directory):
    paths = []
    for (p, directories, filenames) in os.walk(directory):
        for filename in filenames:
            paths.append(os.path.join("..", p, filename))
    return paths


setup(
    name="dyn_libs",
    version="0.2.4",
    description="Mobio Dynamic Fields",
    long_description_content_type="text/markdown",
    long_description=long_description,
    url="https://github.com/mobiovn",
    author="MOBIO",
    author_email="contact@mobio.vn",
    license="MIT",
    packages=[
        "mobio/libs/dynamic_field",
        "mobio/libs/dynamic_field/common",
        "mobio/libs/dynamic_field/controllers",
        "mobio/libs/dynamic_field/helpers",
        "mobio/libs/dynamic_field/helpers/field_helper",
        "mobio/libs/dynamic_field/models",
        "mobio/libs/dynamic_field/models/mongo",
        "mobio/libs/dynamic_field/models/elastic",
    ],
    install_requires=[
        "m-singleton==0.3",
        "pymongo==3.7.2",
        "requests==2.25.1",
        "unidecode==1.1.1",
        "elasticsearch==7.17.4",
    ],
    # package_data={'': extra_files},
    include_package_data=True,
    ext_modules=ext_modules,
    classifiers=[
        "Topic :: Software Development",
        "Development Status :: 4 - Beta",
        "Intended Audience :: Developers",
        "License :: OSI Approved :: MIT License",
        "Programming Language :: Python :: 3",
        "Programming Language :: Python :: 3.4",
        "Programming Language :: Python :: 3.5",
        "Programming Language :: Python :: 3.6",
        "Programming Language :: Python :: 3.7",
        "Programming Language :: Python :: 3.8",
        "Programming Language :: Python :: 3.9",
        "Programming Language :: Python :: Implementation :: CPython",
        "Programming Language :: Python :: Implementation :: PyPy",
    ],
)
