# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['the_python_bay', 'the_python_bay.tests']

package_data = \
{'': ['*']}

install_requires = \
['requests']

setup_kwargs = {
    'name': 'the-python-bay',
    'version': '1.1.7',
    'description': 'A python library for searching thepiratebay.org',
    'long_description': '[![title](https://img.shields.io/pypi/v/the-python-bay.svg)](https://pypi.org/project/the-python-bay)\n[![title](https://img.shields.io/pypi/pyversions/the-python-bay.svg)](https://pypi.org/project/the-python-bay)\n\n\n\n\n# the-python-bay\n\nPython library for searching thepiratebay.org\n\n## Install\n\n    pip install the-python-bay\n\n## Basic Usage\n\n```\nfrom the_python_bay import tpb\n\nresults = tpb.search("ubuntu")\n```\n\nThis will return the a list of instances of the `Torrent` class.\n\nSo you can then access the data like so:\n```\nfor torrent in results:\n    print(f"{torrent.name} - {torrent.magnet}")\n```\n\n## Full Docs\n### search\nThis can be used to search thepiratebay.org, it will return a list of instances of the `Torrent` class.\n```python\nfrom the_python_bay import tpb\nresults = tpb.search("ubuntu")\n```\n\n### top_movies\nCan be used to return the current top 100 movies on thepiratebay.org\n```python\nfrom the_python_bay import tpb\nresults = tpb.top_movies()\n```\n\n### top_tv\nCan be used to return the current top 100 tv on thepiratebay.org\n```python\nfrom the_python_bay import tpb\nresults = tpb.top_tv()\n```\n\n### Torrent\nThe `Torrent` class is the format the torrents are returned in, it has the following attributes:\n- `name`     the torrents name\n- `magent`   the torrents magnet link\n- `seeders`  number of seeders the torrent has\n- `username` the username of the torrents uploader\n- `status`   the users prominence status',
    'author': 'Philip Bell',
    'author_email': 'philhabell@gmail.com',
    'maintainer': 'Philip Bell',
    'maintainer_email': 'philhabell@gmail.com',
    'url': 'https://github.com/philhabell/the-python-bay',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.9,<4.0',
}


setup(**setup_kwargs)
