from ._dependency import *


class DPIRConfig:
    NUMBER_OF_INPUT_CHANNELS: int = 4
    NUMBER_OF_OUTPUT_CHANNELS: int = 3
    UPSCALE_RATIO: int = 1
    PATCH_SIZE = 256
    MAX_BATCH_SIZE = 8
    OPT_BATCH_SIZE = MAX_BATCH_SIZE // 2
    MIN_BATCH_SIZE = 1
    INPUT_OVERLAB_LENGTH = 5
    OUTPUT_OVERLAB_LENGTH = INPUT_OVERLAB_LENGTH

    INPUT_INIT_VECTOR_SHAPE = [NUMBER_OF_INPUT_CHANNELS, -1, -1]

    TRT_INPUT_PATCH_SHAPE = [NUMBER_OF_INPUT_CHANNELS, PATCH_SIZE, PATCH_SIZE]

    TRT_OUTPUT_PATCH_SHAPE = [
        NUMBER_OF_OUTPUT_CHANNELS,
        PATCH_SIZE * UPSCALE_RATIO,
        PATCH_SIZE * UPSCALE_RATIO,
    ]

    PATCHER_OUTPUT_OVERLAB_LENGTH = INPUT_OVERLAB_LENGTH * UPSCALE_RATIO

    PATCHER_INPUT_PATCH_SHAPE = (PATCH_SIZE, PATCH_SIZE, NUMBER_OF_OUTPUT_CHANNELS)

    PATCHER_OUTPUT_PATCH_SHAPE = (
        (PATCH_SIZE - PATCHER_OUTPUT_OVERLAB_LENGTH * 2) * UPSCALE_RATIO,
        (PATCH_SIZE - PATCHER_OUTPUT_OVERLAB_LENGTH * 2) * UPSCALE_RATIO,
        NUMBER_OF_OUTPUT_CHANNELS,
    )
