# Generated by Django 2.2.4 on 2019-09-19 12:44
import logging

from django.db import migrations, models
from django.db.migrations import RunPython

logger = logging.getLogger(__name__)


def save_natural_keys(apps, schema_editor):
    FormQuestion = apps.get_model("caluma_form", "FormQuestion")
    for fq in FormQuestion.objects.all():
        FormQuestion.objects.filter(form=fq.form, question=fq.question).delete()
        fq.pk = f"{fq.form_id}.{fq.question_id}"
        fq.save()


class Migration(migrations.Migration):

    dependencies = [("caluma_form", "0023_auto_20190729_1448")]

    operations = [
        migrations.AlterField(
            model_name="formquestion",
            name="id",
            field=models.CharField(
                max_length=255, primary_key=True, serialize=False, unique=True
            ),
        ),
        migrations.AlterField(
            model_name="historicalformquestion",
            name="id",
            field=models.CharField(db_index=True, max_length=255),
        ),
        RunPython(save_natural_keys, RunPython.noop),
    ]
