"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SageMakerInstanceType = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 *  Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
const cdk = require("aws-cdk-lib/core");
/**
 * Supported instance types for SageMaker instance-based production variants.
 */
class SageMakerInstanceType {
    /**
     * Builds an InstanceType from a given string or token (such as a CfnParameter).
     * @param instanceType An instance type as string
     * @returns A strongly typed InstanceType
     */
    static of(instanceType) {
        return new SageMakerInstanceType(instanceType);
    }
    constructor(instanceType) {
        if (cdk.Token.isUnresolved(instanceType) || instanceType.startsWith('ml.')) {
            this.instanceTypeIdentifier = instanceType;
        }
        else {
            throw new Error(`instance type must start with 'ml.'; (got ${instanceType})`);
        }
    }
    /**
     * Return the instance type as a string
     * @returns The instance type as a string
     */
    toString() {
        return this.instanceTypeIdentifier;
    }
}
_a = JSII_RTTI_SYMBOL_1;
SageMakerInstanceType[_a] = { fqn: "@cdklabs/generative-ai-cdk-constructs.SageMakerInstanceType", version: "0.0.89" };
/**
 * ml.c4.2xlarge
 */
SageMakerInstanceType.ML_C4_2XLARGE = SageMakerInstanceType.of('ml.c4.2xlarge');
/**
 * ml.c4.4xlarge
 */
SageMakerInstanceType.ML_C4_4XLARGE = SageMakerInstanceType.of('ml.c4.4xlarge');
/**
 * ml.c4.8xlarge
 */
SageMakerInstanceType.ML_C4_8XLARGE = SageMakerInstanceType.of('ml.c4.8xlarge');
/**
 * ml.c4.large
 */
SageMakerInstanceType.ML_C4_LARGE = SageMakerInstanceType.of('ml.c4.large');
/**
 * ml.c4.xlarge
 */
SageMakerInstanceType.ML_C4_XLARGE = SageMakerInstanceType.of('ml.c4.xlarge');
/**
 * ml.c5.18xlarge
 */
SageMakerInstanceType.ML_C5_18XLARGE = SageMakerInstanceType.of('ml.c5.18xlarge');
/**
 * ml.c5.2xlarge
 */
SageMakerInstanceType.ML_C5_2XLARGE = SageMakerInstanceType.of('ml.c5.2xlarge');
/**
 * ml.c5.4xlarge
 */
SageMakerInstanceType.ML_C5_4XLARGE = SageMakerInstanceType.of('ml.c5.4xlarge');
/**
 * ml.c5.9xlarge
 */
SageMakerInstanceType.ML_C5_9XLARGE = SageMakerInstanceType.of('ml.c5.9xlarge');
/**
 * ml.c5.large
 */
SageMakerInstanceType.ML_C5_LARGE = SageMakerInstanceType.of('ml.c5.large');
/**
 * ml.c5.xlarge
 */
SageMakerInstanceType.ML_C5_XLARGE = SageMakerInstanceType.of('ml.c5.xlarge');
/**
 * ml.c5d.18xlarge
 */
SageMakerInstanceType.ML_C5D_18XLARGE = SageMakerInstanceType.of('ml.c5d.18xlarge');
/**
 * ml.c5d.2xlarge
 */
SageMakerInstanceType.ML_C5D_2XLARGE = SageMakerInstanceType.of('ml.c5d.2xlarge');
/**
 * ml.c5d.4xlarge
 */
SageMakerInstanceType.ML_C5D_4XLARGE = SageMakerInstanceType.of('ml.c5d.4xlarge');
/**
 * ml.c5d.9xlarge
 */
SageMakerInstanceType.ML_C5D_9XLARGE = SageMakerInstanceType.of('ml.c5d.9xlarge');
/**
 * ml.c5d.large
 */
SageMakerInstanceType.ML_C5D_LARGE = SageMakerInstanceType.of('ml.c5d.large');
/**
 * ml.c5d.xlarge
 */
SageMakerInstanceType.ML_C5D_XLARGE = SageMakerInstanceType.of('ml.c5d.xlarge');
/**
 * ml.c6i.12xlarge
 */
SageMakerInstanceType.ML_C6I_12XLARGE = SageMakerInstanceType.of('ml.c6i.12xlarge');
/**
 * ml.c6i.16xlarge
 */
SageMakerInstanceType.ML_C6I_16XLARGE = SageMakerInstanceType.of('ml.c6i.16xlarge');
/**
 * ml.c6i.24xlarge
 */
SageMakerInstanceType.ML_C6I_24XLARGE = SageMakerInstanceType.of('ml.c6i.24xlarge');
/**
 * ml.c6i.2xlarge
 */
SageMakerInstanceType.ML_C6I_2XLARGE = SageMakerInstanceType.of('ml.c6i.2xlarge');
/**
 * ml.c6i.32xlarge
 */
SageMakerInstanceType.ML_C6I_32XLARGE = SageMakerInstanceType.of('ml.c6i.32xlarge');
/**
 * ml.c6i.4xlarge
 */
SageMakerInstanceType.ML_C6I_4XLARGE = SageMakerInstanceType.of('ml.c6i.4xlarge');
/**
 * ml.c6i.8xlarge
 */
SageMakerInstanceType.ML_C6I_8XLARGE = SageMakerInstanceType.of('ml.c6i.8xlarge');
/**
 * ml.c6i.large
 */
SageMakerInstanceType.ML_C6I_LARGE = SageMakerInstanceType.of('ml.c6i.large');
/**
 * ml.c6i.xlarge
 */
SageMakerInstanceType.ML_C6I_XLARGE = SageMakerInstanceType.of('ml.c6i.xlarge');
/**
 * ml.g4dn.12xlarge
 */
SageMakerInstanceType.ML_G4DN_12XLARGE = SageMakerInstanceType.of('ml.g4dn.12xlarge');
/**
 * ml.g4dn.16xlarge
 */
SageMakerInstanceType.ML_G4DN_16XLARGE = SageMakerInstanceType.of('ml.g4dn.16xlarge');
/**
 * ml.g4dn.2xlarge
 */
SageMakerInstanceType.ML_G4DN_2XLARGE = SageMakerInstanceType.of('ml.g4dn.2xlarge');
/**
 * ml.g4dn.4xlarge
 */
SageMakerInstanceType.ML_G4DN_4XLARGE = SageMakerInstanceType.of('ml.g4dn.4xlarge');
/**
 * ml.g4dn.8xlarge
 */
SageMakerInstanceType.ML_G4DN_8XLARGE = SageMakerInstanceType.of('ml.g4dn.8xlarge');
/**
 * ml.g4dn.xlarge
 */
SageMakerInstanceType.ML_G4DN_XLARGE = SageMakerInstanceType.of('ml.g4dn.xlarge');
/**
 * ml.g5.12xlarge
 */
SageMakerInstanceType.ML_G5_12XLARGE = SageMakerInstanceType.of('ml.g5.12xlarge');
/**
 * ml.g5.16xlarge
 */
SageMakerInstanceType.ML_G5_16XLARGE = SageMakerInstanceType.of('ml.g5.16xlarge');
/**
 * ml.g5.24xlarge
 */
SageMakerInstanceType.ML_G5_24XLARGE = SageMakerInstanceType.of('ml.g5.24xlarge');
/**
 * ml.g5.2xlarge
 */
SageMakerInstanceType.ML_G5_2XLARGE = SageMakerInstanceType.of('ml.g5.2xlarge');
/**
 * ml.g5.48xlarge
 */
SageMakerInstanceType.ML_G5_48XLARGE = SageMakerInstanceType.of('ml.g5.48xlarge');
/**
 * ml.g5.4xlarge
 */
SageMakerInstanceType.ML_G5_4XLARGE = SageMakerInstanceType.of('ml.g5.4xlarge');
/**
 * ml.g5.8xlarge
 */
SageMakerInstanceType.ML_G5_8XLARGE = SageMakerInstanceType.of('ml.g5.8xlarge');
/**
 * ml.g5.xlarge
 */
SageMakerInstanceType.ML_G5_XLARGE = SageMakerInstanceType.of('ml.g5.xlarge');
/**
 * ml.inf1.24xlarge
 */
SageMakerInstanceType.ML_INF1_24XLARGE = SageMakerInstanceType.of('ml.inf1.24xlarge');
/**
 * ml.inf1.2xlarge
 */
SageMakerInstanceType.ML_INF1_2XLARGE = SageMakerInstanceType.of('ml.inf1.2xlarge');
/**
 * ml.inf1.6xlarge
 */
SageMakerInstanceType.ML_INF1_6XLARGE = SageMakerInstanceType.of('ml.inf1.6xlarge');
/**
 * ml.inf1.xlarge
 */
SageMakerInstanceType.ML_INF1_XLARGE = SageMakerInstanceType.of('ml.inf1.xlarge');
/**
 * ml.inf2.xlarge
 */
SageMakerInstanceType.ML_INF2_XLARGE = SageMakerInstanceType.of('ml.inf2.xlarge');
/**
 * ml.inf2.8xlarge
 */
SageMakerInstanceType.ML_INF2_8XLARGE = SageMakerInstanceType.of('ml.inf2.8xlarge');
/**
 * ml.inf2.24xlarge
 */
SageMakerInstanceType.ML_INF2_24XLARGE = SageMakerInstanceType.of('ml.inf2.24xlarge');
/**
 * ml.inf2.48xlarge
 */
SageMakerInstanceType.ML_INF2_48XLARGE = SageMakerInstanceType.of('ml.inf2.48xlarge');
/**
 * ml.m4.10xlarge
 */
SageMakerInstanceType.ML_M4_10XLARGE = SageMakerInstanceType.of('ml.m4.10xlarge');
/**
 * ml.m4.16xlarge
 */
SageMakerInstanceType.ML_M4_16XLARGE = SageMakerInstanceType.of('ml.m4.16xlarge');
/**
 * ml.m4.2xlarge
 */
SageMakerInstanceType.ML_M4_2XLARGE = SageMakerInstanceType.of('ml.m4.2xlarge');
/**
 * ml.m4.4xlarge
 */
SageMakerInstanceType.ML_M4_4XLARGE = SageMakerInstanceType.of('ml.m4.4xlarge');
/**
 * ml.m4.xlarge
 */
SageMakerInstanceType.ML_M4_XLARGE = SageMakerInstanceType.of('ml.m4.xlarge');
/**
 * ml.m5.12xlarge
 */
SageMakerInstanceType.ML_M5_12XLARGE = SageMakerInstanceType.of('ml.m5.12xlarge');
/**
 * ml.m5.24xlarge
 */
SageMakerInstanceType.ML_M5_24XLARGE = SageMakerInstanceType.of('ml.m5.24xlarge');
/**
 * ml.m5.2xlarge
 */
SageMakerInstanceType.ML_M5_2XLARGE = SageMakerInstanceType.of('ml.m5.2xlarge');
/**
 * ml.m5.4xlarge
 */
SageMakerInstanceType.ML_M5_4XLARGE = SageMakerInstanceType.of('ml.m5.4xlarge');
/**
 * ml.m5.large
 */
SageMakerInstanceType.ML_M5_LARGE = SageMakerInstanceType.of('ml.m5.large');
/**
 * ml.m5.xlarge
 */
SageMakerInstanceType.ML_M5_XLARGE = SageMakerInstanceType.of('ml.m5.xlarge');
/**
 * ml.m5d.12xlarge
 */
SageMakerInstanceType.ML_M5D_12XLARGE = SageMakerInstanceType.of('ml.m5d.12xlarge');
/**
 * ml.m5d.24xlarge
 */
SageMakerInstanceType.ML_M5D_24XLARGE = SageMakerInstanceType.of('ml.m5d.24xlarge');
/**
 * ml.m5d.2xlarge
 */
SageMakerInstanceType.ML_M5D_2XLARGE = SageMakerInstanceType.of('ml.m5d.2xlarge');
/**
 * ml.m5d.4xlarge
 */
SageMakerInstanceType.ML_M5D_4XLARGE = SageMakerInstanceType.of('ml.m5d.4xlarge');
/**
 * ml.m5d.large
 */
SageMakerInstanceType.ML_M5D_LARGE = SageMakerInstanceType.of('ml.m5d.large');
/**
 * ml.m5d.xlarge
 */
SageMakerInstanceType.ML_M5D_XLARGE = SageMakerInstanceType.of('ml.m5d.xlarge');
/**
 * ml.p2.16xlarge
 */
SageMakerInstanceType.ML_P2_16XLARGE = SageMakerInstanceType.of('ml.p2.16xlarge');
/**
 * ml.p2.8xlarge
 */
SageMakerInstanceType.ML_P2_8XLARGE = SageMakerInstanceType.of('ml.p2.8xlarge');
/**
 * ml.p2.xlarge
 */
SageMakerInstanceType.ML_P2_XLARGE = SageMakerInstanceType.of('ml.p2.xlarge');
/**
 * ml.p3.16xlarge
 */
SageMakerInstanceType.ML_P3_16XLARGE = SageMakerInstanceType.of('ml.p3.16xlarge');
/**
 * ml.p3.2xlarge
 */
SageMakerInstanceType.ML_P3_2XLARGE = SageMakerInstanceType.of('ml.p3.2xlarge');
/**
 * ml.p3.8xlarge
 */
SageMakerInstanceType.ML_P3_8XLARGE = SageMakerInstanceType.of('ml.p3.8xlarge');
/**
 * ml.p4d.24xlarge
 */
SageMakerInstanceType.ML_P4D_24XLARGE = SageMakerInstanceType.of('ml.p4d.24xlarge');
/**
 * ml.r5.12xlarge
 */
SageMakerInstanceType.ML_R5_12XLARGE = SageMakerInstanceType.of('ml.r5.12xlarge');
/**
 * ml.r5.24xlarge
 */
SageMakerInstanceType.ML_R5_24XLARGE = SageMakerInstanceType.of('ml.r5.24xlarge');
/**
 * ml.r5.2xlarge
 */
SageMakerInstanceType.ML_R5_2XLARGE = SageMakerInstanceType.of('ml.r5.2xlarge');
/**
 * ml.r5.4xlarge
 */
SageMakerInstanceType.ML_R5_4XLARGE = SageMakerInstanceType.of('ml.r5.4xlarge');
/**
 * ml.r5.large
 */
SageMakerInstanceType.ML_R5_LARGE = SageMakerInstanceType.of('ml.r5.large');
/**
 * ml.r5.xlarge
 */
SageMakerInstanceType.ML_R5_XLARGE = SageMakerInstanceType.of('ml.r5.xlarge');
/**
 * ml.r5d.12xlarge
 */
SageMakerInstanceType.ML_R5D_12XLARGE = SageMakerInstanceType.of('ml.r5d.12xlarge');
/**
 * ml.r5d.24xlarge
 */
SageMakerInstanceType.ML_R5D_24XLARGE = SageMakerInstanceType.of('ml.r5d.24xlarge');
/**
 * ml.r5d.2xlarge
 */
SageMakerInstanceType.ML_R5D_2XLARGE = SageMakerInstanceType.of('ml.r5d.2xlarge');
/**
 * ml.r5d.4xlarge
 */
SageMakerInstanceType.ML_R5D_4XLARGE = SageMakerInstanceType.of('ml.r5d.4xlarge');
/**
 * ml.r5d.large
 */
SageMakerInstanceType.ML_R5D_LARGE = SageMakerInstanceType.of('ml.r5d.large');
/**
 * ml.r5d.xlarge
 */
SageMakerInstanceType.ML_R5D_XLARGE = SageMakerInstanceType.of('ml.r5d.xlarge');
/**
 * ml.t2.2xlarge
 */
SageMakerInstanceType.ML_T2_2XLARGE = SageMakerInstanceType.of('ml.t2.2xlarge');
/**
 * ml.t2.large
 */
SageMakerInstanceType.ML_T2_LARGE = SageMakerInstanceType.of('ml.t2.large');
/**
 * ml.t2.medium
 */
SageMakerInstanceType.ML_T2_MEDIUM = SageMakerInstanceType.of('ml.t2.medium');
/**
 * ml.t2.xlarge
 */
SageMakerInstanceType.ML_T2_XLARGE = SageMakerInstanceType.of('ml.t2.xlarge');
exports.SageMakerInstanceType = SageMakerInstanceType;
//# sourceMappingURL=data:application/json;base64,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