/**
 *  Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
/**
 * Supported instance types for SageMaker instance-based production variants.
 */
export declare class SageMakerInstanceType {
    /**
     * ml.c4.2xlarge
     */
    static readonly ML_C4_2XLARGE: SageMakerInstanceType;
    /**
     * ml.c4.4xlarge
     */
    static readonly ML_C4_4XLARGE: SageMakerInstanceType;
    /**
     * ml.c4.8xlarge
     */
    static readonly ML_C4_8XLARGE: SageMakerInstanceType;
    /**
     * ml.c4.large
     */
    static readonly ML_C4_LARGE: SageMakerInstanceType;
    /**
     * ml.c4.xlarge
     */
    static readonly ML_C4_XLARGE: SageMakerInstanceType;
    /**
     * ml.c5.18xlarge
     */
    static readonly ML_C5_18XLARGE: SageMakerInstanceType;
    /**
     * ml.c5.2xlarge
     */
    static readonly ML_C5_2XLARGE: SageMakerInstanceType;
    /**
     * ml.c5.4xlarge
     */
    static readonly ML_C5_4XLARGE: SageMakerInstanceType;
    /**
     * ml.c5.9xlarge
     */
    static readonly ML_C5_9XLARGE: SageMakerInstanceType;
    /**
     * ml.c5.large
     */
    static readonly ML_C5_LARGE: SageMakerInstanceType;
    /**
     * ml.c5.xlarge
     */
    static readonly ML_C5_XLARGE: SageMakerInstanceType;
    /**
     * ml.c5d.18xlarge
     */
    static readonly ML_C5D_18XLARGE: SageMakerInstanceType;
    /**
     * ml.c5d.2xlarge
     */
    static readonly ML_C5D_2XLARGE: SageMakerInstanceType;
    /**
     * ml.c5d.4xlarge
     */
    static readonly ML_C5D_4XLARGE: SageMakerInstanceType;
    /**
     * ml.c5d.9xlarge
     */
    static readonly ML_C5D_9XLARGE: SageMakerInstanceType;
    /**
     * ml.c5d.large
     */
    static readonly ML_C5D_LARGE: SageMakerInstanceType;
    /**
     * ml.c5d.xlarge
     */
    static readonly ML_C5D_XLARGE: SageMakerInstanceType;
    /**
     * ml.c6i.12xlarge
     */
    static readonly ML_C6I_12XLARGE: SageMakerInstanceType;
    /**
     * ml.c6i.16xlarge
     */
    static readonly ML_C6I_16XLARGE: SageMakerInstanceType;
    /**
     * ml.c6i.24xlarge
     */
    static readonly ML_C6I_24XLARGE: SageMakerInstanceType;
    /**
     * ml.c6i.2xlarge
     */
    static readonly ML_C6I_2XLARGE: SageMakerInstanceType;
    /**
     * ml.c6i.32xlarge
     */
    static readonly ML_C6I_32XLARGE: SageMakerInstanceType;
    /**
     * ml.c6i.4xlarge
     */
    static readonly ML_C6I_4XLARGE: SageMakerInstanceType;
    /**
     * ml.c6i.8xlarge
     */
    static readonly ML_C6I_8XLARGE: SageMakerInstanceType;
    /**
     * ml.c6i.large
     */
    static readonly ML_C6I_LARGE: SageMakerInstanceType;
    /**
     * ml.c6i.xlarge
     */
    static readonly ML_C6I_XLARGE: SageMakerInstanceType;
    /**
     * ml.g4dn.12xlarge
     */
    static readonly ML_G4DN_12XLARGE: SageMakerInstanceType;
    /**
     * ml.g4dn.16xlarge
     */
    static readonly ML_G4DN_16XLARGE: SageMakerInstanceType;
    /**
     * ml.g4dn.2xlarge
     */
    static readonly ML_G4DN_2XLARGE: SageMakerInstanceType;
    /**
     * ml.g4dn.4xlarge
     */
    static readonly ML_G4DN_4XLARGE: SageMakerInstanceType;
    /**
     * ml.g4dn.8xlarge
     */
    static readonly ML_G4DN_8XLARGE: SageMakerInstanceType;
    /**
     * ml.g4dn.xlarge
     */
    static readonly ML_G4DN_XLARGE: SageMakerInstanceType;
    /**
     * ml.g5.12xlarge
     */
    static readonly ML_G5_12XLARGE: SageMakerInstanceType;
    /**
     * ml.g5.16xlarge
     */
    static readonly ML_G5_16XLARGE: SageMakerInstanceType;
    /**
     * ml.g5.24xlarge
     */
    static readonly ML_G5_24XLARGE: SageMakerInstanceType;
    /**
     * ml.g5.2xlarge
     */
    static readonly ML_G5_2XLARGE: SageMakerInstanceType;
    /**
     * ml.g5.48xlarge
     */
    static readonly ML_G5_48XLARGE: SageMakerInstanceType;
    /**
     * ml.g5.4xlarge
     */
    static readonly ML_G5_4XLARGE: SageMakerInstanceType;
    /**
     * ml.g5.8xlarge
     */
    static readonly ML_G5_8XLARGE: SageMakerInstanceType;
    /**
     * ml.g5.xlarge
     */
    static readonly ML_G5_XLARGE: SageMakerInstanceType;
    /**
     * ml.inf1.24xlarge
     */
    static readonly ML_INF1_24XLARGE: SageMakerInstanceType;
    /**
     * ml.inf1.2xlarge
     */
    static readonly ML_INF1_2XLARGE: SageMakerInstanceType;
    /**
     * ml.inf1.6xlarge
     */
    static readonly ML_INF1_6XLARGE: SageMakerInstanceType;
    /**
     * ml.inf1.xlarge
     */
    static readonly ML_INF1_XLARGE: SageMakerInstanceType;
    /**
     * ml.inf2.xlarge
     */
    static readonly ML_INF2_XLARGE: SageMakerInstanceType;
    /**
     * ml.inf2.8xlarge
     */
    static readonly ML_INF2_8XLARGE: SageMakerInstanceType;
    /**
     * ml.inf2.24xlarge
     */
    static readonly ML_INF2_24XLARGE: SageMakerInstanceType;
    /**
     * ml.inf2.48xlarge
     */
    static readonly ML_INF2_48XLARGE: SageMakerInstanceType;
    /**
     * ml.m4.10xlarge
     */
    static readonly ML_M4_10XLARGE: SageMakerInstanceType;
    /**
     * ml.m4.16xlarge
     */
    static readonly ML_M4_16XLARGE: SageMakerInstanceType;
    /**
     * ml.m4.2xlarge
     */
    static readonly ML_M4_2XLARGE: SageMakerInstanceType;
    /**
     * ml.m4.4xlarge
     */
    static readonly ML_M4_4XLARGE: SageMakerInstanceType;
    /**
     * ml.m4.xlarge
     */
    static readonly ML_M4_XLARGE: SageMakerInstanceType;
    /**
     * ml.m5.12xlarge
     */
    static readonly ML_M5_12XLARGE: SageMakerInstanceType;
    /**
     * ml.m5.24xlarge
     */
    static readonly ML_M5_24XLARGE: SageMakerInstanceType;
    /**
     * ml.m5.2xlarge
     */
    static readonly ML_M5_2XLARGE: SageMakerInstanceType;
    /**
     * ml.m5.4xlarge
     */
    static readonly ML_M5_4XLARGE: SageMakerInstanceType;
    /**
     * ml.m5.large
     */
    static readonly ML_M5_LARGE: SageMakerInstanceType;
    /**
     * ml.m5.xlarge
     */
    static readonly ML_M5_XLARGE: SageMakerInstanceType;
    /**
     * ml.m5d.12xlarge
     */
    static readonly ML_M5D_12XLARGE: SageMakerInstanceType;
    /**
     * ml.m5d.24xlarge
     */
    static readonly ML_M5D_24XLARGE: SageMakerInstanceType;
    /**
     * ml.m5d.2xlarge
     */
    static readonly ML_M5D_2XLARGE: SageMakerInstanceType;
    /**
     * ml.m5d.4xlarge
     */
    static readonly ML_M5D_4XLARGE: SageMakerInstanceType;
    /**
     * ml.m5d.large
     */
    static readonly ML_M5D_LARGE: SageMakerInstanceType;
    /**
     * ml.m5d.xlarge
     */
    static readonly ML_M5D_XLARGE: SageMakerInstanceType;
    /**
     * ml.p2.16xlarge
     */
    static readonly ML_P2_16XLARGE: SageMakerInstanceType;
    /**
     * ml.p2.8xlarge
     */
    static readonly ML_P2_8XLARGE: SageMakerInstanceType;
    /**
     * ml.p2.xlarge
     */
    static readonly ML_P2_XLARGE: SageMakerInstanceType;
    /**
     * ml.p3.16xlarge
     */
    static readonly ML_P3_16XLARGE: SageMakerInstanceType;
    /**
     * ml.p3.2xlarge
     */
    static readonly ML_P3_2XLARGE: SageMakerInstanceType;
    /**
     * ml.p3.8xlarge
     */
    static readonly ML_P3_8XLARGE: SageMakerInstanceType;
    /**
     * ml.p4d.24xlarge
     */
    static readonly ML_P4D_24XLARGE: SageMakerInstanceType;
    /**
     * ml.r5.12xlarge
     */
    static readonly ML_R5_12XLARGE: SageMakerInstanceType;
    /**
     * ml.r5.24xlarge
     */
    static readonly ML_R5_24XLARGE: SageMakerInstanceType;
    /**
     * ml.r5.2xlarge
     */
    static readonly ML_R5_2XLARGE: SageMakerInstanceType;
    /**
     * ml.r5.4xlarge
     */
    static readonly ML_R5_4XLARGE: SageMakerInstanceType;
    /**
     * ml.r5.large
     */
    static readonly ML_R5_LARGE: SageMakerInstanceType;
    /**
     * ml.r5.xlarge
     */
    static readonly ML_R5_XLARGE: SageMakerInstanceType;
    /**
     * ml.r5d.12xlarge
     */
    static readonly ML_R5D_12XLARGE: SageMakerInstanceType;
    /**
     * ml.r5d.24xlarge
     */
    static readonly ML_R5D_24XLARGE: SageMakerInstanceType;
    /**
     * ml.r5d.2xlarge
     */
    static readonly ML_R5D_2XLARGE: SageMakerInstanceType;
    /**
     * ml.r5d.4xlarge
     */
    static readonly ML_R5D_4XLARGE: SageMakerInstanceType;
    /**
     * ml.r5d.large
     */
    static readonly ML_R5D_LARGE: SageMakerInstanceType;
    /**
     * ml.r5d.xlarge
     */
    static readonly ML_R5D_XLARGE: SageMakerInstanceType;
    /**
     * ml.t2.2xlarge
     */
    static readonly ML_T2_2XLARGE: SageMakerInstanceType;
    /**
     * ml.t2.large
     */
    static readonly ML_T2_LARGE: SageMakerInstanceType;
    /**
     * ml.t2.medium
     */
    static readonly ML_T2_MEDIUM: SageMakerInstanceType;
    /**
     * ml.t2.xlarge
     */
    static readonly ML_T2_XLARGE: SageMakerInstanceType;
    /**
     * Builds an InstanceType from a given string or token (such as a CfnParameter).
     * @param instanceType An instance type as string
     * @returns A strongly typed InstanceType
     */
    static of(instanceType: string): SageMakerInstanceType;
    private readonly instanceTypeIdentifier;
    constructor(instanceType: string);
    /**
     * Return the instance type as a string
     * @returns The instance type as a string
     */
    toString(): string;
}
