"use strict";
/**
 *  Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.JumpStartConstants = void 0;
class JumpStartConstants {
}
/*
https://github.com/aws/sagemaker-python-sdk/blob/8462f1a1975da59304da4441aea956a43deec380/src/sagemaker/jumpstart/constants.py
*/
JumpStartConstants.JUMPSTART_LAUNCHED_REGIONS = {
    'us-west-2': {
        contentBucket: 'jumpstart-cache-prod-us-west-2',
        gatedContentBucket: 'jumpstart-private-cache-prod-us-west-2',
    },
    'us-east-1': {
        contentBucket: 'jumpstart-cache-prod-us-east-1',
        gatedContentBucket: 'jumpstart-private-cache-prod-us-east-1',
    },
    'us-east-2': {
        contentBucket: 'jumpstart-cache-prod-us-east-2',
        gatedContentBucket: 'jumpstart-private-cache-prod-us-east-2',
    },
    'eu-west-1': {
        contentBucket: 'jumpstart-cache-prod-eu-west-1',
        gatedContentBucket: 'jumpstart-private-cache-prod-eu-west-1',
    },
    'eu-central-1': {
        contentBucket: 'jumpstart-cache-prod-eu-central-1',
        gatedContentBucket: 'jumpstart-private-cache-prod-eu-central-1',
    },
    'eu-north-1': {
        contentBucket: 'jumpstart-cache-prod-eu-north-1',
        gatedContentBucket: 'jumpstart-private-cache-prod-eu-north-1',
    },
    'me-south-1': {
        contentBucket: 'jumpstart-cache-prod-me-south-1',
        gatedContentBucket: 'jumpstart-private-cache-prod-me-south-1',
    },
    'ap-south-1': {
        contentBucket: 'jumpstart-cache-prod-ap-south-1',
        gatedContentBucket: 'jumpstart-private-cache-prod-ap-south-1',
    },
    'eu-west-3': {
        contentBucket: 'jumpstart-cache-prod-eu-west-3',
        gatedContentBucket: 'jumpstart-private-cache-prod-eu-west-3',
    },
    'af-south-1': {
        contentBucket: 'jumpstart-cache-prod-af-south-1',
        gatedContentBucket: 'jumpstart-private-cache-prod-af-south-1',
    },
    'sa-east-1': {
        contentBucket: 'jumpstart-cache-prod-sa-east-1',
        gatedContentBucket: 'jumpstart-private-cache-prod-sa-east-1',
    },
    'ap-east-1': {
        contentBucket: 'jumpstart-cache-prod-ap-east-1',
        gatedContentBucket: 'jumpstart-private-cache-prod-ap-east-1',
    },
    'ap-northeast-2': {
        contentBucket: 'jumpstart-cache-prod-ap-northeast-2',
        gatedContentBucket: 'jumpstart-private-cache-prod-ap-northeast-2',
    },
    'eu-west-2': {
        contentBucket: 'jumpstart-cache-prod-eu-west-2',
        gatedContentBucket: 'jumpstart-private-cache-prod-eu-west-2',
    },
    'eu-south-1': {
        contentBucket: 'jumpstart-cache-prod-eu-south-1',
        gatedContentBucket: 'jumpstart-private-cache-prod-eu-south-1',
    },
    'ap-northeast-1': {
        contentBucket: 'jumpstart-cache-prod-ap-northeast-1',
        gatedContentBucket: 'jumpstart-private-cache-prod-ap-northeast-1',
    },
    'us-west-1': {
        contentBucket: 'jumpstart-cache-prod-us-west-1',
        gatedContentBucket: 'jumpstart-private-cache-prod-us-west-1',
    },
    'ap-southeast-1': {
        contentBucket: 'jumpstart-cache-prod-ap-southeast-1',
        gatedContentBucket: 'jumpstart-private-cache-prod-ap-southeast-1',
    },
    'ap-southeast-2': {
        contentBucket: 'jumpstart-cache-prod-ap-southeast-2',
        gatedContentBucket: 'jumpstart-private-cache-prod-ap-southeast-2',
    },
    'ca-central-1': {
        contentBucket: 'jumpstart-cache-prod-ca-central-1',
        gatedContentBucket: 'jumpstart-private-cache-prod-ca-central-1',
    },
    'cn-north-1': {
        contentBucket: 'jumpstart-cache-prod-cn-north-1',
    },
};
JumpStartConstants.JUMPSTART_DEFAULT_MANIFEST_FILE_S3_KEY = 'models_manifest.json';
exports.JumpStartConstants = JumpStartConstants;
//# sourceMappingURL=data:application/json;base64,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