/**
 *  Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
import * as iam from 'aws-cdk-lib/aws-iam';
import * as sagemaker from 'aws-cdk-lib/aws-sagemaker';
import { Construct } from 'constructs';
import { JumpStartModel } from './jumpstart-model';
import { SageMakerEndpointBase } from './sagemaker-endpoint-base';
import { SageMakerInstanceType } from './sagemaker-instance-type';
export interface IJumpStartSageMakerEndpointProps {
    model: JumpStartModel;
    endpointName?: string;
    instanceType?: SageMakerInstanceType;
    instanceCount?: number;
    role?: iam.Role;
    environment?: {
        [key: string]: string;
    };
    startupHealthCheckTimeoutInSeconds?: number;
}
/**
 * @summary The JumpStartSageMakerEndpoint class.
 */
export declare class JumpStartSageMakerEndpoint extends SageMakerEndpointBase {
    readonly grantPrincipal: iam.IPrincipal;
    readonly endpointArn: string;
    readonly cfnModel: sagemaker.CfnModel;
    readonly cfnEndpoint: sagemaker.CfnEndpoint;
    readonly cfnEndpointConfig: sagemaker.CfnEndpointConfig;
    readonly model: JumpStartModel;
    readonly instanceType?: SageMakerInstanceType;
    readonly instanceCount: number;
    readonly role: iam.Role;
    private readonly region;
    private readonly spec;
    private readonly startupHealthCheckTimeoutInSeconds;
    private readonly environment?;
    constructor(scope: Construct, id: string, props: IJumpStartSageMakerEndpointProps);
    addToRolePolicy(statement: iam.PolicyStatement): void;
    grantInvoke(grantee: iam.IGrantable): iam.Grant;
    private verifyInstanceType;
    private buildEnvironment;
    private getModelFromArtifact;
    private getModelFromPackage;
}
