"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DeepLearningContainerImage = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 *  Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
const aws_cdk_lib_1 = require("aws-cdk-lib");
const ecr = require("aws-cdk-lib/aws-ecr");
const region_info_1 = require("aws-cdk-lib/region-info");
const container_image_1 = require("./container-image");
class DeepLearningContainerImage extends container_image_1.ContainerImage {
    static fromDeepLearningContainerImage(repositoryName, tag, accountId) {
        return new DeepLearningContainerImage(repositoryName, tag, accountId);
    }
    constructor(repositoryName, tag, accountId) {
        super();
        this.repositoryName = repositoryName;
        this.tag = tag;
        this.accountId = accountId;
    }
    bind(scope, grantable) {
        const accountId = this.accountId ??
            aws_cdk_lib_1.Stack.of(scope).regionalFact(region_info_1.FactName.DLC_REPOSITORY_ACCOUNT);
        const repository = ecr.Repository.fromRepositoryAttributes(scope, 'DeepLearningContainerRepository', {
            repositoryName: this.repositoryName,
            repositoryArn: ecr.Repository.arnForLocalRepository(this.repositoryName, scope, accountId),
        });
        repository.grantPull(grantable);
        return { imageName: repository.repositoryUri + ':' + this.tag };
    }
}
_a = DeepLearningContainerImage, _b = JSII_RTTI_SYMBOL_1;
DeepLearningContainerImage[_b] = { fqn: "@cdklabs/generative-ai-cdk-constructs.DeepLearningContainerImage", version: "0.0.89" };
DeepLearningContainerImage.DJL_INFERENCE_0_19_0_DEEPSPEED0_7_3_CU113 = _a.fromDeepLearningContainerImage('djl-inference', '0.19.0-deepspeed0.7.3-cu113');
DeepLearningContainerImage.DJL_INFERENCE_0_20_0_DEEPSPEED0_7_5_CU116 = _a.fromDeepLearningContainerImage('djl-inference', '0.20.0-deepspeed0.7.5-cu116');
DeepLearningContainerImage.DJL_INFERENCE_0_21_0_DEEPSPEED0_8_0_CU117 = _a.fromDeepLearningContainerImage('djl-inference', '0.21.0-deepspeed0.8.0-cu117');
DeepLearningContainerImage.DJL_INFERENCE_0_21_0_DEEPSPEED0_8_3_CU117 = _a.fromDeepLearningContainerImage('djl-inference', '0.21.0-deepspeed0.8.3-cu117');
DeepLearningContainerImage.DJL_INFERENCE_0_21_0_FASTERTRANSFORMER5_3_0_CU117 = _a.fromDeepLearningContainerImage('djl-inference', '0.21.0-fastertransformer5.3.0-cu117');
DeepLearningContainerImage.DJL_INFERENCE_0_22_1_DEEPSPEED0_8_3_CU118 = _a.fromDeepLearningContainerImage('djl-inference', '0.22.1-deepspeed0.8.3-cu118');
DeepLearningContainerImage.DJL_INFERENCE_0_22_1_DEEPSPEED0_9_2_CU118 = _a.fromDeepLearningContainerImage('djl-inference', '0.22.1-deepspeed0.9.2-cu118');
DeepLearningContainerImage.DJL_INFERENCE_0_22_1_FASTERTRANSFORMER5_3_0_CU118 = _a.fromDeepLearningContainerImage('djl-inference', '0.22.1-fastertransformer5.3.0-cu118');
DeepLearningContainerImage.DJL_INFERENCE_0_22_1_NEURONX_SDK2_10_0 = _a.fromDeepLearningContainerImage('djl-inference', '0.22.1-neuronx-sdk2.10.0');
DeepLearningContainerImage.DJL_INFERENCE_0_22_1_NEURONX_SDK2_9_0 = _a.fromDeepLearningContainerImage('djl-inference', '0.22.1-neuronx-sdk2.9.0');
DeepLearningContainerImage.DJL_INFERENCE_0_23_0_DEEPSPEED0_9_5_CU118 = _a.fromDeepLearningContainerImage('djl-inference', '0.23.0-deepspeed0.9.5-cu118');
DeepLearningContainerImage.DJL_INFERENCE_0_23_0_FASTERTRANSFORMER5_3_0_CU118 = _a.fromDeepLearningContainerImage('djl-inference', '0.23.0-fastertransformer5.3.0-cu118');
DeepLearningContainerImage.DJL_INFERENCE_0_23_0_NEURONX_SDK2_12_0 = _a.fromDeepLearningContainerImage('djl-inference', '0.23.0-neuronx-sdk2.12.0');
DeepLearningContainerImage.DJL_INFERENCE_0_24_0_DEEPSPEED0_10_0_CU118 = _a.fromDeepLearningContainerImage('djl-inference', '0.24.0-deepspeed0.10.0-cu118');
DeepLearningContainerImage.DJL_INFERENCE_0_24_0_FASTERTRANSFORMER5_3_0_CU118 = _a.fromDeepLearningContainerImage('djl-inference', '0.24.0-fastertransformer5.3.0-cu118');
DeepLearningContainerImage.DJL_INFERENCE_0_24_0_NEURONX_SDK2_14_1 = _a.fromDeepLearningContainerImage('djl-inference', '0.24.0-neuronx-sdk2.14.1');
DeepLearningContainerImage.DJL_INFERENCE_0_25_0_DEEPSPEED0_11_0_CU118 = _a.fromDeepLearningContainerImage('djl-inference', '0.25.0-deepspeed0.11.0-cu118');
DeepLearningContainerImage.DJL_INFERENCE_0_25_0_NEURONX_SDK2_15_0 = _a.fromDeepLearningContainerImage('djl-inference', '0.25.0-neuronx-sdk2.15.0');
DeepLearningContainerImage.HUGGINGFACE_PYTORCH_INFERENCE_1_10_2_TRANSFORMERS4_17_0_CPU_PY38_UBUNTU20_04 = _a.fromDeepLearningContainerImage('huggingface-pytorch-inference', '1.10.2-transformers4.17.0-cpu-py38-ubuntu20.04');
DeepLearningContainerImage.HUGGINGFACE_PYTORCH_INFERENCE_1_10_2_TRANSFORMERS4_17_0_GPU_PY38_CU113_UBUNTU20_04 = _a.fromDeepLearningContainerImage('huggingface-pytorch-inference', '1.10.2-transformers4.17.0-gpu-py38-cu113-ubuntu20.04');
DeepLearningContainerImage.HUGGINGFACE_PYTORCH_INFERENCE_1_13_1_TRANSFORMERS4_26_0_CPU_PY39_UBUNTU20_04 = _a.fromDeepLearningContainerImage('huggingface-pytorch-inference', '1.13.1-transformers4.26.0-cpu-py39-ubuntu20.04');
DeepLearningContainerImage.HUGGINGFACE_PYTORCH_INFERENCE_1_13_1_TRANSFORMERS4_26_0_GPU_PY39_CU117_UBUNTU20_04 = _a.fromDeepLearningContainerImage('huggingface-pytorch-inference', '1.13.1-transformers4.26.0-gpu-py39-cu117-ubuntu20.04');
DeepLearningContainerImage.HUGGINGFACE_PYTORCH_INFERENCE_1_7_1_TRANSFORMERS4_6_1_CPU_PY36_UBUNTU18_04 = _a.fromDeepLearningContainerImage('huggingface-pytorch-inference', '1.7.1-transformers4.6.1-cpu-py36-ubuntu18.04');
DeepLearningContainerImage.HUGGINGFACE_PYTORCH_INFERENCE_1_7_1_TRANSFORMERS4_6_1_GPU_PY36_CU110_UBUNTU18_04 = _a.fromDeepLearningContainerImage('huggingface-pytorch-inference', '1.7.1-transformers4.6.1-gpu-py36-cu110-ubuntu18.04');
DeepLearningContainerImage.HUGGINGFACE_PYTORCH_INFERENCE_1_8_1_TRANSFORMERS4_10_2_CPU_PY36_UBUNTU18_04 = _a.fromDeepLearningContainerImage('huggingface-pytorch-inference', '1.8.1-transformers4.10.2-cpu-py36-ubuntu18.04');
DeepLearningContainerImage.HUGGINGFACE_PYTORCH_INFERENCE_1_8_1_TRANSFORMERS4_10_2_GPU_PY36_CU111_UBUNTU18_04 = _a.fromDeepLearningContainerImage('huggingface-pytorch-inference', '1.8.1-transformers4.10.2-gpu-py36-cu111-ubuntu18.04');
DeepLearningContainerImage.HUGGINGFACE_PYTORCH_INFERENCE_1_8_1_TRANSFORMERS4_6_1_CPU_PY36_UBUNTU18_04 = _a.fromDeepLearningContainerImage('huggingface-pytorch-inference', '1.8.1-transformers4.6.1-cpu-py36-ubuntu18.04');
DeepLearningContainerImage.HUGGINGFACE_PYTORCH_INFERENCE_1_8_1_TRANSFORMERS4_6_1_GPU_PY36_CU111_UBUNTU18_04 = _a.fromDeepLearningContainerImage('huggingface-pytorch-inference', '1.8.1-transformers4.6.1-gpu-py36-cu111-ubuntu18.04');
DeepLearningContainerImage.HUGGINGFACE_PYTORCH_INFERENCE_1_9_0_TRANSFORMERS4_10_2_CPU_PY38_UBUNTU20_04 = _a.fromDeepLearningContainerImage('huggingface-pytorch-inference', '1.9.0-transformers4.10.2-cpu-py38-ubuntu20.04');
DeepLearningContainerImage.HUGGINGFACE_PYTORCH_INFERENCE_1_9_0_TRANSFORMERS4_10_2_GPU_PY38_CU111_UBUNTU20_04 = _a.fromDeepLearningContainerImage('huggingface-pytorch-inference', '1.9.0-transformers4.10.2-gpu-py38-cu111-ubuntu20.04');
DeepLearningContainerImage.HUGGINGFACE_PYTORCH_INFERENCE_1_9_0_TRANSFORMERS4_11_0_CPU_PY38_UBUNTU20_04 = _a.fromDeepLearningContainerImage('huggingface-pytorch-inference', '1.9.0-transformers4.11.0-cpu-py38-ubuntu20.04');
DeepLearningContainerImage.HUGGINGFACE_PYTORCH_INFERENCE_1_9_0_TRANSFORMERS4_11_0_GPU_PY38_CU111_UBUNTU20_04 = _a.fromDeepLearningContainerImage('huggingface-pytorch-inference', '1.9.0-transformers4.11.0-gpu-py38-cu111-ubuntu20.04');
DeepLearningContainerImage.HUGGINGFACE_PYTORCH_INFERENCE_1_9_1_TRANSFORMERS4_12_3_CPU_PY38_UBUNTU20_04 = _a.fromDeepLearningContainerImage('huggingface-pytorch-inference', '1.9.1-transformers4.12.3-cpu-py38-ubuntu20.04');
DeepLearningContainerImage.HUGGINGFACE_PYTORCH_INFERENCE_1_9_1_TRANSFORMERS4_12_3_GPU_PY38_CU111_UBUNTU20_04 = _a.fromDeepLearningContainerImage('huggingface-pytorch-inference', '1.9.1-transformers4.12.3-gpu-py38-cu111-ubuntu20.04');
DeepLearningContainerImage.HUGGINGFACE_PYTORCH_INFERENCE_2_0_0_TRANSFORMERS4_28_1_CPU_PY310_UBUNTU20_04 = _a.fromDeepLearningContainerImage('huggingface-pytorch-inference', '2.0.0-transformers4.28.1-cpu-py310-ubuntu20.04');
DeepLearningContainerImage.HUGGINGFACE_PYTORCH_INFERENCE_2_0_0_TRANSFORMERS4_28_1_GPU_PY310_CU118_UBUNTU20_04 = _a.fromDeepLearningContainerImage('huggingface-pytorch-inference', '2.0.0-transformers4.28.1-gpu-py310-cu118-ubuntu20.04');
DeepLearningContainerImage.HUGGINGFACE_PYTORCH_INFERENCE_NEURONX_1_13_0_TRANSFORMERS4_28_1_NEURONX_PY38_SDK2_9_1_UBUNTU20_04 = _a.fromDeepLearningContainerImage('huggingface-pytorch-inference-neuronx', '1.13.0-transformers4.28.1-neuronx-py38-sdk2.9.1-ubuntu20.04');
DeepLearningContainerImage.HUGGINGFACE_PYTORCH_INFERENCE_NEURONX_1_13_1_TRANSFORMERS4_34_1_NEURONX_PY310_SDK2_15_0_UBUNTU20_04 = _a.fromDeepLearningContainerImage('huggingface-pytorch-inference-neuronx', '1.13.1-transformers4.34.1-neuronx-py310-sdk2.15.0-ubuntu20.04');
DeepLearningContainerImage.HUGGINGFACE_PYTORCH_TGI_INFERENCE_2_0_0_TGI0_6_0_GPU_PY39_CU118_UBUNTU20_04 = _a.fromDeepLearningContainerImage('huggingface-pytorch-tgi-inference', '2.0.0-tgi0.6.0-gpu-py39-cu118-ubuntu20.04');
DeepLearningContainerImage.HUGGINGFACE_PYTORCH_TGI_INFERENCE_2_0_0_TGI0_8_2_GPU_PY39_CU118_UBUNTU20_04 = _a.fromDeepLearningContainerImage('huggingface-pytorch-tgi-inference', '2.0.0-tgi0.8.2-gpu-py39-cu118-ubuntu20.04');
DeepLearningContainerImage.HUGGINGFACE_PYTORCH_TGI_INFERENCE_2_0_1_TGI0_9_3_GPU_PY39_CU118_UBUNTU20_04 = _a.fromDeepLearningContainerImage('huggingface-pytorch-tgi-inference', '2.0.1-tgi0.9.3-gpu-py39-cu118-ubuntu20.04');
DeepLearningContainerImage.HUGGINGFACE_PYTORCH_TGI_INFERENCE_2_0_1_TGI1_0_3_GPU_PY39_CU118_UBUNTU20_04 = _a.fromDeepLearningContainerImage('huggingface-pytorch-tgi-inference', '2.0.1-tgi1.0.3-gpu-py39-cu118-ubuntu20.04');
DeepLearningContainerImage.HUGGINGFACE_PYTORCH_TGI_INFERENCE_2_0_1_TGI1_1_0_GPU_PY39_CU118_UBUNTU20_04 = _a.fromDeepLearningContainerImage('huggingface-pytorch-tgi-inference', '2.0.1-tgi1.1.0-gpu-py39-cu118-ubuntu20.04');
DeepLearningContainerImage.HUGGINGFACE_TENSORFLOW_INFERENCE_2_11_0_TRANSFORMERS4_26_0_CPU_PY39_UBUNTU20_04 = _a.fromDeepLearningContainerImage('huggingface-tensorflow-inference', '2.11.0-transformers4.26.0-cpu-py39-ubuntu20.04');
DeepLearningContainerImage.HUGGINGFACE_TENSORFLOW_INFERENCE_2_11_0_TRANSFORMERS4_26_0_GPU_PY39_CU112_UBUNTU20_04 = _a.fromDeepLearningContainerImage('huggingface-tensorflow-inference', '2.11.0-transformers4.26.0-gpu-py39-cu112-ubuntu20.04');
DeepLearningContainerImage.HUGGINGFACE_TENSORFLOW_INFERENCE_2_11_1_TRANSFORMERS4_26_0_CPU_PY39_UBUNTU20_04 = _a.fromDeepLearningContainerImage('huggingface-tensorflow-inference', '2.11.1-transformers4.26.0-cpu-py39-ubuntu20.04');
DeepLearningContainerImage.HUGGINGFACE_TENSORFLOW_INFERENCE_2_11_1_TRANSFORMERS4_26_0_GPU_PY39_CU112_UBUNTU20_04 = _a.fromDeepLearningContainerImage('huggingface-tensorflow-inference', '2.11.1-transformers4.26.0-gpu-py39-cu112-ubuntu20.04');
DeepLearningContainerImage.HUGGINGFACE_TENSORFLOW_INFERENCE_2_4_1_TRANSFORMERS4_6_1_CPU_PY37_UBUNTU18_04 = _a.fromDeepLearningContainerImage('huggingface-tensorflow-inference', '2.4.1-transformers4.6.1-cpu-py37-ubuntu18.04');
DeepLearningContainerImage.HUGGINGFACE_TENSORFLOW_INFERENCE_2_4_1_TRANSFORMERS4_6_1_GPU_PY37_CU110_UBUNTU18_04 = _a.fromDeepLearningContainerImage('huggingface-tensorflow-inference', '2.4.1-transformers4.6.1-gpu-py37-cu110-ubuntu18.04');
DeepLearningContainerImage.HUGGINGFACE_TENSORFLOW_INFERENCE_2_4_3_TRANSFORMERS4_10_2_CPU_PY37_UBUNTU18_04 = _a.fromDeepLearningContainerImage('huggingface-tensorflow-inference', '2.4.3-transformers4.10.2-cpu-py37-ubuntu18.04');
DeepLearningContainerImage.HUGGINGFACE_TENSORFLOW_INFERENCE_2_4_3_TRANSFORMERS4_10_2_GPU_PY37_CU110_UBUNTU18_04 = _a.fromDeepLearningContainerImage('huggingface-tensorflow-inference', '2.4.3-transformers4.10.2-gpu-py37-cu110-ubuntu18.04');
DeepLearningContainerImage.HUGGINGFACE_TENSORFLOW_INFERENCE_2_5_1_TRANSFORMERS4_10_2_CPU_PY37_UBUNTU18_04 = _a.fromDeepLearningContainerImage('huggingface-tensorflow-inference', '2.5.1-transformers4.10.2-cpu-py37-ubuntu18.04');
DeepLearningContainerImage.HUGGINGFACE_TENSORFLOW_INFERENCE_2_5_1_TRANSFORMERS4_10_2_GPU_PY37_CU112_UBUNTU18_04 = _a.fromDeepLearningContainerImage('huggingface-tensorflow-inference', '2.5.1-transformers4.10.2-gpu-py37-cu112-ubuntu18.04');
DeepLearningContainerImage.HUGGINGFACE_TENSORFLOW_INFERENCE_2_5_1_TRANSFORMERS4_11_0_CPU_PY37_UBUNTU18_04 = _a.fromDeepLearningContainerImage('huggingface-tensorflow-inference', '2.5.1-transformers4.11.0-cpu-py37-ubuntu18.04');
DeepLearningContainerImage.HUGGINGFACE_TENSORFLOW_INFERENCE_2_5_1_TRANSFORMERS4_11_0_GPU_PY37_CU112_UBUNTU18_04 = _a.fromDeepLearningContainerImage('huggingface-tensorflow-inference', '2.5.1-transformers4.11.0-gpu-py37-cu112-ubuntu18.04');
DeepLearningContainerImage.HUGGINGFACE_TENSORFLOW_INFERENCE_2_5_1_TRANSFORMERS4_12_3_CPU_PY37_UBUNTU18_04 = _a.fromDeepLearningContainerImage('huggingface-tensorflow-inference', '2.5.1-transformers4.12.3-cpu-py37-ubuntu18.04');
DeepLearningContainerImage.HUGGINGFACE_TENSORFLOW_INFERENCE_2_5_1_TRANSFORMERS4_12_3_GPU_PY37_CU112_UBUNTU18_04 = _a.fromDeepLearningContainerImage('huggingface-tensorflow-inference', '2.5.1-transformers4.12.3-gpu-py37-cu112-ubuntu18.04');
DeepLearningContainerImage.HUGGINGFACE_TENSORFLOW_INFERENCE_2_5_3_TRANSFORMERS4_12_3_CPU_PY37_UBUNTU18_04 = _a.fromDeepLearningContainerImage('huggingface-tensorflow-inference', '2.5.3-transformers4.12.3-cpu-py37-ubuntu18.04');
DeepLearningContainerImage.HUGGINGFACE_TENSORFLOW_INFERENCE_2_5_3_TRANSFORMERS4_12_3_GPU_PY37_CU112_UBUNTU18_04 = _a.fromDeepLearningContainerImage('huggingface-tensorflow-inference', '2.5.3-transformers4.12.3-gpu-py37-cu112-ubuntu18.04');
DeepLearningContainerImage.HUGGINGFACE_TENSORFLOW_INFERENCE_2_6_3_TRANSFORMERS4_17_0_CPU_PY38_UBUNTU20_04 = _a.fromDeepLearningContainerImage('huggingface-tensorflow-inference', '2.6.3-transformers4.17.0-cpu-py38-ubuntu20.04');
DeepLearningContainerImage.HUGGINGFACE_TENSORFLOW_INFERENCE_2_6_3_TRANSFORMERS4_17_0_GPU_PY38_CU112_UBUNTU20_04 = _a.fromDeepLearningContainerImage('huggingface-tensorflow-inference', '2.6.3-transformers4.17.0-gpu-py38-cu112-ubuntu20.04');
exports.DeepLearningContainerImage = DeepLearningContainerImage;
//# sourceMappingURL=data:application/json;base64,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