import * as iam from 'aws-cdk-lib/aws-iam';
import { Construct } from 'constructs';
import { ContainerImage, ContainerImageConfig } from './container-image';
export declare class DeepLearningContainerImage extends ContainerImage {
    private readonly repositoryName;
    private readonly tag;
    private readonly accountId?;
    static readonly DJL_INFERENCE_0_19_0_DEEPSPEED0_7_3_CU113: ContainerImage;
    static readonly DJL_INFERENCE_0_20_0_DEEPSPEED0_7_5_CU116: ContainerImage;
    static readonly DJL_INFERENCE_0_21_0_DEEPSPEED0_8_0_CU117: ContainerImage;
    static readonly DJL_INFERENCE_0_21_0_DEEPSPEED0_8_3_CU117: ContainerImage;
    static readonly DJL_INFERENCE_0_21_0_FASTERTRANSFORMER5_3_0_CU117: ContainerImage;
    static readonly DJL_INFERENCE_0_22_1_DEEPSPEED0_8_3_CU118: ContainerImage;
    static readonly DJL_INFERENCE_0_22_1_DEEPSPEED0_9_2_CU118: ContainerImage;
    static readonly DJL_INFERENCE_0_22_1_FASTERTRANSFORMER5_3_0_CU118: ContainerImage;
    static readonly DJL_INFERENCE_0_22_1_NEURONX_SDK2_10_0: ContainerImage;
    static readonly DJL_INFERENCE_0_22_1_NEURONX_SDK2_9_0: ContainerImage;
    static readonly DJL_INFERENCE_0_23_0_DEEPSPEED0_9_5_CU118: ContainerImage;
    static readonly DJL_INFERENCE_0_23_0_FASTERTRANSFORMER5_3_0_CU118: ContainerImage;
    static readonly DJL_INFERENCE_0_23_0_NEURONX_SDK2_12_0: ContainerImage;
    static readonly DJL_INFERENCE_0_24_0_DEEPSPEED0_10_0_CU118: ContainerImage;
    static readonly DJL_INFERENCE_0_24_0_FASTERTRANSFORMER5_3_0_CU118: ContainerImage;
    static readonly DJL_INFERENCE_0_24_0_NEURONX_SDK2_14_1: ContainerImage;
    static readonly DJL_INFERENCE_0_25_0_DEEPSPEED0_11_0_CU118: ContainerImage;
    static readonly DJL_INFERENCE_0_25_0_NEURONX_SDK2_15_0: ContainerImage;
    static readonly HUGGINGFACE_PYTORCH_INFERENCE_1_10_2_TRANSFORMERS4_17_0_CPU_PY38_UBUNTU20_04: ContainerImage;
    static readonly HUGGINGFACE_PYTORCH_INFERENCE_1_10_2_TRANSFORMERS4_17_0_GPU_PY38_CU113_UBUNTU20_04: ContainerImage;
    static readonly HUGGINGFACE_PYTORCH_INFERENCE_1_13_1_TRANSFORMERS4_26_0_CPU_PY39_UBUNTU20_04: ContainerImage;
    static readonly HUGGINGFACE_PYTORCH_INFERENCE_1_13_1_TRANSFORMERS4_26_0_GPU_PY39_CU117_UBUNTU20_04: ContainerImage;
    static readonly HUGGINGFACE_PYTORCH_INFERENCE_1_7_1_TRANSFORMERS4_6_1_CPU_PY36_UBUNTU18_04: ContainerImage;
    static readonly HUGGINGFACE_PYTORCH_INFERENCE_1_7_1_TRANSFORMERS4_6_1_GPU_PY36_CU110_UBUNTU18_04: ContainerImage;
    static readonly HUGGINGFACE_PYTORCH_INFERENCE_1_8_1_TRANSFORMERS4_10_2_CPU_PY36_UBUNTU18_04: ContainerImage;
    static readonly HUGGINGFACE_PYTORCH_INFERENCE_1_8_1_TRANSFORMERS4_10_2_GPU_PY36_CU111_UBUNTU18_04: ContainerImage;
    static readonly HUGGINGFACE_PYTORCH_INFERENCE_1_8_1_TRANSFORMERS4_6_1_CPU_PY36_UBUNTU18_04: ContainerImage;
    static readonly HUGGINGFACE_PYTORCH_INFERENCE_1_8_1_TRANSFORMERS4_6_1_GPU_PY36_CU111_UBUNTU18_04: ContainerImage;
    static readonly HUGGINGFACE_PYTORCH_INFERENCE_1_9_0_TRANSFORMERS4_10_2_CPU_PY38_UBUNTU20_04: ContainerImage;
    static readonly HUGGINGFACE_PYTORCH_INFERENCE_1_9_0_TRANSFORMERS4_10_2_GPU_PY38_CU111_UBUNTU20_04: ContainerImage;
    static readonly HUGGINGFACE_PYTORCH_INFERENCE_1_9_0_TRANSFORMERS4_11_0_CPU_PY38_UBUNTU20_04: ContainerImage;
    static readonly HUGGINGFACE_PYTORCH_INFERENCE_1_9_0_TRANSFORMERS4_11_0_GPU_PY38_CU111_UBUNTU20_04: ContainerImage;
    static readonly HUGGINGFACE_PYTORCH_INFERENCE_1_9_1_TRANSFORMERS4_12_3_CPU_PY38_UBUNTU20_04: ContainerImage;
    static readonly HUGGINGFACE_PYTORCH_INFERENCE_1_9_1_TRANSFORMERS4_12_3_GPU_PY38_CU111_UBUNTU20_04: ContainerImage;
    static readonly HUGGINGFACE_PYTORCH_INFERENCE_2_0_0_TRANSFORMERS4_28_1_CPU_PY310_UBUNTU20_04: ContainerImage;
    static readonly HUGGINGFACE_PYTORCH_INFERENCE_2_0_0_TRANSFORMERS4_28_1_GPU_PY310_CU118_UBUNTU20_04: ContainerImage;
    static readonly HUGGINGFACE_PYTORCH_INFERENCE_NEURONX_1_13_0_TRANSFORMERS4_28_1_NEURONX_PY38_SDK2_9_1_UBUNTU20_04: ContainerImage;
    static readonly HUGGINGFACE_PYTORCH_INFERENCE_NEURONX_1_13_1_TRANSFORMERS4_34_1_NEURONX_PY310_SDK2_15_0_UBUNTU20_04: ContainerImage;
    static readonly HUGGINGFACE_PYTORCH_TGI_INFERENCE_2_0_0_TGI0_6_0_GPU_PY39_CU118_UBUNTU20_04: ContainerImage;
    static readonly HUGGINGFACE_PYTORCH_TGI_INFERENCE_2_0_0_TGI0_8_2_GPU_PY39_CU118_UBUNTU20_04: ContainerImage;
    static readonly HUGGINGFACE_PYTORCH_TGI_INFERENCE_2_0_1_TGI0_9_3_GPU_PY39_CU118_UBUNTU20_04: ContainerImage;
    static readonly HUGGINGFACE_PYTORCH_TGI_INFERENCE_2_0_1_TGI1_0_3_GPU_PY39_CU118_UBUNTU20_04: ContainerImage;
    static readonly HUGGINGFACE_PYTORCH_TGI_INFERENCE_2_0_1_TGI1_1_0_GPU_PY39_CU118_UBUNTU20_04: ContainerImage;
    static readonly HUGGINGFACE_TENSORFLOW_INFERENCE_2_11_0_TRANSFORMERS4_26_0_CPU_PY39_UBUNTU20_04: ContainerImage;
    static readonly HUGGINGFACE_TENSORFLOW_INFERENCE_2_11_0_TRANSFORMERS4_26_0_GPU_PY39_CU112_UBUNTU20_04: ContainerImage;
    static readonly HUGGINGFACE_TENSORFLOW_INFERENCE_2_11_1_TRANSFORMERS4_26_0_CPU_PY39_UBUNTU20_04: ContainerImage;
    static readonly HUGGINGFACE_TENSORFLOW_INFERENCE_2_11_1_TRANSFORMERS4_26_0_GPU_PY39_CU112_UBUNTU20_04: ContainerImage;
    static readonly HUGGINGFACE_TENSORFLOW_INFERENCE_2_4_1_TRANSFORMERS4_6_1_CPU_PY37_UBUNTU18_04: ContainerImage;
    static readonly HUGGINGFACE_TENSORFLOW_INFERENCE_2_4_1_TRANSFORMERS4_6_1_GPU_PY37_CU110_UBUNTU18_04: ContainerImage;
    static readonly HUGGINGFACE_TENSORFLOW_INFERENCE_2_4_3_TRANSFORMERS4_10_2_CPU_PY37_UBUNTU18_04: ContainerImage;
    static readonly HUGGINGFACE_TENSORFLOW_INFERENCE_2_4_3_TRANSFORMERS4_10_2_GPU_PY37_CU110_UBUNTU18_04: ContainerImage;
    static readonly HUGGINGFACE_TENSORFLOW_INFERENCE_2_5_1_TRANSFORMERS4_10_2_CPU_PY37_UBUNTU18_04: ContainerImage;
    static readonly HUGGINGFACE_TENSORFLOW_INFERENCE_2_5_1_TRANSFORMERS4_10_2_GPU_PY37_CU112_UBUNTU18_04: ContainerImage;
    static readonly HUGGINGFACE_TENSORFLOW_INFERENCE_2_5_1_TRANSFORMERS4_11_0_CPU_PY37_UBUNTU18_04: ContainerImage;
    static readonly HUGGINGFACE_TENSORFLOW_INFERENCE_2_5_1_TRANSFORMERS4_11_0_GPU_PY37_CU112_UBUNTU18_04: ContainerImage;
    static readonly HUGGINGFACE_TENSORFLOW_INFERENCE_2_5_1_TRANSFORMERS4_12_3_CPU_PY37_UBUNTU18_04: ContainerImage;
    static readonly HUGGINGFACE_TENSORFLOW_INFERENCE_2_5_1_TRANSFORMERS4_12_3_GPU_PY37_CU112_UBUNTU18_04: ContainerImage;
    static readonly HUGGINGFACE_TENSORFLOW_INFERENCE_2_5_3_TRANSFORMERS4_12_3_CPU_PY37_UBUNTU18_04: ContainerImage;
    static readonly HUGGINGFACE_TENSORFLOW_INFERENCE_2_5_3_TRANSFORMERS4_12_3_GPU_PY37_CU112_UBUNTU18_04: ContainerImage;
    static readonly HUGGINGFACE_TENSORFLOW_INFERENCE_2_6_3_TRANSFORMERS4_17_0_CPU_PY38_UBUNTU20_04: ContainerImage;
    static readonly HUGGINGFACE_TENSORFLOW_INFERENCE_2_6_3_TRANSFORMERS4_17_0_GPU_PY38_CU112_UBUNTU20_04: ContainerImage;
    static fromDeepLearningContainerImage(repositoryName: string, tag: string, accountId?: string): ContainerImage;
    constructor(repositoryName: string, tag: string, accountId?: string | undefined);
    bind(scope: Construct, grantable: iam.IGrantable): ContainerImageConfig;
}
