/**
 *  Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
import * as ecr from 'aws-cdk-lib/aws-ecr';
import * as assets from 'aws-cdk-lib/aws-ecr-assets';
import * as iam from 'aws-cdk-lib/aws-iam';
import { Construct } from 'constructs';
export interface ContainerImageConfig {
    /**
     * The image name. Images in Amazon ECR repositories can be specified by either using the full registry/repository:tag or
     * registry/repository@digest.
     *
     * For example, `012345678910.dkr.ecr.<region-name>.amazonaws.com/<repository-name>:latest` or
     * `012345678910.dkr.ecr.<region-name>.amazonaws.com/<repository-name>@sha256:94afd1f2e64d908bc90dbca0035a5b567EXAMPLE`.
     */
    readonly imageName: string;
}
/**
 *
 * https://github.com/aws/deep-learning-containers/blob/master/available_images.md
 */
export declare abstract class ContainerImage {
    static fromEcrRepository(repository: ecr.IRepository, tag?: string): ContainerImage;
    static fromAsset(directory: string, options?: assets.DockerImageAssetOptions): ContainerImage;
    abstract bind(scope: Construct, grantable: iam.IGrantable): ContainerImageConfig;
}
