"use strict";
/**
 *  Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.CheckS3Props = void 0;
function CheckS3Props(propsObject) {
    let errorMessages = '';
    let errorFound = false;
    console.log('ncheck s3 props1' + propsObject);
    if ((propsObject.existingBucketObj || propsObject.existingBucketInterface) && propsObject.bucketProps) {
        errorMessages += 'Error - Either provide bucketProps or existingBucketObj, but not both.\n';
        errorFound = true;
    }
    console.log('ncheck s3 props2' + propsObject);
    if (propsObject.existingLoggingBucketObj && propsObject.loggingBucketProps) {
        errorMessages += 'Error - Either provide existingLoggingBucketObj or loggingBucketProps, but not both.\n';
        errorFound = true;
    }
    console.log('ncheck s3 props3' + propsObject);
    if ((propsObject?.logS3AccessLogs === false) && (propsObject.loggingBucketProps || propsObject.existingLoggingBucketObj)) {
        errorMessages += 'Error - If logS3AccessLogs is false, supplying loggingBucketProps or existingLoggingBucketObj is invalid.\n';
        errorFound = true;
    }
    console.log('ncheck s3 props4' + propsObject);
    if (propsObject.existingBucketObj && (propsObject.loggingBucketProps || propsObject.logS3AccessLogs)) {
        errorMessages += 'Error - If existingBucketObj is provided, supplying loggingBucketProps or logS3AccessLogs is an error.\n';
        errorFound = true;
    }
    console.log('is error found ' + errorFound);
    if (errorFound) {
        throw new Error(errorMessages);
    }
}
exports.CheckS3Props = CheckS3Props;
//# sourceMappingURL=data:application/json;base64,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