/**
 *  Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
import * as ec2 from 'aws-cdk-lib/aws-ec2';
import * as elasticache from 'aws-cdk-lib/aws-elasticache';
import { Construct } from 'constructs';
export interface RedisProps {
    /**
     * Required. Existing instance of a VPC, if this is set then the all Props are ignored,
     * if this is not set then deafultVPC Props are used.
     */
    readonly existingVpc: ec2.IVpc;
    /**
     * Optional cfnCacheClusterProps
     * @default cacheNodeType -  'cache.r6g.xlarge'
     * @default numCacheNodes- 1
     */
    readonly cfnCacheClusterProps?: elasticache.CfnCacheClusterProps;
    /**
    * Optional. Existing Redis cluster to cache the generated summary
    * for subsequent request of same document.
    *
    * @default - none
    */
    readonly existingRedisCulster?: elasticache.CfnCacheCluster;
    /**
     * Optional .name  of redis Security Group
     * @default 'redisSecurityGroup'
     */
    readonly redisSecurityGroupname?: string;
    /**
     * Required. redis Security Group
     *
     */
    readonly redisSecurityGroup: ec2.SecurityGroup;
    /**
     * Required. list of subnet Ids
     * @default None
     */
    readonly subnetIds: string[];
    /**
     * Required. lambda security group which will acces the redis cluster
     *
     */
    readonly inboundSecurityGroup: ec2.ISecurityGroup;
    /**
     * Optional. redis port number
     * @default redisPort
     */
    readonly redisPort?: number;
}
export declare function buildRedisCluster(scope: Construct, props: RedisProps): elasticache.CfnCacheCluster;
export declare function getRedisSecurityGroup(scope: Construct, props: RedisProps | any): ec2.SecurityGroup;
export declare function setInboundRules(redisSecurityGroup: ec2.SecurityGroup, sourceSecuritygroup: ec2.ISecurityGroup, redisPort: number): void;
export declare function CheckRedisClusterProps(propsObject: RedisProps | any): void;
