"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Layer = void 0;
/**
 *  Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
const cdk = require("aws-cdk-lib");
const lambda = require("aws-cdk-lib/aws-lambda");
const s3assets = require("aws-cdk-lib/aws-s3-assets");
const constructs_1 = require("constructs");
class Layer extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const { runtime, architecture, path, autoUpgrade, description } = props;
        const args = ['-t /asset-output/python'];
        if (autoUpgrade) {
            args.push('--upgrade');
        }
        const layerAsset = new s3assets.Asset(this, 'LayerAsset', {
            path,
            bundling: {
                image: runtime.bundlingImage,
                platform: architecture.dockerPlatform,
                command: [
                    'bash',
                    '-c',
                    `pip install -r requirements.txt ${args.join(' ')}`,
                ],
                outputType: cdk.BundlingOutput.AUTO_DISCOVER,
                securityOpt: 'no-new-privileges:true',
                network: 'host',
            },
        });
        const layer = new lambda.LayerVersion(this, 'Layer', {
            code: lambda.Code.fromBucket(layerAsset.bucket, layerAsset.s3ObjectKey),
            compatibleRuntimes: [runtime],
            compatibleArchitectures: [architecture],
            removalPolicy: cdk.RemovalPolicy.DESTROY,
            description: description,
        });
        this.layer = layer;
    }
}
exports.Layer = Layer;
//# sourceMappingURL=data:application/json;base64,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