import * as appsync from 'aws-cdk-lib/aws-appsync';
import * as iam from 'aws-cdk-lib/aws-iam';
import { Construct } from 'constructs';
export interface AppsyncMergedApiProps {
    /**
     * Optional, existing merge api
     * schema for multiple source api.
     * @default None
     */
    readonly existingMergeApi?: appsync.CfnGraphQLApi;
    /**
     * Optional user provided appsync props
     * @default - authentication type - AMAZON_COGNITO_USER_POOL
     * @default - api type -MERGED
     * @default - name - appsyncmergeAPI
     *
     */
    readonly cfnGraphQLApiProps?: appsync.CfnGraphQLApiProps;
    /**
     * OPTIONAL cognito user pool id for appsync auth
     * @default None
     */
    readonly userPoolId?: string;
    /**
     * Required appsync service principle role
     * @default - appsync.amazonaws.com
     */
    readonly appsyncServicePrincipleRole: string;
    /**
     * Optional Field log level
     * @default None
     */
    readonly fieldLogLevel?: string;
    /**
     * Optional log verbose content
     * @default false
     */
    readonly excludeVerboseContent?: boolean;
    /**
     * Optional x ray enablement for app sync
     * @default false
     */
    readonly xRayEnabled?: boolean;
    /**
     * Required mergedApiRole for app sync
     * @default
     */
    readonly mergedApiRole: iam.Role;
}
/**
 * @internal This is an internal core function and should not be called directly by Solutions Constructs clients.
 *
 * build app sync merge api with source api associations
 *
 * @param AppsyncMergedApiProps The  props to be used by the construct
 * @param  apiType - MERGED, GRAPHQL
 * @returns App sync merge api
 */
export declare function buildMergedAPI(scope: Construct, id: string, props: AppsyncMergedApiProps): appsync.CfnGraphQLApi;
export declare function checkAppsyncMergedApiProps(propsObject: AppsyncMergedApiProps | any): void;
/**
 * @internal This is an internal core function and should not be called directly
 * by Solutions Constructs clients.
 * set the merge api role to access source api associations
 *
 * @param AppsyncMergedApiProps The  props to be used by the construct
 * @param mergedAPI app sync graphql api
 * @param mergedApiRole iam role
 * @returns App sync merge api role
 */
export declare function setMergedApiRole(mergedApiID: String, sourceApiId: String, mergedApiRole: iam.Role): iam.Role;
