"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.VirtualNodeListener = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const utils_1 = require("./private/utils");
const shared_interfaces_1 = require("./shared-interfaces");
/**
 * Defines listener for a VirtualNode.
 *
 * @stability stable
 */
class VirtualNodeListener {
    /**
     * Returns an HTTP Listener for a VirtualNode.
     *
     * @stability stable
     */
    static http(props = {}) {
        jsiiDeprecationWarnings._aws_cdk_aws_appmesh_HttpVirtualNodeListenerOptions(props);
        return new VirtualNodeListenerImpl(shared_interfaces_1.Protocol.HTTP, props.healthCheck, props.timeout, props.port, props.tls, props.outlierDetection, props.connectionPool);
    }
    /**
     * Returns an HTTP2 Listener for a VirtualNode.
     *
     * @stability stable
     */
    static http2(props = {}) {
        jsiiDeprecationWarnings._aws_cdk_aws_appmesh_Http2VirtualNodeListenerOptions(props);
        return new VirtualNodeListenerImpl(shared_interfaces_1.Protocol.HTTP2, props.healthCheck, props.timeout, props.port, props.tls, props.outlierDetection, props.connectionPool);
    }
    /**
     * Returns an GRPC Listener for a VirtualNode.
     *
     * @stability stable
     */
    static grpc(props = {}) {
        jsiiDeprecationWarnings._aws_cdk_aws_appmesh_GrpcVirtualNodeListenerOptions(props);
        return new VirtualNodeListenerImpl(shared_interfaces_1.Protocol.GRPC, props.healthCheck, props.timeout, props.port, props.tls, props.outlierDetection, props.connectionPool);
    }
    /**
     * Returns an TCP Listener for a VirtualNode.
     *
     * @stability stable
     */
    static tcp(props = {}) {
        jsiiDeprecationWarnings._aws_cdk_aws_appmesh_TcpVirtualNodeListenerOptions(props);
        return new VirtualNodeListenerImpl(shared_interfaces_1.Protocol.TCP, props.healthCheck, props.timeout, props.port, props.tls, props.outlierDetection, props.connectionPool);
    }
}
exports.VirtualNodeListener = VirtualNodeListener;
_a = JSII_RTTI_SYMBOL_1;
VirtualNodeListener[_a] = { fqn: "@aws-cdk/aws-appmesh.VirtualNodeListener", version: "1.144.0" };
class VirtualNodeListenerImpl extends VirtualNodeListener {
    constructor(protocol, healthCheck, timeout, port = 8080, tls, outlierDetection, connectionPool) {
        super();
        this.protocol = protocol;
        this.healthCheck = healthCheck;
        this.timeout = timeout;
        this.port = port;
        this.tls = tls;
        this.outlierDetection = outlierDetection;
        this.connectionPool = connectionPool;
    }
    bind(scope) {
        var _b;
        return {
            listener: {
                portMapping: {
                    port: this.port,
                    protocol: this.protocol,
                },
                healthCheck: (_b = this.healthCheck) === null || _b === void 0 ? void 0 : _b.bind(scope, { defaultPort: this.port }).virtualNodeHealthCheck,
                timeout: this.timeout ? this.renderTimeout(this.timeout) : undefined,
                tls: utils_1.renderListenerTlsOptions(scope, this.tls),
                outlierDetection: this.outlierDetection ? this.renderOutlierDetection(this.outlierDetection) : undefined,
                connectionPool: this.connectionPool ? this.renderConnectionPool(this.connectionPool) : undefined,
            },
        };
    }
    renderTimeout(timeout) {
        return ({
            [this.protocol]: {
                idle: (timeout === null || timeout === void 0 ? void 0 : timeout.idle) !== undefined ? {
                    unit: 'ms',
                    value: timeout === null || timeout === void 0 ? void 0 : timeout.idle.toMilliseconds(),
                } : undefined,
                perRequest: (timeout === null || timeout === void 0 ? void 0 : timeout.perRequest) !== undefined ? {
                    unit: 'ms',
                    value: timeout === null || timeout === void 0 ? void 0 : timeout.perRequest.toMilliseconds(),
                } : undefined,
            },
        });
    }
    renderOutlierDetection(outlierDetection) {
        return {
            baseEjectionDuration: {
                unit: 'ms',
                value: outlierDetection.baseEjectionDuration.toMilliseconds(),
            },
            interval: {
                unit: 'ms',
                value: outlierDetection.interval.toMilliseconds(),
            },
            maxEjectionPercent: outlierDetection.maxEjectionPercent,
            maxServerErrors: outlierDetection.maxServerErrors,
        };
    }
    renderConnectionPool(connectionPool) {
        return ({
            [this.protocol]: {
                maxRequests: (connectionPool === null || connectionPool === void 0 ? void 0 : connectionPool.maxRequests) !== undefined ? connectionPool.maxRequests : undefined,
                maxConnections: (connectionPool === null || connectionPool === void 0 ? void 0 : connectionPool.maxConnections) !== undefined ? connectionPool.maxConnections : undefined,
                maxPendingRequests: (connectionPool === null || connectionPool === void 0 ? void 0 : connectionPool.maxPendingRequests) !== undefined ? connectionPool.maxPendingRequests : undefined,
            },
        });
    }
}
//# sourceMappingURL=data:application/json;base64,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