import { CfnVirtualNode } from './appmesh.generated';
import { HealthCheck } from './health-checks';
import { ListenerTlsOptions } from './listener-tls-options';
import { GrpcConnectionPool, GrpcTimeout, Http2ConnectionPool, HttpConnectionPool, HttpTimeout, OutlierDetection, TcpConnectionPool, TcpTimeout } from './shared-interfaces';
import { Construct } from '@aws-cdk/core';
/**
 * Properties for a VirtualNode listener.
 *
 * @stability stable
 */
export interface VirtualNodeListenerConfig {
    /**
     * Single listener config for a VirtualNode.
     *
     * @stability stable
     */
    readonly listener: CfnVirtualNode.ListenerProperty;
}
/**
 * Represents the properties needed to define a Listeners for a VirtualNode
 */
interface VirtualNodeListenerCommonOptions {
    /**
     * Port to listen for connections on.
     *
     * @default - 8080
     * @stability stable
     */
    readonly port?: number;
    /**
     * The health check information for the listener.
     *
     * @default - no healthcheck
     * @stability stable
     */
    readonly healthCheck?: HealthCheck;
    /**
     * Represents the configuration for enabling TLS on a listener.
     *
     * @default - none
     * @stability stable
     */
    readonly tls?: ListenerTlsOptions;
    /**
     * Represents the configuration for enabling outlier detection.
     *
     * @default - none
     * @stability stable
     */
    readonly outlierDetection?: OutlierDetection;
}
interface CommonHttpVirtualNodeListenerOptions extends VirtualNodeListenerCommonOptions {
    /**
     * Timeout for HTTP protocol.
     *
     * @default - None
     * @stability stable
     */
    readonly timeout?: HttpTimeout;
}
/**
 * Represent the HTTP Node Listener prorperty.
 *
 * @stability stable
 */
export interface HttpVirtualNodeListenerOptions extends CommonHttpVirtualNodeListenerOptions {
    /**
     * Connection pool for http listeners.
     *
     * @default - None
     * @stability stable
     */
    readonly connectionPool?: HttpConnectionPool;
}
/**
 * Represent the HTTP2 Node Listener prorperty.
 *
 * @stability stable
 */
export interface Http2VirtualNodeListenerOptions extends CommonHttpVirtualNodeListenerOptions {
    /**
     * Connection pool for http2 listeners.
     *
     * @default - None
     * @stability stable
     */
    readonly connectionPool?: Http2ConnectionPool;
}
/**
 * Represent the GRPC Node Listener prorperty.
 *
 * @stability stable
 */
export interface GrpcVirtualNodeListenerOptions extends VirtualNodeListenerCommonOptions {
    /**
     * Timeout for GRPC protocol.
     *
     * @default - None
     * @stability stable
     */
    readonly timeout?: GrpcTimeout;
    /**
     * Connection pool for http listeners.
     *
     * @default - None
     * @stability stable
     */
    readonly connectionPool?: GrpcConnectionPool;
}
/**
 * Represent the TCP Node Listener prorperty.
 *
 * @stability stable
 */
export interface TcpVirtualNodeListenerOptions extends VirtualNodeListenerCommonOptions {
    /**
     * Timeout for TCP protocol.
     *
     * @default - None
     * @stability stable
     */
    readonly timeout?: TcpTimeout;
    /**
     * Connection pool for http listeners.
     *
     * @default - None
     * @stability stable
     */
    readonly connectionPool?: TcpConnectionPool;
}
/**
 * Defines listener for a VirtualNode.
 *
 * @stability stable
 */
export declare abstract class VirtualNodeListener {
    /**
     * Returns an HTTP Listener for a VirtualNode.
     *
     * @stability stable
     */
    static http(props?: HttpVirtualNodeListenerOptions): VirtualNodeListener;
    /**
     * Returns an HTTP2 Listener for a VirtualNode.
     *
     * @stability stable
     */
    static http2(props?: Http2VirtualNodeListenerOptions): VirtualNodeListener;
    /**
     * Returns an GRPC Listener for a VirtualNode.
     *
     * @stability stable
     */
    static grpc(props?: GrpcVirtualNodeListenerOptions): VirtualNodeListener;
    /**
     * Returns an TCP Listener for a VirtualNode.
     *
     * @stability stable
     */
    static tcp(props?: TcpVirtualNodeListenerOptions): VirtualNodeListener;
    /**
     * Binds the current object when adding Listener to a VirtualNode.
     *
     * @stability stable
     */
    abstract bind(scope: Construct): VirtualNodeListenerConfig;
}
export {};
