# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['sweetify', 'sweetify.templatetags']

package_data = \
{'': ['*']}

setup_kwargs = {
    'name': 'sweetify',
    'version': '2.2.0',
    'description': 'SweetAlert integration for Django',
    'long_description': '# Sweetify - SweetAlert for Django\n\n[![Build Status](https://img.shields.io/travis/Atrox/sweetify-django.svg?style=flat-square)](https://travis-ci.org/Atrox/sweetify-django)\n[![Latest Version](https://img.shields.io/pypi/v/sweetify.svg?style=flat-square)](https://pypi.python.org/pypi/sweetify)\n[![Coverage Status](https://img.shields.io/coveralls/Atrox/sweetify-django.svg?style=flat-square)](https://coveralls.io/r/Atrox/sweetify-django)\n\n**Sweetify** allows you to use [SweetAlert](http://t4t5.github.io/sweetalert/) or [SweetAlert2](https://github.com/limonte/sweetalert2) for your temporary messages.\n_See the examples below, to see how to use this library_\n\n## Installation\n**Note: This package does not provide the client-side files of SweetAlert. You have to provide them yourself.**\n\nInstall the latest version with `pip`:\n\n```bash\npip install --upgrade sweetify\n```\n\nThen you have to add `sweetify` to your django apps:\n```python\nINSTALLED_APPS = [\n    ...\n    \'sweetify\'\n]\n```\n\nNext up you have to specify, in your settings, which library you are using (SweetAlert or SweetAlert2):\n```python\n# possible options: \'sweetalert\', \'sweetalert2\' - default is \'sweetalert2\'\nSWEETIFY_SWEETALERT_LIBRARY = \'sweetalert2\'\n```\n\nNext add the following lines to the bottom of your layout/base template:\n```html\n...\n\n{% load sweetify %}\n{% sweetify %}\n\n</body>\n</html>\n```\n\n## Usage\nYou can now easily create alerts in your views with any of the following methods provided by **Sweetify**:\n```python\nimport sweetify\n\n# Base method with no type specified\nsweetify.sweetalert(self.request, \'Westworld is awesome\', text=\'Really... if you have the chance - watch it!\', persistent=\'I agree!\')\n\n# Additional methods with the type already defined\nsweetify.info(self.request, \'Message sent\', button=\'Ok\', timer=3000)\nsweetify.success(self.request, \'You successfully changed your password\')\nsweetify.error(self.request, \'Some error happened here - reload the site\', persistent=\':(\')\nsweetify.warning(self.request, \'This is a warning... I guess\')\n```\n\nWe also support toast messages *(SweetAlert2 only)*\n```python\nimport sweetify\n\n# Base method, default icon is set to success\nsweetify.toast(self.request, \'Cheers to new toast\')\n\nsweetify.toast(self.request, \'Oops, something went wrong !\', icon="error", timer=3000)\nsweetify.toast(self.request, \'Persistent toast that only goes away once clicked\', icon=\'warning\', persistent="Bye toast!")\n```\n\nAdditionally, you can issue multiple alerts without reloading the page **ONLY** if you are using SweetAlerts 2. To do so, you must define your options in a dictionary:\n```python\nimport sweetify\n\n# Call two consecutive alerts (args1 is the options dict for the first alert and args2 the one for the second alert):\nsweetify.multiple(self.request, args1, args2)\n\n# Call five consecutive alerts:\nsweetify.multiple(self.request, args1, args2, args3, args4, args5)\n```\n## Example Usage\n```python\nimport sweetify\n\ndef test_view(request):\n    sweetify.success(request, \'You did it\', text=\'Good job! You successfully showed a SweetAlert message\', persistent=\'Hell yeah\')\n    return redirect(\'/\')\n```\nExample usage for multiple alerts:\n```python\nimport sweetify\n\ndef test_view(request):\n    args1 = dict(title=\'Test1\', icon=\'info\', text="Text placeholder1", button="Next")\n    args2 = dict(title=\'Test2\', icon=\'success\', text="Text placeholder2", timer=5000, timerProgressBar=\'true\', persistent="Close")\n    sweetify.multiple(request, args1, args2)\n    return redirect(\'/\')\n```\n\n## Replacement for SuccessMessageMixin\nSweetify includes a drop-in replacement for `SuccessMessageMixin`.\nJust replace the Django mixin with Sweetify\'s `SweetifySuccessMixin` and you are good to go.\n\n```python\nfrom sweetify.views import SweetifySuccessMixin\n\nclass TestUpdateView(SweetifySuccessMixin, UpdateView):\n    model = TestModel\n    fields = [\'text\']\n    success_message = \'TestModel successfully updated!\'\n```\n\n## Options\n**By default, all alerts will dismiss after a sensible default number of seconds.**\n\nDefault options set by **Sweetify**:\n```python\nsweetify.DEFAULT_OPTS = {\n    \'showConfirmButton\': False,\n    \'timer\': 2500,\n    \'allowOutsideClick\': True,\n    \'confirmButtonText\': \'OK\',\n}\n```\n\nThe following special options provided by **Sweetify** are available:\n```python\n# Shows the alert with a button, but will still close automatically\nsweetify.sweetalert(self.request, \'Title\', button=True)\nsweetify.sweetalert(self.request, \'Title\', button=\'Awesome!\') # Custom text for the button\n\n# Shows the alert with a button and only closes if the button is pressed\nsweetify.sweetalert(self.request, \'Title\', persistent=True)\nsweetify.sweetalert(self.request, \'Title\', persistent=\'Awesome!\') # Custom text for the button\n```\n\nYou also can use any other available option that [SweetAlert accepts](http://t4t5.github.io/sweetalert/):\n```python\nsweetify.info(self.request, \'Sweet!\', text=\'Here is a custom image\', imageUrl=\'images/thumbs-up.jpg\', timer=5000)\n```\n\n\n\n## Development\nUse the `Makefile`to execute common tasks:\n\n- Install dependencies\n```shell\n$ make install\n```\n\n- Run all tests\n```shell\n$ make test\n```\n\n## Contributing\nEveryone is encouraged to help improve this project. Here are a few ways you can help:\n\n- [Report bugs](https://github.com/atrox/sweetify-django/issues)\n- Fix bugs and [submit pull requests](https://github.com/atrox/sweetify-django/pulls)\n- Write, clarify, or fix documentation\n- Suggest or add new features\n',
    'author': 'Atrox',
    'author_email': 'hello@atrox.dev',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/Atrox/sweetify-django',
    'packages': packages,
    'package_data': package_data,
    'python_requires': '>=3.6.2,<4.0.0',
}


setup(**setup_kwargs)
