# -*- coding: utf-8 -*-

"""
coingeckoapiv3

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""

from coingeckoapiv3.api_helper import APIHelper
from coingeckoapiv3.configuration import Server
from coingeckoapiv3.controllers.base_controller import BaseController


class CompaniesBetaController(BaseController):

    """A Controller to access Endpoints in the coingeckoapiv3 API."""

    def __init__(self, config, call_back=None):
        super(CompaniesBetaController, self).__init__(config, call_back)

    def getpubliccompaniesdata(self,
                               coin_id):
        """Does a GET request to /companies/public_treasury/{coin_id}.

        Get public companies bitcoin or ethereum holdings (Ordered by total
        holdings descending)

        Args:
            coin_id (string): bitcoin or ethereum

        Returns:
            void: Response from the API. Get public companies bitcoin or
                ethereum holdings

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/companies/public_treasury/{coin_id}'
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, {
            'coin_id': {'value': coin_id, 'encode': True}
        })
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare and execute request
        _request = self.config.http_client.get(_query_url)
        _response = self.execute_request(_request)
        self.validate_response(_response)
