# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from . import _utilities, _tables
from . import outputs
from ._inputs import *

__all__ = ['InputsUdp']


class InputsUdp(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acl: Optional[pulumi.Input[pulumi.InputType['InputsUdpAclArgs']]] = None,
                 connection_host: Optional[pulumi.Input[str]] = None,
                 disabled: Optional[pulumi.Input[bool]] = None,
                 host: Optional[pulumi.Input[str]] = None,
                 index: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 no_appending_timestamp: Optional[pulumi.Input[bool]] = None,
                 no_priority_stripping: Optional[pulumi.Input[bool]] = None,
                 queue: Optional[pulumi.Input[str]] = None,
                 restrict_to_host: Optional[pulumi.Input[str]] = None,
                 source: Optional[pulumi.Input[str]] = None,
                 sourcetype: Optional[pulumi.Input[str]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        ## # Resource: InputsTcpRaw

        Create and manage UDP data inputs.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_splunk as splunk

        udp = splunk.InputsUdp("udp",
            disabled=False,
            index="main",
            source="new",
            sourcetype="new")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['InputsUdpAclArgs']] acl: The app/user context that is the namespace for the resource
        :param pulumi.Input[str] connection_host: Valid values: (ip | dns | none)
               Set the host for the remote server that is sending data.
               ip sets the host to the IP address of the remote server sending data.
               dns sets the host to the reverse DNS entry for the IP address of the remote server sending data.
               none leaves the host as specified in inputs.conf, which is typically the Splunk system hostname.
               Default value is dns.
        :param pulumi.Input[bool] disabled: Indicates if input is disabled.
        :param pulumi.Input[str] host: The value to populate in the host field for incoming events. This is used during parsing/indexing, in particular to set the host field. It is also the host field used at search time.
        :param pulumi.Input[str] index: Which index events from this input should be stored in. Defaults to default.
        :param pulumi.Input[str] name: The UDP port that this input should listen on.
        :param pulumi.Input[bool] no_appending_timestamp: If set to true, prevents Splunk software from prepending a timestamp and hostname to incoming events.
        :param pulumi.Input[bool] no_priority_stripping: If set to true, Splunk software does not remove the priority field from incoming syslog events.
        :param pulumi.Input[str] queue: Which queue events from this input should be sent to. Generally this does not need to be changed.
        :param pulumi.Input[str] restrict_to_host: Restrict incoming connections on this port to the host specified here.
               If this is not set, the value specified in [udp://<remote server>:<port>] in inputs.conf is used.
        :param pulumi.Input[str] source: The value to populate in the source field for incoming events. The same source should not be used for multiple data inputs.
        :param pulumi.Input[str] sourcetype: The value to populate in the sourcetype field for incoming events.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['acl'] = acl
            __props__['connection_host'] = connection_host
            __props__['disabled'] = disabled
            __props__['host'] = host
            __props__['index'] = index
            __props__['name'] = name
            __props__['no_appending_timestamp'] = no_appending_timestamp
            __props__['no_priority_stripping'] = no_priority_stripping
            __props__['queue'] = queue
            __props__['restrict_to_host'] = restrict_to_host
            __props__['source'] = source
            __props__['sourcetype'] = sourcetype
        super(InputsUdp, __self__).__init__(
            'splunk:index/inputsUdp:InputsUdp',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            acl: Optional[pulumi.Input[pulumi.InputType['InputsUdpAclArgs']]] = None,
            connection_host: Optional[pulumi.Input[str]] = None,
            disabled: Optional[pulumi.Input[bool]] = None,
            host: Optional[pulumi.Input[str]] = None,
            index: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            no_appending_timestamp: Optional[pulumi.Input[bool]] = None,
            no_priority_stripping: Optional[pulumi.Input[bool]] = None,
            queue: Optional[pulumi.Input[str]] = None,
            restrict_to_host: Optional[pulumi.Input[str]] = None,
            source: Optional[pulumi.Input[str]] = None,
            sourcetype: Optional[pulumi.Input[str]] = None) -> 'InputsUdp':
        """
        Get an existing InputsUdp resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['InputsUdpAclArgs']] acl: The app/user context that is the namespace for the resource
        :param pulumi.Input[str] connection_host: Valid values: (ip | dns | none)
               Set the host for the remote server that is sending data.
               ip sets the host to the IP address of the remote server sending data.
               dns sets the host to the reverse DNS entry for the IP address of the remote server sending data.
               none leaves the host as specified in inputs.conf, which is typically the Splunk system hostname.
               Default value is dns.
        :param pulumi.Input[bool] disabled: Indicates if input is disabled.
        :param pulumi.Input[str] host: The value to populate in the host field for incoming events. This is used during parsing/indexing, in particular to set the host field. It is also the host field used at search time.
        :param pulumi.Input[str] index: Which index events from this input should be stored in. Defaults to default.
        :param pulumi.Input[str] name: The UDP port that this input should listen on.
        :param pulumi.Input[bool] no_appending_timestamp: If set to true, prevents Splunk software from prepending a timestamp and hostname to incoming events.
        :param pulumi.Input[bool] no_priority_stripping: If set to true, Splunk software does not remove the priority field from incoming syslog events.
        :param pulumi.Input[str] queue: Which queue events from this input should be sent to. Generally this does not need to be changed.
        :param pulumi.Input[str] restrict_to_host: Restrict incoming connections on this port to the host specified here.
               If this is not set, the value specified in [udp://<remote server>:<port>] in inputs.conf is used.
        :param pulumi.Input[str] source: The value to populate in the source field for incoming events. The same source should not be used for multiple data inputs.
        :param pulumi.Input[str] sourcetype: The value to populate in the sourcetype field for incoming events.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["acl"] = acl
        __props__["connection_host"] = connection_host
        __props__["disabled"] = disabled
        __props__["host"] = host
        __props__["index"] = index
        __props__["name"] = name
        __props__["no_appending_timestamp"] = no_appending_timestamp
        __props__["no_priority_stripping"] = no_priority_stripping
        __props__["queue"] = queue
        __props__["restrict_to_host"] = restrict_to_host
        __props__["source"] = source
        __props__["sourcetype"] = sourcetype
        return InputsUdp(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def acl(self) -> pulumi.Output['outputs.InputsUdpAcl']:
        """
        The app/user context that is the namespace for the resource
        """
        return pulumi.get(self, "acl")

    @property
    @pulumi.getter(name="connectionHost")
    def connection_host(self) -> pulumi.Output[str]:
        """
        Valid values: (ip | dns | none)
        Set the host for the remote server that is sending data.
        ip sets the host to the IP address of the remote server sending data.
        dns sets the host to the reverse DNS entry for the IP address of the remote server sending data.
        none leaves the host as specified in inputs.conf, which is typically the Splunk system hostname.
        Default value is dns.
        """
        return pulumi.get(self, "connection_host")

    @property
    @pulumi.getter
    def disabled(self) -> pulumi.Output[bool]:
        """
        Indicates if input is disabled.
        """
        return pulumi.get(self, "disabled")

    @property
    @pulumi.getter
    def host(self) -> pulumi.Output[str]:
        """
        The value to populate in the host field for incoming events. This is used during parsing/indexing, in particular to set the host field. It is also the host field used at search time.
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter
    def index(self) -> pulumi.Output[str]:
        """
        Which index events from this input should be stored in. Defaults to default.
        """
        return pulumi.get(self, "index")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The UDP port that this input should listen on.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="noAppendingTimestamp")
    def no_appending_timestamp(self) -> pulumi.Output[bool]:
        """
        If set to true, prevents Splunk software from prepending a timestamp and hostname to incoming events.
        """
        return pulumi.get(self, "no_appending_timestamp")

    @property
    @pulumi.getter(name="noPriorityStripping")
    def no_priority_stripping(self) -> pulumi.Output[bool]:
        """
        If set to true, Splunk software does not remove the priority field from incoming syslog events.
        """
        return pulumi.get(self, "no_priority_stripping")

    @property
    @pulumi.getter
    def queue(self) -> pulumi.Output[str]:
        """
        Which queue events from this input should be sent to. Generally this does not need to be changed.
        """
        return pulumi.get(self, "queue")

    @property
    @pulumi.getter(name="restrictToHost")
    def restrict_to_host(self) -> pulumi.Output[str]:
        """
        Restrict incoming connections on this port to the host specified here.
        If this is not set, the value specified in [udp://<remote server>:<port>] in inputs.conf is used.
        """
        return pulumi.get(self, "restrict_to_host")

    @property
    @pulumi.getter
    def source(self) -> pulumi.Output[str]:
        """
        The value to populate in the source field for incoming events. The same source should not be used for multiple data inputs.
        """
        return pulumi.get(self, "source")

    @property
    @pulumi.getter
    def sourcetype(self) -> pulumi.Output[str]:
        """
        The value to populate in the sourcetype field for incoming events.
        """
        return pulumi.get(self, "sourcetype")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

