# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from . import _utilities, _tables

__all__ = ['InputsTcpSsl']


class InputsTcpSsl(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 disabled: Optional[pulumi.Input[bool]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 require_client_cert: Optional[pulumi.Input[bool]] = None,
                 root_ca: Optional[pulumi.Input[str]] = None,
                 server_cert: Optional[pulumi.Input[str]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        ## # Resource: InputsTcpSsl

        Access or update the SSL configuration for the host.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_splunk as splunk

        test = splunk.InputsTcpSsl("test",
            disabled=False,
            require_client_cert=True)
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] disabled: Indicates if input is disabled.
        :param pulumi.Input[str] password: Server certificate password, if any.
        :param pulumi.Input[bool] require_client_cert: Determines whether a client must authenticate.
        :param pulumi.Input[str] root_ca: Certificate authority list (root file)
        :param pulumi.Input[str] server_cert: Full path to the server certificate.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['disabled'] = disabled
            __props__['password'] = password
            __props__['require_client_cert'] = require_client_cert
            __props__['root_ca'] = root_ca
            __props__['server_cert'] = server_cert
        super(InputsTcpSsl, __self__).__init__(
            'splunk:index/inputsTcpSsl:InputsTcpSsl',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            disabled: Optional[pulumi.Input[bool]] = None,
            password: Optional[pulumi.Input[str]] = None,
            require_client_cert: Optional[pulumi.Input[bool]] = None,
            root_ca: Optional[pulumi.Input[str]] = None,
            server_cert: Optional[pulumi.Input[str]] = None) -> 'InputsTcpSsl':
        """
        Get an existing InputsTcpSsl resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] disabled: Indicates if input is disabled.
        :param pulumi.Input[str] password: Server certificate password, if any.
        :param pulumi.Input[bool] require_client_cert: Determines whether a client must authenticate.
        :param pulumi.Input[str] root_ca: Certificate authority list (root file)
        :param pulumi.Input[str] server_cert: Full path to the server certificate.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["disabled"] = disabled
        __props__["password"] = password
        __props__["require_client_cert"] = require_client_cert
        __props__["root_ca"] = root_ca
        __props__["server_cert"] = server_cert
        return InputsTcpSsl(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def disabled(self) -> pulumi.Output[bool]:
        """
        Indicates if input is disabled.
        """
        return pulumi.get(self, "disabled")

    @property
    @pulumi.getter
    def password(self) -> pulumi.Output[str]:
        """
        Server certificate password, if any.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="requireClientCert")
    def require_client_cert(self) -> pulumi.Output[bool]:
        """
        Determines whether a client must authenticate.
        """
        return pulumi.get(self, "require_client_cert")

    @property
    @pulumi.getter(name="rootCa")
    def root_ca(self) -> pulumi.Output[str]:
        """
        Certificate authority list (root file)
        """
        return pulumi.get(self, "root_ca")

    @property
    @pulumi.getter(name="serverCert")
    def server_cert(self) -> pulumi.Output[str]:
        """
        Full path to the server certificate.
        """
        return pulumi.get(self, "server_cert")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

