# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from . import _utilities, _tables
from . import outputs
from ._inputs import *

__all__ = ['InputsTcpSplunkTcpToken']


class InputsTcpSplunkTcpToken(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acl: Optional[pulumi.Input[pulumi.InputType['InputsTcpSplunkTcpTokenAclArgs']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 token: Optional[pulumi.Input[str]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        ## # Resource: InputsTcpSplunkTcpToken

        Manage receiver access using tokens.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_splunk as splunk

        tcp_splunk_tcp_token = splunk.InputsTcpSplunkTcpToken("tcpSplunkTcpToken", token="D66C45B3-7C28-48A1-A13A-027914146501")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['InputsTcpSplunkTcpTokenAclArgs']] acl: The app/user context that is the namespace for the resource
        :param pulumi.Input[str] name: Required. Name for the token to create.
        :param pulumi.Input[str] token: Optional. Token value to use. If unspecified, a token is generated automatically.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['acl'] = acl
            __props__['name'] = name
            __props__['token'] = token
        super(InputsTcpSplunkTcpToken, __self__).__init__(
            'splunk:index/inputsTcpSplunkTcpToken:InputsTcpSplunkTcpToken',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            acl: Optional[pulumi.Input[pulumi.InputType['InputsTcpSplunkTcpTokenAclArgs']]] = None,
            name: Optional[pulumi.Input[str]] = None,
            token: Optional[pulumi.Input[str]] = None) -> 'InputsTcpSplunkTcpToken':
        """
        Get an existing InputsTcpSplunkTcpToken resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['InputsTcpSplunkTcpTokenAclArgs']] acl: The app/user context that is the namespace for the resource
        :param pulumi.Input[str] name: Required. Name for the token to create.
        :param pulumi.Input[str] token: Optional. Token value to use. If unspecified, a token is generated automatically.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["acl"] = acl
        __props__["name"] = name
        __props__["token"] = token
        return InputsTcpSplunkTcpToken(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def acl(self) -> pulumi.Output['outputs.InputsTcpSplunkTcpTokenAcl']:
        """
        The app/user context that is the namespace for the resource
        """
        return pulumi.get(self, "acl")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Required. Name for the token to create.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def token(self) -> pulumi.Output[str]:
        """
        Optional. Token value to use. If unspecified, a token is generated automatically.
        """
        return pulumi.get(self, "token")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

