# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from . import _utilities, _tables
from . import outputs
from ._inputs import *

__all__ = ['AppsLocal']


class AppsLocal(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acl: Optional[pulumi.Input[pulumi.InputType['AppsLocalAclArgs']]] = None,
                 auth: Optional[pulumi.Input[str]] = None,
                 author: Optional[pulumi.Input[str]] = None,
                 configured: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 explicit_appname: Optional[pulumi.Input[str]] = None,
                 filename: Optional[pulumi.Input[bool]] = None,
                 label: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 session: Optional[pulumi.Input[str]] = None,
                 update: Optional[pulumi.Input[bool]] = None,
                 version: Optional[pulumi.Input[str]] = None,
                 visible: Optional[pulumi.Input[bool]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        ## # Resource: AppsLocal

        Create, install and manage apps on your Splunk instance

        ## Example Usage

        ```python
        import pulumi
        import pulumi_splunk as splunk

        amazon_connect_app = splunk.AppsLocal("amazonConnectApp",
            explicit_appname="amazon_connect_app_for_splunk",
            filename=True)
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['AppsLocalAclArgs']] acl: The app/user context that is the namespace for the resource
        :param pulumi.Input[str] auth: Splunkbase session token for operations like install and update that require login. Use auth or session when installing or updating an app through Splunkbase.
        :param pulumi.Input[str] author: For apps posted to Splunkbase, use your Splunk account username. For internal apps, include your name and contact information.
        :param pulumi.Input[bool] configured: Custom setup complete indication:
               <br>true = Custom app setup complete.
               <br>false = Custom app setup not complete.
        :param pulumi.Input[str] description: Short app description also displayed below the app title in Splunk Web Launcher.
        :param pulumi.Input[str] explicit_appname: Custom app name. Overrides name when installing an app from a file where filename is set to true. See also filename.
        :param pulumi.Input[bool] filename: Indicates whether to use the name value as the app source location.
               <br>true indicates that name is a path to a file to install.
               <br>false indicates that name is the literal app name and that the app is created from Splunkbase using a template.
        :param pulumi.Input[str] label: App name displayed in Splunk Web, from five to eighty characters excluding the prefix "Splunk for".
        :param pulumi.Input[str] name: Literal app name or path for the file to install, depending on the value of filename.
               <br>filename = false indicates that name is the literal app name and that the app is created from Splunkbase using a template.
               <br>filename = true indicates that name is the URL or path to the local .tar, .tgz or .spl file. If name is the Splunkbase URL, set auth or session to authenticate the request.
               The app folder name cannot include spaces or special characters.
        :param pulumi.Input[str] session: Login session token for installing or updating an app on Splunkbase. Alternatively, use auth.
        :param pulumi.Input[bool] update: File-based update indication:
               <br>true specifies that filename should be used to update an existing app. If not specified, update defaults to
               <br>false, which indicates that filename should not be used to update an existing app.
        :param pulumi.Input[str] version: App version.
        :param pulumi.Input[bool] visible: Indicates whether the app is visible and navigable from Splunk Web.
               <br>true = App is visible and navigable.
               <br>false = App is not visible or navigable.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['acl'] = acl
            __props__['auth'] = auth
            __props__['author'] = author
            __props__['configured'] = configured
            __props__['description'] = description
            __props__['explicit_appname'] = explicit_appname
            __props__['filename'] = filename
            __props__['label'] = label
            __props__['name'] = name
            __props__['session'] = session
            __props__['update'] = update
            __props__['version'] = version
            __props__['visible'] = visible
        super(AppsLocal, __self__).__init__(
            'splunk:index/appsLocal:AppsLocal',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            acl: Optional[pulumi.Input[pulumi.InputType['AppsLocalAclArgs']]] = None,
            auth: Optional[pulumi.Input[str]] = None,
            author: Optional[pulumi.Input[str]] = None,
            configured: Optional[pulumi.Input[bool]] = None,
            description: Optional[pulumi.Input[str]] = None,
            explicit_appname: Optional[pulumi.Input[str]] = None,
            filename: Optional[pulumi.Input[bool]] = None,
            label: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            session: Optional[pulumi.Input[str]] = None,
            update: Optional[pulumi.Input[bool]] = None,
            version: Optional[pulumi.Input[str]] = None,
            visible: Optional[pulumi.Input[bool]] = None) -> 'AppsLocal':
        """
        Get an existing AppsLocal resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['AppsLocalAclArgs']] acl: The app/user context that is the namespace for the resource
        :param pulumi.Input[str] auth: Splunkbase session token for operations like install and update that require login. Use auth or session when installing or updating an app through Splunkbase.
        :param pulumi.Input[str] author: For apps posted to Splunkbase, use your Splunk account username. For internal apps, include your name and contact information.
        :param pulumi.Input[bool] configured: Custom setup complete indication:
               <br>true = Custom app setup complete.
               <br>false = Custom app setup not complete.
        :param pulumi.Input[str] description: Short app description also displayed below the app title in Splunk Web Launcher.
        :param pulumi.Input[str] explicit_appname: Custom app name. Overrides name when installing an app from a file where filename is set to true. See also filename.
        :param pulumi.Input[bool] filename: Indicates whether to use the name value as the app source location.
               <br>true indicates that name is a path to a file to install.
               <br>false indicates that name is the literal app name and that the app is created from Splunkbase using a template.
        :param pulumi.Input[str] label: App name displayed in Splunk Web, from five to eighty characters excluding the prefix "Splunk for".
        :param pulumi.Input[str] name: Literal app name or path for the file to install, depending on the value of filename.
               <br>filename = false indicates that name is the literal app name and that the app is created from Splunkbase using a template.
               <br>filename = true indicates that name is the URL or path to the local .tar, .tgz or .spl file. If name is the Splunkbase URL, set auth or session to authenticate the request.
               The app folder name cannot include spaces or special characters.
        :param pulumi.Input[str] session: Login session token for installing or updating an app on Splunkbase. Alternatively, use auth.
        :param pulumi.Input[bool] update: File-based update indication:
               <br>true specifies that filename should be used to update an existing app. If not specified, update defaults to
               <br>false, which indicates that filename should not be used to update an existing app.
        :param pulumi.Input[str] version: App version.
        :param pulumi.Input[bool] visible: Indicates whether the app is visible and navigable from Splunk Web.
               <br>true = App is visible and navigable.
               <br>false = App is not visible or navigable.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["acl"] = acl
        __props__["auth"] = auth
        __props__["author"] = author
        __props__["configured"] = configured
        __props__["description"] = description
        __props__["explicit_appname"] = explicit_appname
        __props__["filename"] = filename
        __props__["label"] = label
        __props__["name"] = name
        __props__["session"] = session
        __props__["update"] = update
        __props__["version"] = version
        __props__["visible"] = visible
        return AppsLocal(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def acl(self) -> pulumi.Output['outputs.AppsLocalAcl']:
        """
        The app/user context that is the namespace for the resource
        """
        return pulumi.get(self, "acl")

    @property
    @pulumi.getter
    def auth(self) -> pulumi.Output[Optional[str]]:
        """
        Splunkbase session token for operations like install and update that require login. Use auth or session when installing or updating an app through Splunkbase.
        """
        return pulumi.get(self, "auth")

    @property
    @pulumi.getter
    def author(self) -> pulumi.Output[str]:
        """
        For apps posted to Splunkbase, use your Splunk account username. For internal apps, include your name and contact information.
        """
        return pulumi.get(self, "author")

    @property
    @pulumi.getter
    def configured(self) -> pulumi.Output[bool]:
        """
        Custom setup complete indication:
        <br>true = Custom app setup complete.
        <br>false = Custom app setup not complete.
        """
        return pulumi.get(self, "configured")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        Short app description also displayed below the app title in Splunk Web Launcher.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="explicitAppname")
    def explicit_appname(self) -> pulumi.Output[Optional[str]]:
        """
        Custom app name. Overrides name when installing an app from a file where filename is set to true. See also filename.
        """
        return pulumi.get(self, "explicit_appname")

    @property
    @pulumi.getter
    def filename(self) -> pulumi.Output[Optional[bool]]:
        """
        Indicates whether to use the name value as the app source location.
        <br>true indicates that name is a path to a file to install.
        <br>false indicates that name is the literal app name and that the app is created from Splunkbase using a template.
        """
        return pulumi.get(self, "filename")

    @property
    @pulumi.getter
    def label(self) -> pulumi.Output[str]:
        """
        App name displayed in Splunk Web, from five to eighty characters excluding the prefix "Splunk for".
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Literal app name or path for the file to install, depending on the value of filename.
        <br>filename = false indicates that name is the literal app name and that the app is created from Splunkbase using a template.
        <br>filename = true indicates that name is the URL or path to the local .tar, .tgz or .spl file. If name is the Splunkbase URL, set auth or session to authenticate the request.
        The app folder name cannot include spaces or special characters.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def session(self) -> pulumi.Output[Optional[str]]:
        """
        Login session token for installing or updating an app on Splunkbase. Alternatively, use auth.
        """
        return pulumi.get(self, "session")

    @property
    @pulumi.getter
    def update(self) -> pulumi.Output[Optional[bool]]:
        """
        File-based update indication:
        <br>true specifies that filename should be used to update an existing app. If not specified, update defaults to
        <br>false, which indicates that filename should not be used to update an existing app.
        """
        return pulumi.get(self, "update")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[str]:
        """
        App version.
        """
        return pulumi.get(self, "version")

    @property
    @pulumi.getter
    def visible(self) -> pulumi.Output[bool]:
        """
        Indicates whether the app is visible and navigable from Splunk Web.
        <br>true = App is visible and navigable.
        <br>false = App is not visible or navigable.
        """
        return pulumi.get(self, "visible")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

