"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.app = void 0;
const ec2 = require("@aws-cdk/aws-ec2");
const cloudmap = require("@aws-cdk/aws-servicediscovery");
const cdk = require("@aws-cdk/core");
const appmesh = require("../lib/");
exports.app = new cdk.App();
const stack = new cdk.Stack(exports.app, 'mesh-stack', {});
const vpc = new ec2.Vpc(stack, 'vpc', {
    natGateways: 1,
});
const namespace = new cloudmap.PrivateDnsNamespace(stack, 'test-namespace', {
    vpc,
    name: 'domain.local',
});
const mesh = new appmesh.Mesh(stack, 'mesh');
const router = mesh.addVirtualRouter('router', {
    listener: {
        portMapping: {
            port: 8080,
            protocol: appmesh.Protocol.HTTP,
        },
    },
});
const virtualService = mesh.addVirtualService('service', {
    virtualRouter: router,
    virtualServiceName: 'service1.domain.local',
});
const node = mesh.addVirtualNode('node', {
    dnsHostName: `node1.${namespace.namespaceName}`,
    listener: {
        healthCheck: {
            healthyThreshold: 3,
            path: '/check-path',
        },
    },
    backends: [
        virtualService,
    ],
});
node.addBackends(new appmesh.VirtualService(stack, 'service-2', {
    virtualServiceName: 'service2.domain.local',
    mesh,
}));
router.addRoute('route-1', {
    routeTargets: [
        {
            virtualNode: node,
            weight: 50,
        },
    ],
    prefix: '/',
});
const node2 = mesh.addVirtualNode('node2', {
    dnsHostName: `node2.${namespace.namespaceName}`,
    listener: {
        healthCheck: {
            healthyThreshold: 3,
            interval: cdk.Duration.seconds(5),
            path: '/check-path2',
            port: 8080,
            protocol: appmesh.Protocol.HTTP,
            timeout: cdk.Duration.seconds(2),
            unhealthyThreshold: 2,
        },
    },
    backends: [
        new appmesh.VirtualService(stack, 'service-3', {
            virtualServiceName: 'service3.domain.local',
            mesh,
        }),
    ],
});
const node3 = mesh.addVirtualNode('node3', {
    dnsHostName: `node3.${namespace.namespaceName}`,
    listener: {
        healthCheck: {
            healthyThreshold: 3,
            interval: cdk.Duration.seconds(5),
            path: '/check-path3',
            port: 8080,
            protocol: appmesh.Protocol.HTTP,
            timeout: cdk.Duration.seconds(2),
            unhealthyThreshold: 2,
        },
    },
});
router.addRoute('route-2', {
    routeTargets: [
        {
            virtualNode: node2,
            weight: 30,
        },
    ],
    prefix: '/path2',
});
router.addRoute('route-3', {
    routeTargets: [
        {
            virtualNode: node3,
            weight: 20,
        },
    ],
});
//# sourceMappingURL=data:application/json;base64,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