"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApplicationCode = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const s3_assets = require("@aws-cdk/aws-s3-assets");
/**
 * Code configuration providing the location to a Flink application JAR file.
 */
class ApplicationCode {
    /**
     * Reference code from an S3 bucket.
     *
     * @param bucket - an s3 bucket
     * @param fileKey - a key pointing to a Flink JAR file
     * @param objectVersion - an optional version string for the provided fileKey
     */
    static fromBucket(bucket, fileKey, objectVersion) {
        return new BucketApplicationCode({
            bucket,
            fileKey,
            objectVersion,
        });
    }
    /**
     * Reference code from a local directory containing a Flink JAR file.
     *
     * @param path - a local directory path
     * @parm options - standard s3 AssetOptions
     */
    static fromAsset(path, options) {
        return new AssetApplicationCode(path, options);
    }
}
exports.ApplicationCode = ApplicationCode;
_a = JSII_RTTI_SYMBOL_1;
ApplicationCode[_a] = { fqn: "@aws-cdk/aws-kinesisanalytics-flink.ApplicationCode", version: "1.184.1" };
class BucketApplicationCode extends ApplicationCode {
    constructor(props) {
        super();
        this.bucket = props.bucket;
        this.fileKey = props.fileKey;
        this.objectVersion = props.objectVersion;
    }
    bind(_scope) {
        return {
            applicationCodeConfigurationProperty: {
                applicationCodeConfiguration: {
                    codeContent: {
                        s3ContentLocation: {
                            bucketArn: this.bucket.bucketArn,
                            fileKey: this.fileKey,
                            objectVersion: this.objectVersion,
                        },
                    },
                    codeContentType: 'ZIPFILE',
                },
            },
            bucket: this.bucket,
        };
    }
}
class AssetApplicationCode extends ApplicationCode {
    constructor(path, options) {
        super();
        this.path = path;
        this.options = options;
    }
    bind(scope) {
        this._asset = new s3_assets.Asset(scope, 'Code', {
            path: this.path,
            ...this.options,
        });
        if (!this._asset.isZipArchive) {
            throw new Error(`Asset must be a .zip file or a directory (${this.path})`);
        }
        return {
            applicationCodeConfigurationProperty: {
                applicationCodeConfiguration: {
                    codeContent: {
                        s3ContentLocation: {
                            bucketArn: this._asset.bucket.bucketArn,
                            fileKey: this._asset.s3ObjectKey,
                        },
                    },
                    codeContentType: 'ZIPFILE',
                },
            },
            bucket: this._asset.bucket,
        };
    }
    get asset() {
        return this._asset;
    }
    get bucket() {
        return this._asset?.bucket;
    }
}
//# sourceMappingURL=data:application/json;base64,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