# AUTOGENERATED! DO NOT EDIT! File to edit: apt.ipynb (unless otherwise specified).

__all__ = ['get_apartments', 'show_apts']

# Cell
#export
from fastcore.all import urlread, L, test_eq, call_parse, first
from bs4 import BeautifulSoup as bs

# Cell
def get_apartments(region:str, #craiglist region like `portland`
                  ):
    "return listing of apartments from craigslist"
    try:
        _pg = bs(urlread(f'https://{region}.craigslist.org/search/apa'), features='lxml')
    except:
        raise Exception(f"could not pull website for {region}")
    return L(_pg.find_all('li', {'class': 'result-row'})).map(lambda x: x.a['href'])

# Cell

@call_parse
def show_apts(region:str, #craiglist region like `portland`
             n:int, #show n listings
             ):
    "Show links to apartments on craigslist"
    print(f"Showing {n} apartments in {region}\n{'='*50}")
    for a in get_apartments(region)[:n]:
        print(a)