# -*- coding: utf-8 -*-

""" Code is generated by ucloud-model, DO NOT EDIT IT. """
from ucloud.core.client import Client
from ucloud.services.ucloudstack.schemas import apis


class UCloudStackClient(Client):
    def __init__(self, config, transport=None, middleware=None, logger=None):
        super(UCloudStackClient, self).__init__(
            config, transport, middleware, logger
        )

    def allocate_eip(self, req=None, **kwargs):
        """ AllocateEIP - 申请外网IP

        **Request**

        - **Region** (str) - (Config) 地域。枚举值：cn,表示中国；
        - **Bandwidth** (int) - (Required) 带宽，默认值1，默认范围1~100
        - **ChargeType** (str) - (Required) 计费模式。枚举值：Dynamic，表示小时；Month，表示月；Year，表示年；
        - **Name** (str) - (Required) 名称
        - **OperatorName** (str) - (Required) 线路。目前支持Bgp
        - **Zone** (str) - (Required) 可用区。枚举值：zone-01，表示中国；
        - **Quantity** (int) - 购买时长。默认值1。小时不生效，月范围【1，11】，年范围【1，5】。
        
        **Response**

        - **EIPID** (str) - 申请的EIP的ID
        - **Message** (str) - 返回信息描述。
        
        """
        d = {"Region": self.config.region}
        req and d.update(req)
        d = apis.AllocateEIPRequestSchema().dumps(d)
        resp = self.invoke("AllocateEIP", d, **kwargs)
        return apis.AllocateEIPResponseSchema().loads(resp)

    def attach_disk(self, req=None, **kwargs):
        """ AttachDisk - 绑定硬盘

        **Request**

        - **Region** (str) - (Config) 地域。枚举值：cn,表示中国；
        - **DiskID** (str) - (Required) 硬盘ID
        - **ResourceID** (str) - (Required) 绑定的资源ID
        - **ResourceType** (str) - (Required) 绑定的资源类型，枚举值：VM，标识虚拟机
        - **Zone** (str) - (Required) 可用区。枚举值：zone-01，表示中国；
        
        **Response**

        - **Message** (str) - 返回信息描述。
        
        """
        d = {"Region": self.config.region}
        req and d.update(req)
        d = apis.AttachDiskRequestSchema().dumps(d)
        resp = self.invoke("AttachDisk", d, **kwargs)
        return apis.AttachDiskResponseSchema().loads(resp)

    def bind_alarm_template(self, req=None, **kwargs):
        """ BindAlarmTemplate - 绑定告警模板

        **Request**

        - **Region** (str) - (Config) 地域。枚举值： cn，表示中国；
        - **AlarmTemplateID** (str) - (Required) 告警模板ID
        - **ResourceIDs** (list) - (Required) 【数组】告警模板ID。调用方式举例：ResourceIDs.0=“one-id”、ResourceIDs.1=“two-id”。
        - **ResourceType** (str) - (Required) 资源类型。VM：虚拟机, LB:负载均衡, NATGW：nat网关;EIP:弹性IP
        - **Zone** (str) - (Required) 可用区。枚举值：zone-01，表示中国；
        
        **Response**

        - **Message** (str) - 返回信息描述
        
        """
        d = {"Region": self.config.region}
        req and d.update(req)
        d = apis.BindAlarmTemplateRequestSchema().dumps(d)
        resp = self.invoke("BindAlarmTemplate", d, **kwargs)
        return apis.BindAlarmTemplateResponseSchema().loads(resp)

    def bind_eip(self, req=None, **kwargs):
        """ BindEIP - 绑定UCoudStack外网IP

        **Request**

        - **Region** (str) - (Config) 地域。枚举值：cn,表示中国；中国
        - **EIPID** (str) - (Required) 外网IP的ID
        - **ResourceID** (str) - (Required) 资源ID
        - **ResourceType** (str) - (Required) 资源类型。VM：虚拟机, LB:负载均衡, NATGW：nat网关
        - **Zone** (str) - (Required) 可用区。枚举值：zone-01，表示中国；
        
        **Response**

        - **Message** (str) - 返回描述
        
        """
        d = {"Region": self.config.region}
        req and d.update(req)
        d = apis.BindEIPRequestSchema().dumps(d)
        resp = self.invoke("BindEIP", d, **kwargs)
        return apis.BindEIPResponseSchema().loads(resp)

    def bind_physical_ip(self, req=None, **kwargs):
        """ BindPhysicalIP - 绑定物理 IP ，被绑定的资源必须处于运行中或有效状态。

        **Request**

        - **Region** (str) - (Config) 地域。
        - **PhysicalIPID** (str) - (Required) 物理IP的ID
        - **ResourceID** (str) - (Required) 资源ID
        - **ResourceType** (str) - (Required) 资源类型。VM：虚拟机
        - **Zone** (str) - (Required) 可用区。
        
        **Response**

        - **Message** (str) - 返回描述
        
        """
        d = {"Region": self.config.region}
        req and d.update(req)
        d = apis.BindPhysicalIPRequestSchema().dumps(d)
        resp = self.invoke("BindPhysicalIP", d, **kwargs)
        return apis.BindPhysicalIPResponseSchema().loads(resp)

    def bind_security_group(self, req=None, **kwargs):
        """ BindSecurityGroup - 绑定安全组

        **Request**

        - **Region** (str) - (Config) 地域。枚举值： cn，表示中国；
        - **ResourceID** (str) - (Required) 绑定的资源ID。调用方式举例：ResourceID=“one-id”。
        - **SGID** (str) - (Required) 安全组ID
        - **Zone** (str) - (Required) 可用区。枚举值：zone-01，表示中国；
        - **NICID** (str) - 网卡ID
        
        **Response**

        - **Message** (str) - 返回信息描述
        
        """
        d = {"Region": self.config.region}
        req and d.update(req)
        d = apis.BindSecurityGroupRequestSchema().dumps(d)
        resp = self.invoke("BindSecurityGroup", d, **kwargs)
        return apis.BindSecurityGroupResponseSchema().loads(resp)

    def clone_disk(self, req=None, **kwargs):
        """ CloneDisk - 克隆硬盘

        **Request**

        - **Region** (str) - (Config) 地域。枚举值：cn,表示中国；
        - **ChargeType** (str) - (Required) 计费模式。枚举值：Dynamic，表示小时；Month，表示月；Year，表示年；
        - **Name** (str) - (Required) 名称
        - **SrcID** (str) - (Required) 源硬盘ID
        - **Zone** (str) - (Required) 可用区。枚举值：zone-01，表示中国；
        - **Quantity** (int) - 购买时长。默认值1。小时不生效，月范围【1，11】，年范围【1，5】。
        
        **Response**

        - **DiskID** (str) - 克隆出的硬盘ID
        - **Message** (str) - 返回信息描述。
        
        """
        d = {"Region": self.config.region}
        req and d.update(req)
        d = apis.CloneDiskRequestSchema().dumps(d)
        resp = self.invoke("CloneDisk", d, **kwargs)
        return apis.CloneDiskResponseSchema().loads(resp)

    def create_certificate(self, req=None, **kwargs):
        """ CreateCertificate - 创建证书

        **Request**

        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist.html>`_ 
        - **Certificate** (str) - (Required) 证书内容
        - **CertificateType** (str) - (Required) 证书类型，枚举值["ServerCrt","CACrt"]。分别表示服务器证书和CA证书。只有在双向认证的时候才需要CA证书
        - **Name** (str) - (Required) 证书名称
        - **Zone** (str) - (Required) 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist.html>`_ 
        - **PrivateKey** (str) - 私钥内容,服务器证书必传,CA证书不用传递
        - **Remark** (str) - 证书描述
        
        **Response**

        - **CertificateID** (str) - 证书ID
        - **Message** (str) - 错误描述
        
        """
        d = {"Region": self.config.region}
        req and d.update(req)
        d = apis.CreateCertificateRequestSchema().dumps(d)
        resp = self.invoke("CreateCertificate", d, **kwargs)
        return apis.CreateCertificateResponseSchema().loads(resp)

    def create_custom_image(self, req=None, **kwargs):
        """ CreateCustomImage - 创建自制镜像

        **Request**

        - **Region** (str) - (Config) 地域。枚举值：cn,表示中国；
        - **ImageName** (str) - (Required) 镜像名称
        - **VMID** (str) - (Required) 虚拟机ID
        - **Zone** (str) - (Required) 可用区。枚举值：zone-01，表示中国；
        - **ImageDescription** (str) - 镜像描述。
        
        **Response**

        - **ImageID** (str) - 创建的自制镜像ID
        - **Message** (str) - 返回信息描述。
        
        """
        d = {"Region": self.config.region}
        req and d.update(req)
        d = apis.CreateCustomImageRequestSchema().dumps(d)
        resp = self.invoke("CreateCustomImage", d, **kwargs)
        return apis.CreateCustomImageResponseSchema().loads(resp)

    def create_disk(self, req=None, **kwargs):
        """ CreateDisk - 创建硬盘

        **Request**

        - **Region** (str) - (Config) 地域。枚举值：cn,表示中国；
        - **ChargeType** (str) - (Required) 计费模式。枚举值：Dynamic，表示小时；Month，表示月；Year，表示年；
        - **DiskSpace** (int) - (Required) 磁盘大小
        - **Name** (str) - (Required) 磁盘名称
        - **SetType** (str) - (Required) 磁盘类型。例如：Normal,SSD
        - **Zone** (str) - (Required) 可用区。枚举值：zone-01，表示中国；
        - **Quantity** (int) - 购买时长。默认值1。小时不生效，月范围【1，11】，年范围【1，5】。
        
        **Response**

        - **DiskID** (str) - 创建的磁盘ID
        - **Message** (str) - 返回信息描述。
        
        """
        d = {"Region": self.config.region}
        req and d.update(req)
        d = apis.CreateDiskRequestSchema().dumps(d)
        resp = self.invoke("CreateDisk", d, **kwargs)
        return apis.CreateDiskResponseSchema().loads(resp)

    def create_lb(self, req=None, **kwargs):
        """ CreateLB - 创建负载均衡

        **Request**

        - **Region** (str) - (Config) 地域。枚举值：cn,表示中国；
        - **ChargeType** (str) - (Required) 计费模式。枚举值：Dynamic，表示小时；Month，表示月；Year，表示年；
        - **LBType** (str) - (Required) 枚举值。LAN：内网，WAN:外网
        - **Name** (str) - (Required) 名称。
        - **SubnetID** (str) - (Required) LB 实例所在的子网 ID 。
        - **VMType** (str) - (Required) 运行负载均衡实例的主机机型。枚举值：如 Normal ，表示普通机型； SSD，表示 SSD 机型。（机型由平台管理员修改和指定，可参考获取主机机型接口）
        - **VPCID** (str) - (Required) LB实例所在的 VPC ID 。
        - **Zone** (str) - (Required) 可用区。枚举值：zone-01，表示中国；
        - **EIPID** (str) - 外网IP的ID，创建外网LB时为必需
        - **Quantity** (int) - 购买时长。默认值1。小时不生效，月范围【1，11】，年范围【1，5】。
        - **Remark** (str) - 描述。
        - **SGID** (str) - 安全组ID，创建外网LB时为必需
        
        **Response**

        - **LBID** (str) - 返回创建的负载均衡ID
        - **Message** (str) - 返回信息描述。
        
        """
        d = {"Region": self.config.region}
        req and d.update(req)
        d = apis.CreateLBRequestSchema().dumps(d)
        resp = self.invoke("CreateLB", d, **kwargs)
        return apis.CreateLBResponseSchema().loads(resp)

    def create_natgw(self, req=None, **kwargs):
        """ CreateNATGW - 创建NAT网关

        **Request**

        - **Region** (str) - (Config) 地域。枚举值：cn,表示中国；
        - **ChargeType** (str) - (Required) 计费模式。枚举值：Dynamic，表示小时；Month，表示月；Year，表示年；
        - **EIPID** (str) - (Required) 外网IP的ID
        - **Name** (str) - (Required) 名称。
        - **SGID** (str) - (Required) 安全组ID
        - **SubnetID** (str) - (Required) NAT网关实例所在的子网 ID
        - **VMType** (str) - (Required) 运行NAT网关实例的主机机型。枚举值：如 Normal ，表示普通机型； SSD，表示 SSD 机型。（机型由平台管理员修改和指定，可参考获取主机机型接口）
        - **VPCID** (str) - (Required) NAT网关实例所在的 VPC ID
        - **Zone** (str) - (Required) 可用区。枚举值：zone-01，表示中国；
        - **Quantity** (int) - 购买时长。默认值1。小时不生效，月范围【1，11】，年范围【1，5】。
        - **Remark** (str) - 描述
        
        **Response**

        - **Message** (str) - 返回信息描述。
        - **NATGWID** (str) - 返回创建的NAT网关ID
        
        """
        d = {"Region": self.config.region}
        req and d.update(req)
        d = apis.CreateNATGWRequestSchema().dumps(d)
        resp = self.invoke("CreateNATGW", d, **kwargs)
        return apis.CreateNATGWResponseSchema().loads(resp)

    def create_natgw_rule(self, req=None, **kwargs):
        """ CreateNATGWRule - 添加NAT网关白名单

        **Request**

        - **Region** (str) - (Config) 地域。枚举值：cn,表示中国；
        - **BindResourceID** (str) - (Required) 绑定的虚拟机资源ID
        - **NATGWID** (str) - (Required) NAT网关ID
        - **NATGWType** (str) - (Required) NAT的类型。枚举值：SNAT，DNAT
        - **Zone** (str) - (Required) 可用区。枚举值：zone-01，表示中国；
        
        **Response**

        - **Message** (str) - 返回信息描述。
        - **RuleID** (str) - 白名单ID
        
        """
        d = {"Region": self.config.region}
        req and d.update(req)
        d = apis.CreateNATGWRuleRequestSchema().dumps(d)
        resp = self.invoke("CreateNATGWRule", d, **kwargs)
        return apis.CreateNATGWRuleResponseSchema().loads(resp)

    def create_physical_ip(self, req=None, **kwargs):
        """ CreatePhysicalIP - 创建物理 IP ，需确保平台已配置物理 IP 线路相关信息及物理网络联通性。

        **Request**

        - **Region** (str) - (Config) 地域。枚举值：cn,表示中国；
        - **Name** (str) - (Required) 物理IP名称，限制字符长度30
        - **OperatorName** (str) - (Required) 物理IP线路
        - **Zone** (str) - (Required) 可用区。枚举值：zone-01，表示中国；
        - **Remark** (str) - 描述
        
        **Response**

        - **Message** (str) - 返回信息描述
        - **PhysicalIPID** (str) - 返回创建的物理IP的ID
        
        """
        d = {"Region": self.config.region}
        req and d.update(req)
        d = apis.CreatePhysicalIPRequestSchema().dumps(d)
        resp = self.invoke("CreatePhysicalIP", d, **kwargs)
        return apis.CreatePhysicalIPResponseSchema().loads(resp)

    def create_rs(self, req=None, **kwargs):
        """ CreateRS - 为负载均衡的 VServer 添加后端服务节点。

        **Request**

        - **Region** (str) - (Config) 地域。枚举值：cn,表示中国；
        - **BindResourceID** (str) - (Required) 服务节点的资源 ID ，仅支持添加与 LB 相同 VPC 的虚拟机资源
        - **LBID** (str) - (Required) 负载均衡ID
        - **Port** (int) - (Required) 服务节点暴露的服务端口号
        - **VSID** (str) - (Required) VServer的ID
        - **Weight** (int) - (Required) 服务节点的权重
        - **Zone** (str) - (Required) 可用区。枚举值：zone-01，表示中国；
        
        **Response**

        - **Message** (str) - 返回信息描述。
        - **RSID** (str) - 返回创建的RSID
        
        """
        d = {"Region": self.config.region}
        req and d.update(req)
        d = apis.CreateRSRequestSchema().dumps(d)
        resp = self.invoke("CreateRS", d, **kwargs)
        return apis.CreateRSResponseSchema().loads(resp)

    def create_security_group(self, req=None, **kwargs):
        """ CreateSecurityGroup - 创建安全组

        **Request**

        - **Region** (str) - (Config) 地域。枚举值： cn，表示中国；
        - **Name** (str) - (Required) 名称;
        - **Rule** (list) - (Required) 【数组】安全组规则。输入有效的规则，调用方式举例：Rule.0=“TCP|23|0.0.0.0/0|ACCEPT|HIGH|1”、Rule.1=“TCP|55|0.0.0.0/0|ACCEPT|HIGH|1”
        - **Zone** (str) - (Required) 可用区。枚举值：zone-01，表示中国；
        - **Remark** (str) - 描述;
        
        **Response**

        - **Message** (str) - 返回信息描述；
        - **SGID** (str) - 创建的安全组ID
        
        """
        d = {"Region": self.config.region}
        req and d.update(req)
        d = apis.CreateSecurityGroupRequestSchema().dumps(d)
        resp = self.invoke("CreateSecurityGroup", d, **kwargs)
        return apis.CreateSecurityGroupResponseSchema().loads(resp)

    def create_security_group_rule(self, req=None, **kwargs):
        """ CreateSecurityGroupRule - 创建安全组规则

        **Request**

        - **Region** (str) - (Config) 地域。枚举值： cn，表示中国；
        - **Rules** (list) - (Required) 【数组】安全组规则。输入有效的规则，调用方式举例：Rule.0=“TCP|23|0.0.0.0/0|ACCEPT|HIGH|1”、Rule.1=“TCP|55|0.0.0.0/0|ACCEPT|HIGH|1”
        - **SGID** (str) - (Required) 安全组ID
        - **Zone** (str) - (Required) 可用区。枚举值：zone-01，表示中国；
        
        **Response**

        - **Message** (str) - 返回信息描述；
        - **SGRuleID** (str) - 创建的安全组规则ID
        
        """
        d = {"Region": self.config.region}
        req and d.update(req)
        d = apis.CreateSecurityGroupRuleRequestSchema().dumps(d)
        resp = self.invoke("CreateSecurityGroupRule", d, **kwargs)
        return apis.CreateSecurityGroupRuleResponseSchema().loads(resp)

    def create_snapshot(self, req=None, **kwargs):
        """ CreateSnapshot - 创建硬盘快照

        **Request**

        - **Region** (str) - (Config) 地域。枚举值：如 cn,表示中国。
        - **DiskID** (str) - (Required) 硬盘ID，输入“有效”状态的ID
        - **Name** (str) - (Required) 快照名称，限制字符长度30
        - **Zone** (str) - (Required) 可用区。枚举值：如 zone-01，表示可用区1。
        - **Remark** (str) - 描述，限制字符长度100
        
        **Response**

        - **Message** (str) - 返回信息描述
        - **SnapshotID** (str) - 创建的快照ID
        
        """
        d = {"Region": self.config.region}
        req and d.update(req)
        d = apis.CreateSnapshotRequestSchema().dumps(d)
        resp = self.invoke("CreateSnapshot", d, **kwargs)
        return apis.CreateSnapshotResponseSchema().loads(resp)

    def create_subnet(self, req=None, **kwargs):
        """ CreateSubnet - 创建子网

        **Request**

        - **Region** (str) - (Config) 地域。枚举值： cn，表示中国；
        - **Name** (str) - (Required) 名称;
        - **Network** (str) - (Required) 网段。列如：10.0.0.0/16；
        - **VPCID** (str) - (Required) 所属VPCID
        - **Zone** (str) - (Required) 可用区。枚举值：zone-01，表示中国；
        - **Remark** (str) - 描述;
        
        **Response**

        - **Message** (str) - 返回信息描述；
        - **SubnetID** (str) - 创建Subnet的ID；
        
        """
        d = {"Region": self.config.region}
        req and d.update(req)
        d = apis.CreateSubnetRequestSchema().dumps(d)
        resp = self.invoke("CreateSubnet", d, **kwargs)
        return apis.CreateSubnetResponseSchema().loads(resp)

    def create_user(self, req=None, **kwargs):
        """ CreateUser - 管理员添加账号

        **Request**

        - **PassWord** (str) - (Required) 账号密码。
        - **UserEmail** (str) - (Required) 账号邮箱。
        
        **Response**

        - **Message** (str) - 返回信息描述。
        - **UserID** (int) - 账户ID
        
        """
        d = {}
        req and d.update(req)
        d = apis.CreateUserRequestSchema().dumps(d)
        resp = self.invoke("CreateUser", d, **kwargs)
        return apis.CreateUserResponseSchema().loads(resp)

    def create_vm_instance(self, req=None, **kwargs):
        """ CreateVMInstance - 创建虚拟机

        **Request**

        - **Region** (str) - (Config) 地域。枚举值：cn,表示中国；
        - **BootDiskSetType** (str) - (Required) 系统盘类型。枚举值：Normal，表示普通；SSD，表示SSD；
        - **CPU** (int) - (Required) CPU个数，如1，2，4，8，16，32，64等。
        - **ChargeType** (str) - (Required) 计费模式。枚举值：Dynamic，表示小时；Month，表示月；Year，表示年；
        - **DataDiskSetType** (str) - (Required) 数据盘类型。枚举值：Normal，表示普通；SSD，表示SSD；
        - **ImageID** (str) - (Required) 镜像 ID。基础镜像 ID 或者自制镜像 ID。如：cn-image-centos-74。
        - **Memory** (int) - (Required) 内存容量，如1024，2048，4096，8192，16384，32768，65535等。
        - **Name** (str) - (Required) 虚拟机名称。可输入如：myVM。名称只能包含中英文、数字以及- _ .且1-30个字符。
        - **Password** (str) - (Required) 密码。可输入如：ucloud.cn。密码长度限6-30个字符；需要同时包含两项或以上（大写字母/小写字母/数字/特殊符号)；windows不能包含用户名（administrator）中超过2个连续字符的部分。
        - **SubnetID** (str) - (Required) 子网 ID。
        - **VMType** (str) - (Required) 机型。枚举值：Normal，表示普通；SSD，表示SSD；
        - **VPCID** (str) - (Required) VPC ID。
        - **WANSGID** (str) - (Required) 外网安全组 ID。输入“有效”状态的安全组的ID。
        - **Zone** (str) - (Required) 可用区。枚举值：zone-01，表示中国；
        - **Bandwidth** (str) - 带宽
        - **DataDiskSpace** (int) - 数据盘大小，单位 GB。默认值为0。范围：【0，8000】，步长10。
        - **GPU** (int) - GPU 卡核心的占用个数。枚举值：【1,2,4】。GPU与CPU、内存大小关系：CPU个数>=4*GPU个数，同时内存与CPU规格匹配.
        - **IPVersion** (str) - 外网IP版本，默认IPv4
        - **InternalIP** (str) - 指定内网IP。输入有效的指定内网 IP。默认为系统自动分配内网 IP。
        - **InternetIP** (str) - 指定外网IP
        - **LANSGID** (str) - 内网安全组 ID。输入“有效”状态的安全组的ID。
        - **OperatorName** (str) - 线路
        - **Quantity** (int) - 购买时长。默认值1。小时不生效，月范围【1，11】，年范围【1，5】。
        
        **Response**

        - **DiskID** (str) - 返回创建数据盘的 ID
        - **EIPID** (str) - 返回创建外网IP的 ID
        - **Message** (str) - 返回信息描述。
        - **VMID** (str) - 返回创建虚拟机的 ID
        
        """
        d = {"Region": self.config.region}
        req and d.update(req)
        d = apis.CreateVMInstanceRequestSchema().dumps(d)
        resp = self.invoke("CreateVMInstance", d, **kwargs)
        return apis.CreateVMInstanceResponseSchema().loads(resp)

    def create_vpc(self, req=None, **kwargs):
        """ CreateVPC - 创建VPC

        **Request**

        - **Region** (str) - (Config) 地域。枚举值： cn，表示中国；
        - **Name** (str) - (Required) 名称;
        - **Network** (str) - (Required) 网段。例如：10.0.0.0/16；
        - **Zone** (str) - (Required) 可用区。枚举值：zone-01，表示中国；
        - **Remark** (str) - 描述;
        
        **Response**

        - **Message** (str) - 返回信息描述；
        - **VPCID** (str) - 创建的VPCID；
        
        """
        d = {"Region": self.config.region}
        req and d.update(req)
        d = apis.CreateVPCRequestSchema().dumps(d)
        resp = self.invoke("CreateVPC", d, **kwargs)
        return apis.CreateVPCResponseSchema().loads(resp)

    def create_vs(self, req=None, **kwargs):
        """ CreateVS - 创建负载均衡VServer

        **Request**

        - **Region** (str) - (Config) 地域。枚举值：cn,表示中国；
        - **HealthcheckType** (str) - (Required) 健康检查类型，枚举值，Port:端口,Path:域名。TCP和UDP协议只支持Port类型。
        - **LBID** (str) - (Required) 负载均衡ID
        - **Port** (int) - (Required) VServer 的监听端口。端口范围为 1~65535 ，其中 323、9102、9103、9104、9105、60909、60910 被系统占用。
        - **Protocol** (str) - (Required) VServer 的监听协议。枚举值：支持 TCP、UDP、HTTP、HTTPS 四种协议转发。
        - **Scheduler** (str) - (Required) 负载均衡的调度算法。枚举值：wrr:加权轮训；least_conn:最小连接数；hash:原地址,四层lb使用。ip_hash:七层lb使用
        - **Zone** (str) - (Required) 可用区。枚举值：zone-01，表示中国；
        - **CACertificateID** (str) - CA证书ID，用于验证客户端证书的签名，仅当VServer监听协议为 HTTPS 且 SSLMode 为双向认证时有效。
        - **Domain** (str) - HTTP 健康检查时校验请求的 HOST 字段中的域名。当健康检查类型为端口检查时，该值为空。
        - **KeepaliveTimeout** (int) - 负载均衡的连接空闲超时时间，单位为秒，默认值为 60s 。
        - **Path** (str) - HTTP 健康检查的路径，健康检查类型为 HTTP 检查时为必填项。当健康检查类型为端口检查时，该值为空。
        - **PersistenceKey** (str) - 会话保持KEY，会话保持类型为Manual时为必填项，仅当 VServer 协议为 HTTP 时有效。
        - **PersistenceType** (str) - 会话保持类型。枚举值：None:关闭；Auto:自动生成；Manual:手动生成 。当协议为 TCP 时，该值不生效，会话保持和选择的调度算法相关；当协议为 UDP 时 Auto 表示开启会话保持 。
        - **SSLMode** (str) - SSL认证模式,HTTPS协议下必传,取值范围["simplex","duplex"]分别表示单向认证和双向认证。
        - **ServerCertificateID** (str) - 服务器证书ID，用于证明服务器的身份，仅当 VServer监听协议为 HTTPS时有效。
        
        **Response**

        - **Message** (str) - 返回信息描述。
        - **VSID** (str) - 返回创建的VSID
        
        """
        d = {"Region": self.config.region}
        req and d.update(req)
        d = apis.CreateVSRequestSchema().dumps(d)
        resp = self.invoke("CreateVS", d, **kwargs)
        return apis.CreateVSResponseSchema().loads(resp)

    def create_vs_policy(self, req=None, **kwargs):
        """ CreateVSPolicy - 创建七层负载均衡内容转发规则，仅当 VServer 的监听协议为 HTTP 时有效。

        **Request**

        - **Region** (str) - (Config) 地域。枚举值：cn,表示中国；
        - **LBID** (str) - (Required) 负载均衡ID
        - **RSIDs** (list) - (Required) 【数组】内容转发规则应用的服务节点的 ID，来源于 VServer 中添加的服务节点。调用方式举例：RSIDs.0=“one-id”、RSIDs.1=“two-id”。
        - **VSID** (str) - (Required) VServer的ID
        - **Zone** (str) - (Required) 可用区。枚举值：zone-01，表示中国；
        - **Domain** (str) - 内容转发规则关联的请求域名，值可为空，即代表仅匹配路径。域名和路径至少需要指定一项，且域名和路径的组合在一个 VServer 中必须唯一。
        - **Path** (str) - 内容转发规则关联的请求访问路径，如 "/" 。域名和路径至少需要指定一项，且域名和路径的组合在一个 VServer 中必须唯一。
        
        **Response**

        - **Message** (str) - 返回信息描述。
        - **PolicyID** (str) - 返回创建的内容转发规则ID
        
        """
        d = {"Region": self.config.region}
        req and d.update(req)
        d = apis.CreateVSPolicyRequestSchema().dumps(d)
        resp = self.invoke("CreateVSPolicy", d, **kwargs)
        return apis.CreateVSPolicyResponseSchema().loads(resp)

    def delete_certificate(self, req=None, **kwargs):
        """ DeleteCertificate - 删除证书

        **Request**

        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist.html>`_ 
        - **CertificateID** (str) - (Required) 证书ID
        - **Zone** (str) - (Required) 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist.html>`_ 
        
        **Response**

        - **Message** (str) - 返回信息描述
        
        """
        d = {"Region": self.config.region}
        req and d.update(req)
        d = apis.DeleteCertificateRequestSchema().dumps(d)
        resp = self.invoke("DeleteCertificate", d, **kwargs)
        return apis.DeleteCertificateResponseSchema().loads(resp)

    def delete_custom_image(self, req=None, **kwargs):
        """ DeleteCustomImage - 删除自制镜像

        **Request**

        - **Region** (str) - (Config) 地域。枚举值：cn,表示中国；
        - **ImageID** (str) - (Required) 自制镜像ID
        - **Zone** (str) - (Required) 可用区。枚举值：zone-01，表示中国；
        
        **Response**

        - **Message** (str) - 返回信息描述。
        
        """
        d = {"Region": self.config.region}
        req and d.update(req)
        d = apis.DeleteCustomImageRequestSchema().dumps(d)
        resp = self.invoke("DeleteCustomImage", d, **kwargs)
        return apis.DeleteCustomImageResponseSchema().loads(resp)

    def delete_disk(self, req=None, **kwargs):
        """ DeleteDisk - 删除硬盘

        **Request**

        - **Region** (str) - (Config) 地域。枚举值：cn,表示中国；
        - **DiskID** (str) - (Required) 被删除的硬盘ID
        - **Zone** (str) - (Required) 可用区。枚举值：zone-01，表示中国；
        
        **Response**

        - **Message** (str) - 返回信息描述。
        
        """
        d = {"Region": self.config.region}
        req and d.update(req)
        d = apis.DeleteDiskRequestSchema().dumps(d)
        resp = self.invoke("DeleteDisk", d, **kwargs)
        return apis.DeleteDiskResponseSchema().loads(resp)

    def delete_lb(self, req=None, **kwargs):
        """ DeleteLB - 删除负载均衡

        **Request**

        - **Region** (str) - (Config) 地域。枚举值：cn,表示中国；
        - **LBID** (str) - (Required) 负载均衡ID
        - **Zone** (str) - (Required) 可用区。枚举值：zone-01，表示中国；
        
        **Response**

        - **Message** (str) - 返回信息描述。
        
        """
        d = {"Region": self.config.region}
        req and d.update(req)
        d = apis.DeleteLBRequestSchema().dumps(d)
        resp = self.invoke("DeleteLB", d, **kwargs)
        return apis.DeleteLBResponseSchema().loads(resp)

    def delete_natgw(self, req=None, **kwargs):
        """ DeleteNATGW - 删除NAT网关

        **Request**

        - **Region** (str) - (Config) 地域。枚举值：cn,表示中国；
        - **NATGWID** (str) - (Required) NAT网关ID
        - **Zone** (str) - (Required) 可用区。枚举值：zone-01，表示中国；
        
        **Response**

        - **Message** (str) - 返回信息描述。
        
        """
        d = {"Region": self.config.region}
        req and d.update(req)
        d = apis.DeleteNATGWRequestSchema().dumps(d)
        resp = self.invoke("DeleteNATGW", d, **kwargs)
        return apis.DeleteNATGWResponseSchema().loads(resp)

    def delete_natgw_rule(self, req=None, **kwargs):
        """ DeleteNATGWRule - 删除NAT网关白名单

        **Request**

        - **Region** (str) - (Config) 地域。枚举值：cn,表示中国；
        - **NATGWID** (str) - (Required) nat网关ID
        - **RuleID** (str) - (Required) 白名单ID
        - **Zone** (str) - (Required) 可用区。枚举值：zone-01，表示中国；
        
        **Response**

        - **Message** (str) - 返回信息描述。
        
        """
        d = {"Region": self.config.region}
        req and d.update(req)
        d = apis.DeleteNATGWRuleRequestSchema().dumps(d)
        resp = self.invoke("DeleteNATGWRule", d, **kwargs)
        return apis.DeleteNATGWRuleResponseSchema().loads(resp)

    def delete_physical_ip(self, req=None, **kwargs):
        """ DeletePhysicalIP - 删除物理IP

        **Request**

        - **Region** (str) - (Config) 地域。
        - **PhysicalIPID** (str) - (Required) 物理IP的ID
        - **Zone** (str) - (Required) 可用区。
        
        **Response**

        - **Message** (str) - 返回状态描述
        
        """
        d = {"Region": self.config.region}
        req and d.update(req)
        d = apis.DeletePhysicalIPRequestSchema().dumps(d)
        resp = self.invoke("DeletePhysicalIP", d, **kwargs)
        return apis.DeletePhysicalIPResponseSchema().loads(resp)

    def delete_rs(self, req=None, **kwargs):
        """ DeleteRS - 移除负载均衡的单个服务节点

        **Request**

        - **Region** (str) - (Config) 地域。枚举值：cn,表示中国；
        - **LBID** (str) - (Required) 负载均衡ID
        - **RSID** (str) - (Required) RServer的ID
        - **VSID** (str) - (Required) VServer的ID
        - **Zone** (str) - (Required) 可用区。枚举值：zone-01，表示中国；
        
        **Response**

        - **Message** (str) - 返回信息描述。
        
        """
        d = {"Region": self.config.region}
        req and d.update(req)
        d = apis.DeleteRSRequestSchema().dumps(d)
        resp = self.invoke("DeleteRS", d, **kwargs)
        return apis.DeleteRSResponseSchema().loads(resp)

    def delete_security_group(self, req=None, **kwargs):
        """ DeleteSecurityGroup - 删除安全组

        **Request**

        - **Region** (str) - (Config) 地域。枚举值： cn，表示中国；
        - **SGID** (str) - (Required) 安全组ID
        - **Zone** (str) - (Required) 可用区。枚举值：zone-01，表示中国；
        
        **Response**

        - **Message** (str) - 返回信息描述；
        
        """
        d = {"Region": self.config.region}
        req and d.update(req)
        d = apis.DeleteSecurityGroupRequestSchema().dumps(d)
        resp = self.invoke("DeleteSecurityGroup", d, **kwargs)
        return apis.DeleteSecurityGroupResponseSchema().loads(resp)

    def delete_security_group_rule(self, req=None, **kwargs):
        """ DeleteSecurityGroupRule - 删除安全组规则

        **Request**

        - **Region** (str) - (Config) 地域。
        - **SGID** (str) - (Required) 安全组ID
        - **SGRuleID** (str) - (Required) 安全组规则ID
        - **Zone** (str) - (Required) 可用区。
        
        **Response**

        - **Message** (str) - 返回信息描述；
        
        """
        d = {"Region": self.config.region}
        req and d.update(req)
        d = apis.DeleteSecurityGroupRuleRequestSchema().dumps(d)
        resp = self.invoke("DeleteSecurityGroupRule", d, **kwargs)
        return apis.DeleteSecurityGroupRuleResponseSchema().loads(resp)

    def delete_snapshot(self, req=None, **kwargs):
        """ DeleteSnapshot - 删除快照，仅支持状态为正常的快照进行删除操作。

        **Request**

        - **Region** (str) - (Config) 地域。枚举值：如 cn,表示中国。
        - **SnapshotID** (str) - (Required) 快照ID
        - **Zone** (str) - (Required) 可用区。枚举值：如 zone-01，表示可用区1。
        
        **Response**

        - **Message** (str) - 返回信息描述
        
        """
        d = {"Region": self.config.region}
        req and d.update(req)
        d = apis.DeleteSnapshotRequestSchema().dumps(d)
        resp = self.invoke("DeleteSnapshot", d, **kwargs)
        return apis.DeleteSnapshotResponseSchema().loads(resp)

    def delete_subnet(self, req=None, **kwargs):
        """ DeleteSubnet - 删除子网

        **Request**

        - **Region** (str) - (Config) 地域。
        - **SubnetID** (str) - (Required) SubnetID
        - **Zone** (str) - (Required) 可用区。
        
        **Response**

        - **Message** (str) - 返回信息描述；
        
        """
        d = {"Region": self.config.region}
        req and d.update(req)
        d = apis.DeleteSubnetRequestSchema().dumps(d)
        resp = self.invoke("DeleteSubnet", d, **kwargs)
        return apis.DeleteSubnetResponseSchema().loads(resp)

    def delete_vm_instance(self, req=None, **kwargs):
        """ DeleteVMInstance - 删除虚拟机

        **Request**

        - **Region** (str) - (Config) 地域。 枚举值：cn，表示中国；
        - **VMID** (str) - (Required) 虚拟机 ID。输入有效的虚拟机 ID。
        - **Zone** (str) - (Required) 可用区。枚举值：zone-01，表示中国；
        
        **Response**

        - **Message** (str) - 返回信息描述。
        
        """
        d = {"Region": self.config.region}
        req and d.update(req)
        d = apis.DeleteVMInstanceRequestSchema().dumps(d)
        resp = self.invoke("DeleteVMInstance", d, **kwargs)
        return apis.DeleteVMInstanceResponseSchema().loads(resp)

    def delete_vpc(self, req=None, **kwargs):
        """ DeleteVPC - 删除VPC

        **Request**

        - **Region** (str) - (Config) 地域。
        - **VPCID** (str) - (Required) ID
        - **Zone** (str) - (Required) 可用区。
        
        **Response**

        - **Message** (str) - 返回信息描述；
        
        """
        d = {"Region": self.config.region}
        req and d.update(req)
        d = apis.DeleteVPCRequestSchema().dumps(d)
        resp = self.invoke("DeleteVPC", d, **kwargs)
        return apis.DeleteVPCResponseSchema().loads(resp)

    def delete_vs(self, req=None, **kwargs):
        """ DeleteVS - 删除VServer

        **Request**

        - **Region** (str) - (Config) 地域。枚举值：cn,表示中国；
        - **LBID** (str) - (Required) VServer 监听器所属的负载均衡 ID
        - **VSID** (str) - (Required) 负载均衡VServer监听器ID
        - **Zone** (str) - (Required) 可用区。枚举值：zone-01，表示中国；
        
        **Response**

        - **Message** (str) - 返回信息描述。
        
        """
        d = {"Region": self.config.region}
        req and d.update(req)
        d = apis.DeleteVSRequestSchema().dumps(d)
        resp = self.invoke("DeleteVS", d, **kwargs)
        return apis.DeleteVSResponseSchema().loads(resp)

    def delete_vs_policy(self, req=None, **kwargs):
        """ DeleteVSPolicy - 删除七层负载均衡内容转发规则，仅当 VServer 的监听协议为 HTTP 时有效。

        **Request**

        - **Region** (str) - (Config) 地域。枚举值：cn,表示中国；
        - **LBID** (str) - (Required) 负载均衡ID
        - **PolicyID** (str) - (Required) 内容转发规则ID
        - **VSID** (str) - (Required) VServer的ID
        - **Zone** (str) - (Required) 可用区。枚举值：zone-01，表示中国；
        
        **Response**

        - **Message** (str) - 返回信息描述。
        
        """
        d = {"Region": self.config.region}
        req and d.update(req)
        d = apis.DeleteVSPolicyRequestSchema().dumps(d)
        resp = self.invoke("DeleteVSPolicy", d, **kwargs)
        return apis.DeleteVSPolicyResponseSchema().loads(resp)

    def describe_certificate(self, req=None, **kwargs):
        """ DescribeCertificate - 查询证书

        **Request**

        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist.html>`_ 
        - **Zone** (str) - (Required) 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist.html>`_ 
        - **CertificateIDs** (list) - 证书ID列表
        - **CertificateType** (str) - 证书类型，枚举值["ServerCrt","CACrt"]。分别表示服务器证书和CA证书。
        - **Limit** (int) - 返回数据长度，默认为20，最大100
        - **Offset** (int) - 列表起始位置偏移量，默认为0
        
        **Response**

        - **Infos** (list) - 见 **CertificateInfo** 模型定义
        - **Message** (str) - 返回信息描述
        - **TotalCount** (int) - 证书总个数
        
        **Response Model**
        
        **BindVSInfo** 
        
        - **LBID** (str) - LB ID
        - **LBName** (str) - LB名称
        - **Port** (int) - VS的端口
        - **Protocol** (str) - VS的协议
        - **VSID** (str) - VS ID

        **CertificateInfo** 
        
        - **CertificateContent** (str) - 证书内容
        - **CertificateID** (str) - 证书ID
        - **CertificateType** (str) - 证书类型，枚举值["ServerCrt","CACrt"]
        - **CommonName** (str) - 主域名
        - **CreateTime** (int) - 创建时间（平台创建时间）
        - **ExpireTime** (int) - 证书内容的过期时间
        - **Fingerprint** (str) - 证书指纹
        - **Name** (str) - 证书名
        - **Privatekey** (str) - 私钥内容
        - **Region** (str) - 地域
        - **Remark** (str) - 证书描述
        - **SubjectAlternativeNames** (list) - 备域名
        - **VSInfos** (list) - 见 **BindVSInfo** 模型定义
        - **Zone** (str) - 可用区

        """
        d = {"Region": self.config.region}
        req and d.update(req)
        d = apis.DescribeCertificateRequestSchema().dumps(d)
        resp = self.invoke("DescribeCertificate", d, **kwargs)
        return apis.DescribeCertificateResponseSchema().loads(resp)

    def describe_disk(self, req=None, **kwargs):
        """ DescribeDisk - 获取硬盘信息

        **Request**

        - **Region** (str) - (Config) 地域。枚举值： cn，表示中国；
        - **Zone** (str) - (Required) 可用区。枚举值：zone-01，表示中国；
        - **DiskIDs** (list) - 【数组】磁盘的 ID。输入有效的 ID。调用方式举例：DiskIDs.0=“one-id”、DiskIDs.1=“two-id”。
        - **Limit** (int) - 返回数据长度，默认为20，最大100。
        - **Offset** (int) - 列表起始位置偏移量，默认为0。
        
        **Response**

        - **Infos** (list) - 见 **DiskInfo** 模型定义
        - **Message** (str) - 返回信息描述。
        - **TotalCount** (int) - 返回磁盘总个数。
        
        **Response Model**
        
        **DiskInfo** 
        
        - **AttachResourceID** (str) - 绑定资源ID
        - **ChargeType** (str) - 硬盘计费模式。枚举值：Dynamic，表示小时；Month，表示月；Year，表示年；
        - **CreateTime** (int) - 创建时间。时间戳
        - **DiskID** (str) - 硬盘ID
        - **DiskStatus** (str) - 硬盘状态。Creating：创建中,BeingCloned：正在被克隆中,Unbound：已解绑,Unbounding：解绑中,Bounding：绑定中,Bound：已绑定,Upgrading：升级中,Deleting：删除中,Deleted：已删除,Releasing：销毁中,Released：已销毁
        - **ExpireTime** (int) - 过期时间。时间戳
        - **Name** (str) - 名称
        - **Region** (str) - 地域
        - **Remark** (str) - 备注
        - **SetType** (str) - 磁盘类型。例如：Normal,SSD
        - **Size** (int) - 大小。单位GB
        - **Zone** (str) - 可用区

        """
        d = {"Region": self.config.region}
        req and d.update(req)
        d = apis.DescribeDiskRequestSchema().dumps(d)
        resp = self.invoke("DescribeDisk", d, **kwargs)
        return apis.DescribeDiskResponseSchema().loads(resp)

    def describe_eip(self, req=None, **kwargs):
        """ DescribeEIP - 获取外网IP的信息

        **Request**

        - **Region** (str) - (Config) 地域。枚举值：cn,表示中国；
        - **Zone** (str) - (Required) 可用区。枚举值：zone-01，表示中国；
        - **EIPIDs** (list) - 【数组】外网的 ID。输入有效的 ID。调用方式举例：EIPIDs.0=“one-id”、EIPIDs.1=“two-id”
        - **Limit** (str) - 返回数据长度，默认为20，最大100。
        - **Offset** (str) - 列表起始位置偏移量，默认为0。
        
        **Response**

        - **Infos** (list) - 见 **EIPInfo** 模型定义
        - **Message** (str) - 返回信息描述
        - **Totalcount** (int) - 返回现有外网IP总数
        
        **Response Model**
        
        **EIPInfo** 
        
        - **Bandwidth** (int) - 带宽大小
        - **BindResourceID** (str) - 绑定资源ID
        - **BindResourceType** (str) - 绑定资源类型
        - **ChargeType** (str) - 计费模式。枚举值：Dynamic，表示小时；Month，表示月；Year，表示年；
        - **CreateTime** (int) - 创建时间。时间戳
        - **EIPID** (str) - ID
        - **ExpireTime** (int) - 过期时间。时间戳
        - **IP** (str) - 外网IP
        - **Name** (str) - 名称
        - **OperatorName** (str) - 线路
        - **Region** (str) - 地域
        - **Remark** (str) - 备注
        - **Status** (str) - 状态。Allocating：申请中,Free：未绑定,Bounding：绑定中,Bound：已绑定,Unbounding：解绑中,Deleted：已删除,Releasing：销毁中,Released：已销毁,BandwidthChanging：带宽修改中
        - **Zone** (str) - 可用区

        """
        d = {"Region": self.config.region}
        req and d.update(req)
        d = apis.DescribeEIPRequestSchema().dumps(d)
        resp = self.invoke("DescribeEIP", d, **kwargs)
        return apis.DescribeEIPResponseSchema().loads(resp)

    def describe_image(self, req=None, **kwargs):
        """ DescribeImage - 获取镜像信息，包括默认镜像和自制镜像。

        **Request**

        - **Region** (str) - (Config) 地域。枚举值： cn，表示中国；
        - **Zone** (str) - (Required) 可用区。枚举值：zone-01，表示中国；
        - **ImageIDs** (list) - 【数组】镜像的 ID。输入有效的 ID。调用方式举例：ImageIDs.0=“one-id”、ImageIDs.1=“two-id”。
        - **ImageType** (str) - 镜像类型。枚举值：Base(基础镜像，平台默认提供的镜像)，Custom(自制镜像，通过虚拟机导出的镜像) 。若该值为空，默认查询所有镜像。
        - **Limit** (int) - 返回数据长度，默认为20，最大100。
        - **Offset** (int) - 列表起始位置偏移量，默认为0。
        
        **Response**

        - **Action** (str) - 操作名称
        - **Infos** (list) - 见 **ImageInfo** 模型定义
        - **Message** (str) - 返回信息描述。
        - **RetCode** (int) - 返回码
        - **TotalCount** (int) - 返回镜像的总个数。
        
        **Response Model**
        
        **ImageInfo** 
        
        - **CreateTime** (int) - 创建时间。时间戳。
        - **ImageID** (str) - 镜像ID
        - **ImageStatus** (str) - 镜像状态。枚举类型：Making（创建中）,Available（可用）,Unavailable（不可用）,Terminating（销毁中）,Used（被使用中）,Deleting（删除中）,Deleted（已删除）, Uploading（导入中）
        - **ImageType** (str) - 镜像类型。枚举类型：Base(基础镜像),Custom（自制镜像）。
        - **Name** (str) - 镜像名称
        - **OSDistribution** (str) - 镜像系统发行版本。例如：Centos, Ubuntu, Windows等
        - **OSName** (str) - 系统名称。例如：CentOS 7.4 x86_64
        - **OSType** (str) - 系统类型。例如：Linux, Windows，Kylin
        - **Region** (str) - 地域
        - **SetArch** (str) - 架构名称。例如：x86_64
        - **Zone** (str) - 可用区

        """
        d = {"Region": self.config.region}
        req and d.update(req)
        d = apis.DescribeImageRequestSchema().dumps(d)
        resp = self.invoke("DescribeImage", d, **kwargs)
        return apis.DescribeImageResponseSchema().loads(resp)

    def describe_lb(self, req=None, **kwargs):
        """ DescribeLB - 获取负载均衡信息

        **Request**

        - **Region** (str) - (Config) 地域。枚举值： cn，表示中国；
        - **Zone** (str) - (Required) 可用区。枚举值：zone-01，表示中国；
        - **LBIDs** (list) - 【数组】负载均衡的 ID。调用方式举例：LBIDs.0=“one-id”、LBIDs.1=“two-id”。
        - **Limit** (int) - 返回数据长度，默认为20，最大100。
        - **Offset** (int) - 列表起始位置偏移量，默认为0。
        - **SubnetID** (str) - 子网ID
        - **VPCID** (str) - VPCID
        
        **Response**

        - **Infos** (list) - 见 **LBInfo** 模型定义
        - **Message** (str) - 返回信息描述。
        - **TotalCount** (int) - 返回负载均衡总个数。
        
        **Response Model**
        
        **LBInfo** 
        
        - **AlarmTemplateID** (str) - 告警模板ID
        - **ChargeType** (str) - 虚拟机计费模式。枚举值：Dynamic，表示小时；Month，表示月；Year，表示年；
        - **CreateTime** (int) - 创建时间，时间戳
        - **ExpireTime** (int) - 过期时间，时间戳
        - **LBID** (str) - 负载均衡ID
        - **LBStatus** (str) - 状态。Creating:创建中,Running:运行中,Deleting:删除中,Deleted:已删除
        - **LBType** (str) - 负载均衡类型，枚举值，WAN:外网负载均衡，LAN:内网负载均衡。
        - **Name** (str) - 名称
        - **PrivateIP** (str) - 负载均衡的内网 IP 地址，当LB为外网类型时，该值为空。
        - **PublicIP** (str) - 负载均衡的外网 IP 地址，当LB为内网类型时，该值为空。
        - **Region** (str) - 地域
        - **Remark** (str) - 描述
        - **SGID** (str) - 安全组 ID ，当LB为内网类型时，该值为空。
        - **SubnetID** (str) - 子网ID
        - **VPCID** (str) - VPCID
        - **VSCount** (int) - VServer的数量
        - **Zone** (str) - 可用区

        """
        d = {"Region": self.config.region}
        req and d.update(req)
        d = apis.DescribeLBRequestSchema().dumps(d)
        resp = self.invoke("DescribeLB", d, **kwargs)
        return apis.DescribeLBResponseSchema().loads(resp)

    def describe_metric(self, req=None, **kwargs):
        """ DescribeMetric - 获取资源监控信息

        **Request**

        - **Region** (str) - (Config) 地域。枚举值：cn，表示中国；
        - **BeginTime** (str) - (Required) 开始时间。使用unix时间戳
        - **EndTime** (str) - (Required) 结束时间。使用Unix时间戳
        - **MetricName** (list) - (Required) 监控指标。1. 获取虚拟机监控信息调用举例，MetricName.0="CPUUtilization"、MetricName.0="MemUsage"。虚拟机监控指标枚举值：BlockProcessCount，表示阻塞进程数；CPUUtilization，表示CPU使用率；DiskReadOps，表示磁盘读次数；DiskWriteOps，表示磁盘写次数；IORead，表示磁盘读吞吐；IOWrite，表示磁盘写吞吐；LoadAvg，表示平均负载1分钟；MemUsage，表示内存使用率；NetPacketIn，表示网卡入包量；NetPacketOut，表示网卡出包量；NICIn，表示网卡入带宽；NICOut，表示网卡出带宽；SpaceUsage，表示空间使用率；TCPConnectCount，表示TCP连接数；2. EIP监控指标：NetPacketIn：入包量；NetPacketOut：出包量；NICIn：入带宽；NICOut：出带宽；NICOutUsage：出带宽使用率；
        - **ResourceID** (str) - (Required) 资源ID
        - **ResourceType** (str) - (Required) 资源类型。VM：虚拟机；EIP：弹性IP
        - **Zone** (str) - (Required) 可用区。枚举值：zone-01，中国；
        
        **Response**

        - **Infos** (list) - 见 **MetricInfo** 模型定义
        - **Message** (str) - 返回信息描述
        - **TotalCount** (int) - 返回监控信息条数
        
        **Response Model**
        
        **MetricSet** 
        
        - **Timestamp** (int) - 监控时间
        - **Value** (float) - 监控值

        **MetricInfo** 
        
        - **Infos** (list) - 见 **MetricSet** 模型定义
        - **MetricName** (str) - 监控指标。虚拟机的监控指标枚举值为：BlockProcessCount，表示阻塞进程数；CPUUtilization，表示CPU使用率；DiskReadOps，表示磁盘读次数；DiskWriteOps，表示磁盘写次数；IORead，表示磁盘读吞吐；IOWrite，表示磁盘写吞吐；LoadAvg，表示平均负载1分钟；MemUsage，表示内存使用率；NetPacketIn，表示网卡入包量；NetPacketOut，表示网卡出包量；NICIn，表示网卡入带宽；NICOut，表示网卡出带宽；SpaceUsage，表示空间使用率；TCPConnectCount，表示TCP连接数；

        """
        d = {"Region": self.config.region}
        req and d.update(req)
        d = apis.DescribeMetricRequestSchema().dumps(d)
        resp = self.invoke("DescribeMetric", d, **kwargs)
        return apis.DescribeMetricResponseSchema().loads(resp)

    def describe_natgw(self, req=None, **kwargs):
        """ DescribeNATGW - 获取NAT网关信息

        **Request**

        - **Region** (str) - (Config) 地域。枚举值： cn，表示中国；
        - **Zone** (str) - (Required) 可用区。枚举值：zone-01，表示中国；
        - **Limit** (int) - 返回数据长度，默认为20，最大100。
        - **NATGWIDs** (list) - 【数组】NAT网关的 ID。调用方式举例：NATGWIDs.0=“one-id”、NATGWIDs.1=“two-id”。
        - **Offset** (int) - 列表起始位置偏移量，默认为0。
        
        **Response**

        - **Infos** (list) - 见 **NATGWInfo** 模型定义
        - **Message** (str) - 返回信息描述。
        - **TotalCount** (int) - 返回NAT网关总个数
        
        **Response Model**
        
        **NATGWInfo** 
        
        - **AlarmTemplateID** (str) - 告警模板ID
        - **ChargeType** (str) - 计费模式。枚举值：Dynamic，表示小时；Month，表示月；Year，表示年；
        - **CreateTime** (int) - 创建时间，时间戳
        - **EIP** (str) - 虚拟IP
        - **ExpireTime** (int) - 过期时间，时间戳
        - **NATGWID** (str) - NAT网关ID
        - **NATGWStatus** (str) - 状态。Creating:创建中, Running:运行中, Deleting:删除中, Deleted:已删除
        - **Name** (str) - 名称
        - **Region** (str) - 地域
        - **Remark** (str) - 备注
        - **SGID** (str) - NAT网关绑定的安全组ID
        - **SubnetID** (str) - NAT网关实例所在的子网 ID
        - **VPCID** (str) - NAT网关实例所在的 VPC ID
        - **Zone** (str) - 可用区

        """
        d = {"Region": self.config.region}
        req and d.update(req)
        d = apis.DescribeNATGWRequestSchema().dumps(d)
        resp = self.invoke("DescribeNATGW", d, **kwargs)
        return apis.DescribeNATGWResponseSchema().loads(resp)

    def describe_natgw_rule(self, req=None, **kwargs):
        """ DescribeNATGWRule - 获取NAT网关白名单信息

        **Request**

        - **Region** (str) - (Config) 地域。枚举值： cn，表示中国；
        - **NATGWID** (str) - (Required) NAT网关ID
        - **NATGWType** (str) - (Required) NAT类型。枚举值：SNAT，DNAT
        - **Zone** (str) - (Required) 可用区。枚举值：zone-01，表示中国；
        - **BindResourceIDs** (list) - 【数组】NAT网关白名单资源ID。调用方式举例：NATGWRules.0=“one-id”、NATGWRules.1=“two-id”。
        - **Limit** (int) - 返回数据长度，默认为20，最大100。
        - **Offset** (int) - 列表起始位置偏移量，默认为0。
        - **RuleIDs** (list) - 【数组】NAT网关白名单ID。调用方式举例：NATGWRules.0=“one-id”、NATGWRules.1=“two-id”。
        
        **Response**

        - **Infos** (list) - 见 **NATGWRuleInfo** 模型定义
        - **Message** (str) - 返回信息描述。
        - **TotalCount** (int) - 返回NAT网关白名单资源总个数。
        
        **Response Model**
        
        **NATGWRuleInfo** 
        
        - **BindResourceID** (str) - 绑定的资源ID
        - **BindResourceType** (str) - 绑定资源的类型
        - **CreateTime** (int) - 创建时间，时间戳。
        - **IP** (str) - 白名单资源的内网IP地址
        - **NATGWID** (str) - NAT网关ID
        - **NATGWType** (str) - nat网关类型
        - **Name** (str) - 添加的白名单资源名称
        - **RuleID** (str) - 白名单ID
        - **RuleStatus** (str) - 状态。Bounding:绑定中,Bound:已绑定,Unbounding:解绑中,Unbound：已解绑

        """
        d = {"Region": self.config.region}
        req and d.update(req)
        d = apis.DescribeNATGWRuleRequestSchema().dumps(d)
        resp = self.invoke("DescribeNATGWRule", d, **kwargs)
        return apis.DescribeNATGWRuleResponseSchema().loads(resp)

    def describe_op_logs(self, req=None, **kwargs):
        """ DescribeOPLogs - 查询操作日志

        **Request**

        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist.html>`_ 
        - **BeginTime** (int) - (Required) 开始时间
        - **EndTime** (int) - (Required) 结束时间
        - **Zone** (str) - (Required) 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist.html>`_ 
        - **IsSuccess** (str) - 是否操作成功
        - **Limit** (int) - 
        - **Offset** (int) - 
        - **ResourceID** (str) - 资源ID
        - **ResourceType** (str) - 资源类型
        
        **Response**

        - **Infos** (list) - 见 **OPLogInfo** 模型定义
        - **Message** (str) - 错误信息
        - **TotalCount** (int) - 总数
        
        **Response Model**
        
        **OPLogInfo** 
        
        - **CreateTime** (int) - 创建时间
        - **IsSuccess** (str) - 是否操作成功， Yes, No
        - **OPLogsID** (str) - 日志ID
        - **OPName** (str) - API
        - **OPTime** (int) - 操作时间
        - **OpMessage** (str) - 错误信息
        - **Region** (str) - 
        - **ResourceID** (str) - 资源ID
        - **ResourceType** (int) - 资源类型
        - **RetCode** (int) - 状态码
        - **UserEmail** (str) - 账号邮箱
        - **Zone** (str) - 

        """
        d = {"Region": self.config.region}
        req and d.update(req)
        d = apis.DescribeOPLogsRequestSchema().dumps(d)
        resp = self.invoke("DescribeOPLogs", d, **kwargs)
        return apis.DescribeOPLogsResponseSchema().loads(resp)

    def describe_physical_ip(self, req=None, **kwargs):
        """ DescribePhysicalIP - 获取物理IP信息

        **Request**

        - **Region** (str) - (Config) 地域。枚举值：cn,表示中国；
        - **Zone** (str) - (Required) 可用区。枚举值：zone-01，表示中国；
        - **Limit** (str) - 返回数据长度，默认为20，最大100。
        - **Offset** (str) - 列表起始位置偏移量，默认为0。
        - **PhysicalIPIDs** (list) - 【数组】物理IP的 ID。输入有效的 ID。调用方式举例：PhysicalIPIDs.0=“one-id”、PhysicalIPIDs.1=“two-id”
        
        **Response**

        - **Infos** (list) - 见 **PhysicalIPInfo** 模型定义
        - **Message** (str) - 返回信息描述
        - **TotalCount** (int) - 返回现有物理IP总数
        
        **Response Model**
        
        **PhysicalIPInfo** 
        
        - **BindResourceID** (str) - 绑定资源ID
        - **BindResourceType** (str) - 绑定资源类型
        - **CreateTime** (int) - 创建时间。时间戳
        - **IP** (str) - 物理IP
        - **Name** (str) - 名称
        - **OperatorName** (str) - 线路
        - **PhysicalIPID** (str) - 物理IP的ID
        - **Region** (str) - 地域
        - **Remark** (str) - 备注
        - **Status** (str) - 状态。Allocating：申请中,Free：未绑定,Bounding：绑定中,Bound：已绑定,Unbounding：解绑中,Deleted：已删除,Releasing：销毁中,Released：已销毁
        - **UpdateTime** (int) - 过期时间。时间戳
        - **Zone** (str) - 可用区

        """
        d = {"Region": self.config.region}
        req and d.update(req)
        d = apis.DescribePhysicalIPRequestSchema().dumps(d)
        resp = self.invoke("DescribePhysicalIP", d, **kwargs)
        return apis.DescribePhysicalIPResponseSchema().loads(resp)

    def describe_rs(self, req=None, **kwargs):
        """ DescribeRS - 获取负载均衡服务的服务节点信息

        **Request**

        - **Region** (str) - (Config) 地域。枚举值： cn，表示中国；
        - **LBID** (str) - (Required) 负载均衡ID
        - **Zone** (str) - (Required) 可用区。枚举值：zone-01，表示中国；
        - **Limit** (int) - 返回数据长度，默认为20，最大100。
        - **Offset** (int) - 列表起始位置偏移量，默认为0。
        - **RSIDs** (list) - 【数组】RServer的 ID。调用方式举例：RSIDs.0=“one-id”、RSIDs.1=“two-id”。
        - **VSID** (str) - VServer的ID
        
        **Response**

        - **Infos** (list) - 见 **RSInfo** 模型定义
        - **Message** (str) - 返回信息描述。
        - **TotalCount** (int) - 返回该负载均衡下VServer的总个数。
        
        **Response Model**
        
        **RSInfo** 
        
        - **BindResourceID** (str) - 绑定的资源ID
        - **CreateTime** (int) - 创建时间，时间戳
        - **IP** (str) - 服务节点的内网 IP 地址
        - **LBID** (str) - 服务节点所属的负载均衡 ID
        - **Name** (str) - 服务节点的资源名称
        - **Port** (int) - 服务节点暴露的服务端口号
        - **RSID** (str) - 服务节点的 ID
        - **RSMode** (str) - 节点模式。枚举值，Enabling:开启中,Enable:已启用,Disabling:禁用中,Disable:已禁用
        - **RSStatus** (str) - RSStatus 的描述修改为：状态，枚举值，Creating:创建中,Inactive:无效,Active:有效,Updating:更新中,Deleting:删除中,Deleted:已删除。其中有效代表节点服务健康，无效代表节点服务异常。
        - **UpdateTime** (int) - 更新时间，时间戳
        - **VSID** (str) - 服务节点所属的 VServer ID
        - **Weight** (int) - 服务节点的权重

        """
        d = {"Region": self.config.region}
        req and d.update(req)
        d = apis.DescribeRSRequestSchema().dumps(d)
        resp = self.invoke("DescribeRS", d, **kwargs)
        return apis.DescribeRSResponseSchema().loads(resp)

    def describe_recycled_resource(self, req=None, **kwargs):
        """ DescribeRecycledResource - 查询回收站资源

        **Request**

        - **Region** (str) - (Config) 地域。枚举值：如 cn,表示中国。
        - **Zone** (str) - (Required) 可用区。枚举值：如 zone-01，表示可用区1。
        - **Limit** (int) - 返回数据长度，默认为20，最大100。
        - **Offset** (int) - 列表起始位置偏移量，默认为0。
        - **ResourceIDs** (list) - 【数组】资源ID，输入“有效”的ID。调用方式举例：ResourceIDs.0=“one-id”、ResourceIDs.1=“two-id”。
        
        **Response**

        - **Infos** (list) - 见 **RecycledResourceInfo** 模型定义
        - **TotalCount** (int) - 返回回收站资源的总个数
        
        **Response Model**
        
        **RecycledResourceInfo** 
        
        - **CreateTime** (int) - 创建时间
        - **DeleteTime** (int) - 删除时间
        - **Description** (str) - 描述
        - **ExpireTime** (int) - 过期时间
        - **IsAutoTerminated** (bool) - 是否自动销户
        - **Name** (str) - 名称
        - **Region** (str) - 地域
        - **ResourceID** (str) - 资源ID
        - **ResourceType** (str) - 资源类型：VM:虚拟机，Disk:硬盘，EIP:外网IP，PIP:物理IP，MySQL:数据库，Redis:缓存
        - **Status** (str) - 资源状态
        - **WillTerminateTime** (int) - 销毁时间
        - **Zone** (str) - 可用区

        """
        d = {"Region": self.config.region}
        req and d.update(req)
        d = apis.DescribeRecycledResourceRequestSchema().dumps(d)
        resp = self.invoke("DescribeRecycledResource", d, **kwargs)
        return apis.DescribeRecycledResourceResponseSchema().loads(resp)

    def describe_security_group(self, req=None, **kwargs):
        """ DescribeSecurityGroup - 查询安全组信息

        **Request**

        - **Region** (str) - (Config) 地域。
        - **Zone** (str) - (Required) 可用区。
        - **Limit** (int) - 返回数据长度，默认为20，最大100。
        - **Offset** (int) - 列表起始位置偏移量，默认为0。
        - **SGIDs** (list) - 【数组】安全组的 ID。输入有效的 ID。调用方式举例：SGIDs.0=“one-id”、SGIDs.1=“two-id”
        
        **Response**

        - **Infos** (list) - 见 **SGInfo** 模型定义
        - **Message** (str) - 返回信息描述；
        - **TotalCount** (int) - 安全组的总数
        
        **Response Model**
        
        **SGRuleInfo** 
        
        - **DstPort** (str) - 端口号
        - **IsIn** (str) - 方向。1：入，0：出
        - **Priority** (str) - 优先级。HIGH:高，MEDIUM:中，LOW:低
        - **ProtocolType** (str) - 协议
        - **RuleAction** (str) - 动作。ACCEPT：接受，DROP：拒绝
        - **RuleID** (str) - 规则ID
        - **SrcIP** (str) - IP或者掩码/段形式。10.0.0.2,10.0.10.10/16

        **SGInfo** 
        
        - **CreateTime** (int) - 创建时间，时间戳
        - **Name** (str) - 名称
        - **Region** (str) - 地域
        - **Remark** (str) - 描述
        - **ResourceCount** (int) - 资源绑定数量
        - **Rule** (list) - 见 **SGRuleInfo** 模型定义
        - **RuleCount** (int) - 规则数量
        - **SGID** (str) - 安全组ID
        - **Status** (str) - 状态。Creating：创建中,Updating：更新中,Available：有效,Deleted：已删除,Terminating：销毁中,Terminated：已销毁
        - **UpdateTime** (int) - 更新时间，时间戳
        - **Zone** (str) - 可用区

        """
        d = {"Region": self.config.region}
        req and d.update(req)
        d = apis.DescribeSecurityGroupRequestSchema().dumps(d)
        resp = self.invoke("DescribeSecurityGroup", d, **kwargs)
        return apis.DescribeSecurityGroupResponseSchema().loads(resp)

    def describe_storage_type(self, req=None, **kwargs):
        """ DescribeStorageType - 查询存储类型

        **Request**

        - **Region** (str) - (Config) 地域。
        - **Zone** (str) - (Required) 可用区。
        
        **Response**

        - **Infos** (list) - 见 **StorageTypeInfo** 模型定义
        - **Message** (str) - 返回信息描述；
        - **TotalCount** (int) - 存储类型的总数
        
        **Response Model**
        
        **StorageTypeInfo** 
        
        - **Region** (str) - 地域
        - **SetArch** (str) - 架构
        - **StorageType** (str) - 存储类型
        - **StorageTypeAlias** (str) - 存储类型别名
        - **Zone** (str) - 可用区

        """
        d = {"Region": self.config.region}
        req and d.update(req)
        d = apis.DescribeStorageTypeRequestSchema().dumps(d)
        resp = self.invoke("DescribeStorageType", d, **kwargs)
        return apis.DescribeStorageTypeResponseSchema().loads(resp)

    def describe_subnet(self, req=None, **kwargs):
        """ DescribeSubnet - 查询子网信息

        **Request**

        - **Region** (str) - (Config) 地域。
        - **Zone** (str) - (Required) 可用区。
        - **Limit** (int) - 返回数据长度，默认为20，最大100。
        - **Offset** (int) - 列表起始位置偏移量，默认为0。
        - **SubnetIDs** (list) - 【数组】子网 ID。调用方式举例：SubnetIDs.0=“one-id”、SubnetIDs.1=“two-id”
        - **VPCID** (str) - VPCID
        
        **Response**

        - **Infos** (list) - 见 **SubnetInfo** 模型定义
        - **Message** (str) - 返回信息描述；
        - **TotalCount** (int) - 子网的总数
        
        **Response Model**
        
        **SubnetInfo** 
        
        - **CreateTime** (int) - 创建时间，时间戳
        - **Name** (str) - 名称
        - **Network** (str) - 网段
        - **Region** (str) - 地域
        - **Remark** (str) - 描述
        - **State** (str) - 状态；Allocating：申请中,Available：有效,Deleting：删除中,Deleted：已删除
        - **SubnetID** (str) - ID
        - **UpdateTime** (int) - 更新时间，时间戳
        - **Zone** (str) - 可用区

        """
        d = {"Region": self.config.region}
        req and d.update(req)
        d = apis.DescribeSubnetRequestSchema().dumps(d)
        resp = self.invoke("DescribeSubnet", d, **kwargs)
        return apis.DescribeSubnetResponseSchema().loads(resp)

    def describe_user(self, req=None, **kwargs):
        """ DescribeUser - 查询租户信息

        **Request**

        - **Limit** (int) - 返回数据长度，默认为20，最大100。
        - **Offset** (int) - 列表起始位置偏移量，默认为0。
        - **UserIDs** (list) - 【数组】租户的 ID。输入有效的 ID。调用方式举例：UserIDs.0=123”、UserIDs.1=456
        
        **Response**

        - **Infos** (list) - 见 **UserInfo** 模型定义
        - **Message** (str) - 返回信息描述
        - **TotalCount** (int) - 返回现有租户总数
        
        **Response Model**
        
        **UserInfo** 
        
        - **Amount** (float) - 账户余额
        - **CreateTime** (int) - 账户创建时间。时间戳
        - **Email** (str) - 租户名称
        - **PrivateKey** (str) - 私钥
        - **PublicKey** (str) - 公钥
        - **Status** (str) - 用户状态。USER_STATUS_AVAILABLE：正常，USER_STATUS_FREEZE：冻结
        - **UpdateTime** (int) - 更新时间。时间戳
        - **UserID** (int) - 租户ID.

        """
        d = {}
        req and d.update(req)
        d = apis.DescribeUserRequestSchema().dumps(d)
        resp = self.invoke("DescribeUser", d, **kwargs)
        return apis.DescribeUserResponseSchema().loads(resp)

    def describe_vm_instance(self, req=None, **kwargs):
        """ DescribeVMInstance - 查询虚拟机

        **Request**

        - **Region** (str) - (Config) 地域。枚举值： cn，表示中国；
        - **Zone** (str) - (Required) 可用区。枚举值：zone-01，表示中国；
        - **Limit** (int) - 返回数据长度，默认为20，最大100。
        - **Offset** (str) - 列表起始位置偏移量，默认为0。
        - **SubnetID** (str) - 子网 ID。输入“有效”状态的子网 ID。
        - **VMIDs** (list) - 【数组】虚拟机的 ID。输入有效的 ID。调用方式举例：PrivateIp.0=“one-id”、PrivateIp.1=“two-id”。
        - **VPCID** (str) - VPC ID。输入“有效”状态的VPC ID。
        
        **Response**

        - **Infos** (list) - 见 **VMInstanceInfo** 模型定义
        - **Message** (str) - 返回信息描述
        - **TotalCount** (int) - 返回虚拟机总个数
        
        **Response Model**
        
        **VMIPInfo** 
        
        - **IP** (str) - IP 值
        - **IPVersion** (str) - IP版本,支持值：IPv4\\IPv6
        - **InterfaceID** (str) - 网卡 ID
        - **IsElastic** (str) - 是否是弹性网卡。枚举值：Y，表示是；N，表示否；
        - **MAC** (str) - MAC 地址值
        - **SGID** (str) - 安全组 ID
        - **SGName** (str) - 安全组名称
        - **SubnetID** (str) - 子网 ID
        - **SubnetName** (str) - 子网名称
        - **Type** (str) - IP 类型。枚举值：Private，表示内网；Public，表示外网；Physical，表示物理网；
        - **VPCID** (str) - VPC ID
        - **VPCName** (str) - VPC 名称

        **VMDiskInfo** 
        
        - **DiskID** (str) - 磁盘 ID
        - **Drive** (str) - 磁盘盘符
        - **IsElastic** (str) - 是否是弹性磁盘。枚举值为：Y，表示是；N，表示否；
        - **Name** (str) - 磁盘名称
        - **Size** (int) - 磁盘大小，单位 GB
        - **Type** (str) - 磁盘类型。枚举值：Boot，表示系统盘；Data，表示数据盘；

        **VMInstanceInfo** 
        
        - **CPU** (int) - CPU 个数
        - **ChargeType** (str) - 虚拟机计费模式。枚举值：Dynamic，表示小时；Month，表示月；Year，表示年；
        - **CreateTime** (int) - 虚拟机创建时间
        - **DiskInfos** (list) - 见 **VMDiskInfo** 模型定义
        - **ExpireTime** (int) - 虚拟机过期时间
        - **IPInfos** (list) - 见 **VMIPInfo** 模型定义
        - **ImageID** (str) - 镜像 ID
        - **Memory** (int) - 内存大小，单位 M
        - **Name** (str) - 虚拟机名称
        - **OSName** (str) - 操作系统名称
        - **OSType** (str) - 操作系统类型
        - **Region** (str) - Region
        - **RegionAlias** (str) - Region 别名
        - **Remark** (str) - 备注
        - **State** (str) - 虚拟机状态。枚举值：Initializing，表示初始化；Starting，表示启动中；Restarting，表示重启中；Running，表示运行；Stopping，表示关机中；Stopped，表示关机；Deleted，表示已删除；Resizing，表示修改配置中；Terminating，表示销毁中；Terminated，表示已销毁；Migrating，表示迁移中；WaitReinstall，表示等待重装系统；Reinstalling，表示重装中；Poweroffing，表示断电中；ChangeSGing，表示修改防火墙中；
        - **SubnetID** (str) - 子网 ID
        - **SubnetName** (str) - 子网 名称
        - **VMID** (str) - 虚拟机 ID
        - **VMType** (str) - 虚拟机类型
        - **VMTypeAlias** (str) - 虚拟机类型别名
        - **VPCID** (str) - VPC ID
        - **VPCName** (str) - VPC 名称
        - **Zone** (str) - Zone
        - **ZoneAlias** (str) - Zone 别名

        """
        d = {"Region": self.config.region}
        req and d.update(req)
        d = apis.DescribeVMInstanceRequestSchema().dumps(d)
        resp = self.invoke("DescribeVMInstance", d, **kwargs)
        return apis.DescribeVMInstanceResponseSchema().loads(resp)

    def describe_vm_type(self, req=None, **kwargs):
        """ DescribeVMType - 查询主机机型

        **Request**

        - **Region** (str) - (Config) 地域。
        - **Zone** (str) - (Required) 可用区。
        
        **Response**

        - **Infos** (list) - 见 **VMTypeInfo** 模型定义
        - **Message** (str) - 返回信息描述；
        - **TotalCount** (int) - 主机机型的总数
        
        **Response Model**
        
        **VMTypeInfo** 
        
        - **Region** (str) - 地域
        - **SetArch** (str) - 架构
        - **VMType** (str) - 机型
        - **VMTypeAlias** (str) - 机型别名
        - **Zone** (str) - 可用区

        """
        d = {"Region": self.config.region}
        req and d.update(req)
        d = apis.DescribeVMTypeRequestSchema().dumps(d)
        resp = self.invoke("DescribeVMType", d, **kwargs)
        return apis.DescribeVMTypeResponseSchema().loads(resp)

    def describe_vpc(self, req=None, **kwargs):
        """ DescribeVPC - 查询VPC信息

        **Request**

        - **Region** (str) - (Config) 地域。
        - **Zone** (str) - (Required) 可用区。
        - **Limit** (int) - 返回数据长度，默认为20，最大100。
        - **Offset** (int) - 列表起始位置偏移量，默认为0。
        - **VPCIDs** (list) - 【数组】VPC的 ID。调用方式举例：VPCIDs.0=“one-id”、VPCIDs.1=“two-id”
        
        **Response**

        - **Infos** (list) - 见 **VPCInfo** 模型定义
        - **Message** (str) - 返回信息描述；
        - **TotalCount** (int) - VPC的总数
        
        **Response Model**
        
        **SubnetInfo** 
        
        - **CreateTime** (int) - 创建时间，时间戳
        - **Name** (str) - 名称
        - **Network** (str) - 网段
        - **Region** (str) - 地域
        - **Remark** (str) - 描述
        - **State** (str) - 状态；Allocating：申请中,Available：有效,Deleting：删除中,Deleted：已删除
        - **SubnetID** (str) - ID
        - **UpdateTime** (int) - 更新时间，时间戳
        - **Zone** (str) - 可用区

        **VPCInfo** 
        
        - **CreateTime** (int) - 创建时间，时间戳
        - **Name** (str) - 名称
        - **Network** (str) - 网段，比如10.0.0.0/16
        - **Region** (str) - 地域。
        - **Remark** (str) - 描述
        - **State** (str) - 状态；Allocating：申请中,Available：有效,Terminating：销毁中,Terminated：已销毁
        - **SubnetCount** (int) - 该VPC下拥有的子网数目
        - **SubnetInfos** (list) - 见 **SubnetInfo** 模型定义
        - **UpdateTime** (int) - 修改时间，时间戳
        - **VPCID** (str) - VPC的ID
        - **Zone** (str) - 可用区

        """
        d = {"Region": self.config.region}
        req and d.update(req)
        d = apis.DescribeVPCRequestSchema().dumps(d)
        resp = self.invoke("DescribeVPC", d, **kwargs)
        return apis.DescribeVPCResponseSchema().loads(resp)

    def describe_vs(self, req=None, **kwargs):
        """ DescribeVS - 获取负载均衡 VServer 信息

        **Request**

        - **Region** (str) - (Config) 地域。枚举值： cn，表示中国；
        - **LBID** (str) - (Required) 负载均衡ID
        - **Zone** (str) - (Required) 可用区。枚举值：zone-01，表示中国；
        - **Limit** (int) - 返回数据长度，默认为20，最大100。
        - **Offset** (int) - 列表起始位置偏移量，默认为0。
        - **VSIDs** (list) - 【数组】VServer的 ID。调用方式举例：VSIDs.0=“one-id”、VSIDs.1=“two-id”。
        
        **Response**

        - **Infos** (list) - 见 **VSInfo** 模型定义
        - **Message** (str) - 返回信息描述。
        - **TotalCount** (int) - 返回当前负载均衡 VServer 总个数。
        
        **Response Model**
        
        **VSPolicyInfo** 
        
        - **CreateTime** (int) - 创建时间，时间戳
        - **Domain** (str) - 内容转发规则关联的请求域名，值可为空，即代表仅匹配路径。
        - **LBID** (str) - 负载均衡ID
        - **Path** (str) - 内容转发规则关联的请求访问路径，如 "/" 。
        - **PolicyID** (str) - 内容转发规则ID
        - **PolicyStatus** (str) - 状态，枚举值，Available:有效,Deleted:已删除
        - **RSInfos** (list) - 见 **RSInfo** 模型定义
        - **UpdateTime** (int) - 更新时间，时间戳
        - **VSID** (str) - VServerID

        **RSInfo** 
        
        - **BindResourceID** (str) - 绑定的资源ID
        - **CreateTime** (int) - 创建时间，时间戳
        - **IP** (str) - 服务节点的内网 IP 地址
        - **LBID** (str) - 服务节点所属的负载均衡 ID
        - **Name** (str) - 服务节点的资源名称
        - **Port** (int) - 服务节点暴露的服务端口号
        - **RSID** (str) - 服务节点的 ID
        - **RSMode** (str) - 节点模式。枚举值，Enabling:开启中,Enable:已启用,Disabling:禁用中,Disable:已禁用
        - **RSStatus** (str) - RSStatus 的描述修改为：状态，枚举值，Creating:创建中,Inactive:无效,Active:有效,Updating:更新中,Deleting:删除中,Deleted:已删除。其中有效代表节点服务健康，无效代表节点服务异常。
        - **UpdateTime** (int) - 更新时间，时间戳
        - **VSID** (str) - 服务节点所属的 VServer ID
        - **Weight** (int) - 服务节点的权重

        **VSInfo** 
        
        - **AlarmTemplateID** (str) - 告警模板ID
        - **CreateTime** (int) - 创建时间，时间戳
        - **Domain** (str) - HTTP 健康检查时校验请求的 HOST 字段中的域名。当健康检查类型为端口检查时，该值为空。
        - **HealthcheckType** (str) - 负载均衡的健康检查类型。枚举值：Port:端口检查；Path: HTTP检查 。
        - **KeepaliveTimeout** (int) - 负载均衡的连接空闲超时时间，单位为秒，默认值为 60s 。当 VServer 协议为 UDP 时，该值为空。
        - **LBID** (str) - VServer 所属的负载均衡 ID
        - **Path** (str) - HTTP 健康检查的路径。当健康检查类型为端口检查时，该值为空。
        - **PersistenceKey** (str) - 会话保持KEY，仅当 VServer 协议为 HTTP 且会话保持为手动时有效。
        - **PersistenceType** (str) - 会话保持类型。枚举值：None:关闭；Auto:自动生成；Manual:手动生成 。当协议为 TCP 时，该值为空；当协议为 UDP 时 Auto 表示开启会话保持 。
        - **Port** (int) - 端口
        - **Protocol** (str) - 协议
        - **RSHealthStatus** (str) - 健康检查状态，枚举值，Empty:全部异常,Parts:部分异常,All:正常
        - **RSInfos** (list) - 见 **RSInfo** 模型定义
        - **UpdateTime** (int) - 更新时间，时间戳
        - **VSID** (str) - VServer的ID
        - **VSPolicyInfos** (list) - 见 **VSPolicyInfo** 模型定义
        - **VSStatus** (str) - VServer 的资源状态。枚举值，Available:可用,Updating:更新中,Deleted:已删除 。

        """
        d = {"Region": self.config.region}
        req and d.update(req)
        d = apis.DescribeVSRequestSchema().dumps(d)
        resp = self.invoke("DescribeVS", d, **kwargs)
        return apis.DescribeVSResponseSchema().loads(resp)

    def describe_vs_policy(self, req=None, **kwargs):
        """ DescribeVSPolicy - 获取七层负载均衡内容转发规则信息，仅当 VServer 的监听协议为 HTTP 时有效。

        **Request**

        - **Region** (str) - (Config) 地域。枚举值： cn，表示中国；
        - **LBID** (str) - (Required) 负载均衡ID
        - **Zone** (str) - (Required) 可用区。枚举值：zone-01，表示中国；
        - **Limit** (int) - 返回数据长度，默认为20，最大100。
        - **Offset** (int) - 列表起始位置偏移量，默认为0。
        - **PolicyIDs** (list) - 【数组】七层负载均衡内容转发规则的 ID。调用方式举例：PolicyIDs.0=“one-id”、PolicyIDs.1=“two-id”
        - **VSID** (str) - VServerID
        
        **Response**

        - **Infos** (list) - 见 **VSPolicyInfo** 模型定义
        - **Message** (str) - 返回信息描述。
        - **TotalCount** (int) - 返回内容转发规则的总个数。
        
        **Response Model**
        
        **RSInfo** 
        
        - **BindResourceID** (str) - 绑定的资源ID
        - **CreateTime** (int) - 创建时间，时间戳
        - **IP** (str) - 服务节点的内网 IP 地址
        - **LBID** (str) - 服务节点所属的负载均衡 ID
        - **Name** (str) - 服务节点的资源名称
        - **Port** (int) - 服务节点暴露的服务端口号
        - **RSID** (str) - 服务节点的 ID
        - **RSMode** (str) - 节点模式。枚举值，Enabling:开启中,Enable:已启用,Disabling:禁用中,Disable:已禁用
        - **RSStatus** (str) - RSStatus 的描述修改为：状态，枚举值，Creating:创建中,Inactive:无效,Active:有效,Updating:更新中,Deleting:删除中,Deleted:已删除。其中有效代表节点服务健康，无效代表节点服务异常。
        - **UpdateTime** (int) - 更新时间，时间戳
        - **VSID** (str) - 服务节点所属的 VServer ID
        - **Weight** (int) - 服务节点的权重

        **VSPolicyInfo** 
        
        - **CreateTime** (int) - 创建时间，时间戳
        - **Domain** (str) - 内容转发规则关联的请求域名，值可为空，即代表仅匹配路径。
        - **LBID** (str) - 负载均衡ID
        - **Path** (str) - 内容转发规则关联的请求访问路径，如 "/" 。
        - **PolicyID** (str) - 内容转发规则ID
        - **PolicyStatus** (str) - 状态，枚举值，Available:有效,Deleted:已删除
        - **RSInfos** (list) - 见 **RSInfo** 模型定义
        - **UpdateTime** (int) - 更新时间，时间戳
        - **VSID** (str) - VServerID

        """
        d = {"Region": self.config.region}
        req and d.update(req)
        d = apis.DescribeVSPolicyRequestSchema().dumps(d)
        resp = self.invoke("DescribeVSPolicy", d, **kwargs)
        return apis.DescribeVSPolicyResponseSchema().loads(resp)

    def detach_disk(self, req=None, **kwargs):
        """ DetachDisk - 解绑UClouStack硬盘

        **Request**

        - **Region** (str) - (Config) 地域。枚举值：cn,表示中国；
        - **DiskID** (str) - (Required) 硬盘ID
        - **ResourceID** (str) - (Required) 绑定的资源ID
        - **Zone** (str) - (Required) 可用区。枚举值：zone-01，表示中国；
        
        **Response**

        - **Message** (str) - 返回信息描述。
        
        """
        d = {"Region": self.config.region}
        req and d.update(req)
        d = apis.DetachDiskRequestSchema().dumps(d)
        resp = self.invoke("DetachDisk", d, **kwargs)
        return apis.DetachDiskResponseSchema().loads(resp)

    def disable_rs(self, req=None, **kwargs):
        """ DisableRS - 禁用负载均衡的单个服务节点

        **Request**

        - **Region** (str) - (Config) 地域。枚举值：cn,表示中国；
        - **LBID** (str) - (Required) 负载均衡ID
        - **RSID** (str) - (Required) RServer的ID
        - **VSID** (str) - (Required) VServer的ID
        - **Zone** (str) - (Required) 可用区。枚举值：zone-01，表示中国；
        
        **Response**

        - **Message** (str) - 返回信息描述。
        
        """
        d = {"Region": self.config.region}
        req and d.update(req)
        d = apis.DisableRSRequestSchema().dumps(d)
        resp = self.invoke("DisableRS", d, **kwargs)
        return apis.DisableRSResponseSchema().loads(resp)

    def enable_rs(self, req=None, **kwargs):
        """ EnableRS - 启用负载均衡的单个服务节点

        **Request**

        - **Region** (str) - (Config) 地域。枚举值：cn,表示中国；
        - **LBID** (str) - (Required) 负载均衡ID
        - **RSID** (str) - (Required) RServer的ID
        - **VSID** (str) - (Required) VServer的ID
        - **Zone** (str) - (Required) 可用区。枚举值：zone-01，表示中国；
        
        **Response**

        - **Message** (str) - 返回信息描述。
        
        """
        d = {"Region": self.config.region}
        req and d.update(req)
        d = apis.EnableRSRequestSchema().dumps(d)
        resp = self.invoke("EnableRS", d, **kwargs)
        return apis.EnableRSResponseSchema().loads(resp)

    def get_disk_price(self, req=None, **kwargs):
        """ GetDiskPrice - 获取硬盘价格

        **Request**

        - **Region** (str) - (Config) 地域。枚举值：cn,表示中国；
        - **ChargeType** (str) - (Required) 计费模式。枚举值：Dynamic，表示小时；Month，表示月；Year，表示年；
        - **DiskSpace** (int) - (Required) 磁盘大小
        - **SetType** (str) - (Required) 磁盘类型
        - **Zone** (str) - (Required) 可用区。枚举值：zone-01，表示中国；
        - **Quantity** (int) - 购买时长。默认值1。小时不生效，月范围【1，11】，年范围【1，5】。
        
        **Response**

        - **Infos** (list) - 见 **PriceInfo** 模型定义
        - **Message** (str) - 返回信息描述。
        
        **Response Model**
        
        **PriceInfo** 
        
        - **ChargeType** (str) - 计费模式。枚举值：Dynamic，表示小时；Month，表示月；Year，表示年；
        - **Price** (float) - 价格

        """
        d = {"Region": self.config.region}
        req and d.update(req)
        d = apis.GetDiskPriceRequestSchema().dumps(d)
        resp = self.invoke("GetDiskPrice", d, **kwargs)
        return apis.GetDiskPriceResponseSchema().loads(resp)

    def get_eip_price(self, req=None, **kwargs):
        """ GetEIPPrice - 获取外网IP价格

        **Request**

        - **Region** (str) - (Config) 地域。枚举值：cn,表示中国；
        - **Bandwidth** (int) - (Required) 带宽，默认值1，默认范围1~100
        - **ChargeType** (str) - (Required) 计费模式。枚举值：Dynamic，表示小时；Month，表示月；Year，表示年；
        - **OpertatorName** (str) - (Required) 线路。目前支持Bgp
        - **Zone** (str) - (Required) 可用区。枚举值：zone-01，表示中国；
        - **Quantity** (int) - 购买时长。默认值1。小时不生效，月范围【1，11】，年范围【1，5】。
        
        **Response**

        - **Infos** (list) - 见 **PriceInfo** 模型定义
        - **Message** (str) - 返回信息描述
        
        **Response Model**
        
        **PriceInfo** 
        
        - **ChargeType** (str) - 计费模式。枚举值：Dynamic，表示小时；Month，表示月；Year，表示年；
        - **Price** (float) - 价格

        """
        d = {"Region": self.config.region}
        req and d.update(req)
        d = apis.GetEIPPriceRequestSchema().dumps(d)
        resp = self.invoke("GetEIPPrice", d, **kwargs)
        return apis.GetEIPPriceResponseSchema().loads(resp)

    def get_vm_instance_price(self, req=None, **kwargs):
        """ GetVMInstancePrice - 获取虚拟机价格

        **Request**

        - **Region** (str) - (Config) 地域。枚举值：cn,表示中国；
        - **BootDiskSetType** (str) - (Required) 系统盘类型。枚举值：Normal，表示普通；SSD，表示SSD；
        - **CPU** (int) - (Required) CPU 个数，目前只能输入数据库配置指定规格参数，如：1核2048M、2核4096M、4核8192M、8核16384M、16核32768M。
        - **ChargeType** (str) - (Required) 计费模式。枚举值：Dynamic，表示小时；Month，表示月；Year，表示年；
        - **DataDiskSetType** (str) - (Required) 数据盘类型。枚举值：Normal，表示普通；SSD，表示SSD；
        - **DataDiskSpace** (int) - (Required) 数据盘大小，单位 GB。默认值为0。范围：【0，8000】，步长10。
        - **ImageID** (str) - (Required) 镜像 ID。基础镜像 ID 或者自制镜像 ID。如：cn-image-centos-74。
        - **Memory** (int) - (Required) 内存大小，单位 M。目前只能输入数据库配置指定规格参数，如：1核2048M、2核4096M、4核8192M、8核16384M、16核32768M。
        - **OSType** (str) - (Required) 系统类型。
        - **VMType** (str) - (Required) 机型。枚举值：Normal，表示普通；SSD，表示SSD；
        - **Zone** (str) - (Required) 可用区。枚举值：zone-01，表示中国；
        - **GPU** (int) - GPU 卡核心的占用个数。枚举值：【1,2,4】。GPU与CPU、内存大小关系：CPU个数>=4*GPU个数，同时内存与CPU规格匹配.
        - **Quantity** (int) - 购买时长。默认值1。小时不生效，月范围【1，11】，年范围【1，5】。
        
        **Response**

        - **Infos** (list) - 见 **PriceInfo** 模型定义
        - **Message** (str) - 返回信息描述。
        
        **Response Model**
        
        **PriceInfo** 
        
        - **ChargeType** (str) - 计费模式。枚举值：Dynamic，表示小时；Month，表示月；Year，表示年；
        - **Price** (float) - 价格

        """
        d = {"Region": self.config.region}
        req and d.update(req)
        d = apis.GetVMInstancePriceRequestSchema().dumps(d)
        resp = self.invoke("GetVMInstancePrice", d, **kwargs)
        return apis.GetVMInstancePriceResponseSchema().loads(resp)

    def modify_eip_bandwidth(self, req=None, **kwargs):
        """ ModifyEIPBandwidth - 调整外网IP带宽

        **Request**

        - **Region** (str) - (Config) 地域。
        - **Bandwidth** (int) - (Required) 调整后的带宽
        - **EIPID** (str) - (Required) 外网IP的ID
        - **Zone** (str) - (Required) 可用区。
        
        **Response**

        - **Message** (str) - 返回信息描述；
        
        """
        d = {"Region": self.config.region}
        req and d.update(req)
        d = apis.ModifyEIPBandwidthRequestSchema().dumps(d)
        resp = self.invoke("ModifyEIPBandwidth", d, **kwargs)
        return apis.ModifyEIPBandwidthResponseSchema().loads(resp)

    def modify_name_and_remark(self, req=None, **kwargs):
        """ ModifyNameAndRemark - 修改资源名称和备注

        **Request**

        - **Region** (str) - (Config) 地域。枚举值： cn，表示中国；
        - **Name** (str) - (Required) 名称;
        - **ResourceID** (str) - (Required) 资源ID;
        - **Zone** (str) - (Required) 可用区。枚举值：zone-01，表示中国；
        - **Remark** (str) - 描述;
        
        **Response**

        - **Message** (str) - 返回信息描述
        
        """
        d = {"Region": self.config.region}
        req and d.update(req)
        d = apis.ModifyNameAndRemarkRequestSchema().dumps(d)
        resp = self.invoke("ModifyNameAndRemark", d, **kwargs)
        return apis.ModifyNameAndRemarkResponseSchema().loads(resp)

    def poweroff_vm_instance(self, req=None, **kwargs):
        """ PoweroffVMInstance - 断电虚拟机，可能导致丢失数据甚至损坏操作系统，仅适用于虚拟机死机及级端测试场景。

        **Request**

        - **Region** (str) - (Config) 地域。枚举值：如 cn,表示中国。
        - **VMID** (str) - (Required) 虚拟机ID
        - **Zone** (str) - (Required) 可用区。枚举值：如 zone-01，表示可用区1。
        
        **Response**

        - **Message** (str) - 返回信息描述
        
        """
        d = {"Region": self.config.region}
        req and d.update(req)
        d = apis.PoweroffVMInstanceRequestSchema().dumps(d)
        resp = self.invoke("PoweroffVMInstance", d, **kwargs)
        return apis.PoweroffVMInstanceResponseSchema().loads(resp)

    def recharge(self, req=None, **kwargs):
        """ Recharge - 管理员给租户充值

        **Request**

        - **Amount** (int) - (Required) 充值金额。最少100,最大500000
        - **FromType** (str) - (Required) 充值来源。INPOUR_FROM_ALIPAY：支付宝，INPOUR_FROM_OFFLINE：银行转账，INPOUR_FROM_SINPAY：新浪支付，INPOUR_FROM_WECHAT_PAY：微信转账。
        - **SerialNo** (str) - (Required) 充值单号。充值方式为“账户余额”时为必要参数。
        - **UserID** (int) - (Required) 租户的账户ID。
        
        **Response**

        - **Message** (str) - 返回信息描述。
        
        """
        d = {}
        req and d.update(req)
        d = apis.RechargeRequestSchema().dumps(d)
        resp = self.invoke("Recharge", d, **kwargs)
        return apis.RechargeResponseSchema().loads(resp)

    def reinstall_vm_instance(self, req=None, **kwargs):
        """ ReinstallVMInstance - 重装系统，关机的虚拟机才可以重装系统

        **Request**

        - **Region** (str) - (Config) 地域。枚举值： cn，表示中国；
        - **ImageID** (str) - (Required) 镜像ID
        - **VMID** (str) - (Required) 虚拟机ID
        - **Zone** (str) - (Required) 可用区。枚举值：zone-01，表示中国；
        
        **Response**

        - **Message** (str) - 返回信息描述
        
        """
        d = {"Region": self.config.region}
        req and d.update(req)
        d = apis.ReinstallVMInstanceRequestSchema().dumps(d)
        resp = self.invoke("ReinstallVMInstance", d, **kwargs)
        return apis.ReinstallVMInstanceResponseSchema().loads(resp)

    def release_eip(self, req=None, **kwargs):
        """ ReleaseEIP - 删除外网IP

        **Request**

        - **Region** (str) - (Config) 地域。枚举值：cn,表示中国；中国
        - **EIPID** (str) - (Required) 外网IP的ID
        - **Zone** (str) - (Required) 可用区。枚举值：zone-01，表示中国
        
        **Response**

        - **Message** (str) - 返回状态描述
        
        """
        d = {"Region": self.config.region}
        req and d.update(req)
        d = apis.ReleaseEIPRequestSchema().dumps(d)
        resp = self.invoke("ReleaseEIP", d, **kwargs)
        return apis.ReleaseEIPResponseSchema().loads(resp)

    def renew_resource(self, req=None, **kwargs):
        """ RenewResource - 续费回收站资源

        **Request**

        - **Region** (str) - (Config) 地域。枚举值：如 cn,表示中国。
        - **ResourceID** (str) - (Required) 待续续的资源ID
        - **Zone** (str) - (Required) 可用区。枚举值：如 zone-01，表示可用区1。
        - **Quantity** (int) - 购买时长，默认为 1。按小时(Dynamic)付费的资源无需此参数，按月付费的资源传 0 时，代表购买至月末。
        
        **Response**

        - **Message** (str) - 返回描述信息
        
        """
        d = {"Region": self.config.region}
        req and d.update(req)
        d = apis.RenewResourceRequestSchema().dumps(d)
        resp = self.invoke("RenewResource", d, **kwargs)
        return apis.RenewResourceResponseSchema().loads(resp)

    def reset_vm_instance_password(self, req=None, **kwargs):
        """ ResetVMInstancePassword - 重置虚拟机密码，主机必须开机才可以重置密码

        **Request**

        - **Region** (str) - (Config) 地域。枚举值： cn，表示中国；
        - **Password** (str) - (Required) 密码
        - **VMID** (str) - (Required) 虚拟机ID
        - **Zone** (str) - (Required) 可用区。枚举值：zone-01，表示中国；
        
        **Response**

        - **Message** (str) - 返回信息描述
        
        """
        d = {"Region": self.config.region}
        req and d.update(req)
        d = apis.ResetVMInstancePasswordRequestSchema().dumps(d)
        resp = self.invoke("ResetVMInstancePassword", d, **kwargs)
        return apis.ResetVMInstancePasswordResponseSchema().loads(resp)

    def resize_vm_config(self, req=None, **kwargs):
        """ ResizeVMConfig - 修改虚拟机配置

        **Request**

        - **Region** (str) - (Config) 地域。枚举值： cn，表示中国；
        - **CPU** (int) - (Required) CPU 个数，如 1、2、4、8、16、32、64。
        - **Memory** (int) - (Required) 内存容量，如 2048、4096、8192、16384、32768、65536、131072。
        - **VMID** (str) - (Required) 虚拟机ID
        - **Zone** (str) - (Required) 可用区。枚举值：zone-01，表示中国；
        
        **Response**

        - **Message** (str) - 返回信息描述
        
        """
        d = {"Region": self.config.region}
        req and d.update(req)
        d = apis.ResizeVMConfigRequestSchema().dumps(d)
        resp = self.invoke("ResizeVMConfig", d, **kwargs)
        return apis.ResizeVMConfigResponseSchema().loads(resp)

    def restart_vm_instance(self, req=None, **kwargs):
        """ RestartVMInstance - 重启虚拟机

        **Request**

        - **Region** (str) - (Config) 地域。枚举值：cn,表示中国；
        - **VMID** (str) - (Required) 虚拟机ID;
        - **Zone** (str) - (Required) 可用区。枚举值：zone-01，表示中国；
        
        **Response**

        - **Message** (str) - 返回信息描述
        
        """
        d = {"Region": self.config.region}
        req and d.update(req)
        d = apis.RestartVMInstanceRequestSchema().dumps(d)
        resp = self.invoke("RestartVMInstance", d, **kwargs)
        return apis.RestartVMInstanceResponseSchema().loads(resp)

    def rollback_resource(self, req=None, **kwargs):
        """ RollbackResource - 恢复回收站资源

        **Request**

        - **Region** (str) - (Config) 地域。枚举值：如 cn,表示中国。
        - **ResourceID** (str) - (Required) 待恢复的资源ID
        - **Zone** (str) - (Required) 可用区。枚举值：如 zone-01，表示可用区1。
        
        **Response**

        - **Message** (str) - 返回描述信息
        
        """
        d = {"Region": self.config.region}
        req and d.update(req)
        d = apis.RollbackResourceRequestSchema().dumps(d)
        resp = self.invoke("RollbackResource", d, **kwargs)
        return apis.RollbackResourceResponseSchema().loads(resp)

    def rollback_snapshot(self, req=None, **kwargs):
        """ RollbackSnapshot - 将某个快照内的数据回滚到原云硬盘，仅支持正常状态的快照进行回滚操作，回滚时硬盘必须处于未绑定或其挂载的主机为关机状态。

        **Request**

        - **Region** (str) - (Config) 地域。枚举值：如 cn,表示中国。
        - **DiskID** (str) - (Required) 对应的云硬盘 ID；
        - **SnapshotID** (str) - (Required) 快照ID
        - **Zone** (str) - (Required) 可用区。枚举值：如 zone-01，表示可用区1。
        
        **Response**

        - **Message** (str) - 返回信息描述
        
        """
        d = {"Region": self.config.region}
        req and d.update(req)
        d = apis.RollbackSnapshotRequestSchema().dumps(d)
        resp = self.invoke("RollbackSnapshot", d, **kwargs)
        return apis.RollbackSnapshotResponseSchema().loads(resp)

    def start_vm_instance(self, req=None, **kwargs):
        """ StartVMInstance - 开启虚拟机

        **Request**

        - **Region** (str) - (Config) 地域。枚举值：cn，表示中国；
        - **VMID** (str) - (Required) 虚拟机 ID
        - **Zone** (str) - (Required) 可用区。枚举值：zone-01，表示中国；
        
        **Response**

        - **Message** (str) - 返回信息描述
        
        """
        d = {"Region": self.config.region}
        req and d.update(req)
        d = apis.StartVMInstanceRequestSchema().dumps(d)
        resp = self.invoke("StartVMInstance", d, **kwargs)
        return apis.StartVMInstanceResponseSchema().loads(resp)

    def stop_vm_instance(self, req=None, **kwargs):
        """ StopVMInstance - 关闭虚拟机

        **Request**

        - **Region** (str) - (Config) 地域。枚举值：cn，表示中国；
        - **VMID** (str) - (Required) 虚拟机 ID
        - **Zone** (str) - (Required) 可用区。枚举值：zone-01，表示中国；
        
        **Response**

        - **Message** (str) - 返回信息描述
        - **VMID** (str) - 虚拟机 ID
        
        """
        d = {"Region": self.config.region}
        req and d.update(req)
        d = apis.StopVMInstanceRequestSchema().dumps(d)
        resp = self.invoke("StopVMInstance", d, **kwargs)
        return apis.StopVMInstanceResponseSchema().loads(resp)

    def terminate_resource(self, req=None, **kwargs):
        """ TerminateResource - 销毁资源

        **Request**

        - **Region** (str) - (Config) 地域。
        - **ResourceID** (str) - (Required) 资源id
        - **Zone** (str) - (Required) 可用区。
        
        **Response**

        - **Message** (str) - 返回描述信息
        
        """
        d = {"Region": self.config.region}
        req and d.update(req)
        d = apis.TerminateResourceRequestSchema().dumps(d)
        resp = self.invoke("TerminateResource", d, **kwargs)
        return apis.TerminateResourceResponseSchema().loads(resp)

    def un_bind_eip(self, req=None, **kwargs):
        """ UnBindEIP - 解绑外网IP

        **Request**

        - **Region** (str) - (Config) 地域。枚举值：cn,表示中国；中国
        - **EIPID** (str) - (Required) 外网IP的ID
        - **ResourceID** (str) - (Required) 资源ID
        - **ResourceType** (str) - (Required) 资源类型。VM：虚拟机, LB:负载均衡, NATGW：nat网关
        - **Zone** (str) - (Required) 可用区。枚举值：zone-01，表示中国；
        
        **Response**

        - **Message** (str) - 返回信息描述。
        
        """
        d = {"Region": self.config.region}
        req and d.update(req)
        d = apis.UnBindEIPRequestSchema().dumps(d)
        resp = self.invoke("UnBindEIP", d, **kwargs)
        return apis.UnBindEIPResponseSchema().loads(resp)

    def un_bind_security_group(self, req=None, **kwargs):
        """ UnBindSecurityGroup - 解绑安全组

        **Request**

        - **Region** (str) - (Config) 地域。枚举值： cn，表示中国；
        - **ResourceID** (str) - (Required) 解绑的资源ID。调用方式举例：ResourceID=“one-id”。
        - **SGID** (str) - (Required) 安全组ID
        - **Zone** (str) - (Required) 可用区。枚举值：zone-01，表示中国；
        
        **Response**

        - **Message** (str) - 返回信息描述
        
        """
        d = {"Region": self.config.region}
        req and d.update(req)
        d = apis.UnBindSecurityGroupRequestSchema().dumps(d)
        resp = self.invoke("UnBindSecurityGroup", d, **kwargs)
        return apis.UnBindSecurityGroupResponseSchema().loads(resp)

    def unbind_alarm_template(self, req=None, **kwargs):
        """ UnbindAlarmTemplate - 解绑告警模板

        **Request**

        - **Region** (str) - (Config) 地域。枚举值： cn，表示中国；
        - **AlarmTemplateID** (str) - (Required) 告警模板ID
        - **ResourceIDs** (list) - (Required) 【数组】资源的 ID。调用方式举例：ResourceIDs.0=“one-id”、ResourceIDs.1=“two-id”。
        - **ResourceType** (str) - (Required) 资源类型。VM：虚拟机, LB:负载均衡, NATGW：nat网关;EIP:弹性网卡
        - **Zone** (str) - (Required) 可用区。枚举值：zone-01，表示中国；
        
        **Response**

        - **Message** (str) - 返回信息描述
        
        """
        d = {"Region": self.config.region}
        req and d.update(req)
        d = apis.UnbindAlarmTemplateRequestSchema().dumps(d)
        resp = self.invoke("UnbindAlarmTemplate", d, **kwargs)
        return apis.UnbindAlarmTemplateResponseSchema().loads(resp)

    def unbind_physical_ip(self, req=None, **kwargs):
        """ UnbindPhysicalIP - 解绑物理IP

        **Request**

        - **Region** (str) - (Config) 地域。
        - **PhysicalIPID** (str) - (Required) 物理IP的ID
        - **ResourceID** (str) - (Required) 资源ID
        - **ResourceType** (str) - (Required) 资源类型。VM：虚拟机
        - **Zone** (str) - (Required) 可用区。
        
        **Response**

        - **Message** (str) - 返回信息描述。
        
        """
        d = {"Region": self.config.region}
        req and d.update(req)
        d = apis.UnbindPhysicalIPRequestSchema().dumps(d)
        resp = self.invoke("UnbindPhysicalIP", d, **kwargs)
        return apis.UnbindPhysicalIPResponseSchema().loads(resp)

    def update_alarm_template_rule(self, req=None, **kwargs):
        """ UpdateAlarmTemplateRule - 更新告警模板规则

        **Request**

        - **Region** (str) - (Config) 地域
        - **AlarmStrategy** (str) - (Required) 瘦脸策略
        - **AlarmTemplateID** (str) - (Required) 告警模板ID
        - **AlarmTemplateRuleID** (str) - (Required) 告警规则ID
        - **Compare** (str) - (Required) 对比方式
        - **ContactGroupID** (str) - (Required) 通知组ID
        - **MetricName** (str) - (Required) 监控指标名称
        - **ResourceType** (str) - (Required) 资源类型
        - **Threshold** (str) - (Required) 告警阈值
        - **TriggerCount** (str) - (Required) 连续触发次数
        - **Zone** (str) - (Required) 可用区
        
        **Response**

        - **Message** (str) - 返回描述信息
        
        """
        d = {"Region": self.config.region}
        req and d.update(req)
        d = apis.UpdateAlarmTemplateRuleRequestSchema().dumps(d)
        resp = self.invoke("UpdateAlarmTemplateRule", d, **kwargs)
        return apis.UpdateAlarmTemplateRuleResponseSchema().loads(resp)

    def update_rs(self, req=None, **kwargs):
        """ UpdateRS - 修改负载均衡的服务节点

        **Request**

        - **Region** (str) - (Config) 地域。枚举值：cn,表示中国；
        - **LBID** (str) - (Required) VServer 监听器所属的负载均衡 ID
        - **RSID** (str) - (Required) RServer的ID
        - **VSID** (str) - (Required) RServer所属的VServer的ID
        - **Zone** (str) - (Required) 可用区。枚举值：zone-01，表示中国；
        - **Port** (int) - 端口号
        - **Weight** (int) - 权重
        
        **Response**

        - **Message** (str) - 返回信息描述。
        
        """
        d = {"Region": self.config.region}
        req and d.update(req)
        d = apis.UpdateRSRequestSchema().dumps(d)
        resp = self.invoke("UpdateRS", d, **kwargs)
        return apis.UpdateRSResponseSchema().loads(resp)

    def update_security_group_rule(self, req=None, **kwargs):
        """ UpdateSecurityGroupRule - 修改安全组规则

        **Request**

        - **Region** (str) - (Config) 地域。枚举值： cn，表示中国；
        - **Rules** (list) - (Required) 【数组】规则。输入有效的 规则。调用方式举例：Rules.0=“TCP|23|0.0.0.0/0|ACCEPT|HIGH|1”、Rules.1=“TCP|55|0.0.0.0/0|ACCEPT|HIGH|1”
        - **SGID** (str) - (Required) 安全组ID
        - **Zone** (str) - (Required) 可用区。枚举值：zone-01，表示中国；
        
        **Response**

        - **Message** (str) - 返回信息描述；
        
        """
        d = {"Region": self.config.region}
        req and d.update(req)
        d = apis.UpdateSecurityGroupRuleRequestSchema().dumps(d)
        resp = self.invoke("UpdateSecurityGroupRule", d, **kwargs)
        return apis.UpdateSecurityGroupRuleResponseSchema().loads(resp)

    def update_vs(self, req=None, **kwargs):
        """ UpdateVS - 修改负载均衡VServer

        **Request**

        - **Region** (str) - (Config) 地域。枚举值：cn,表示中国；
        - **LBID** (str) - (Required) VServer 监听器所属的负载均衡 ID
        - **VSID** (str) - (Required) 需要更新的VSID
        - **Zone** (str) - (Required) 可用区。枚举值：zone-01，表示中国；
        - **CACertificateID** (str) - CA证书ID，用于验证客户端证书的签名，仅当VServer监听协议为 HTTPS 且 SSLMode 为双向认证时有效。
        - **Domain** (str) - HTTP 健康检查时校验请求的 HOST 字段中的域名。当健康检查类型为端口检查时，该值为空。
        - **HealthcheckType** (str) - 负载均衡的健康检查类型。枚举值：Port:端口检查；Path: HTTP检查 。仅当 VServer 协议类型为 HTTP 时，才可进行 HTTP 检查。
        - **KeepaliveTimeout** (int) - 负载均衡的连接空闲超时时间，单位为秒，默认值为 60s 。当 VServer 协议为 UDP 时，该值为空。
        - **Path** (str) - HTTP 健康检查的路径，健康检查类型为 HTTP 检查时为必填项。当健康检查类型为端口检查时，该值为空。
        - **PersistenceKey** (str) - 会话保持KEY，会话保持类型为Manual时为必填项，仅当 VServer 协议为 HTTP 时有效。
        - **PersistenceType** (str) - 会话保持类型。枚举值：None:关闭；Auto:自动生成；Manual:手动生成 。当协议为 TCP 时，该值不生效，会话保持和选择的调度算法相关；当协议为 UDP 时 Auto 表示开启会话保持 。
        - **Port** (int) - VServer 监听端口
        - **SSLMode** (str) - SSL认证模式,HTTPS协议下必传,取值范围["simplex","duplex"]分别表示单向认证和双向认证。
        - **Scheduler** (str) - 负载均衡的调度算法。枚举值：wrr:加权轮训；least_conn:最小连接数；hash:原地址,四层lb使用。ip_hash:七层lb使用
        - **ServerCertificateID** (str) - 服务器证书ID，用于证明服务器的身份，仅当 VServer监听协议为 HTTPS 时有效。
        
        **Response**

        - **Message** (str) - 返回信息描述。
        
        """
        d = {"Region": self.config.region}
        req and d.update(req)
        d = apis.UpdateVSRequestSchema().dumps(d)
        resp = self.invoke("UpdateVS", d, **kwargs)
        return apis.UpdateVSResponseSchema().loads(resp)

    def update_vs_policy(self, req=None, **kwargs):
        """ UpdateVSPolicy - 更新七层负载均衡内容转发规则，仅当 VServer 的监听协议为 HTTP 时有效。

        **Request**

        - **Region** (str) - (Config) 地域。枚举值：cn,表示中国；
        - **LBID** (str) - (Required) 负载均衡ID
        - **PolicyID** (str) - (Required) 内容转发规则ID
        - **VSID** (str) - (Required) VServer的ID
        - **Zone** (str) - (Required) 可用区。枚举值：zone-01，表示中国；
        - **Domain** (str) - 内容转发规则关联的请求域名，值可为空，即代表仅匹配路径。
        - **Path** (str) - 内容转发规则关联的请求访问路径，如 "/" 。
        - **RSIDs** (list) - 【数组】RServer的 ID。调用方式举例：RSIDs.0=“one-id”、RSIDs.1=“two-id”。
        
        **Response**

        - **Message** (str) - 返回信息描述。
        
        """
        d = {"Region": self.config.region}
        req and d.update(req)
        d = apis.UpdateVSPolicyRequestSchema().dumps(d)
        resp = self.invoke("UpdateVSPolicy", d, **kwargs)
        return apis.UpdateVSPolicyResponseSchema().loads(resp)

    def upgrade_disk(self, req=None, **kwargs):
        """ UpgradeDisk - 升级硬盘

        **Request**

        - **Region** (str) - (Config) 地域。枚举值：cn,表示中国；
        - **DiskID** (str) - (Required) 硬盘ID
        - **DiskSpace** (int) - (Required) 硬盘升级后的容量， 不能小于原硬盘容量，单位为 GB 。
        - **Zone** (str) - (Required) 可用区。枚举值：zone-01，表示中国；
        
        **Response**

        - **Message** (str) - 返回信息描述。
        
        """
        d = {"Region": self.config.region}
        req and d.update(req)
        d = apis.UpgradeDiskRequestSchema().dumps(d)
        resp = self.invoke("UpgradeDisk", d, **kwargs)
        return apis.UpgradeDiskResponseSchema().loads(resp)
